
Object.defineProperty(exports, "__esModule", { value: true });

const {
  Decimal,
  objectEnumValues,
  makeStrictEnum,
  Public,
  getRuntime,
  skip
} = require('@prisma/client/runtime/index-browser.js')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 5.21.1
 * Query Engine version: bf0e5e8a04cada8225617067eaa03d041e2bba36
 */
Prisma.prismaVersion = {
  client: "5.21.1",
  engine: "bf0e5e8a04cada8225617067eaa03d041e2bba36"
}

Prisma.PrismaClientKnownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientKnownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)};
Prisma.PrismaClientUnknownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientUnknownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientRustPanicError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientRustPanicError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientInitializationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientInitializationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientValidationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientValidationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.NotFoundError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`NotFoundError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`sqltag is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.empty = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`empty is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.join = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`join is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.raw = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`raw is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.getExtensionContext is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.defineExtension = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.defineExtension is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = objectEnumValues.instances.DbNull
Prisma.JsonNull = objectEnumValues.instances.JsonNull
Prisma.AnyNull = objectEnumValues.instances.AnyNull

Prisma.NullTypes = {
  DbNull: objectEnumValues.classes.DbNull,
  JsonNull: objectEnumValues.classes.JsonNull,
  AnyNull: objectEnumValues.classes.AnyNull
}



/**
 * Enums
 */

exports.Prisma.TransactionIsolationLevel = makeStrictEnum({
  ReadUncommitted: 'ReadUncommitted',
  ReadCommitted: 'ReadCommitted',
  RepeatableRead: 'RepeatableRead',
  Serializable: 'Serializable'
});

exports.Prisma.UserScalarFieldEnum = {
  id: 'id',
  email: 'email',
  full_name: 'full_name',
  password: 'password',
  whatsapp_number: 'whatsapp_number',
  role: 'role',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.MitraRequestScalarFieldEnum = {
  id: 'id',
  user_id: 'user_id',
  ktp: 'ktp',
  upgrade_amount: 'upgrade_amount',
  payment_proof: 'payment_proof',
  status: 'status',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.UserPackageScalarFieldEnum = {
  id: 'id',
  transportation_id: 'transportation_id',
  flight_id: 'flight_id',
  hotel_mekkah_id: 'hotel_mekkah_id',
  hotel_madinah_id: 'hotel_madinah_id',
  muthawif_id: 'muthawif_id',
  handling_id: 'handling_id',
  number_of_pax: 'number_of_pax',
  travel_duration: 'travel_duration',
  mekkah_duration: 'mekkah_duration',
  madinah_duration: 'madinah_duration',
  per_pax_price: 'per_pax_price',
  total_price: 'total_price',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.PackageTypeScalarFieldEnum = {
  id: 'id',
  name: 'name',
  is_public: 'is_public',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.UserPackageOptionScalarFieldEnum = {
  id: 'id',
  package_type_id: 'package_type_id',
  name: 'name',
  price: 'price',
  order_number: 'order_number',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.UserPackageOrderScalarFieldEnum = {
  id: 'id',
  full_name: 'full_name',
  email: 'email',
  whatsapp_number: 'whatsapp_number',
  user_package_id: 'user_package_id',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.CategoryScalarFieldEnum = {
  id: 'id',
  name: 'name',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.ProductScalarFieldEnum = {
  id: 'id',
  name: 'name',
  description: 'description',
  price: 'price',
  has_variation: 'has_variation',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.ProductThumbnailScalarFieldEnum = {
  id: 'id',
  product_id: 'product_id',
  image_url: 'image_url'
};

exports.Prisma.ProductCategoryScalarFieldEnum = {
  id: 'id',
  product_id: 'product_id',
  category_id: 'category_id'
};

exports.Prisma.ProductVariationScalarFieldEnum = {
  id: 'id',
  product_id: 'product_id',
  name: 'name',
  price: 'price',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.ProductIncludeScalarFieldEnum = {
  id: 'id',
  product_id: 'product_id',
  description: 'description'
};

exports.Prisma.ProductExcludeScalarFieldEnum = {
  id: 'id',
  product_id: 'product_id',
  description: 'description'
};

exports.Prisma.ProductOrderScalarFieldEnum = {
  id: 'id',
  user_id: 'user_id',
  product_id: 'product_id',
  variation_id: 'variation_id',
  departure: 'departure',
  number_of_pax: 'number_of_pax',
  per_pax_price: 'per_pax_price',
  total_price: 'total_price',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.VendorScalarFieldEnum = {
  id: 'id',
  name: 'name',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.HotelScalarFieldEnum = {
  id: 'id',
  vendor_id: 'vendor_id',
  name: 'name',
  city: 'city',
  order_number: 'order_number',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.PeriodScalarFieldEnum = {
  id: 'id',
  category: 'category',
  start_date: 'start_date',
  end_date: 'end_date',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.HotelPeriodPriceScalarFieldEnum = {
  id: 'id',
  hotel_id: 'hotel_id',
  period_id: 'period_id',
  price_double: 'price_double',
  price_triple: 'price_triple',
  price_quad: 'price_quad',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.AirlineScalarFieldEnum = {
  id: 'id',
  name: 'name',
  price_idr: 'price_idr',
  order_number: 'order_number',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.VisaScalarFieldEnum = {
  id: 'id',
  name: 'name',
  price_idr: 'price_idr',
  order_number: 'order_number',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.TransportationScalarFieldEnum = {
  id: 'id',
  name: 'name',
  price_idr: 'price_idr',
  order_number: 'order_number',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.MuthawifScalarFieldEnum = {
  id: 'id',
  name: 'name',
  price_idr: 'price_idr',
  order_number: 'order_number',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.HandlingSaudiScalarFieldEnum = {
  id: 'id',
  name: 'name',
  price_idr: 'price_idr',
  order_number: 'order_number',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.HandlingDomesticScalarFieldEnum = {
  id: 'id',
  name: 'name',
  price_idr: 'price_idr',
  order_number: 'order_number',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.SiskopatuhScalarFieldEnum = {
  id: 'id',
  name: 'name',
  price_idr: 'price_idr',
  order_number: 'order_number',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.EquipmentScalarFieldEnum = {
  id: 'id',
  name: 'name',
  price_idr: 'price_idr',
  order_number: 'order_number',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.TourPlusScalarFieldEnum = {
  id: 'id',
  name: 'name',
  price_idr: 'price_idr',
  order_number: 'order_number',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.ManasikScalarFieldEnum = {
  id: 'id',
  name: 'name',
  price_idr: 'price_idr',
  order_number: 'order_number',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.MitraPackageScalarFieldEnum = {
  id: 'id',
  period_id: 'period_id',
  airline_id: 'airline_id',
  vendor_id: 'vendor_id',
  hotel_mekkah_id: 'hotel_mekkah_id',
  hotel_madinah_id: 'hotel_madinah_id',
  visa_id: 'visa_id',
  transportation_id: 'transportation_id',
  muthawif_id: 'muthawif_id',
  handling_saudi_id: 'handling_saudi_id',
  handling_domestic_id: 'handling_domestic_id',
  siskopatuh_id: 'siskopatuh_id',
  equipment_id: 'equipment_id',
  tour_plus_id: 'tour_plus_id',
  manasik_id: 'manasik_id',
  number_of_pax: 'number_of_pax',
  departure_date: 'departure_date',
  travel_duration: 'travel_duration',
  mekkah_duration: 'mekkah_duration',
  madinah_duration: 'madinah_duration',
  tour_leader: 'tour_leader',
  margin: 'margin',
  per_pax_price_double: 'per_pax_price_double',
  per_pax_price_triple: 'per_pax_price_triple',
  per_pax_price_quad: 'per_pax_price_quad',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.MitraPackageOrderScalarFieldEnum = {
  id: 'id',
  user_id: 'user_id',
  mitra_package_id: 'mitra_package_id',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.ExchangeRateScalarFieldEnum = {
  id: 'id',
  currency: 'currency',
  rate_idr: 'rate_idr',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.ContactScalarFieldEnum = {
  id: 'id',
  name: 'name',
  value: 'value',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.FaqScalarFieldEnum = {
  id: 'id',
  question: 'question',
  answer: 'answer',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.ContentScalarFieldEnum = {
  id: 'id',
  page: 'page',
  section: 'section',
  type: 'type',
  key: 'key',
  value: 'value',
  visible: 'visible',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.MenuItemScalarFieldEnum = {
  id: 'id',
  name: 'name',
  url: 'url',
  visible: 'visible',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.FooterScalarFieldEnum = {
  id: 'id',
  name: 'name',
  type: 'type',
  visible: 'visible',
  order: 'order',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.FooterItemScalarFieldEnum = {
  id: 'id',
  footer_id: 'footer_id',
  name: 'name',
  url: 'url',
  visible: 'visible',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.ColorScalarFieldEnum = {
  id: 'id',
  name: 'name',
  hex: 'hex',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.JsonNullValueInput = {
  JsonNull: Prisma.JsonNull
};

exports.Prisma.NullsOrder = {
  first: 'first',
  last: 'last'
};

exports.Prisma.JsonNullValueFilter = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull,
  AnyNull: Prisma.AnyNull
};
exports.Role = exports.$Enums.Role = {
  ADMIN: 'ADMIN',
  MITRA: 'MITRA',
  USER: 'USER'
};

exports.RequestStatus = exports.$Enums.RequestStatus = {
  PENDING: 'PENDING',
  APPROVED: 'APPROVED',
  REJECTED: 'REJECTED'
};

exports.City = exports.$Enums.City = {
  MEKKAH: 'MEKKAH',
  MADINAH: 'MADINAH'
};

exports.PeriodCategory = exports.$Enums.PeriodCategory = {
  LOW: 'LOW',
  MID: 'MID',
  HIGH: 'HIGH',
  RAMADHAN: 'RAMADHAN',
  ITIKAF: 'ITIKAF'
};

exports.ContentType = exports.$Enums.ContentType = {
  TEXT: 'TEXT',
  IMAGE: 'IMAGE',
  BUTTON: 'BUTTON',
  BENEFIT_CARD: 'BENEFIT_CARD'
};

exports.FooterType = exports.$Enums.FooterType = {
  MENU: 'MENU',
  LINK: 'LINK',
  SOCIAL_MEDIA: 'SOCIAL_MEDIA'
};

exports.Prisma.ModelName = {
  User: 'User',
  MitraRequest: 'MitraRequest',
  UserPackage: 'UserPackage',
  PackageType: 'PackageType',
  UserPackageOption: 'UserPackageOption',
  UserPackageOrder: 'UserPackageOrder',
  Category: 'Category',
  Product: 'Product',
  ProductThumbnail: 'ProductThumbnail',
  ProductCategory: 'ProductCategory',
  ProductVariation: 'ProductVariation',
  ProductInclude: 'ProductInclude',
  ProductExclude: 'ProductExclude',
  ProductOrder: 'ProductOrder',
  Vendor: 'Vendor',
  Hotel: 'Hotel',
  Period: 'Period',
  HotelPeriodPrice: 'HotelPeriodPrice',
  Airline: 'Airline',
  Visa: 'Visa',
  Transportation: 'Transportation',
  Muthawif: 'Muthawif',
  HandlingSaudi: 'HandlingSaudi',
  HandlingDomestic: 'HandlingDomestic',
  Siskopatuh: 'Siskopatuh',
  Equipment: 'Equipment',
  TourPlus: 'TourPlus',
  Manasik: 'Manasik',
  MitraPackage: 'MitraPackage',
  MitraPackageOrder: 'MitraPackageOrder',
  ExchangeRate: 'ExchangeRate',
  Contact: 'Contact',
  Faq: 'Faq',
  Content: 'Content',
  MenuItem: 'MenuItem',
  Footer: 'Footer',
  FooterItem: 'FooterItem',
  Color: 'Color'
};

/**
 * This is a stub Prisma Client that will error at runtime if called.
 */
class PrismaClient {
  constructor() {
    return new Proxy(this, {
      get(target, prop) {
        let message
        const runtime = getRuntime()
        if (runtime.isEdge) {
          message = `PrismaClient is not configured to run in ${runtime.prettyName}. In order to run Prisma Client on edge runtime, either:
- Use Prisma Accelerate: https://pris.ly/d/accelerate
- Use Driver Adapters: https://pris.ly/d/driver-adapters
`;
        } else {
          message = 'PrismaClient is unable to run in this browser environment, or has been bundled for the browser (running in `' + runtime.prettyName + '`).'
        }
        
        message += `
If this is unexpected, please open an issue: https://pris.ly/prisma-prisma-bug-report`

        throw new Error(message)
      }
    })
  }
}

exports.PrismaClient = PrismaClient

Object.assign(exports, Prisma)
