
/**
 * Client
**/

import * as runtime from '@prisma/client/runtime/library.js';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model User
 * 
 */
export type User = $Result.DefaultSelection<Prisma.$UserPayload>
/**
 * Model MitraRequest
 * 
 */
export type MitraRequest = $Result.DefaultSelection<Prisma.$MitraRequestPayload>
/**
 * Model UserPackage
 * 
 */
export type UserPackage = $Result.DefaultSelection<Prisma.$UserPackagePayload>
/**
 * Model PackageType
 * 
 */
export type PackageType = $Result.DefaultSelection<Prisma.$PackageTypePayload>
/**
 * Model UserPackageOption
 * 
 */
export type UserPackageOption = $Result.DefaultSelection<Prisma.$UserPackageOptionPayload>
/**
 * Model UserPackageOrder
 * 
 */
export type UserPackageOrder = $Result.DefaultSelection<Prisma.$UserPackageOrderPayload>
/**
 * Model Category
 * 
 */
export type Category = $Result.DefaultSelection<Prisma.$CategoryPayload>
/**
 * Model Product
 * 
 */
export type Product = $Result.DefaultSelection<Prisma.$ProductPayload>
/**
 * Model ProductThumbnail
 * 
 */
export type ProductThumbnail = $Result.DefaultSelection<Prisma.$ProductThumbnailPayload>
/**
 * Model ProductCategory
 * 
 */
export type ProductCategory = $Result.DefaultSelection<Prisma.$ProductCategoryPayload>
/**
 * Model ProductVariation
 * 
 */
export type ProductVariation = $Result.DefaultSelection<Prisma.$ProductVariationPayload>
/**
 * Model ProductInclude
 * 
 */
export type ProductInclude = $Result.DefaultSelection<Prisma.$ProductIncludePayload>
/**
 * Model ProductExclude
 * 
 */
export type ProductExclude = $Result.DefaultSelection<Prisma.$ProductExcludePayload>
/**
 * Model ProductOrder
 * 
 */
export type ProductOrder = $Result.DefaultSelection<Prisma.$ProductOrderPayload>
/**
 * Model Vendor
 * 
 */
export type Vendor = $Result.DefaultSelection<Prisma.$VendorPayload>
/**
 * Model Hotel
 * 
 */
export type Hotel = $Result.DefaultSelection<Prisma.$HotelPayload>
/**
 * Model Period
 * 
 */
export type Period = $Result.DefaultSelection<Prisma.$PeriodPayload>
/**
 * Model HotelPeriodPrice
 * 
 */
export type HotelPeriodPrice = $Result.DefaultSelection<Prisma.$HotelPeriodPricePayload>
/**
 * Model Airline
 * 
 */
export type Airline = $Result.DefaultSelection<Prisma.$AirlinePayload>
/**
 * Model Visa
 * 
 */
export type Visa = $Result.DefaultSelection<Prisma.$VisaPayload>
/**
 * Model Transportation
 * 
 */
export type Transportation = $Result.DefaultSelection<Prisma.$TransportationPayload>
/**
 * Model Muthawif
 * 
 */
export type Muthawif = $Result.DefaultSelection<Prisma.$MuthawifPayload>
/**
 * Model HandlingSaudi
 * 
 */
export type HandlingSaudi = $Result.DefaultSelection<Prisma.$HandlingSaudiPayload>
/**
 * Model HandlingDomestic
 * 
 */
export type HandlingDomestic = $Result.DefaultSelection<Prisma.$HandlingDomesticPayload>
/**
 * Model Siskopatuh
 * 
 */
export type Siskopatuh = $Result.DefaultSelection<Prisma.$SiskopatuhPayload>
/**
 * Model Equipment
 * 
 */
export type Equipment = $Result.DefaultSelection<Prisma.$EquipmentPayload>
/**
 * Model TourPlus
 * 
 */
export type TourPlus = $Result.DefaultSelection<Prisma.$TourPlusPayload>
/**
 * Model Manasik
 * 
 */
export type Manasik = $Result.DefaultSelection<Prisma.$ManasikPayload>
/**
 * Model MitraPackage
 * 
 */
export type MitraPackage = $Result.DefaultSelection<Prisma.$MitraPackagePayload>
/**
 * Model MitraPackageOrder
 * 
 */
export type MitraPackageOrder = $Result.DefaultSelection<Prisma.$MitraPackageOrderPayload>
/**
 * Model ExchangeRate
 * 
 */
export type ExchangeRate = $Result.DefaultSelection<Prisma.$ExchangeRatePayload>
/**
 * Model Contact
 * 
 */
export type Contact = $Result.DefaultSelection<Prisma.$ContactPayload>
/**
 * Model Faq
 * 
 */
export type Faq = $Result.DefaultSelection<Prisma.$FaqPayload>
/**
 * Model Content
 * 
 */
export type Content = $Result.DefaultSelection<Prisma.$ContentPayload>
/**
 * Model MenuItem
 * 
 */
export type MenuItem = $Result.DefaultSelection<Prisma.$MenuItemPayload>
/**
 * Model Footer
 * 
 */
export type Footer = $Result.DefaultSelection<Prisma.$FooterPayload>
/**
 * Model FooterItem
 * 
 */
export type FooterItem = $Result.DefaultSelection<Prisma.$FooterItemPayload>
/**
 * Model Color
 * 
 */
export type Color = $Result.DefaultSelection<Prisma.$ColorPayload>

/**
 * Enums
 */
export namespace $Enums {
  export const Role: {
  ADMIN: 'ADMIN',
  MITRA: 'MITRA',
  USER: 'USER'
};

export type Role = (typeof Role)[keyof typeof Role]


export const RequestStatus: {
  PENDING: 'PENDING',
  APPROVED: 'APPROVED',
  REJECTED: 'REJECTED'
};

export type RequestStatus = (typeof RequestStatus)[keyof typeof RequestStatus]


export const City: {
  MEKKAH: 'MEKKAH',
  MADINAH: 'MADINAH'
};

export type City = (typeof City)[keyof typeof City]


export const PeriodCategory: {
  LOW: 'LOW',
  MID: 'MID',
  HIGH: 'HIGH',
  RAMADHAN: 'RAMADHAN',
  ITIKAF: 'ITIKAF'
};

export type PeriodCategory = (typeof PeriodCategory)[keyof typeof PeriodCategory]


export const ContentType: {
  TEXT: 'TEXT',
  IMAGE: 'IMAGE',
  BUTTON: 'BUTTON',
  BENEFIT_CARD: 'BENEFIT_CARD'
};

export type ContentType = (typeof ContentType)[keyof typeof ContentType]


export const FooterType: {
  MENU: 'MENU',
  LINK: 'LINK',
  SOCIAL_MEDIA: 'SOCIAL_MEDIA'
};

export type FooterType = (typeof FooterType)[keyof typeof FooterType]

}

export type Role = $Enums.Role

export const Role: typeof $Enums.Role

export type RequestStatus = $Enums.RequestStatus

export const RequestStatus: typeof $Enums.RequestStatus

export type City = $Enums.City

export const City: typeof $Enums.City

export type PeriodCategory = $Enums.PeriodCategory

export const PeriodCategory: typeof $Enums.PeriodCategory

export type ContentType = $Enums.ContentType

export const ContentType: typeof $Enums.ContentType

export type FooterType = $Enums.FooterType

export const FooterType: typeof $Enums.FooterType

/**
 * ##  Prisma Client ʲˢ
 * 
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Users
 * const users = await prisma.user.findMany()
 * ```
 *
 * 
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  ClientOptions extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof ClientOptions ? ClientOptions['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<ClientOptions['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   * 
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Users
   * const users = await prisma.user.findMany()
   * ```
   *
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<ClientOptions, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): void;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

  /**
   * Add a middleware
   * @deprecated since 4.16.0. For new code, prefer client extensions instead.
   * @see https://pris.ly/d/extensions
   */
  $use(cb: Prisma.Middleware): void

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;


  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<R>


  $extends: $Extensions.ExtendsHook<"extends", Prisma.TypeMapCb, ExtArgs>

      /**
   * `prisma.user`: Exposes CRUD operations for the **User** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Users
    * const users = await prisma.user.findMany()
    * ```
    */
  get user(): Prisma.UserDelegate<ExtArgs>;

  /**
   * `prisma.mitraRequest`: Exposes CRUD operations for the **MitraRequest** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more MitraRequests
    * const mitraRequests = await prisma.mitraRequest.findMany()
    * ```
    */
  get mitraRequest(): Prisma.MitraRequestDelegate<ExtArgs>;

  /**
   * `prisma.userPackage`: Exposes CRUD operations for the **UserPackage** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserPackages
    * const userPackages = await prisma.userPackage.findMany()
    * ```
    */
  get userPackage(): Prisma.UserPackageDelegate<ExtArgs>;

  /**
   * `prisma.packageType`: Exposes CRUD operations for the **PackageType** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more PackageTypes
    * const packageTypes = await prisma.packageType.findMany()
    * ```
    */
  get packageType(): Prisma.PackageTypeDelegate<ExtArgs>;

  /**
   * `prisma.userPackageOption`: Exposes CRUD operations for the **UserPackageOption** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserPackageOptions
    * const userPackageOptions = await prisma.userPackageOption.findMany()
    * ```
    */
  get userPackageOption(): Prisma.UserPackageOptionDelegate<ExtArgs>;

  /**
   * `prisma.userPackageOrder`: Exposes CRUD operations for the **UserPackageOrder** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserPackageOrders
    * const userPackageOrders = await prisma.userPackageOrder.findMany()
    * ```
    */
  get userPackageOrder(): Prisma.UserPackageOrderDelegate<ExtArgs>;

  /**
   * `prisma.category`: Exposes CRUD operations for the **Category** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Categories
    * const categories = await prisma.category.findMany()
    * ```
    */
  get category(): Prisma.CategoryDelegate<ExtArgs>;

  /**
   * `prisma.product`: Exposes CRUD operations for the **Product** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Products
    * const products = await prisma.product.findMany()
    * ```
    */
  get product(): Prisma.ProductDelegate<ExtArgs>;

  /**
   * `prisma.productThumbnail`: Exposes CRUD operations for the **ProductThumbnail** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ProductThumbnails
    * const productThumbnails = await prisma.productThumbnail.findMany()
    * ```
    */
  get productThumbnail(): Prisma.ProductThumbnailDelegate<ExtArgs>;

  /**
   * `prisma.productCategory`: Exposes CRUD operations for the **ProductCategory** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ProductCategories
    * const productCategories = await prisma.productCategory.findMany()
    * ```
    */
  get productCategory(): Prisma.ProductCategoryDelegate<ExtArgs>;

  /**
   * `prisma.productVariation`: Exposes CRUD operations for the **ProductVariation** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ProductVariations
    * const productVariations = await prisma.productVariation.findMany()
    * ```
    */
  get productVariation(): Prisma.ProductVariationDelegate<ExtArgs>;

  /**
   * `prisma.productInclude`: Exposes CRUD operations for the **ProductInclude** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ProductIncludes
    * const productIncludes = await prisma.productInclude.findMany()
    * ```
    */
  get productInclude(): Prisma.ProductIncludeDelegate<ExtArgs>;

  /**
   * `prisma.productExclude`: Exposes CRUD operations for the **ProductExclude** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ProductExcludes
    * const productExcludes = await prisma.productExclude.findMany()
    * ```
    */
  get productExclude(): Prisma.ProductExcludeDelegate<ExtArgs>;

  /**
   * `prisma.productOrder`: Exposes CRUD operations for the **ProductOrder** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ProductOrders
    * const productOrders = await prisma.productOrder.findMany()
    * ```
    */
  get productOrder(): Prisma.ProductOrderDelegate<ExtArgs>;

  /**
   * `prisma.vendor`: Exposes CRUD operations for the **Vendor** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Vendors
    * const vendors = await prisma.vendor.findMany()
    * ```
    */
  get vendor(): Prisma.VendorDelegate<ExtArgs>;

  /**
   * `prisma.hotel`: Exposes CRUD operations for the **Hotel** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Hotels
    * const hotels = await prisma.hotel.findMany()
    * ```
    */
  get hotel(): Prisma.HotelDelegate<ExtArgs>;

  /**
   * `prisma.period`: Exposes CRUD operations for the **Period** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Periods
    * const periods = await prisma.period.findMany()
    * ```
    */
  get period(): Prisma.PeriodDelegate<ExtArgs>;

  /**
   * `prisma.hotelPeriodPrice`: Exposes CRUD operations for the **HotelPeriodPrice** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more HotelPeriodPrices
    * const hotelPeriodPrices = await prisma.hotelPeriodPrice.findMany()
    * ```
    */
  get hotelPeriodPrice(): Prisma.HotelPeriodPriceDelegate<ExtArgs>;

  /**
   * `prisma.airline`: Exposes CRUD operations for the **Airline** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Airlines
    * const airlines = await prisma.airline.findMany()
    * ```
    */
  get airline(): Prisma.AirlineDelegate<ExtArgs>;

  /**
   * `prisma.visa`: Exposes CRUD operations for the **Visa** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Visas
    * const visas = await prisma.visa.findMany()
    * ```
    */
  get visa(): Prisma.VisaDelegate<ExtArgs>;

  /**
   * `prisma.transportation`: Exposes CRUD operations for the **Transportation** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Transportation
    * const transportation = await prisma.transportation.findMany()
    * ```
    */
  get transportation(): Prisma.TransportationDelegate<ExtArgs>;

  /**
   * `prisma.muthawif`: Exposes CRUD operations for the **Muthawif** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Muthawifs
    * const muthawifs = await prisma.muthawif.findMany()
    * ```
    */
  get muthawif(): Prisma.MuthawifDelegate<ExtArgs>;

  /**
   * `prisma.handlingSaudi`: Exposes CRUD operations for the **HandlingSaudi** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more HandlingSaudis
    * const handlingSaudis = await prisma.handlingSaudi.findMany()
    * ```
    */
  get handlingSaudi(): Prisma.HandlingSaudiDelegate<ExtArgs>;

  /**
   * `prisma.handlingDomestic`: Exposes CRUD operations for the **HandlingDomestic** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more HandlingDomestics
    * const handlingDomestics = await prisma.handlingDomestic.findMany()
    * ```
    */
  get handlingDomestic(): Prisma.HandlingDomesticDelegate<ExtArgs>;

  /**
   * `prisma.siskopatuh`: Exposes CRUD operations for the **Siskopatuh** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Siskopatuhs
    * const siskopatuhs = await prisma.siskopatuh.findMany()
    * ```
    */
  get siskopatuh(): Prisma.SiskopatuhDelegate<ExtArgs>;

  /**
   * `prisma.equipment`: Exposes CRUD operations for the **Equipment** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Equipment
    * const equipment = await prisma.equipment.findMany()
    * ```
    */
  get equipment(): Prisma.EquipmentDelegate<ExtArgs>;

  /**
   * `prisma.tourPlus`: Exposes CRUD operations for the **TourPlus** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more TourPluses
    * const tourPluses = await prisma.tourPlus.findMany()
    * ```
    */
  get tourPlus(): Prisma.TourPlusDelegate<ExtArgs>;

  /**
   * `prisma.manasik`: Exposes CRUD operations for the **Manasik** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Manasiks
    * const manasiks = await prisma.manasik.findMany()
    * ```
    */
  get manasik(): Prisma.ManasikDelegate<ExtArgs>;

  /**
   * `prisma.mitraPackage`: Exposes CRUD operations for the **MitraPackage** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more MitraPackages
    * const mitraPackages = await prisma.mitraPackage.findMany()
    * ```
    */
  get mitraPackage(): Prisma.MitraPackageDelegate<ExtArgs>;

  /**
   * `prisma.mitraPackageOrder`: Exposes CRUD operations for the **MitraPackageOrder** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more MitraPackageOrders
    * const mitraPackageOrders = await prisma.mitraPackageOrder.findMany()
    * ```
    */
  get mitraPackageOrder(): Prisma.MitraPackageOrderDelegate<ExtArgs>;

  /**
   * `prisma.exchangeRate`: Exposes CRUD operations for the **ExchangeRate** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ExchangeRates
    * const exchangeRates = await prisma.exchangeRate.findMany()
    * ```
    */
  get exchangeRate(): Prisma.ExchangeRateDelegate<ExtArgs>;

  /**
   * `prisma.contact`: Exposes CRUD operations for the **Contact** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Contacts
    * const contacts = await prisma.contact.findMany()
    * ```
    */
  get contact(): Prisma.ContactDelegate<ExtArgs>;

  /**
   * `prisma.faq`: Exposes CRUD operations for the **Faq** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Faqs
    * const faqs = await prisma.faq.findMany()
    * ```
    */
  get faq(): Prisma.FaqDelegate<ExtArgs>;

  /**
   * `prisma.content`: Exposes CRUD operations for the **Content** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Contents
    * const contents = await prisma.content.findMany()
    * ```
    */
  get content(): Prisma.ContentDelegate<ExtArgs>;

  /**
   * `prisma.menuItem`: Exposes CRUD operations for the **MenuItem** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more MenuItems
    * const menuItems = await prisma.menuItem.findMany()
    * ```
    */
  get menuItem(): Prisma.MenuItemDelegate<ExtArgs>;

  /**
   * `prisma.footer`: Exposes CRUD operations for the **Footer** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Footers
    * const footers = await prisma.footer.findMany()
    * ```
    */
  get footer(): Prisma.FooterDelegate<ExtArgs>;

  /**
   * `prisma.footerItem`: Exposes CRUD operations for the **FooterItem** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more FooterItems
    * const footerItems = await prisma.footerItem.findMany()
    * ```
    */
  get footerItem(): Prisma.FooterItemDelegate<ExtArgs>;

  /**
   * `prisma.color`: Exposes CRUD operations for the **Color** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Colors
    * const colors = await prisma.color.findMany()
    * ```
    */
  get color(): Prisma.ColorDelegate<ExtArgs>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError
  export import NotFoundError = runtime.NotFoundError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql



  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics 
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 5.21.1
   * Query Engine version: bf0e5e8a04cada8225617067eaa03d041e2bba36
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion 

  /**
   * Utility Types
   */


  export import JsonObject = runtime.JsonObject
  export import JsonArray = runtime.JsonArray
  export import JsonValue = runtime.JsonValue
  export import InputJsonObject = runtime.InputJsonObject
  export import InputJsonArray = runtime.InputJsonArray
  export import InputJsonValue = runtime.InputJsonValue

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  type SelectAndOmit = {
    select: any
    omit: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : T extends SelectAndOmit
        ? 'Please either choose `select` or `omit`.'
        : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? K : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    User: 'User',
    MitraRequest: 'MitraRequest',
    UserPackage: 'UserPackage',
    PackageType: 'PackageType',
    UserPackageOption: 'UserPackageOption',
    UserPackageOrder: 'UserPackageOrder',
    Category: 'Category',
    Product: 'Product',
    ProductThumbnail: 'ProductThumbnail',
    ProductCategory: 'ProductCategory',
    ProductVariation: 'ProductVariation',
    ProductInclude: 'ProductInclude',
    ProductExclude: 'ProductExclude',
    ProductOrder: 'ProductOrder',
    Vendor: 'Vendor',
    Hotel: 'Hotel',
    Period: 'Period',
    HotelPeriodPrice: 'HotelPeriodPrice',
    Airline: 'Airline',
    Visa: 'Visa',
    Transportation: 'Transportation',
    Muthawif: 'Muthawif',
    HandlingSaudi: 'HandlingSaudi',
    HandlingDomestic: 'HandlingDomestic',
    Siskopatuh: 'Siskopatuh',
    Equipment: 'Equipment',
    TourPlus: 'TourPlus',
    Manasik: 'Manasik',
    MitraPackage: 'MitraPackage',
    MitraPackageOrder: 'MitraPackageOrder',
    ExchangeRate: 'ExchangeRate',
    Contact: 'Contact',
    Faq: 'Faq',
    Content: 'Content',
    MenuItem: 'MenuItem',
    Footer: 'Footer',
    FooterItem: 'FooterItem',
    Color: 'Color'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }

  interface TypeMapCb extends $Utils.Fn<{extArgs: $Extensions.InternalArgs, clientOptions: PrismaClientOptions }, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs'], this['params']['clientOptions']>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> = {
    meta: {
      modelProps: "user" | "mitraRequest" | "userPackage" | "packageType" | "userPackageOption" | "userPackageOrder" | "category" | "product" | "productThumbnail" | "productCategory" | "productVariation" | "productInclude" | "productExclude" | "productOrder" | "vendor" | "hotel" | "period" | "hotelPeriodPrice" | "airline" | "visa" | "transportation" | "muthawif" | "handlingSaudi" | "handlingDomestic" | "siskopatuh" | "equipment" | "tourPlus" | "manasik" | "mitraPackage" | "mitraPackageOrder" | "exchangeRate" | "contact" | "faq" | "content" | "menuItem" | "footer" | "footerItem" | "color"
      txIsolationLevel: Prisma.TransactionIsolationLevel
    }
    model: {
      User: {
        payload: Prisma.$UserPayload<ExtArgs>
        fields: Prisma.UserFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findFirst: {
            args: Prisma.UserFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findMany: {
            args: Prisma.UserFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          create: {
            args: Prisma.UserCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          createMany: {
            args: Prisma.UserCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.UserDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          update: {
            args: Prisma.UserUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          deleteMany: {
            args: Prisma.UserDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.UserUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.UserUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          aggregate: {
            args: Prisma.UserAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUser>
          }
          groupBy: {
            args: Prisma.UserGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserCountArgs<ExtArgs>
            result: $Utils.Optional<UserCountAggregateOutputType> | number
          }
        }
      }
      MitraRequest: {
        payload: Prisma.$MitraRequestPayload<ExtArgs>
        fields: Prisma.MitraRequestFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MitraRequestFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraRequestPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MitraRequestFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraRequestPayload>
          }
          findFirst: {
            args: Prisma.MitraRequestFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraRequestPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MitraRequestFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraRequestPayload>
          }
          findMany: {
            args: Prisma.MitraRequestFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraRequestPayload>[]
          }
          create: {
            args: Prisma.MitraRequestCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraRequestPayload>
          }
          createMany: {
            args: Prisma.MitraRequestCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.MitraRequestDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraRequestPayload>
          }
          update: {
            args: Prisma.MitraRequestUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraRequestPayload>
          }
          deleteMany: {
            args: Prisma.MitraRequestDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.MitraRequestUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.MitraRequestUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraRequestPayload>
          }
          aggregate: {
            args: Prisma.MitraRequestAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateMitraRequest>
          }
          groupBy: {
            args: Prisma.MitraRequestGroupByArgs<ExtArgs>
            result: $Utils.Optional<MitraRequestGroupByOutputType>[]
          }
          count: {
            args: Prisma.MitraRequestCountArgs<ExtArgs>
            result: $Utils.Optional<MitraRequestCountAggregateOutputType> | number
          }
        }
      }
      UserPackage: {
        payload: Prisma.$UserPackagePayload<ExtArgs>
        fields: Prisma.UserPackageFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserPackageFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackagePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserPackageFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackagePayload>
          }
          findFirst: {
            args: Prisma.UserPackageFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackagePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserPackageFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackagePayload>
          }
          findMany: {
            args: Prisma.UserPackageFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackagePayload>[]
          }
          create: {
            args: Prisma.UserPackageCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackagePayload>
          }
          createMany: {
            args: Prisma.UserPackageCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.UserPackageDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackagePayload>
          }
          update: {
            args: Prisma.UserPackageUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackagePayload>
          }
          deleteMany: {
            args: Prisma.UserPackageDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.UserPackageUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.UserPackageUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackagePayload>
          }
          aggregate: {
            args: Prisma.UserPackageAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUserPackage>
          }
          groupBy: {
            args: Prisma.UserPackageGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserPackageGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserPackageCountArgs<ExtArgs>
            result: $Utils.Optional<UserPackageCountAggregateOutputType> | number
          }
        }
      }
      PackageType: {
        payload: Prisma.$PackageTypePayload<ExtArgs>
        fields: Prisma.PackageTypeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.PackageTypeFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PackageTypePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.PackageTypeFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PackageTypePayload>
          }
          findFirst: {
            args: Prisma.PackageTypeFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PackageTypePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.PackageTypeFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PackageTypePayload>
          }
          findMany: {
            args: Prisma.PackageTypeFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PackageTypePayload>[]
          }
          create: {
            args: Prisma.PackageTypeCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PackageTypePayload>
          }
          createMany: {
            args: Prisma.PackageTypeCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.PackageTypeDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PackageTypePayload>
          }
          update: {
            args: Prisma.PackageTypeUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PackageTypePayload>
          }
          deleteMany: {
            args: Prisma.PackageTypeDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.PackageTypeUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.PackageTypeUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PackageTypePayload>
          }
          aggregate: {
            args: Prisma.PackageTypeAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregatePackageType>
          }
          groupBy: {
            args: Prisma.PackageTypeGroupByArgs<ExtArgs>
            result: $Utils.Optional<PackageTypeGroupByOutputType>[]
          }
          count: {
            args: Prisma.PackageTypeCountArgs<ExtArgs>
            result: $Utils.Optional<PackageTypeCountAggregateOutputType> | number
          }
        }
      }
      UserPackageOption: {
        payload: Prisma.$UserPackageOptionPayload<ExtArgs>
        fields: Prisma.UserPackageOptionFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserPackageOptionFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOptionPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserPackageOptionFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOptionPayload>
          }
          findFirst: {
            args: Prisma.UserPackageOptionFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOptionPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserPackageOptionFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOptionPayload>
          }
          findMany: {
            args: Prisma.UserPackageOptionFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOptionPayload>[]
          }
          create: {
            args: Prisma.UserPackageOptionCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOptionPayload>
          }
          createMany: {
            args: Prisma.UserPackageOptionCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.UserPackageOptionDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOptionPayload>
          }
          update: {
            args: Prisma.UserPackageOptionUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOptionPayload>
          }
          deleteMany: {
            args: Prisma.UserPackageOptionDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.UserPackageOptionUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.UserPackageOptionUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOptionPayload>
          }
          aggregate: {
            args: Prisma.UserPackageOptionAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUserPackageOption>
          }
          groupBy: {
            args: Prisma.UserPackageOptionGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserPackageOptionGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserPackageOptionCountArgs<ExtArgs>
            result: $Utils.Optional<UserPackageOptionCountAggregateOutputType> | number
          }
        }
      }
      UserPackageOrder: {
        payload: Prisma.$UserPackageOrderPayload<ExtArgs>
        fields: Prisma.UserPackageOrderFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserPackageOrderFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOrderPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserPackageOrderFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOrderPayload>
          }
          findFirst: {
            args: Prisma.UserPackageOrderFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOrderPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserPackageOrderFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOrderPayload>
          }
          findMany: {
            args: Prisma.UserPackageOrderFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOrderPayload>[]
          }
          create: {
            args: Prisma.UserPackageOrderCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOrderPayload>
          }
          createMany: {
            args: Prisma.UserPackageOrderCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.UserPackageOrderDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOrderPayload>
          }
          update: {
            args: Prisma.UserPackageOrderUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOrderPayload>
          }
          deleteMany: {
            args: Prisma.UserPackageOrderDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.UserPackageOrderUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.UserPackageOrderUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPackageOrderPayload>
          }
          aggregate: {
            args: Prisma.UserPackageOrderAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUserPackageOrder>
          }
          groupBy: {
            args: Prisma.UserPackageOrderGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserPackageOrderGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserPackageOrderCountArgs<ExtArgs>
            result: $Utils.Optional<UserPackageOrderCountAggregateOutputType> | number
          }
        }
      }
      Category: {
        payload: Prisma.$CategoryPayload<ExtArgs>
        fields: Prisma.CategoryFieldRefs
        operations: {
          findUnique: {
            args: Prisma.CategoryFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.CategoryFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>
          }
          findFirst: {
            args: Prisma.CategoryFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.CategoryFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>
          }
          findMany: {
            args: Prisma.CategoryFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>[]
          }
          create: {
            args: Prisma.CategoryCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>
          }
          createMany: {
            args: Prisma.CategoryCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.CategoryDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>
          }
          update: {
            args: Prisma.CategoryUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>
          }
          deleteMany: {
            args: Prisma.CategoryDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.CategoryUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.CategoryUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>
          }
          aggregate: {
            args: Prisma.CategoryAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateCategory>
          }
          groupBy: {
            args: Prisma.CategoryGroupByArgs<ExtArgs>
            result: $Utils.Optional<CategoryGroupByOutputType>[]
          }
          count: {
            args: Prisma.CategoryCountArgs<ExtArgs>
            result: $Utils.Optional<CategoryCountAggregateOutputType> | number
          }
        }
      }
      Product: {
        payload: Prisma.$ProductPayload<ExtArgs>
        fields: Prisma.ProductFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProductFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProductFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductPayload>
          }
          findFirst: {
            args: Prisma.ProductFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProductFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductPayload>
          }
          findMany: {
            args: Prisma.ProductFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductPayload>[]
          }
          create: {
            args: Prisma.ProductCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductPayload>
          }
          createMany: {
            args: Prisma.ProductCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ProductDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductPayload>
          }
          update: {
            args: Prisma.ProductUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductPayload>
          }
          deleteMany: {
            args: Prisma.ProductDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProductUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ProductUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductPayload>
          }
          aggregate: {
            args: Prisma.ProductAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProduct>
          }
          groupBy: {
            args: Prisma.ProductGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProductGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProductCountArgs<ExtArgs>
            result: $Utils.Optional<ProductCountAggregateOutputType> | number
          }
        }
      }
      ProductThumbnail: {
        payload: Prisma.$ProductThumbnailPayload<ExtArgs>
        fields: Prisma.ProductThumbnailFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProductThumbnailFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductThumbnailPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProductThumbnailFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductThumbnailPayload>
          }
          findFirst: {
            args: Prisma.ProductThumbnailFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductThumbnailPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProductThumbnailFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductThumbnailPayload>
          }
          findMany: {
            args: Prisma.ProductThumbnailFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductThumbnailPayload>[]
          }
          create: {
            args: Prisma.ProductThumbnailCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductThumbnailPayload>
          }
          createMany: {
            args: Prisma.ProductThumbnailCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ProductThumbnailDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductThumbnailPayload>
          }
          update: {
            args: Prisma.ProductThumbnailUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductThumbnailPayload>
          }
          deleteMany: {
            args: Prisma.ProductThumbnailDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProductThumbnailUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ProductThumbnailUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductThumbnailPayload>
          }
          aggregate: {
            args: Prisma.ProductThumbnailAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProductThumbnail>
          }
          groupBy: {
            args: Prisma.ProductThumbnailGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProductThumbnailGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProductThumbnailCountArgs<ExtArgs>
            result: $Utils.Optional<ProductThumbnailCountAggregateOutputType> | number
          }
        }
      }
      ProductCategory: {
        payload: Prisma.$ProductCategoryPayload<ExtArgs>
        fields: Prisma.ProductCategoryFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProductCategoryFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductCategoryPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProductCategoryFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductCategoryPayload>
          }
          findFirst: {
            args: Prisma.ProductCategoryFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductCategoryPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProductCategoryFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductCategoryPayload>
          }
          findMany: {
            args: Prisma.ProductCategoryFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductCategoryPayload>[]
          }
          create: {
            args: Prisma.ProductCategoryCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductCategoryPayload>
          }
          createMany: {
            args: Prisma.ProductCategoryCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ProductCategoryDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductCategoryPayload>
          }
          update: {
            args: Prisma.ProductCategoryUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductCategoryPayload>
          }
          deleteMany: {
            args: Prisma.ProductCategoryDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProductCategoryUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ProductCategoryUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductCategoryPayload>
          }
          aggregate: {
            args: Prisma.ProductCategoryAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProductCategory>
          }
          groupBy: {
            args: Prisma.ProductCategoryGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProductCategoryGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProductCategoryCountArgs<ExtArgs>
            result: $Utils.Optional<ProductCategoryCountAggregateOutputType> | number
          }
        }
      }
      ProductVariation: {
        payload: Prisma.$ProductVariationPayload<ExtArgs>
        fields: Prisma.ProductVariationFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProductVariationFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductVariationPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProductVariationFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductVariationPayload>
          }
          findFirst: {
            args: Prisma.ProductVariationFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductVariationPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProductVariationFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductVariationPayload>
          }
          findMany: {
            args: Prisma.ProductVariationFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductVariationPayload>[]
          }
          create: {
            args: Prisma.ProductVariationCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductVariationPayload>
          }
          createMany: {
            args: Prisma.ProductVariationCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ProductVariationDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductVariationPayload>
          }
          update: {
            args: Prisma.ProductVariationUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductVariationPayload>
          }
          deleteMany: {
            args: Prisma.ProductVariationDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProductVariationUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ProductVariationUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductVariationPayload>
          }
          aggregate: {
            args: Prisma.ProductVariationAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProductVariation>
          }
          groupBy: {
            args: Prisma.ProductVariationGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProductVariationGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProductVariationCountArgs<ExtArgs>
            result: $Utils.Optional<ProductVariationCountAggregateOutputType> | number
          }
        }
      }
      ProductInclude: {
        payload: Prisma.$ProductIncludePayload<ExtArgs>
        fields: Prisma.ProductIncludeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProductIncludeFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductIncludePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProductIncludeFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductIncludePayload>
          }
          findFirst: {
            args: Prisma.ProductIncludeFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductIncludePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProductIncludeFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductIncludePayload>
          }
          findMany: {
            args: Prisma.ProductIncludeFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductIncludePayload>[]
          }
          create: {
            args: Prisma.ProductIncludeCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductIncludePayload>
          }
          createMany: {
            args: Prisma.ProductIncludeCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ProductIncludeDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductIncludePayload>
          }
          update: {
            args: Prisma.ProductIncludeUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductIncludePayload>
          }
          deleteMany: {
            args: Prisma.ProductIncludeDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProductIncludeUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ProductIncludeUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductIncludePayload>
          }
          aggregate: {
            args: Prisma.ProductIncludeAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProductInclude>
          }
          groupBy: {
            args: Prisma.ProductIncludeGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProductIncludeGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProductIncludeCountArgs<ExtArgs>
            result: $Utils.Optional<ProductIncludeCountAggregateOutputType> | number
          }
        }
      }
      ProductExclude: {
        payload: Prisma.$ProductExcludePayload<ExtArgs>
        fields: Prisma.ProductExcludeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProductExcludeFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductExcludePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProductExcludeFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductExcludePayload>
          }
          findFirst: {
            args: Prisma.ProductExcludeFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductExcludePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProductExcludeFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductExcludePayload>
          }
          findMany: {
            args: Prisma.ProductExcludeFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductExcludePayload>[]
          }
          create: {
            args: Prisma.ProductExcludeCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductExcludePayload>
          }
          createMany: {
            args: Prisma.ProductExcludeCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ProductExcludeDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductExcludePayload>
          }
          update: {
            args: Prisma.ProductExcludeUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductExcludePayload>
          }
          deleteMany: {
            args: Prisma.ProductExcludeDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProductExcludeUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ProductExcludeUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductExcludePayload>
          }
          aggregate: {
            args: Prisma.ProductExcludeAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProductExclude>
          }
          groupBy: {
            args: Prisma.ProductExcludeGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProductExcludeGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProductExcludeCountArgs<ExtArgs>
            result: $Utils.Optional<ProductExcludeCountAggregateOutputType> | number
          }
        }
      }
      ProductOrder: {
        payload: Prisma.$ProductOrderPayload<ExtArgs>
        fields: Prisma.ProductOrderFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProductOrderFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductOrderPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProductOrderFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductOrderPayload>
          }
          findFirst: {
            args: Prisma.ProductOrderFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductOrderPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProductOrderFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductOrderPayload>
          }
          findMany: {
            args: Prisma.ProductOrderFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductOrderPayload>[]
          }
          create: {
            args: Prisma.ProductOrderCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductOrderPayload>
          }
          createMany: {
            args: Prisma.ProductOrderCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ProductOrderDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductOrderPayload>
          }
          update: {
            args: Prisma.ProductOrderUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductOrderPayload>
          }
          deleteMany: {
            args: Prisma.ProductOrderDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProductOrderUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ProductOrderUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProductOrderPayload>
          }
          aggregate: {
            args: Prisma.ProductOrderAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProductOrder>
          }
          groupBy: {
            args: Prisma.ProductOrderGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProductOrderGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProductOrderCountArgs<ExtArgs>
            result: $Utils.Optional<ProductOrderCountAggregateOutputType> | number
          }
        }
      }
      Vendor: {
        payload: Prisma.$VendorPayload<ExtArgs>
        fields: Prisma.VendorFieldRefs
        operations: {
          findUnique: {
            args: Prisma.VendorFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VendorPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.VendorFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VendorPayload>
          }
          findFirst: {
            args: Prisma.VendorFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VendorPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.VendorFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VendorPayload>
          }
          findMany: {
            args: Prisma.VendorFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VendorPayload>[]
          }
          create: {
            args: Prisma.VendorCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VendorPayload>
          }
          createMany: {
            args: Prisma.VendorCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.VendorDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VendorPayload>
          }
          update: {
            args: Prisma.VendorUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VendorPayload>
          }
          deleteMany: {
            args: Prisma.VendorDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.VendorUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.VendorUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VendorPayload>
          }
          aggregate: {
            args: Prisma.VendorAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateVendor>
          }
          groupBy: {
            args: Prisma.VendorGroupByArgs<ExtArgs>
            result: $Utils.Optional<VendorGroupByOutputType>[]
          }
          count: {
            args: Prisma.VendorCountArgs<ExtArgs>
            result: $Utils.Optional<VendorCountAggregateOutputType> | number
          }
        }
      }
      Hotel: {
        payload: Prisma.$HotelPayload<ExtArgs>
        fields: Prisma.HotelFieldRefs
        operations: {
          findUnique: {
            args: Prisma.HotelFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.HotelFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPayload>
          }
          findFirst: {
            args: Prisma.HotelFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.HotelFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPayload>
          }
          findMany: {
            args: Prisma.HotelFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPayload>[]
          }
          create: {
            args: Prisma.HotelCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPayload>
          }
          createMany: {
            args: Prisma.HotelCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.HotelDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPayload>
          }
          update: {
            args: Prisma.HotelUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPayload>
          }
          deleteMany: {
            args: Prisma.HotelDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.HotelUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.HotelUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPayload>
          }
          aggregate: {
            args: Prisma.HotelAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateHotel>
          }
          groupBy: {
            args: Prisma.HotelGroupByArgs<ExtArgs>
            result: $Utils.Optional<HotelGroupByOutputType>[]
          }
          count: {
            args: Prisma.HotelCountArgs<ExtArgs>
            result: $Utils.Optional<HotelCountAggregateOutputType> | number
          }
        }
      }
      Period: {
        payload: Prisma.$PeriodPayload<ExtArgs>
        fields: Prisma.PeriodFieldRefs
        operations: {
          findUnique: {
            args: Prisma.PeriodFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PeriodPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.PeriodFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PeriodPayload>
          }
          findFirst: {
            args: Prisma.PeriodFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PeriodPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.PeriodFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PeriodPayload>
          }
          findMany: {
            args: Prisma.PeriodFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PeriodPayload>[]
          }
          create: {
            args: Prisma.PeriodCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PeriodPayload>
          }
          createMany: {
            args: Prisma.PeriodCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.PeriodDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PeriodPayload>
          }
          update: {
            args: Prisma.PeriodUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PeriodPayload>
          }
          deleteMany: {
            args: Prisma.PeriodDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.PeriodUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.PeriodUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PeriodPayload>
          }
          aggregate: {
            args: Prisma.PeriodAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregatePeriod>
          }
          groupBy: {
            args: Prisma.PeriodGroupByArgs<ExtArgs>
            result: $Utils.Optional<PeriodGroupByOutputType>[]
          }
          count: {
            args: Prisma.PeriodCountArgs<ExtArgs>
            result: $Utils.Optional<PeriodCountAggregateOutputType> | number
          }
        }
      }
      HotelPeriodPrice: {
        payload: Prisma.$HotelPeriodPricePayload<ExtArgs>
        fields: Prisma.HotelPeriodPriceFieldRefs
        operations: {
          findUnique: {
            args: Prisma.HotelPeriodPriceFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPeriodPricePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.HotelPeriodPriceFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPeriodPricePayload>
          }
          findFirst: {
            args: Prisma.HotelPeriodPriceFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPeriodPricePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.HotelPeriodPriceFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPeriodPricePayload>
          }
          findMany: {
            args: Prisma.HotelPeriodPriceFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPeriodPricePayload>[]
          }
          create: {
            args: Prisma.HotelPeriodPriceCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPeriodPricePayload>
          }
          createMany: {
            args: Prisma.HotelPeriodPriceCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.HotelPeriodPriceDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPeriodPricePayload>
          }
          update: {
            args: Prisma.HotelPeriodPriceUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPeriodPricePayload>
          }
          deleteMany: {
            args: Prisma.HotelPeriodPriceDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.HotelPeriodPriceUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.HotelPeriodPriceUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HotelPeriodPricePayload>
          }
          aggregate: {
            args: Prisma.HotelPeriodPriceAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateHotelPeriodPrice>
          }
          groupBy: {
            args: Prisma.HotelPeriodPriceGroupByArgs<ExtArgs>
            result: $Utils.Optional<HotelPeriodPriceGroupByOutputType>[]
          }
          count: {
            args: Prisma.HotelPeriodPriceCountArgs<ExtArgs>
            result: $Utils.Optional<HotelPeriodPriceCountAggregateOutputType> | number
          }
        }
      }
      Airline: {
        payload: Prisma.$AirlinePayload<ExtArgs>
        fields: Prisma.AirlineFieldRefs
        operations: {
          findUnique: {
            args: Prisma.AirlineFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AirlinePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.AirlineFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AirlinePayload>
          }
          findFirst: {
            args: Prisma.AirlineFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AirlinePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.AirlineFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AirlinePayload>
          }
          findMany: {
            args: Prisma.AirlineFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AirlinePayload>[]
          }
          create: {
            args: Prisma.AirlineCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AirlinePayload>
          }
          createMany: {
            args: Prisma.AirlineCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.AirlineDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AirlinePayload>
          }
          update: {
            args: Prisma.AirlineUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AirlinePayload>
          }
          deleteMany: {
            args: Prisma.AirlineDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.AirlineUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.AirlineUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AirlinePayload>
          }
          aggregate: {
            args: Prisma.AirlineAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAirline>
          }
          groupBy: {
            args: Prisma.AirlineGroupByArgs<ExtArgs>
            result: $Utils.Optional<AirlineGroupByOutputType>[]
          }
          count: {
            args: Prisma.AirlineCountArgs<ExtArgs>
            result: $Utils.Optional<AirlineCountAggregateOutputType> | number
          }
        }
      }
      Visa: {
        payload: Prisma.$VisaPayload<ExtArgs>
        fields: Prisma.VisaFieldRefs
        operations: {
          findUnique: {
            args: Prisma.VisaFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VisaPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.VisaFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VisaPayload>
          }
          findFirst: {
            args: Prisma.VisaFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VisaPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.VisaFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VisaPayload>
          }
          findMany: {
            args: Prisma.VisaFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VisaPayload>[]
          }
          create: {
            args: Prisma.VisaCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VisaPayload>
          }
          createMany: {
            args: Prisma.VisaCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.VisaDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VisaPayload>
          }
          update: {
            args: Prisma.VisaUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VisaPayload>
          }
          deleteMany: {
            args: Prisma.VisaDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.VisaUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.VisaUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VisaPayload>
          }
          aggregate: {
            args: Prisma.VisaAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateVisa>
          }
          groupBy: {
            args: Prisma.VisaGroupByArgs<ExtArgs>
            result: $Utils.Optional<VisaGroupByOutputType>[]
          }
          count: {
            args: Prisma.VisaCountArgs<ExtArgs>
            result: $Utils.Optional<VisaCountAggregateOutputType> | number
          }
        }
      }
      Transportation: {
        payload: Prisma.$TransportationPayload<ExtArgs>
        fields: Prisma.TransportationFieldRefs
        operations: {
          findUnique: {
            args: Prisma.TransportationFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TransportationPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.TransportationFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TransportationPayload>
          }
          findFirst: {
            args: Prisma.TransportationFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TransportationPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.TransportationFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TransportationPayload>
          }
          findMany: {
            args: Prisma.TransportationFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TransportationPayload>[]
          }
          create: {
            args: Prisma.TransportationCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TransportationPayload>
          }
          createMany: {
            args: Prisma.TransportationCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.TransportationDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TransportationPayload>
          }
          update: {
            args: Prisma.TransportationUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TransportationPayload>
          }
          deleteMany: {
            args: Prisma.TransportationDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.TransportationUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.TransportationUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TransportationPayload>
          }
          aggregate: {
            args: Prisma.TransportationAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTransportation>
          }
          groupBy: {
            args: Prisma.TransportationGroupByArgs<ExtArgs>
            result: $Utils.Optional<TransportationGroupByOutputType>[]
          }
          count: {
            args: Prisma.TransportationCountArgs<ExtArgs>
            result: $Utils.Optional<TransportationCountAggregateOutputType> | number
          }
        }
      }
      Muthawif: {
        payload: Prisma.$MuthawifPayload<ExtArgs>
        fields: Prisma.MuthawifFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MuthawifFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MuthawifPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MuthawifFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MuthawifPayload>
          }
          findFirst: {
            args: Prisma.MuthawifFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MuthawifPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MuthawifFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MuthawifPayload>
          }
          findMany: {
            args: Prisma.MuthawifFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MuthawifPayload>[]
          }
          create: {
            args: Prisma.MuthawifCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MuthawifPayload>
          }
          createMany: {
            args: Prisma.MuthawifCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.MuthawifDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MuthawifPayload>
          }
          update: {
            args: Prisma.MuthawifUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MuthawifPayload>
          }
          deleteMany: {
            args: Prisma.MuthawifDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.MuthawifUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.MuthawifUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MuthawifPayload>
          }
          aggregate: {
            args: Prisma.MuthawifAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateMuthawif>
          }
          groupBy: {
            args: Prisma.MuthawifGroupByArgs<ExtArgs>
            result: $Utils.Optional<MuthawifGroupByOutputType>[]
          }
          count: {
            args: Prisma.MuthawifCountArgs<ExtArgs>
            result: $Utils.Optional<MuthawifCountAggregateOutputType> | number
          }
        }
      }
      HandlingSaudi: {
        payload: Prisma.$HandlingSaudiPayload<ExtArgs>
        fields: Prisma.HandlingSaudiFieldRefs
        operations: {
          findUnique: {
            args: Prisma.HandlingSaudiFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingSaudiPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.HandlingSaudiFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingSaudiPayload>
          }
          findFirst: {
            args: Prisma.HandlingSaudiFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingSaudiPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.HandlingSaudiFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingSaudiPayload>
          }
          findMany: {
            args: Prisma.HandlingSaudiFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingSaudiPayload>[]
          }
          create: {
            args: Prisma.HandlingSaudiCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingSaudiPayload>
          }
          createMany: {
            args: Prisma.HandlingSaudiCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.HandlingSaudiDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingSaudiPayload>
          }
          update: {
            args: Prisma.HandlingSaudiUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingSaudiPayload>
          }
          deleteMany: {
            args: Prisma.HandlingSaudiDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.HandlingSaudiUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.HandlingSaudiUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingSaudiPayload>
          }
          aggregate: {
            args: Prisma.HandlingSaudiAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateHandlingSaudi>
          }
          groupBy: {
            args: Prisma.HandlingSaudiGroupByArgs<ExtArgs>
            result: $Utils.Optional<HandlingSaudiGroupByOutputType>[]
          }
          count: {
            args: Prisma.HandlingSaudiCountArgs<ExtArgs>
            result: $Utils.Optional<HandlingSaudiCountAggregateOutputType> | number
          }
        }
      }
      HandlingDomestic: {
        payload: Prisma.$HandlingDomesticPayload<ExtArgs>
        fields: Prisma.HandlingDomesticFieldRefs
        operations: {
          findUnique: {
            args: Prisma.HandlingDomesticFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingDomesticPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.HandlingDomesticFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingDomesticPayload>
          }
          findFirst: {
            args: Prisma.HandlingDomesticFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingDomesticPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.HandlingDomesticFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingDomesticPayload>
          }
          findMany: {
            args: Prisma.HandlingDomesticFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingDomesticPayload>[]
          }
          create: {
            args: Prisma.HandlingDomesticCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingDomesticPayload>
          }
          createMany: {
            args: Prisma.HandlingDomesticCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.HandlingDomesticDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingDomesticPayload>
          }
          update: {
            args: Prisma.HandlingDomesticUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingDomesticPayload>
          }
          deleteMany: {
            args: Prisma.HandlingDomesticDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.HandlingDomesticUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.HandlingDomesticUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HandlingDomesticPayload>
          }
          aggregate: {
            args: Prisma.HandlingDomesticAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateHandlingDomestic>
          }
          groupBy: {
            args: Prisma.HandlingDomesticGroupByArgs<ExtArgs>
            result: $Utils.Optional<HandlingDomesticGroupByOutputType>[]
          }
          count: {
            args: Prisma.HandlingDomesticCountArgs<ExtArgs>
            result: $Utils.Optional<HandlingDomesticCountAggregateOutputType> | number
          }
        }
      }
      Siskopatuh: {
        payload: Prisma.$SiskopatuhPayload<ExtArgs>
        fields: Prisma.SiskopatuhFieldRefs
        operations: {
          findUnique: {
            args: Prisma.SiskopatuhFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SiskopatuhPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.SiskopatuhFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SiskopatuhPayload>
          }
          findFirst: {
            args: Prisma.SiskopatuhFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SiskopatuhPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.SiskopatuhFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SiskopatuhPayload>
          }
          findMany: {
            args: Prisma.SiskopatuhFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SiskopatuhPayload>[]
          }
          create: {
            args: Prisma.SiskopatuhCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SiskopatuhPayload>
          }
          createMany: {
            args: Prisma.SiskopatuhCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.SiskopatuhDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SiskopatuhPayload>
          }
          update: {
            args: Prisma.SiskopatuhUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SiskopatuhPayload>
          }
          deleteMany: {
            args: Prisma.SiskopatuhDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.SiskopatuhUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.SiskopatuhUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SiskopatuhPayload>
          }
          aggregate: {
            args: Prisma.SiskopatuhAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateSiskopatuh>
          }
          groupBy: {
            args: Prisma.SiskopatuhGroupByArgs<ExtArgs>
            result: $Utils.Optional<SiskopatuhGroupByOutputType>[]
          }
          count: {
            args: Prisma.SiskopatuhCountArgs<ExtArgs>
            result: $Utils.Optional<SiskopatuhCountAggregateOutputType> | number
          }
        }
      }
      Equipment: {
        payload: Prisma.$EquipmentPayload<ExtArgs>
        fields: Prisma.EquipmentFieldRefs
        operations: {
          findUnique: {
            args: Prisma.EquipmentFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$EquipmentPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.EquipmentFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$EquipmentPayload>
          }
          findFirst: {
            args: Prisma.EquipmentFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$EquipmentPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.EquipmentFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$EquipmentPayload>
          }
          findMany: {
            args: Prisma.EquipmentFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$EquipmentPayload>[]
          }
          create: {
            args: Prisma.EquipmentCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$EquipmentPayload>
          }
          createMany: {
            args: Prisma.EquipmentCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.EquipmentDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$EquipmentPayload>
          }
          update: {
            args: Prisma.EquipmentUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$EquipmentPayload>
          }
          deleteMany: {
            args: Prisma.EquipmentDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.EquipmentUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.EquipmentUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$EquipmentPayload>
          }
          aggregate: {
            args: Prisma.EquipmentAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateEquipment>
          }
          groupBy: {
            args: Prisma.EquipmentGroupByArgs<ExtArgs>
            result: $Utils.Optional<EquipmentGroupByOutputType>[]
          }
          count: {
            args: Prisma.EquipmentCountArgs<ExtArgs>
            result: $Utils.Optional<EquipmentCountAggregateOutputType> | number
          }
        }
      }
      TourPlus: {
        payload: Prisma.$TourPlusPayload<ExtArgs>
        fields: Prisma.TourPlusFieldRefs
        operations: {
          findUnique: {
            args: Prisma.TourPlusFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TourPlusPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.TourPlusFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TourPlusPayload>
          }
          findFirst: {
            args: Prisma.TourPlusFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TourPlusPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.TourPlusFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TourPlusPayload>
          }
          findMany: {
            args: Prisma.TourPlusFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TourPlusPayload>[]
          }
          create: {
            args: Prisma.TourPlusCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TourPlusPayload>
          }
          createMany: {
            args: Prisma.TourPlusCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.TourPlusDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TourPlusPayload>
          }
          update: {
            args: Prisma.TourPlusUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TourPlusPayload>
          }
          deleteMany: {
            args: Prisma.TourPlusDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.TourPlusUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.TourPlusUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TourPlusPayload>
          }
          aggregate: {
            args: Prisma.TourPlusAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTourPlus>
          }
          groupBy: {
            args: Prisma.TourPlusGroupByArgs<ExtArgs>
            result: $Utils.Optional<TourPlusGroupByOutputType>[]
          }
          count: {
            args: Prisma.TourPlusCountArgs<ExtArgs>
            result: $Utils.Optional<TourPlusCountAggregateOutputType> | number
          }
        }
      }
      Manasik: {
        payload: Prisma.$ManasikPayload<ExtArgs>
        fields: Prisma.ManasikFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ManasikFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ManasikPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ManasikFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ManasikPayload>
          }
          findFirst: {
            args: Prisma.ManasikFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ManasikPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ManasikFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ManasikPayload>
          }
          findMany: {
            args: Prisma.ManasikFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ManasikPayload>[]
          }
          create: {
            args: Prisma.ManasikCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ManasikPayload>
          }
          createMany: {
            args: Prisma.ManasikCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ManasikDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ManasikPayload>
          }
          update: {
            args: Prisma.ManasikUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ManasikPayload>
          }
          deleteMany: {
            args: Prisma.ManasikDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ManasikUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ManasikUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ManasikPayload>
          }
          aggregate: {
            args: Prisma.ManasikAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateManasik>
          }
          groupBy: {
            args: Prisma.ManasikGroupByArgs<ExtArgs>
            result: $Utils.Optional<ManasikGroupByOutputType>[]
          }
          count: {
            args: Prisma.ManasikCountArgs<ExtArgs>
            result: $Utils.Optional<ManasikCountAggregateOutputType> | number
          }
        }
      }
      MitraPackage: {
        payload: Prisma.$MitraPackagePayload<ExtArgs>
        fields: Prisma.MitraPackageFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MitraPackageFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackagePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MitraPackageFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackagePayload>
          }
          findFirst: {
            args: Prisma.MitraPackageFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackagePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MitraPackageFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackagePayload>
          }
          findMany: {
            args: Prisma.MitraPackageFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackagePayload>[]
          }
          create: {
            args: Prisma.MitraPackageCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackagePayload>
          }
          createMany: {
            args: Prisma.MitraPackageCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.MitraPackageDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackagePayload>
          }
          update: {
            args: Prisma.MitraPackageUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackagePayload>
          }
          deleteMany: {
            args: Prisma.MitraPackageDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.MitraPackageUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.MitraPackageUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackagePayload>
          }
          aggregate: {
            args: Prisma.MitraPackageAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateMitraPackage>
          }
          groupBy: {
            args: Prisma.MitraPackageGroupByArgs<ExtArgs>
            result: $Utils.Optional<MitraPackageGroupByOutputType>[]
          }
          count: {
            args: Prisma.MitraPackageCountArgs<ExtArgs>
            result: $Utils.Optional<MitraPackageCountAggregateOutputType> | number
          }
        }
      }
      MitraPackageOrder: {
        payload: Prisma.$MitraPackageOrderPayload<ExtArgs>
        fields: Prisma.MitraPackageOrderFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MitraPackageOrderFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackageOrderPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MitraPackageOrderFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackageOrderPayload>
          }
          findFirst: {
            args: Prisma.MitraPackageOrderFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackageOrderPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MitraPackageOrderFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackageOrderPayload>
          }
          findMany: {
            args: Prisma.MitraPackageOrderFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackageOrderPayload>[]
          }
          create: {
            args: Prisma.MitraPackageOrderCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackageOrderPayload>
          }
          createMany: {
            args: Prisma.MitraPackageOrderCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.MitraPackageOrderDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackageOrderPayload>
          }
          update: {
            args: Prisma.MitraPackageOrderUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackageOrderPayload>
          }
          deleteMany: {
            args: Prisma.MitraPackageOrderDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.MitraPackageOrderUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.MitraPackageOrderUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MitraPackageOrderPayload>
          }
          aggregate: {
            args: Prisma.MitraPackageOrderAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateMitraPackageOrder>
          }
          groupBy: {
            args: Prisma.MitraPackageOrderGroupByArgs<ExtArgs>
            result: $Utils.Optional<MitraPackageOrderGroupByOutputType>[]
          }
          count: {
            args: Prisma.MitraPackageOrderCountArgs<ExtArgs>
            result: $Utils.Optional<MitraPackageOrderCountAggregateOutputType> | number
          }
        }
      }
      ExchangeRate: {
        payload: Prisma.$ExchangeRatePayload<ExtArgs>
        fields: Prisma.ExchangeRateFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ExchangeRateFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ExchangeRatePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ExchangeRateFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ExchangeRatePayload>
          }
          findFirst: {
            args: Prisma.ExchangeRateFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ExchangeRatePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ExchangeRateFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ExchangeRatePayload>
          }
          findMany: {
            args: Prisma.ExchangeRateFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ExchangeRatePayload>[]
          }
          create: {
            args: Prisma.ExchangeRateCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ExchangeRatePayload>
          }
          createMany: {
            args: Prisma.ExchangeRateCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ExchangeRateDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ExchangeRatePayload>
          }
          update: {
            args: Prisma.ExchangeRateUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ExchangeRatePayload>
          }
          deleteMany: {
            args: Prisma.ExchangeRateDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ExchangeRateUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ExchangeRateUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ExchangeRatePayload>
          }
          aggregate: {
            args: Prisma.ExchangeRateAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateExchangeRate>
          }
          groupBy: {
            args: Prisma.ExchangeRateGroupByArgs<ExtArgs>
            result: $Utils.Optional<ExchangeRateGroupByOutputType>[]
          }
          count: {
            args: Prisma.ExchangeRateCountArgs<ExtArgs>
            result: $Utils.Optional<ExchangeRateCountAggregateOutputType> | number
          }
        }
      }
      Contact: {
        payload: Prisma.$ContactPayload<ExtArgs>
        fields: Prisma.ContactFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ContactFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ContactFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>
          }
          findFirst: {
            args: Prisma.ContactFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ContactFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>
          }
          findMany: {
            args: Prisma.ContactFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>[]
          }
          create: {
            args: Prisma.ContactCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>
          }
          createMany: {
            args: Prisma.ContactCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ContactDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>
          }
          update: {
            args: Prisma.ContactUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>
          }
          deleteMany: {
            args: Prisma.ContactDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ContactUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ContactUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>
          }
          aggregate: {
            args: Prisma.ContactAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateContact>
          }
          groupBy: {
            args: Prisma.ContactGroupByArgs<ExtArgs>
            result: $Utils.Optional<ContactGroupByOutputType>[]
          }
          count: {
            args: Prisma.ContactCountArgs<ExtArgs>
            result: $Utils.Optional<ContactCountAggregateOutputType> | number
          }
        }
      }
      Faq: {
        payload: Prisma.$FaqPayload<ExtArgs>
        fields: Prisma.FaqFieldRefs
        operations: {
          findUnique: {
            args: Prisma.FaqFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FaqPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.FaqFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FaqPayload>
          }
          findFirst: {
            args: Prisma.FaqFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FaqPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.FaqFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FaqPayload>
          }
          findMany: {
            args: Prisma.FaqFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FaqPayload>[]
          }
          create: {
            args: Prisma.FaqCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FaqPayload>
          }
          createMany: {
            args: Prisma.FaqCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.FaqDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FaqPayload>
          }
          update: {
            args: Prisma.FaqUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FaqPayload>
          }
          deleteMany: {
            args: Prisma.FaqDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.FaqUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.FaqUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FaqPayload>
          }
          aggregate: {
            args: Prisma.FaqAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateFaq>
          }
          groupBy: {
            args: Prisma.FaqGroupByArgs<ExtArgs>
            result: $Utils.Optional<FaqGroupByOutputType>[]
          }
          count: {
            args: Prisma.FaqCountArgs<ExtArgs>
            result: $Utils.Optional<FaqCountAggregateOutputType> | number
          }
        }
      }
      Content: {
        payload: Prisma.$ContentPayload<ExtArgs>
        fields: Prisma.ContentFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ContentFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContentPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ContentFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContentPayload>
          }
          findFirst: {
            args: Prisma.ContentFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContentPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ContentFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContentPayload>
          }
          findMany: {
            args: Prisma.ContentFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContentPayload>[]
          }
          create: {
            args: Prisma.ContentCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContentPayload>
          }
          createMany: {
            args: Prisma.ContentCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ContentDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContentPayload>
          }
          update: {
            args: Prisma.ContentUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContentPayload>
          }
          deleteMany: {
            args: Prisma.ContentDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ContentUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ContentUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContentPayload>
          }
          aggregate: {
            args: Prisma.ContentAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateContent>
          }
          groupBy: {
            args: Prisma.ContentGroupByArgs<ExtArgs>
            result: $Utils.Optional<ContentGroupByOutputType>[]
          }
          count: {
            args: Prisma.ContentCountArgs<ExtArgs>
            result: $Utils.Optional<ContentCountAggregateOutputType> | number
          }
        }
      }
      MenuItem: {
        payload: Prisma.$MenuItemPayload<ExtArgs>
        fields: Prisma.MenuItemFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MenuItemFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MenuItemPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MenuItemFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MenuItemPayload>
          }
          findFirst: {
            args: Prisma.MenuItemFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MenuItemPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MenuItemFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MenuItemPayload>
          }
          findMany: {
            args: Prisma.MenuItemFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MenuItemPayload>[]
          }
          create: {
            args: Prisma.MenuItemCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MenuItemPayload>
          }
          createMany: {
            args: Prisma.MenuItemCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.MenuItemDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MenuItemPayload>
          }
          update: {
            args: Prisma.MenuItemUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MenuItemPayload>
          }
          deleteMany: {
            args: Prisma.MenuItemDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.MenuItemUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.MenuItemUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MenuItemPayload>
          }
          aggregate: {
            args: Prisma.MenuItemAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateMenuItem>
          }
          groupBy: {
            args: Prisma.MenuItemGroupByArgs<ExtArgs>
            result: $Utils.Optional<MenuItemGroupByOutputType>[]
          }
          count: {
            args: Prisma.MenuItemCountArgs<ExtArgs>
            result: $Utils.Optional<MenuItemCountAggregateOutputType> | number
          }
        }
      }
      Footer: {
        payload: Prisma.$FooterPayload<ExtArgs>
        fields: Prisma.FooterFieldRefs
        operations: {
          findUnique: {
            args: Prisma.FooterFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.FooterFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterPayload>
          }
          findFirst: {
            args: Prisma.FooterFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.FooterFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterPayload>
          }
          findMany: {
            args: Prisma.FooterFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterPayload>[]
          }
          create: {
            args: Prisma.FooterCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterPayload>
          }
          createMany: {
            args: Prisma.FooterCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.FooterDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterPayload>
          }
          update: {
            args: Prisma.FooterUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterPayload>
          }
          deleteMany: {
            args: Prisma.FooterDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.FooterUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.FooterUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterPayload>
          }
          aggregate: {
            args: Prisma.FooterAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateFooter>
          }
          groupBy: {
            args: Prisma.FooterGroupByArgs<ExtArgs>
            result: $Utils.Optional<FooterGroupByOutputType>[]
          }
          count: {
            args: Prisma.FooterCountArgs<ExtArgs>
            result: $Utils.Optional<FooterCountAggregateOutputType> | number
          }
        }
      }
      FooterItem: {
        payload: Prisma.$FooterItemPayload<ExtArgs>
        fields: Prisma.FooterItemFieldRefs
        operations: {
          findUnique: {
            args: Prisma.FooterItemFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterItemPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.FooterItemFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterItemPayload>
          }
          findFirst: {
            args: Prisma.FooterItemFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterItemPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.FooterItemFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterItemPayload>
          }
          findMany: {
            args: Prisma.FooterItemFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterItemPayload>[]
          }
          create: {
            args: Prisma.FooterItemCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterItemPayload>
          }
          createMany: {
            args: Prisma.FooterItemCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.FooterItemDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterItemPayload>
          }
          update: {
            args: Prisma.FooterItemUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterItemPayload>
          }
          deleteMany: {
            args: Prisma.FooterItemDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.FooterItemUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.FooterItemUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FooterItemPayload>
          }
          aggregate: {
            args: Prisma.FooterItemAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateFooterItem>
          }
          groupBy: {
            args: Prisma.FooterItemGroupByArgs<ExtArgs>
            result: $Utils.Optional<FooterItemGroupByOutputType>[]
          }
          count: {
            args: Prisma.FooterItemCountArgs<ExtArgs>
            result: $Utils.Optional<FooterItemCountAggregateOutputType> | number
          }
        }
      }
      Color: {
        payload: Prisma.$ColorPayload<ExtArgs>
        fields: Prisma.ColorFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ColorFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ColorPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ColorFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ColorPayload>
          }
          findFirst: {
            args: Prisma.ColorFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ColorPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ColorFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ColorPayload>
          }
          findMany: {
            args: Prisma.ColorFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ColorPayload>[]
          }
          create: {
            args: Prisma.ColorCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ColorPayload>
          }
          createMany: {
            args: Prisma.ColorCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ColorDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ColorPayload>
          }
          update: {
            args: Prisma.ColorUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ColorPayload>
          }
          deleteMany: {
            args: Prisma.ColorDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ColorUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ColorUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ColorPayload>
          }
          aggregate: {
            args: Prisma.ColorAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateColor>
          }
          groupBy: {
            args: Prisma.ColorGroupByArgs<ExtArgs>
            result: $Utils.Optional<ColorGroupByOutputType>[]
          }
          count: {
            args: Prisma.ColorCountArgs<ExtArgs>
            result: $Utils.Optional<ColorCountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $executeRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $executeRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $queryRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $queryRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<"define", Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *   { emit: 'stdout', level: 'query' },
     *   { emit: 'stdout', level: 'info' },
     *   { emit: 'stdout', level: 'warn' }
     *   { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
    /**
     * The default values for transactionOptions
     * maxWait ?= 2000
     * timeout ?= 5000
     */
    transactionOptions?: {
      maxWait?: number
      timeout?: number
      isolationLevel?: Prisma.TransactionIsolationLevel
    }
  }


  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'createManyAndReturn'
    | 'update'
    | 'updateMany'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => $Utils.JsPromise<T>,
  ) => $Utils.JsPromise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */


  /**
   * Count Type UserCountOutputType
   */

  export type UserCountOutputType = {
    ProductOrders: number
    MitraPackageOrder: number
    MitraRequest: number
  }

  export type UserCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ProductOrders?: boolean | UserCountOutputTypeCountProductOrdersArgs
    MitraPackageOrder?: boolean | UserCountOutputTypeCountMitraPackageOrderArgs
    MitraRequest?: boolean | UserCountOutputTypeCountMitraRequestArgs
  }

  // Custom InputTypes
  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserCountOutputType
     */
    select?: UserCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountProductOrdersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductOrderWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountMitraPackageOrderArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageOrderWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountMitraRequestArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraRequestWhereInput
  }


  /**
   * Count Type UserPackageCountOutputType
   */

  export type UserPackageCountOutputType = {
    UserPackageOrders: number
  }

  export type UserPackageCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    UserPackageOrders?: boolean | UserPackageCountOutputTypeCountUserPackageOrdersArgs
  }

  // Custom InputTypes
  /**
   * UserPackageCountOutputType without action
   */
  export type UserPackageCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageCountOutputType
     */
    select?: UserPackageCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * UserPackageCountOutputType without action
   */
  export type UserPackageCountOutputTypeCountUserPackageOrdersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPackageOrderWhereInput
  }


  /**
   * Count Type PackageTypeCountOutputType
   */

  export type PackageTypeCountOutputType = {
    UserPackageOptions: number
  }

  export type PackageTypeCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    UserPackageOptions?: boolean | PackageTypeCountOutputTypeCountUserPackageOptionsArgs
  }

  // Custom InputTypes
  /**
   * PackageTypeCountOutputType without action
   */
  export type PackageTypeCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PackageTypeCountOutputType
     */
    select?: PackageTypeCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * PackageTypeCountOutputType without action
   */
  export type PackageTypeCountOutputTypeCountUserPackageOptionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPackageOptionWhereInput
  }


  /**
   * Count Type UserPackageOptionCountOutputType
   */

  export type UserPackageOptionCountOutputType = {
    transportations: number
    flights: number
    hotelMekkahs: number
    hotelMadinahs: number
    muthawifs: number
    handlings: number
  }

  export type UserPackageOptionCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    transportations?: boolean | UserPackageOptionCountOutputTypeCountTransportationsArgs
    flights?: boolean | UserPackageOptionCountOutputTypeCountFlightsArgs
    hotelMekkahs?: boolean | UserPackageOptionCountOutputTypeCountHotelMekkahsArgs
    hotelMadinahs?: boolean | UserPackageOptionCountOutputTypeCountHotelMadinahsArgs
    muthawifs?: boolean | UserPackageOptionCountOutputTypeCountMuthawifsArgs
    handlings?: boolean | UserPackageOptionCountOutputTypeCountHandlingsArgs
  }

  // Custom InputTypes
  /**
   * UserPackageOptionCountOutputType without action
   */
  export type UserPackageOptionCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOptionCountOutputType
     */
    select?: UserPackageOptionCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * UserPackageOptionCountOutputType without action
   */
  export type UserPackageOptionCountOutputTypeCountTransportationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPackageWhereInput
  }

  /**
   * UserPackageOptionCountOutputType without action
   */
  export type UserPackageOptionCountOutputTypeCountFlightsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPackageWhereInput
  }

  /**
   * UserPackageOptionCountOutputType without action
   */
  export type UserPackageOptionCountOutputTypeCountHotelMekkahsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPackageWhereInput
  }

  /**
   * UserPackageOptionCountOutputType without action
   */
  export type UserPackageOptionCountOutputTypeCountHotelMadinahsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPackageWhereInput
  }

  /**
   * UserPackageOptionCountOutputType without action
   */
  export type UserPackageOptionCountOutputTypeCountMuthawifsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPackageWhereInput
  }

  /**
   * UserPackageOptionCountOutputType without action
   */
  export type UserPackageOptionCountOutputTypeCountHandlingsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPackageWhereInput
  }


  /**
   * Count Type CategoryCountOutputType
   */

  export type CategoryCountOutputType = {
    ProductCategories: number
  }

  export type CategoryCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ProductCategories?: boolean | CategoryCountOutputTypeCountProductCategoriesArgs
  }

  // Custom InputTypes
  /**
   * CategoryCountOutputType without action
   */
  export type CategoryCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryCountOutputType
     */
    select?: CategoryCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * CategoryCountOutputType without action
   */
  export type CategoryCountOutputTypeCountProductCategoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductCategoryWhereInput
  }


  /**
   * Count Type ProductCountOutputType
   */

  export type ProductCountOutputType = {
    ProductThumbnails: number
    ProductCategories: number
    ProductVariations: number
    ProductIncludes: number
    ProductExcludes: number
    ProductOrders: number
  }

  export type ProductCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ProductThumbnails?: boolean | ProductCountOutputTypeCountProductThumbnailsArgs
    ProductCategories?: boolean | ProductCountOutputTypeCountProductCategoriesArgs
    ProductVariations?: boolean | ProductCountOutputTypeCountProductVariationsArgs
    ProductIncludes?: boolean | ProductCountOutputTypeCountProductIncludesArgs
    ProductExcludes?: boolean | ProductCountOutputTypeCountProductExcludesArgs
    ProductOrders?: boolean | ProductCountOutputTypeCountProductOrdersArgs
  }

  // Custom InputTypes
  /**
   * ProductCountOutputType without action
   */
  export type ProductCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductCountOutputType
     */
    select?: ProductCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ProductCountOutputType without action
   */
  export type ProductCountOutputTypeCountProductThumbnailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductThumbnailWhereInput
  }

  /**
   * ProductCountOutputType without action
   */
  export type ProductCountOutputTypeCountProductCategoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductCategoryWhereInput
  }

  /**
   * ProductCountOutputType without action
   */
  export type ProductCountOutputTypeCountProductVariationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductVariationWhereInput
  }

  /**
   * ProductCountOutputType without action
   */
  export type ProductCountOutputTypeCountProductIncludesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductIncludeWhereInput
  }

  /**
   * ProductCountOutputType without action
   */
  export type ProductCountOutputTypeCountProductExcludesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductExcludeWhereInput
  }

  /**
   * ProductCountOutputType without action
   */
  export type ProductCountOutputTypeCountProductOrdersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductOrderWhereInput
  }


  /**
   * Count Type ProductVariationCountOutputType
   */

  export type ProductVariationCountOutputType = {
    ProductOrders: number
  }

  export type ProductVariationCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ProductOrders?: boolean | ProductVariationCountOutputTypeCountProductOrdersArgs
  }

  // Custom InputTypes
  /**
   * ProductVariationCountOutputType without action
   */
  export type ProductVariationCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductVariationCountOutputType
     */
    select?: ProductVariationCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ProductVariationCountOutputType without action
   */
  export type ProductVariationCountOutputTypeCountProductOrdersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductOrderWhereInput
  }


  /**
   * Count Type VendorCountOutputType
   */

  export type VendorCountOutputType = {
    Hotels: number
    MitraPackages: number
  }

  export type VendorCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Hotels?: boolean | VendorCountOutputTypeCountHotelsArgs
    MitraPackages?: boolean | VendorCountOutputTypeCountMitraPackagesArgs
  }

  // Custom InputTypes
  /**
   * VendorCountOutputType without action
   */
  export type VendorCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the VendorCountOutputType
     */
    select?: VendorCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * VendorCountOutputType without action
   */
  export type VendorCountOutputTypeCountHotelsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: HotelWhereInput
  }

  /**
   * VendorCountOutputType without action
   */
  export type VendorCountOutputTypeCountMitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }


  /**
   * Count Type HotelCountOutputType
   */

  export type HotelCountOutputType = {
    HotelPeriodPrices: number
    MitraPackagesMekkah: number
    MitraPackagesMadinah: number
  }

  export type HotelCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    HotelPeriodPrices?: boolean | HotelCountOutputTypeCountHotelPeriodPricesArgs
    MitraPackagesMekkah?: boolean | HotelCountOutputTypeCountMitraPackagesMekkahArgs
    MitraPackagesMadinah?: boolean | HotelCountOutputTypeCountMitraPackagesMadinahArgs
  }

  // Custom InputTypes
  /**
   * HotelCountOutputType without action
   */
  export type HotelCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HotelCountOutputType
     */
    select?: HotelCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * HotelCountOutputType without action
   */
  export type HotelCountOutputTypeCountHotelPeriodPricesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: HotelPeriodPriceWhereInput
  }

  /**
   * HotelCountOutputType without action
   */
  export type HotelCountOutputTypeCountMitraPackagesMekkahArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }

  /**
   * HotelCountOutputType without action
   */
  export type HotelCountOutputTypeCountMitraPackagesMadinahArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }


  /**
   * Count Type PeriodCountOutputType
   */

  export type PeriodCountOutputType = {
    HotelPeriodPrices: number
    MitraPackages: number
  }

  export type PeriodCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    HotelPeriodPrices?: boolean | PeriodCountOutputTypeCountHotelPeriodPricesArgs
    MitraPackages?: boolean | PeriodCountOutputTypeCountMitraPackagesArgs
  }

  // Custom InputTypes
  /**
   * PeriodCountOutputType without action
   */
  export type PeriodCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PeriodCountOutputType
     */
    select?: PeriodCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * PeriodCountOutputType without action
   */
  export type PeriodCountOutputTypeCountHotelPeriodPricesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: HotelPeriodPriceWhereInput
  }

  /**
   * PeriodCountOutputType without action
   */
  export type PeriodCountOutputTypeCountMitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }


  /**
   * Count Type AirlineCountOutputType
   */

  export type AirlineCountOutputType = {
    MitraPackages: number
  }

  export type AirlineCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | AirlineCountOutputTypeCountMitraPackagesArgs
  }

  // Custom InputTypes
  /**
   * AirlineCountOutputType without action
   */
  export type AirlineCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AirlineCountOutputType
     */
    select?: AirlineCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * AirlineCountOutputType without action
   */
  export type AirlineCountOutputTypeCountMitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }


  /**
   * Count Type VisaCountOutputType
   */

  export type VisaCountOutputType = {
    MitraPackages: number
  }

  export type VisaCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | VisaCountOutputTypeCountMitraPackagesArgs
  }

  // Custom InputTypes
  /**
   * VisaCountOutputType without action
   */
  export type VisaCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the VisaCountOutputType
     */
    select?: VisaCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * VisaCountOutputType without action
   */
  export type VisaCountOutputTypeCountMitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }


  /**
   * Count Type TransportationCountOutputType
   */

  export type TransportationCountOutputType = {
    MitraPackage: number
  }

  export type TransportationCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackage?: boolean | TransportationCountOutputTypeCountMitraPackageArgs
  }

  // Custom InputTypes
  /**
   * TransportationCountOutputType without action
   */
  export type TransportationCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TransportationCountOutputType
     */
    select?: TransportationCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * TransportationCountOutputType without action
   */
  export type TransportationCountOutputTypeCountMitraPackageArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }


  /**
   * Count Type MuthawifCountOutputType
   */

  export type MuthawifCountOutputType = {
    MitraPackages: number
  }

  export type MuthawifCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | MuthawifCountOutputTypeCountMitraPackagesArgs
  }

  // Custom InputTypes
  /**
   * MuthawifCountOutputType without action
   */
  export type MuthawifCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MuthawifCountOutputType
     */
    select?: MuthawifCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * MuthawifCountOutputType without action
   */
  export type MuthawifCountOutputTypeCountMitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }


  /**
   * Count Type HandlingSaudiCountOutputType
   */

  export type HandlingSaudiCountOutputType = {
    MitraPackages: number
  }

  export type HandlingSaudiCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | HandlingSaudiCountOutputTypeCountMitraPackagesArgs
  }

  // Custom InputTypes
  /**
   * HandlingSaudiCountOutputType without action
   */
  export type HandlingSaudiCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingSaudiCountOutputType
     */
    select?: HandlingSaudiCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * HandlingSaudiCountOutputType without action
   */
  export type HandlingSaudiCountOutputTypeCountMitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }


  /**
   * Count Type HandlingDomesticCountOutputType
   */

  export type HandlingDomesticCountOutputType = {
    MitraPackages: number
  }

  export type HandlingDomesticCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | HandlingDomesticCountOutputTypeCountMitraPackagesArgs
  }

  // Custom InputTypes
  /**
   * HandlingDomesticCountOutputType without action
   */
  export type HandlingDomesticCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingDomesticCountOutputType
     */
    select?: HandlingDomesticCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * HandlingDomesticCountOutputType without action
   */
  export type HandlingDomesticCountOutputTypeCountMitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }


  /**
   * Count Type SiskopatuhCountOutputType
   */

  export type SiskopatuhCountOutputType = {
    MitraPackages: number
  }

  export type SiskopatuhCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | SiskopatuhCountOutputTypeCountMitraPackagesArgs
  }

  // Custom InputTypes
  /**
   * SiskopatuhCountOutputType without action
   */
  export type SiskopatuhCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SiskopatuhCountOutputType
     */
    select?: SiskopatuhCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * SiskopatuhCountOutputType without action
   */
  export type SiskopatuhCountOutputTypeCountMitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }


  /**
   * Count Type EquipmentCountOutputType
   */

  export type EquipmentCountOutputType = {
    MitraPackages: number
  }

  export type EquipmentCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | EquipmentCountOutputTypeCountMitraPackagesArgs
  }

  // Custom InputTypes
  /**
   * EquipmentCountOutputType without action
   */
  export type EquipmentCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the EquipmentCountOutputType
     */
    select?: EquipmentCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * EquipmentCountOutputType without action
   */
  export type EquipmentCountOutputTypeCountMitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }


  /**
   * Count Type TourPlusCountOutputType
   */

  export type TourPlusCountOutputType = {
    MitraPackages: number
  }

  export type TourPlusCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | TourPlusCountOutputTypeCountMitraPackagesArgs
  }

  // Custom InputTypes
  /**
   * TourPlusCountOutputType without action
   */
  export type TourPlusCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TourPlusCountOutputType
     */
    select?: TourPlusCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * TourPlusCountOutputType without action
   */
  export type TourPlusCountOutputTypeCountMitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }


  /**
   * Count Type ManasikCountOutputType
   */

  export type ManasikCountOutputType = {
    MitraPackages: number
  }

  export type ManasikCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | ManasikCountOutputTypeCountMitraPackagesArgs
  }

  // Custom InputTypes
  /**
   * ManasikCountOutputType without action
   */
  export type ManasikCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ManasikCountOutputType
     */
    select?: ManasikCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ManasikCountOutputType without action
   */
  export type ManasikCountOutputTypeCountMitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageWhereInput
  }


  /**
   * Count Type MitraPackageCountOutputType
   */

  export type MitraPackageCountOutputType = {
    MitraPackageOrders: number
  }

  export type MitraPackageCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackageOrders?: boolean | MitraPackageCountOutputTypeCountMitraPackageOrdersArgs
  }

  // Custom InputTypes
  /**
   * MitraPackageCountOutputType without action
   */
  export type MitraPackageCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraPackageCountOutputType
     */
    select?: MitraPackageCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * MitraPackageCountOutputType without action
   */
  export type MitraPackageCountOutputTypeCountMitraPackageOrdersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraPackageOrderWhereInput
  }


  /**
   * Count Type FooterCountOutputType
   */

  export type FooterCountOutputType = {
    FooterItem: number
  }

  export type FooterCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    FooterItem?: boolean | FooterCountOutputTypeCountFooterItemArgs
  }

  // Custom InputTypes
  /**
   * FooterCountOutputType without action
   */
  export type FooterCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FooterCountOutputType
     */
    select?: FooterCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * FooterCountOutputType without action
   */
  export type FooterCountOutputTypeCountFooterItemArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: FooterItemWhereInput
  }


  /**
   * Models
   */

  /**
   * Model User
   */

  export type AggregateUser = {
    _count: UserCountAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  export type UserMinAggregateOutputType = {
    id: string | null
    email: string | null
    full_name: string | null
    password: string | null
    whatsapp_number: string | null
    role: $Enums.Role | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type UserMaxAggregateOutputType = {
    id: string | null
    email: string | null
    full_name: string | null
    password: string | null
    whatsapp_number: string | null
    role: $Enums.Role | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type UserCountAggregateOutputType = {
    id: number
    email: number
    full_name: number
    password: number
    whatsapp_number: number
    role: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type UserMinAggregateInputType = {
    id?: true
    email?: true
    full_name?: true
    password?: true
    whatsapp_number?: true
    role?: true
    created_at?: true
    updated_at?: true
  }

  export type UserMaxAggregateInputType = {
    id?: true
    email?: true
    full_name?: true
    password?: true
    whatsapp_number?: true
    role?: true
    created_at?: true
    updated_at?: true
  }

  export type UserCountAggregateInputType = {
    id?: true
    email?: true
    full_name?: true
    password?: true
    whatsapp_number?: true
    role?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type UserAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which User to aggregate.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Users
    **/
    _count?: true | UserCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserMaxAggregateInputType
  }

  export type GetUserAggregateType<T extends UserAggregateArgs> = {
        [P in keyof T & keyof AggregateUser]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUser[P]>
      : GetScalarType<T[P], AggregateUser[P]>
  }




  export type UserGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
    orderBy?: UserOrderByWithAggregationInput | UserOrderByWithAggregationInput[]
    by: UserScalarFieldEnum[] | UserScalarFieldEnum
    having?: UserScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserCountAggregateInputType | true
    _min?: UserMinAggregateInputType
    _max?: UserMaxAggregateInputType
  }

  export type UserGroupByOutputType = {
    id: string
    email: string
    full_name: string
    password: string
    whatsapp_number: string
    role: $Enums.Role
    created_at: Date
    updated_at: Date
    _count: UserCountAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  type GetUserGroupByPayload<T extends UserGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserGroupByOutputType[P]>
            : GetScalarType<T[P], UserGroupByOutputType[P]>
        }
      >
    >


  export type UserSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    email?: boolean
    full_name?: boolean
    password?: boolean
    whatsapp_number?: boolean
    role?: boolean
    created_at?: boolean
    updated_at?: boolean
    ProductOrders?: boolean | User$ProductOrdersArgs<ExtArgs>
    MitraPackageOrder?: boolean | User$MitraPackageOrderArgs<ExtArgs>
    MitraRequest?: boolean | User$MitraRequestArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user"]>


  export type UserSelectScalar = {
    id?: boolean
    email?: boolean
    full_name?: boolean
    password?: boolean
    whatsapp_number?: boolean
    role?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type UserInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ProductOrders?: boolean | User$ProductOrdersArgs<ExtArgs>
    MitraPackageOrder?: boolean | User$MitraPackageOrderArgs<ExtArgs>
    MitraRequest?: boolean | User$MitraRequestArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $UserPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "User"
    objects: {
      ProductOrders: Prisma.$ProductOrderPayload<ExtArgs>[]
      MitraPackageOrder: Prisma.$MitraPackageOrderPayload<ExtArgs>[]
      MitraRequest: Prisma.$MitraRequestPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      email: string
      full_name: string
      password: string
      whatsapp_number: string
      role: $Enums.Role
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["user"]>
    composites: {}
  }

  type UserGetPayload<S extends boolean | null | undefined | UserDefaultArgs> = $Result.GetResult<Prisma.$UserPayload, S>

  type UserCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UserFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: UserCountAggregateInputType | true
    }

  export interface UserDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['User'], meta: { name: 'User' } }
    /**
     * Find zero or one User that matches the filter.
     * @param {UserFindUniqueArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends UserFindUniqueArgs>(args: SelectSubset<T, UserFindUniqueArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one User that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {UserFindUniqueOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends UserFindUniqueOrThrowArgs>(args: SelectSubset<T, UserFindUniqueOrThrowArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first User that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends UserFindFirstArgs>(args?: SelectSubset<T, UserFindFirstArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first User that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends UserFindFirstOrThrowArgs>(args?: SelectSubset<T, UserFindFirstOrThrowArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Users that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Users
     * const users = await prisma.user.findMany()
     * 
     * // Get first 10 Users
     * const users = await prisma.user.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userWithIdOnly = await prisma.user.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends UserFindManyArgs>(args?: SelectSubset<T, UserFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a User.
     * @param {UserCreateArgs} args - Arguments to create a User.
     * @example
     * // Create one User
     * const User = await prisma.user.create({
     *   data: {
     *     // ... data to create a User
     *   }
     * })
     * 
     */
    create<T extends UserCreateArgs>(args: SelectSubset<T, UserCreateArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Users.
     * @param {UserCreateManyArgs} args - Arguments to create many Users.
     * @example
     * // Create many Users
     * const user = await prisma.user.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends UserCreateManyArgs>(args?: SelectSubset<T, UserCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a User.
     * @param {UserDeleteArgs} args - Arguments to delete one User.
     * @example
     * // Delete one User
     * const User = await prisma.user.delete({
     *   where: {
     *     // ... filter to delete one User
     *   }
     * })
     * 
     */
    delete<T extends UserDeleteArgs>(args: SelectSubset<T, UserDeleteArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one User.
     * @param {UserUpdateArgs} args - Arguments to update one User.
     * @example
     * // Update one User
     * const user = await prisma.user.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends UserUpdateArgs>(args: SelectSubset<T, UserUpdateArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Users.
     * @param {UserDeleteManyArgs} args - Arguments to filter Users to delete.
     * @example
     * // Delete a few Users
     * const { count } = await prisma.user.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends UserDeleteManyArgs>(args?: SelectSubset<T, UserDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Users
     * const user = await prisma.user.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends UserUpdateManyArgs>(args: SelectSubset<T, UserUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one User.
     * @param {UserUpsertArgs} args - Arguments to update or create a User.
     * @example
     * // Update or create a User
     * const user = await prisma.user.upsert({
     *   create: {
     *     // ... data to create a User
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the User we want to update
     *   }
     * })
     */
    upsert<T extends UserUpsertArgs>(args: SelectSubset<T, UserUpsertArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserCountArgs} args - Arguments to filter Users to count.
     * @example
     * // Count the number of Users
     * const count = await prisma.user.count({
     *   where: {
     *     // ... the filter for the Users we want to count
     *   }
     * })
    **/
    count<T extends UserCountArgs>(
      args?: Subset<T, UserCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserAggregateArgs>(args: Subset<T, UserAggregateArgs>): Prisma.PrismaPromise<GetUserAggregateType<T>>

    /**
     * Group by User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserGroupByArgs['orderBy'] }
        : { orderBy?: UserGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the User model
   */
  readonly fields: UserFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for User.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    ProductOrders<T extends User$ProductOrdersArgs<ExtArgs> = {}>(args?: Subset<T, User$ProductOrdersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductOrderPayload<ExtArgs>, T, "findMany"> | Null>
    MitraPackageOrder<T extends User$MitraPackageOrderArgs<ExtArgs> = {}>(args?: Subset<T, User$MitraPackageOrderArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraPackageOrderPayload<ExtArgs>, T, "findMany"> | Null>
    MitraRequest<T extends User$MitraRequestArgs<ExtArgs> = {}>(args?: Subset<T, User$MitraRequestArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraRequestPayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the User model
   */ 
  interface UserFieldRefs {
    readonly id: FieldRef<"User", 'String'>
    readonly email: FieldRef<"User", 'String'>
    readonly full_name: FieldRef<"User", 'String'>
    readonly password: FieldRef<"User", 'String'>
    readonly whatsapp_number: FieldRef<"User", 'String'>
    readonly role: FieldRef<"User", 'Role'>
    readonly created_at: FieldRef<"User", 'DateTime'>
    readonly updated_at: FieldRef<"User", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * User findUnique
   */
  export type UserFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findUniqueOrThrow
   */
  export type UserFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findFirst
   */
  export type UserFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findFirstOrThrow
   */
  export type UserFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findMany
   */
  export type UserFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which Users to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User create
   */
  export type UserCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to create a User.
     */
    data: XOR<UserCreateInput, UserUncheckedCreateInput>
  }

  /**
   * User createMany
   */
  export type UserCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Users.
     */
    data: UserCreateManyInput | UserCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * User update
   */
  export type UserUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to update a User.
     */
    data: XOR<UserUpdateInput, UserUncheckedUpdateInput>
    /**
     * Choose, which User to update.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User updateMany
   */
  export type UserUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Users.
     */
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyInput>
    /**
     * Filter which Users to update
     */
    where?: UserWhereInput
  }

  /**
   * User upsert
   */
  export type UserUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The filter to search for the User to update in case it exists.
     */
    where: UserWhereUniqueInput
    /**
     * In case the User found by the `where` argument doesn't exist, create a new User with this data.
     */
    create: XOR<UserCreateInput, UserUncheckedCreateInput>
    /**
     * In case the User was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserUpdateInput, UserUncheckedUpdateInput>
  }

  /**
   * User delete
   */
  export type UserDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter which User to delete.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User deleteMany
   */
  export type UserDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Users to delete
     */
    where?: UserWhereInput
  }

  /**
   * User.ProductOrders
   */
  export type User$ProductOrdersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductOrder
     */
    select?: ProductOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductOrderInclude<ExtArgs> | null
    where?: ProductOrderWhereInput
    orderBy?: ProductOrderOrderByWithRelationInput | ProductOrderOrderByWithRelationInput[]
    cursor?: ProductOrderWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProductOrderScalarFieldEnum | ProductOrderScalarFieldEnum[]
  }

  /**
   * User.MitraPackageOrder
   */
  export type User$MitraPackageOrderArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraPackageOrder
     */
    select?: MitraPackageOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraPackageOrderInclude<ExtArgs> | null
    where?: MitraPackageOrderWhereInput
    orderBy?: MitraPackageOrderOrderByWithRelationInput | MitraPackageOrderOrderByWithRelationInput[]
    cursor?: MitraPackageOrderWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MitraPackageOrderScalarFieldEnum | MitraPackageOrderScalarFieldEnum[]
  }

  /**
   * User.MitraRequest
   */
  export type User$MitraRequestArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraRequest
     */
    select?: MitraRequestSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraRequestInclude<ExtArgs> | null
    where?: MitraRequestWhereInput
    orderBy?: MitraRequestOrderByWithRelationInput | MitraRequestOrderByWithRelationInput[]
    cursor?: MitraRequestWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MitraRequestScalarFieldEnum | MitraRequestScalarFieldEnum[]
  }

  /**
   * User without action
   */
  export type UserDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
  }


  /**
   * Model MitraRequest
   */

  export type AggregateMitraRequest = {
    _count: MitraRequestCountAggregateOutputType | null
    _avg: MitraRequestAvgAggregateOutputType | null
    _sum: MitraRequestSumAggregateOutputType | null
    _min: MitraRequestMinAggregateOutputType | null
    _max: MitraRequestMaxAggregateOutputType | null
  }

  export type MitraRequestAvgAggregateOutputType = {
    upgrade_amount: Decimal | null
  }

  export type MitraRequestSumAggregateOutputType = {
    upgrade_amount: Decimal | null
  }

  export type MitraRequestMinAggregateOutputType = {
    id: string | null
    user_id: string | null
    ktp: string | null
    upgrade_amount: Decimal | null
    payment_proof: string | null
    status: $Enums.RequestStatus | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type MitraRequestMaxAggregateOutputType = {
    id: string | null
    user_id: string | null
    ktp: string | null
    upgrade_amount: Decimal | null
    payment_proof: string | null
    status: $Enums.RequestStatus | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type MitraRequestCountAggregateOutputType = {
    id: number
    user_id: number
    ktp: number
    upgrade_amount: number
    payment_proof: number
    status: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type MitraRequestAvgAggregateInputType = {
    upgrade_amount?: true
  }

  export type MitraRequestSumAggregateInputType = {
    upgrade_amount?: true
  }

  export type MitraRequestMinAggregateInputType = {
    id?: true
    user_id?: true
    ktp?: true
    upgrade_amount?: true
    payment_proof?: true
    status?: true
    created_at?: true
    updated_at?: true
  }

  export type MitraRequestMaxAggregateInputType = {
    id?: true
    user_id?: true
    ktp?: true
    upgrade_amount?: true
    payment_proof?: true
    status?: true
    created_at?: true
    updated_at?: true
  }

  export type MitraRequestCountAggregateInputType = {
    id?: true
    user_id?: true
    ktp?: true
    upgrade_amount?: true
    payment_proof?: true
    status?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type MitraRequestAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which MitraRequest to aggregate.
     */
    where?: MitraRequestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MitraRequests to fetch.
     */
    orderBy?: MitraRequestOrderByWithRelationInput | MitraRequestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: MitraRequestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MitraRequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MitraRequests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned MitraRequests
    **/
    _count?: true | MitraRequestCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: MitraRequestAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: MitraRequestSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: MitraRequestMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: MitraRequestMaxAggregateInputType
  }

  export type GetMitraRequestAggregateType<T extends MitraRequestAggregateArgs> = {
        [P in keyof T & keyof AggregateMitraRequest]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateMitraRequest[P]>
      : GetScalarType<T[P], AggregateMitraRequest[P]>
  }




  export type MitraRequestGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MitraRequestWhereInput
    orderBy?: MitraRequestOrderByWithAggregationInput | MitraRequestOrderByWithAggregationInput[]
    by: MitraRequestScalarFieldEnum[] | MitraRequestScalarFieldEnum
    having?: MitraRequestScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: MitraRequestCountAggregateInputType | true
    _avg?: MitraRequestAvgAggregateInputType
    _sum?: MitraRequestSumAggregateInputType
    _min?: MitraRequestMinAggregateInputType
    _max?: MitraRequestMaxAggregateInputType
  }

  export type MitraRequestGroupByOutputType = {
    id: string
    user_id: string
    ktp: string
    upgrade_amount: Decimal
    payment_proof: string
    status: $Enums.RequestStatus
    created_at: Date
    updated_at: Date
    _count: MitraRequestCountAggregateOutputType | null
    _avg: MitraRequestAvgAggregateOutputType | null
    _sum: MitraRequestSumAggregateOutputType | null
    _min: MitraRequestMinAggregateOutputType | null
    _max: MitraRequestMaxAggregateOutputType | null
  }

  type GetMitraRequestGroupByPayload<T extends MitraRequestGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<MitraRequestGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof MitraRequestGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], MitraRequestGroupByOutputType[P]>
            : GetScalarType<T[P], MitraRequestGroupByOutputType[P]>
        }
      >
    >


  export type MitraRequestSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    ktp?: boolean
    upgrade_amount?: boolean
    payment_proof?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    User?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["mitraRequest"]>


  export type MitraRequestSelectScalar = {
    id?: boolean
    user_id?: boolean
    ktp?: boolean
    upgrade_amount?: boolean
    payment_proof?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type MitraRequestInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    User?: boolean | UserDefaultArgs<ExtArgs>
  }

  export type $MitraRequestPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "MitraRequest"
    objects: {
      User: Prisma.$UserPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      user_id: string
      ktp: string
      upgrade_amount: Prisma.Decimal
      payment_proof: string
      status: $Enums.RequestStatus
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["mitraRequest"]>
    composites: {}
  }

  type MitraRequestGetPayload<S extends boolean | null | undefined | MitraRequestDefaultArgs> = $Result.GetResult<Prisma.$MitraRequestPayload, S>

  type MitraRequestCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<MitraRequestFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: MitraRequestCountAggregateInputType | true
    }

  export interface MitraRequestDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['MitraRequest'], meta: { name: 'MitraRequest' } }
    /**
     * Find zero or one MitraRequest that matches the filter.
     * @param {MitraRequestFindUniqueArgs} args - Arguments to find a MitraRequest
     * @example
     * // Get one MitraRequest
     * const mitraRequest = await prisma.mitraRequest.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends MitraRequestFindUniqueArgs>(args: SelectSubset<T, MitraRequestFindUniqueArgs<ExtArgs>>): Prisma__MitraRequestClient<$Result.GetResult<Prisma.$MitraRequestPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one MitraRequest that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {MitraRequestFindUniqueOrThrowArgs} args - Arguments to find a MitraRequest
     * @example
     * // Get one MitraRequest
     * const mitraRequest = await prisma.mitraRequest.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends MitraRequestFindUniqueOrThrowArgs>(args: SelectSubset<T, MitraRequestFindUniqueOrThrowArgs<ExtArgs>>): Prisma__MitraRequestClient<$Result.GetResult<Prisma.$MitraRequestPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first MitraRequest that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MitraRequestFindFirstArgs} args - Arguments to find a MitraRequest
     * @example
     * // Get one MitraRequest
     * const mitraRequest = await prisma.mitraRequest.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends MitraRequestFindFirstArgs>(args?: SelectSubset<T, MitraRequestFindFirstArgs<ExtArgs>>): Prisma__MitraRequestClient<$Result.GetResult<Prisma.$MitraRequestPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first MitraRequest that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MitraRequestFindFirstOrThrowArgs} args - Arguments to find a MitraRequest
     * @example
     * // Get one MitraRequest
     * const mitraRequest = await prisma.mitraRequest.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends MitraRequestFindFirstOrThrowArgs>(args?: SelectSubset<T, MitraRequestFindFirstOrThrowArgs<ExtArgs>>): Prisma__MitraRequestClient<$Result.GetResult<Prisma.$MitraRequestPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more MitraRequests that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MitraRequestFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all MitraRequests
     * const mitraRequests = await prisma.mitraRequest.findMany()
     * 
     * // Get first 10 MitraRequests
     * const mitraRequests = await prisma.mitraRequest.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const mitraRequestWithIdOnly = await prisma.mitraRequest.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends MitraRequestFindManyArgs>(args?: SelectSubset<T, MitraRequestFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraRequestPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a MitraRequest.
     * @param {MitraRequestCreateArgs} args - Arguments to create a MitraRequest.
     * @example
     * // Create one MitraRequest
     * const MitraRequest = await prisma.mitraRequest.create({
     *   data: {
     *     // ... data to create a MitraRequest
     *   }
     * })
     * 
     */
    create<T extends MitraRequestCreateArgs>(args: SelectSubset<T, MitraRequestCreateArgs<ExtArgs>>): Prisma__MitraRequestClient<$Result.GetResult<Prisma.$MitraRequestPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many MitraRequests.
     * @param {MitraRequestCreateManyArgs} args - Arguments to create many MitraRequests.
     * @example
     * // Create many MitraRequests
     * const mitraRequest = await prisma.mitraRequest.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends MitraRequestCreateManyArgs>(args?: SelectSubset<T, MitraRequestCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a MitraRequest.
     * @param {MitraRequestDeleteArgs} args - Arguments to delete one MitraRequest.
     * @example
     * // Delete one MitraRequest
     * const MitraRequest = await prisma.mitraRequest.delete({
     *   where: {
     *     // ... filter to delete one MitraRequest
     *   }
     * })
     * 
     */
    delete<T extends MitraRequestDeleteArgs>(args: SelectSubset<T, MitraRequestDeleteArgs<ExtArgs>>): Prisma__MitraRequestClient<$Result.GetResult<Prisma.$MitraRequestPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one MitraRequest.
     * @param {MitraRequestUpdateArgs} args - Arguments to update one MitraRequest.
     * @example
     * // Update one MitraRequest
     * const mitraRequest = await prisma.mitraRequest.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends MitraRequestUpdateArgs>(args: SelectSubset<T, MitraRequestUpdateArgs<ExtArgs>>): Prisma__MitraRequestClient<$Result.GetResult<Prisma.$MitraRequestPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more MitraRequests.
     * @param {MitraRequestDeleteManyArgs} args - Arguments to filter MitraRequests to delete.
     * @example
     * // Delete a few MitraRequests
     * const { count } = await prisma.mitraRequest.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends MitraRequestDeleteManyArgs>(args?: SelectSubset<T, MitraRequestDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more MitraRequests.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MitraRequestUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many MitraRequests
     * const mitraRequest = await prisma.mitraRequest.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends MitraRequestUpdateManyArgs>(args: SelectSubset<T, MitraRequestUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one MitraRequest.
     * @param {MitraRequestUpsertArgs} args - Arguments to update or create a MitraRequest.
     * @example
     * // Update or create a MitraRequest
     * const mitraRequest = await prisma.mitraRequest.upsert({
     *   create: {
     *     // ... data to create a MitraRequest
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the MitraRequest we want to update
     *   }
     * })
     */
    upsert<T extends MitraRequestUpsertArgs>(args: SelectSubset<T, MitraRequestUpsertArgs<ExtArgs>>): Prisma__MitraRequestClient<$Result.GetResult<Prisma.$MitraRequestPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of MitraRequests.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MitraRequestCountArgs} args - Arguments to filter MitraRequests to count.
     * @example
     * // Count the number of MitraRequests
     * const count = await prisma.mitraRequest.count({
     *   where: {
     *     // ... the filter for the MitraRequests we want to count
     *   }
     * })
    **/
    count<T extends MitraRequestCountArgs>(
      args?: Subset<T, MitraRequestCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], MitraRequestCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a MitraRequest.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MitraRequestAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends MitraRequestAggregateArgs>(args: Subset<T, MitraRequestAggregateArgs>): Prisma.PrismaPromise<GetMitraRequestAggregateType<T>>

    /**
     * Group by MitraRequest.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MitraRequestGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends MitraRequestGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: MitraRequestGroupByArgs['orderBy'] }
        : { orderBy?: MitraRequestGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, MitraRequestGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetMitraRequestGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the MitraRequest model
   */
  readonly fields: MitraRequestFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for MitraRequest.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__MitraRequestClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    User<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the MitraRequest model
   */ 
  interface MitraRequestFieldRefs {
    readonly id: FieldRef<"MitraRequest", 'String'>
    readonly user_id: FieldRef<"MitraRequest", 'String'>
    readonly ktp: FieldRef<"MitraRequest", 'String'>
    readonly upgrade_amount: FieldRef<"MitraRequest", 'Decimal'>
    readonly payment_proof: FieldRef<"MitraRequest", 'String'>
    readonly status: FieldRef<"MitraRequest", 'RequestStatus'>
    readonly created_at: FieldRef<"MitraRequest", 'DateTime'>
    readonly updated_at: FieldRef<"MitraRequest", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * MitraRequest findUnique
   */
  export type MitraRequestFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraRequest
     */
    select?: MitraRequestSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraRequestInclude<ExtArgs> | null
    /**
     * Filter, which MitraRequest to fetch.
     */
    where: MitraRequestWhereUniqueInput
  }

  /**
   * MitraRequest findUniqueOrThrow
   */
  export type MitraRequestFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraRequest
     */
    select?: MitraRequestSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraRequestInclude<ExtArgs> | null
    /**
     * Filter, which MitraRequest to fetch.
     */
    where: MitraRequestWhereUniqueInput
  }

  /**
   * MitraRequest findFirst
   */
  export type MitraRequestFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraRequest
     */
    select?: MitraRequestSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraRequestInclude<ExtArgs> | null
    /**
     * Filter, which MitraRequest to fetch.
     */
    where?: MitraRequestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MitraRequests to fetch.
     */
    orderBy?: MitraRequestOrderByWithRelationInput | MitraRequestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for MitraRequests.
     */
    cursor?: MitraRequestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MitraRequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MitraRequests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of MitraRequests.
     */
    distinct?: MitraRequestScalarFieldEnum | MitraRequestScalarFieldEnum[]
  }

  /**
   * MitraRequest findFirstOrThrow
   */
  export type MitraRequestFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraRequest
     */
    select?: MitraRequestSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraRequestInclude<ExtArgs> | null
    /**
     * Filter, which MitraRequest to fetch.
     */
    where?: MitraRequestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MitraRequests to fetch.
     */
    orderBy?: MitraRequestOrderByWithRelationInput | MitraRequestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for MitraRequests.
     */
    cursor?: MitraRequestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MitraRequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MitraRequests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of MitraRequests.
     */
    distinct?: MitraRequestScalarFieldEnum | MitraRequestScalarFieldEnum[]
  }

  /**
   * MitraRequest findMany
   */
  export type MitraRequestFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraRequest
     */
    select?: MitraRequestSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraRequestInclude<ExtArgs> | null
    /**
     * Filter, which MitraRequests to fetch.
     */
    where?: MitraRequestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MitraRequests to fetch.
     */
    orderBy?: MitraRequestOrderByWithRelationInput | MitraRequestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing MitraRequests.
     */
    cursor?: MitraRequestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MitraRequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MitraRequests.
     */
    skip?: number
    distinct?: MitraRequestScalarFieldEnum | MitraRequestScalarFieldEnum[]
  }

  /**
   * MitraRequest create
   */
  export type MitraRequestCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraRequest
     */
    select?: MitraRequestSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraRequestInclude<ExtArgs> | null
    /**
     * The data needed to create a MitraRequest.
     */
    data: XOR<MitraRequestCreateInput, MitraRequestUncheckedCreateInput>
  }

  /**
   * MitraRequest createMany
   */
  export type MitraRequestCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many MitraRequests.
     */
    data: MitraRequestCreateManyInput | MitraRequestCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * MitraRequest update
   */
  export type MitraRequestUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraRequest
     */
    select?: MitraRequestSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraRequestInclude<ExtArgs> | null
    /**
     * The data needed to update a MitraRequest.
     */
    data: XOR<MitraRequestUpdateInput, MitraRequestUncheckedUpdateInput>
    /**
     * Choose, which MitraRequest to update.
     */
    where: MitraRequestWhereUniqueInput
  }

  /**
   * MitraRequest updateMany
   */
  export type MitraRequestUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update MitraRequests.
     */
    data: XOR<MitraRequestUpdateManyMutationInput, MitraRequestUncheckedUpdateManyInput>
    /**
     * Filter which MitraRequests to update
     */
    where?: MitraRequestWhereInput
  }

  /**
   * MitraRequest upsert
   */
  export type MitraRequestUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraRequest
     */
    select?: MitraRequestSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraRequestInclude<ExtArgs> | null
    /**
     * The filter to search for the MitraRequest to update in case it exists.
     */
    where: MitraRequestWhereUniqueInput
    /**
     * In case the MitraRequest found by the `where` argument doesn't exist, create a new MitraRequest with this data.
     */
    create: XOR<MitraRequestCreateInput, MitraRequestUncheckedCreateInput>
    /**
     * In case the MitraRequest was found with the provided `where` argument, update it with this data.
     */
    update: XOR<MitraRequestUpdateInput, MitraRequestUncheckedUpdateInput>
  }

  /**
   * MitraRequest delete
   */
  export type MitraRequestDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraRequest
     */
    select?: MitraRequestSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraRequestInclude<ExtArgs> | null
    /**
     * Filter which MitraRequest to delete.
     */
    where: MitraRequestWhereUniqueInput
  }

  /**
   * MitraRequest deleteMany
   */
  export type MitraRequestDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which MitraRequests to delete
     */
    where?: MitraRequestWhereInput
  }

  /**
   * MitraRequest without action
   */
  export type MitraRequestDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraRequest
     */
    select?: MitraRequestSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraRequestInclude<ExtArgs> | null
  }


  /**
   * Model UserPackage
   */

  export type AggregateUserPackage = {
    _count: UserPackageCountAggregateOutputType | null
    _avg: UserPackageAvgAggregateOutputType | null
    _sum: UserPackageSumAggregateOutputType | null
    _min: UserPackageMinAggregateOutputType | null
    _max: UserPackageMaxAggregateOutputType | null
  }

  export type UserPackageAvgAggregateOutputType = {
    number_of_pax: number | null
    travel_duration: number | null
    mekkah_duration: number | null
    madinah_duration: number | null
    per_pax_price: Decimal | null
    total_price: Decimal | null
  }

  export type UserPackageSumAggregateOutputType = {
    number_of_pax: number | null
    travel_duration: number | null
    mekkah_duration: number | null
    madinah_duration: number | null
    per_pax_price: Decimal | null
    total_price: Decimal | null
  }

  export type UserPackageMinAggregateOutputType = {
    id: string | null
    transportation_id: string | null
    flight_id: string | null
    hotel_mekkah_id: string | null
    hotel_madinah_id: string | null
    muthawif_id: string | null
    handling_id: string | null
    number_of_pax: number | null
    travel_duration: number | null
    mekkah_duration: number | null
    madinah_duration: number | null
    per_pax_price: Decimal | null
    total_price: Decimal | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type UserPackageMaxAggregateOutputType = {
    id: string | null
    transportation_id: string | null
    flight_id: string | null
    hotel_mekkah_id: string | null
    hotel_madinah_id: string | null
    muthawif_id: string | null
    handling_id: string | null
    number_of_pax: number | null
    travel_duration: number | null
    mekkah_duration: number | null
    madinah_duration: number | null
    per_pax_price: Decimal | null
    total_price: Decimal | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type UserPackageCountAggregateOutputType = {
    id: number
    transportation_id: number
    flight_id: number
    hotel_mekkah_id: number
    hotel_madinah_id: number
    muthawif_id: number
    handling_id: number
    number_of_pax: number
    travel_duration: number
    mekkah_duration: number
    madinah_duration: number
    per_pax_price: number
    total_price: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type UserPackageAvgAggregateInputType = {
    number_of_pax?: true
    travel_duration?: true
    mekkah_duration?: true
    madinah_duration?: true
    per_pax_price?: true
    total_price?: true
  }

  export type UserPackageSumAggregateInputType = {
    number_of_pax?: true
    travel_duration?: true
    mekkah_duration?: true
    madinah_duration?: true
    per_pax_price?: true
    total_price?: true
  }

  export type UserPackageMinAggregateInputType = {
    id?: true
    transportation_id?: true
    flight_id?: true
    hotel_mekkah_id?: true
    hotel_madinah_id?: true
    muthawif_id?: true
    handling_id?: true
    number_of_pax?: true
    travel_duration?: true
    mekkah_duration?: true
    madinah_duration?: true
    per_pax_price?: true
    total_price?: true
    created_at?: true
    updated_at?: true
  }

  export type UserPackageMaxAggregateInputType = {
    id?: true
    transportation_id?: true
    flight_id?: true
    hotel_mekkah_id?: true
    hotel_madinah_id?: true
    muthawif_id?: true
    handling_id?: true
    number_of_pax?: true
    travel_duration?: true
    mekkah_duration?: true
    madinah_duration?: true
    per_pax_price?: true
    total_price?: true
    created_at?: true
    updated_at?: true
  }

  export type UserPackageCountAggregateInputType = {
    id?: true
    transportation_id?: true
    flight_id?: true
    hotel_mekkah_id?: true
    hotel_madinah_id?: true
    muthawif_id?: true
    handling_id?: true
    number_of_pax?: true
    travel_duration?: true
    mekkah_duration?: true
    madinah_duration?: true
    per_pax_price?: true
    total_price?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type UserPackageAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserPackage to aggregate.
     */
    where?: UserPackageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPackages to fetch.
     */
    orderBy?: UserPackageOrderByWithRelationInput | UserPackageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserPackageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPackages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPackages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserPackages
    **/
    _count?: true | UserPackageCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserPackageAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserPackageSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserPackageMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserPackageMaxAggregateInputType
  }

  export type GetUserPackageAggregateType<T extends UserPackageAggregateArgs> = {
        [P in keyof T & keyof AggregateUserPackage]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserPackage[P]>
      : GetScalarType<T[P], AggregateUserPackage[P]>
  }




  export type UserPackageGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPackageWhereInput
    orderBy?: UserPackageOrderByWithAggregationInput | UserPackageOrderByWithAggregationInput[]
    by: UserPackageScalarFieldEnum[] | UserPackageScalarFieldEnum
    having?: UserPackageScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserPackageCountAggregateInputType | true
    _avg?: UserPackageAvgAggregateInputType
    _sum?: UserPackageSumAggregateInputType
    _min?: UserPackageMinAggregateInputType
    _max?: UserPackageMaxAggregateInputType
  }

  export type UserPackageGroupByOutputType = {
    id: string
    transportation_id: string | null
    flight_id: string | null
    hotel_mekkah_id: string | null
    hotel_madinah_id: string | null
    muthawif_id: string | null
    handling_id: string | null
    number_of_pax: number
    travel_duration: number
    mekkah_duration: number
    madinah_duration: number
    per_pax_price: Decimal
    total_price: Decimal
    created_at: Date
    updated_at: Date
    _count: UserPackageCountAggregateOutputType | null
    _avg: UserPackageAvgAggregateOutputType | null
    _sum: UserPackageSumAggregateOutputType | null
    _min: UserPackageMinAggregateOutputType | null
    _max: UserPackageMaxAggregateOutputType | null
  }

  type GetUserPackageGroupByPayload<T extends UserPackageGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserPackageGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserPackageGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserPackageGroupByOutputType[P]>
            : GetScalarType<T[P], UserPackageGroupByOutputType[P]>
        }
      >
    >


  export type UserPackageSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    transportation_id?: boolean
    flight_id?: boolean
    hotel_mekkah_id?: boolean
    hotel_madinah_id?: boolean
    muthawif_id?: boolean
    handling_id?: boolean
    number_of_pax?: boolean
    travel_duration?: boolean
    mekkah_duration?: boolean
    madinah_duration?: boolean
    per_pax_price?: boolean
    total_price?: boolean
    created_at?: boolean
    updated_at?: boolean
    UserPackageOrders?: boolean | UserPackage$UserPackageOrdersArgs<ExtArgs>
    transportation?: boolean | UserPackage$transportationArgs<ExtArgs>
    flight?: boolean | UserPackage$flightArgs<ExtArgs>
    hotelMekkah?: boolean | UserPackage$hotelMekkahArgs<ExtArgs>
    hotelMadinah?: boolean | UserPackage$hotelMadinahArgs<ExtArgs>
    muthawif?: boolean | UserPackage$muthawifArgs<ExtArgs>
    handling?: boolean | UserPackage$handlingArgs<ExtArgs>
    _count?: boolean | UserPackageCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userPackage"]>


  export type UserPackageSelectScalar = {
    id?: boolean
    transportation_id?: boolean
    flight_id?: boolean
    hotel_mekkah_id?: boolean
    hotel_madinah_id?: boolean
    muthawif_id?: boolean
    handling_id?: boolean
    number_of_pax?: boolean
    travel_duration?: boolean
    mekkah_duration?: boolean
    madinah_duration?: boolean
    per_pax_price?: boolean
    total_price?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type UserPackageInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    UserPackageOrders?: boolean | UserPackage$UserPackageOrdersArgs<ExtArgs>
    transportation?: boolean | UserPackage$transportationArgs<ExtArgs>
    flight?: boolean | UserPackage$flightArgs<ExtArgs>
    hotelMekkah?: boolean | UserPackage$hotelMekkahArgs<ExtArgs>
    hotelMadinah?: boolean | UserPackage$hotelMadinahArgs<ExtArgs>
    muthawif?: boolean | UserPackage$muthawifArgs<ExtArgs>
    handling?: boolean | UserPackage$handlingArgs<ExtArgs>
    _count?: boolean | UserPackageCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $UserPackagePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "UserPackage"
    objects: {
      UserPackageOrders: Prisma.$UserPackageOrderPayload<ExtArgs>[]
      transportation: Prisma.$UserPackageOptionPayload<ExtArgs> | null
      flight: Prisma.$UserPackageOptionPayload<ExtArgs> | null
      hotelMekkah: Prisma.$UserPackageOptionPayload<ExtArgs> | null
      hotelMadinah: Prisma.$UserPackageOptionPayload<ExtArgs> | null
      muthawif: Prisma.$UserPackageOptionPayload<ExtArgs> | null
      handling: Prisma.$UserPackageOptionPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      transportation_id: string | null
      flight_id: string | null
      hotel_mekkah_id: string | null
      hotel_madinah_id: string | null
      muthawif_id: string | null
      handling_id: string | null
      number_of_pax: number
      travel_duration: number
      mekkah_duration: number
      madinah_duration: number
      per_pax_price: Prisma.Decimal
      total_price: Prisma.Decimal
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["userPackage"]>
    composites: {}
  }

  type UserPackageGetPayload<S extends boolean | null | undefined | UserPackageDefaultArgs> = $Result.GetResult<Prisma.$UserPackagePayload, S>

  type UserPackageCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UserPackageFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: UserPackageCountAggregateInputType | true
    }

  export interface UserPackageDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['UserPackage'], meta: { name: 'UserPackage' } }
    /**
     * Find zero or one UserPackage that matches the filter.
     * @param {UserPackageFindUniqueArgs} args - Arguments to find a UserPackage
     * @example
     * // Get one UserPackage
     * const userPackage = await prisma.userPackage.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends UserPackageFindUniqueArgs>(args: SelectSubset<T, UserPackageFindUniqueArgs<ExtArgs>>): Prisma__UserPackageClient<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one UserPackage that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {UserPackageFindUniqueOrThrowArgs} args - Arguments to find a UserPackage
     * @example
     * // Get one UserPackage
     * const userPackage = await prisma.userPackage.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends UserPackageFindUniqueOrThrowArgs>(args: SelectSubset<T, UserPackageFindUniqueOrThrowArgs<ExtArgs>>): Prisma__UserPackageClient<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first UserPackage that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageFindFirstArgs} args - Arguments to find a UserPackage
     * @example
     * // Get one UserPackage
     * const userPackage = await prisma.userPackage.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends UserPackageFindFirstArgs>(args?: SelectSubset<T, UserPackageFindFirstArgs<ExtArgs>>): Prisma__UserPackageClient<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first UserPackage that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageFindFirstOrThrowArgs} args - Arguments to find a UserPackage
     * @example
     * // Get one UserPackage
     * const userPackage = await prisma.userPackage.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends UserPackageFindFirstOrThrowArgs>(args?: SelectSubset<T, UserPackageFindFirstOrThrowArgs<ExtArgs>>): Prisma__UserPackageClient<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more UserPackages that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserPackages
     * const userPackages = await prisma.userPackage.findMany()
     * 
     * // Get first 10 UserPackages
     * const userPackages = await prisma.userPackage.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userPackageWithIdOnly = await prisma.userPackage.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends UserPackageFindManyArgs>(args?: SelectSubset<T, UserPackageFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "findMany">>

    /**
     * Create a UserPackage.
     * @param {UserPackageCreateArgs} args - Arguments to create a UserPackage.
     * @example
     * // Create one UserPackage
     * const UserPackage = await prisma.userPackage.create({
     *   data: {
     *     // ... data to create a UserPackage
     *   }
     * })
     * 
     */
    create<T extends UserPackageCreateArgs>(args: SelectSubset<T, UserPackageCreateArgs<ExtArgs>>): Prisma__UserPackageClient<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many UserPackages.
     * @param {UserPackageCreateManyArgs} args - Arguments to create many UserPackages.
     * @example
     * // Create many UserPackages
     * const userPackage = await prisma.userPackage.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends UserPackageCreateManyArgs>(args?: SelectSubset<T, UserPackageCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a UserPackage.
     * @param {UserPackageDeleteArgs} args - Arguments to delete one UserPackage.
     * @example
     * // Delete one UserPackage
     * const UserPackage = await prisma.userPackage.delete({
     *   where: {
     *     // ... filter to delete one UserPackage
     *   }
     * })
     * 
     */
    delete<T extends UserPackageDeleteArgs>(args: SelectSubset<T, UserPackageDeleteArgs<ExtArgs>>): Prisma__UserPackageClient<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one UserPackage.
     * @param {UserPackageUpdateArgs} args - Arguments to update one UserPackage.
     * @example
     * // Update one UserPackage
     * const userPackage = await prisma.userPackage.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends UserPackageUpdateArgs>(args: SelectSubset<T, UserPackageUpdateArgs<ExtArgs>>): Prisma__UserPackageClient<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more UserPackages.
     * @param {UserPackageDeleteManyArgs} args - Arguments to filter UserPackages to delete.
     * @example
     * // Delete a few UserPackages
     * const { count } = await prisma.userPackage.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends UserPackageDeleteManyArgs>(args?: SelectSubset<T, UserPackageDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserPackages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserPackages
     * const userPackage = await prisma.userPackage.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends UserPackageUpdateManyArgs>(args: SelectSubset<T, UserPackageUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one UserPackage.
     * @param {UserPackageUpsertArgs} args - Arguments to update or create a UserPackage.
     * @example
     * // Update or create a UserPackage
     * const userPackage = await prisma.userPackage.upsert({
     *   create: {
     *     // ... data to create a UserPackage
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserPackage we want to update
     *   }
     * })
     */
    upsert<T extends UserPackageUpsertArgs>(args: SelectSubset<T, UserPackageUpsertArgs<ExtArgs>>): Prisma__UserPackageClient<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of UserPackages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageCountArgs} args - Arguments to filter UserPackages to count.
     * @example
     * // Count the number of UserPackages
     * const count = await prisma.userPackage.count({
     *   where: {
     *     // ... the filter for the UserPackages we want to count
     *   }
     * })
    **/
    count<T extends UserPackageCountArgs>(
      args?: Subset<T, UserPackageCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserPackageCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserPackage.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserPackageAggregateArgs>(args: Subset<T, UserPackageAggregateArgs>): Prisma.PrismaPromise<GetUserPackageAggregateType<T>>

    /**
     * Group by UserPackage.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserPackageGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserPackageGroupByArgs['orderBy'] }
        : { orderBy?: UserPackageGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserPackageGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserPackageGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the UserPackage model
   */
  readonly fields: UserPackageFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for UserPackage.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserPackageClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    UserPackageOrders<T extends UserPackage$UserPackageOrdersArgs<ExtArgs> = {}>(args?: Subset<T, UserPackage$UserPackageOrdersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPackageOrderPayload<ExtArgs>, T, "findMany"> | Null>
    transportation<T extends UserPackage$transportationArgs<ExtArgs> = {}>(args?: Subset<T, UserPackage$transportationArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "findUniqueOrThrow"> | null, null, ExtArgs>
    flight<T extends UserPackage$flightArgs<ExtArgs> = {}>(args?: Subset<T, UserPackage$flightArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "findUniqueOrThrow"> | null, null, ExtArgs>
    hotelMekkah<T extends UserPackage$hotelMekkahArgs<ExtArgs> = {}>(args?: Subset<T, UserPackage$hotelMekkahArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "findUniqueOrThrow"> | null, null, ExtArgs>
    hotelMadinah<T extends UserPackage$hotelMadinahArgs<ExtArgs> = {}>(args?: Subset<T, UserPackage$hotelMadinahArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "findUniqueOrThrow"> | null, null, ExtArgs>
    muthawif<T extends UserPackage$muthawifArgs<ExtArgs> = {}>(args?: Subset<T, UserPackage$muthawifArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "findUniqueOrThrow"> | null, null, ExtArgs>
    handling<T extends UserPackage$handlingArgs<ExtArgs> = {}>(args?: Subset<T, UserPackage$handlingArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "findUniqueOrThrow"> | null, null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the UserPackage model
   */ 
  interface UserPackageFieldRefs {
    readonly id: FieldRef<"UserPackage", 'String'>
    readonly transportation_id: FieldRef<"UserPackage", 'String'>
    readonly flight_id: FieldRef<"UserPackage", 'String'>
    readonly hotel_mekkah_id: FieldRef<"UserPackage", 'String'>
    readonly hotel_madinah_id: FieldRef<"UserPackage", 'String'>
    readonly muthawif_id: FieldRef<"UserPackage", 'String'>
    readonly handling_id: FieldRef<"UserPackage", 'String'>
    readonly number_of_pax: FieldRef<"UserPackage", 'Int'>
    readonly travel_duration: FieldRef<"UserPackage", 'Int'>
    readonly mekkah_duration: FieldRef<"UserPackage", 'Int'>
    readonly madinah_duration: FieldRef<"UserPackage", 'Int'>
    readonly per_pax_price: FieldRef<"UserPackage", 'Decimal'>
    readonly total_price: FieldRef<"UserPackage", 'Decimal'>
    readonly created_at: FieldRef<"UserPackage", 'DateTime'>
    readonly updated_at: FieldRef<"UserPackage", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * UserPackage findUnique
   */
  export type UserPackageFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    /**
     * Filter, which UserPackage to fetch.
     */
    where: UserPackageWhereUniqueInput
  }

  /**
   * UserPackage findUniqueOrThrow
   */
  export type UserPackageFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    /**
     * Filter, which UserPackage to fetch.
     */
    where: UserPackageWhereUniqueInput
  }

  /**
   * UserPackage findFirst
   */
  export type UserPackageFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    /**
     * Filter, which UserPackage to fetch.
     */
    where?: UserPackageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPackages to fetch.
     */
    orderBy?: UserPackageOrderByWithRelationInput | UserPackageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserPackages.
     */
    cursor?: UserPackageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPackages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPackages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserPackages.
     */
    distinct?: UserPackageScalarFieldEnum | UserPackageScalarFieldEnum[]
  }

  /**
   * UserPackage findFirstOrThrow
   */
  export type UserPackageFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    /**
     * Filter, which UserPackage to fetch.
     */
    where?: UserPackageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPackages to fetch.
     */
    orderBy?: UserPackageOrderByWithRelationInput | UserPackageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserPackages.
     */
    cursor?: UserPackageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPackages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPackages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserPackages.
     */
    distinct?: UserPackageScalarFieldEnum | UserPackageScalarFieldEnum[]
  }

  /**
   * UserPackage findMany
   */
  export type UserPackageFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    /**
     * Filter, which UserPackages to fetch.
     */
    where?: UserPackageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPackages to fetch.
     */
    orderBy?: UserPackageOrderByWithRelationInput | UserPackageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserPackages.
     */
    cursor?: UserPackageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPackages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPackages.
     */
    skip?: number
    distinct?: UserPackageScalarFieldEnum | UserPackageScalarFieldEnum[]
  }

  /**
   * UserPackage create
   */
  export type UserPackageCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    /**
     * The data needed to create a UserPackage.
     */
    data: XOR<UserPackageCreateInput, UserPackageUncheckedCreateInput>
  }

  /**
   * UserPackage createMany
   */
  export type UserPackageCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many UserPackages.
     */
    data: UserPackageCreateManyInput | UserPackageCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * UserPackage update
   */
  export type UserPackageUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    /**
     * The data needed to update a UserPackage.
     */
    data: XOR<UserPackageUpdateInput, UserPackageUncheckedUpdateInput>
    /**
     * Choose, which UserPackage to update.
     */
    where: UserPackageWhereUniqueInput
  }

  /**
   * UserPackage updateMany
   */
  export type UserPackageUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update UserPackages.
     */
    data: XOR<UserPackageUpdateManyMutationInput, UserPackageUncheckedUpdateManyInput>
    /**
     * Filter which UserPackages to update
     */
    where?: UserPackageWhereInput
  }

  /**
   * UserPackage upsert
   */
  export type UserPackageUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    /**
     * The filter to search for the UserPackage to update in case it exists.
     */
    where: UserPackageWhereUniqueInput
    /**
     * In case the UserPackage found by the `where` argument doesn't exist, create a new UserPackage with this data.
     */
    create: XOR<UserPackageCreateInput, UserPackageUncheckedCreateInput>
    /**
     * In case the UserPackage was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserPackageUpdateInput, UserPackageUncheckedUpdateInput>
  }

  /**
   * UserPackage delete
   */
  export type UserPackageDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    /**
     * Filter which UserPackage to delete.
     */
    where: UserPackageWhereUniqueInput
  }

  /**
   * UserPackage deleteMany
   */
  export type UserPackageDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserPackages to delete
     */
    where?: UserPackageWhereInput
  }

  /**
   * UserPackage.UserPackageOrders
   */
  export type UserPackage$UserPackageOrdersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOrder
     */
    select?: UserPackageOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOrderInclude<ExtArgs> | null
    where?: UserPackageOrderWhereInput
    orderBy?: UserPackageOrderOrderByWithRelationInput | UserPackageOrderOrderByWithRelationInput[]
    cursor?: UserPackageOrderWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserPackageOrderScalarFieldEnum | UserPackageOrderScalarFieldEnum[]
  }

  /**
   * UserPackage.transportation
   */
  export type UserPackage$transportationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    where?: UserPackageOptionWhereInput
  }

  /**
   * UserPackage.flight
   */
  export type UserPackage$flightArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    where?: UserPackageOptionWhereInput
  }

  /**
   * UserPackage.hotelMekkah
   */
  export type UserPackage$hotelMekkahArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    where?: UserPackageOptionWhereInput
  }

  /**
   * UserPackage.hotelMadinah
   */
  export type UserPackage$hotelMadinahArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    where?: UserPackageOptionWhereInput
  }

  /**
   * UserPackage.muthawif
   */
  export type UserPackage$muthawifArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    where?: UserPackageOptionWhereInput
  }

  /**
   * UserPackage.handling
   */
  export type UserPackage$handlingArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    where?: UserPackageOptionWhereInput
  }

  /**
   * UserPackage without action
   */
  export type UserPackageDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
  }


  /**
   * Model PackageType
   */

  export type AggregatePackageType = {
    _count: PackageTypeCountAggregateOutputType | null
    _min: PackageTypeMinAggregateOutputType | null
    _max: PackageTypeMaxAggregateOutputType | null
  }

  export type PackageTypeMinAggregateOutputType = {
    id: string | null
    name: string | null
    is_public: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type PackageTypeMaxAggregateOutputType = {
    id: string | null
    name: string | null
    is_public: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type PackageTypeCountAggregateOutputType = {
    id: number
    name: number
    is_public: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type PackageTypeMinAggregateInputType = {
    id?: true
    name?: true
    is_public?: true
    created_at?: true
    updated_at?: true
  }

  export type PackageTypeMaxAggregateInputType = {
    id?: true
    name?: true
    is_public?: true
    created_at?: true
    updated_at?: true
  }

  export type PackageTypeCountAggregateInputType = {
    id?: true
    name?: true
    is_public?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type PackageTypeAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which PackageType to aggregate.
     */
    where?: PackageTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PackageTypes to fetch.
     */
    orderBy?: PackageTypeOrderByWithRelationInput | PackageTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: PackageTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PackageTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PackageTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned PackageTypes
    **/
    _count?: true | PackageTypeCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: PackageTypeMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: PackageTypeMaxAggregateInputType
  }

  export type GetPackageTypeAggregateType<T extends PackageTypeAggregateArgs> = {
        [P in keyof T & keyof AggregatePackageType]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregatePackageType[P]>
      : GetScalarType<T[P], AggregatePackageType[P]>
  }




  export type PackageTypeGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PackageTypeWhereInput
    orderBy?: PackageTypeOrderByWithAggregationInput | PackageTypeOrderByWithAggregationInput[]
    by: PackageTypeScalarFieldEnum[] | PackageTypeScalarFieldEnum
    having?: PackageTypeScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: PackageTypeCountAggregateInputType | true
    _min?: PackageTypeMinAggregateInputType
    _max?: PackageTypeMaxAggregateInputType
  }

  export type PackageTypeGroupByOutputType = {
    id: string
    name: string
    is_public: boolean
    created_at: Date
    updated_at: Date
    _count: PackageTypeCountAggregateOutputType | null
    _min: PackageTypeMinAggregateOutputType | null
    _max: PackageTypeMaxAggregateOutputType | null
  }

  type GetPackageTypeGroupByPayload<T extends PackageTypeGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<PackageTypeGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof PackageTypeGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], PackageTypeGroupByOutputType[P]>
            : GetScalarType<T[P], PackageTypeGroupByOutputType[P]>
        }
      >
    >


  export type PackageTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    is_public?: boolean
    created_at?: boolean
    updated_at?: boolean
    UserPackageOptions?: boolean | PackageType$UserPackageOptionsArgs<ExtArgs>
    _count?: boolean | PackageTypeCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["packageType"]>


  export type PackageTypeSelectScalar = {
    id?: boolean
    name?: boolean
    is_public?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type PackageTypeInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    UserPackageOptions?: boolean | PackageType$UserPackageOptionsArgs<ExtArgs>
    _count?: boolean | PackageTypeCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $PackageTypePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "PackageType"
    objects: {
      UserPackageOptions: Prisma.$UserPackageOptionPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      is_public: boolean
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["packageType"]>
    composites: {}
  }

  type PackageTypeGetPayload<S extends boolean | null | undefined | PackageTypeDefaultArgs> = $Result.GetResult<Prisma.$PackageTypePayload, S>

  type PackageTypeCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<PackageTypeFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: PackageTypeCountAggregateInputType | true
    }

  export interface PackageTypeDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['PackageType'], meta: { name: 'PackageType' } }
    /**
     * Find zero or one PackageType that matches the filter.
     * @param {PackageTypeFindUniqueArgs} args - Arguments to find a PackageType
     * @example
     * // Get one PackageType
     * const packageType = await prisma.packageType.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends PackageTypeFindUniqueArgs>(args: SelectSubset<T, PackageTypeFindUniqueArgs<ExtArgs>>): Prisma__PackageTypeClient<$Result.GetResult<Prisma.$PackageTypePayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one PackageType that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {PackageTypeFindUniqueOrThrowArgs} args - Arguments to find a PackageType
     * @example
     * // Get one PackageType
     * const packageType = await prisma.packageType.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends PackageTypeFindUniqueOrThrowArgs>(args: SelectSubset<T, PackageTypeFindUniqueOrThrowArgs<ExtArgs>>): Prisma__PackageTypeClient<$Result.GetResult<Prisma.$PackageTypePayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first PackageType that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PackageTypeFindFirstArgs} args - Arguments to find a PackageType
     * @example
     * // Get one PackageType
     * const packageType = await prisma.packageType.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends PackageTypeFindFirstArgs>(args?: SelectSubset<T, PackageTypeFindFirstArgs<ExtArgs>>): Prisma__PackageTypeClient<$Result.GetResult<Prisma.$PackageTypePayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first PackageType that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PackageTypeFindFirstOrThrowArgs} args - Arguments to find a PackageType
     * @example
     * // Get one PackageType
     * const packageType = await prisma.packageType.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends PackageTypeFindFirstOrThrowArgs>(args?: SelectSubset<T, PackageTypeFindFirstOrThrowArgs<ExtArgs>>): Prisma__PackageTypeClient<$Result.GetResult<Prisma.$PackageTypePayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more PackageTypes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PackageTypeFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all PackageTypes
     * const packageTypes = await prisma.packageType.findMany()
     * 
     * // Get first 10 PackageTypes
     * const packageTypes = await prisma.packageType.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const packageTypeWithIdOnly = await prisma.packageType.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends PackageTypeFindManyArgs>(args?: SelectSubset<T, PackageTypeFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$PackageTypePayload<ExtArgs>, T, "findMany">>

    /**
     * Create a PackageType.
     * @param {PackageTypeCreateArgs} args - Arguments to create a PackageType.
     * @example
     * // Create one PackageType
     * const PackageType = await prisma.packageType.create({
     *   data: {
     *     // ... data to create a PackageType
     *   }
     * })
     * 
     */
    create<T extends PackageTypeCreateArgs>(args: SelectSubset<T, PackageTypeCreateArgs<ExtArgs>>): Prisma__PackageTypeClient<$Result.GetResult<Prisma.$PackageTypePayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many PackageTypes.
     * @param {PackageTypeCreateManyArgs} args - Arguments to create many PackageTypes.
     * @example
     * // Create many PackageTypes
     * const packageType = await prisma.packageType.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends PackageTypeCreateManyArgs>(args?: SelectSubset<T, PackageTypeCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a PackageType.
     * @param {PackageTypeDeleteArgs} args - Arguments to delete one PackageType.
     * @example
     * // Delete one PackageType
     * const PackageType = await prisma.packageType.delete({
     *   where: {
     *     // ... filter to delete one PackageType
     *   }
     * })
     * 
     */
    delete<T extends PackageTypeDeleteArgs>(args: SelectSubset<T, PackageTypeDeleteArgs<ExtArgs>>): Prisma__PackageTypeClient<$Result.GetResult<Prisma.$PackageTypePayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one PackageType.
     * @param {PackageTypeUpdateArgs} args - Arguments to update one PackageType.
     * @example
     * // Update one PackageType
     * const packageType = await prisma.packageType.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends PackageTypeUpdateArgs>(args: SelectSubset<T, PackageTypeUpdateArgs<ExtArgs>>): Prisma__PackageTypeClient<$Result.GetResult<Prisma.$PackageTypePayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more PackageTypes.
     * @param {PackageTypeDeleteManyArgs} args - Arguments to filter PackageTypes to delete.
     * @example
     * // Delete a few PackageTypes
     * const { count } = await prisma.packageType.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends PackageTypeDeleteManyArgs>(args?: SelectSubset<T, PackageTypeDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more PackageTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PackageTypeUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many PackageTypes
     * const packageType = await prisma.packageType.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends PackageTypeUpdateManyArgs>(args: SelectSubset<T, PackageTypeUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one PackageType.
     * @param {PackageTypeUpsertArgs} args - Arguments to update or create a PackageType.
     * @example
     * // Update or create a PackageType
     * const packageType = await prisma.packageType.upsert({
     *   create: {
     *     // ... data to create a PackageType
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the PackageType we want to update
     *   }
     * })
     */
    upsert<T extends PackageTypeUpsertArgs>(args: SelectSubset<T, PackageTypeUpsertArgs<ExtArgs>>): Prisma__PackageTypeClient<$Result.GetResult<Prisma.$PackageTypePayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of PackageTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PackageTypeCountArgs} args - Arguments to filter PackageTypes to count.
     * @example
     * // Count the number of PackageTypes
     * const count = await prisma.packageType.count({
     *   where: {
     *     // ... the filter for the PackageTypes we want to count
     *   }
     * })
    **/
    count<T extends PackageTypeCountArgs>(
      args?: Subset<T, PackageTypeCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], PackageTypeCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a PackageType.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PackageTypeAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends PackageTypeAggregateArgs>(args: Subset<T, PackageTypeAggregateArgs>): Prisma.PrismaPromise<GetPackageTypeAggregateType<T>>

    /**
     * Group by PackageType.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PackageTypeGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends PackageTypeGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: PackageTypeGroupByArgs['orderBy'] }
        : { orderBy?: PackageTypeGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, PackageTypeGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetPackageTypeGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the PackageType model
   */
  readonly fields: PackageTypeFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for PackageType.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__PackageTypeClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    UserPackageOptions<T extends PackageType$UserPackageOptionsArgs<ExtArgs> = {}>(args?: Subset<T, PackageType$UserPackageOptionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the PackageType model
   */ 
  interface PackageTypeFieldRefs {
    readonly id: FieldRef<"PackageType", 'String'>
    readonly name: FieldRef<"PackageType", 'String'>
    readonly is_public: FieldRef<"PackageType", 'Boolean'>
    readonly created_at: FieldRef<"PackageType", 'DateTime'>
    readonly updated_at: FieldRef<"PackageType", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * PackageType findUnique
   */
  export type PackageTypeFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PackageType
     */
    select?: PackageTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PackageTypeInclude<ExtArgs> | null
    /**
     * Filter, which PackageType to fetch.
     */
    where: PackageTypeWhereUniqueInput
  }

  /**
   * PackageType findUniqueOrThrow
   */
  export type PackageTypeFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PackageType
     */
    select?: PackageTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PackageTypeInclude<ExtArgs> | null
    /**
     * Filter, which PackageType to fetch.
     */
    where: PackageTypeWhereUniqueInput
  }

  /**
   * PackageType findFirst
   */
  export type PackageTypeFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PackageType
     */
    select?: PackageTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PackageTypeInclude<ExtArgs> | null
    /**
     * Filter, which PackageType to fetch.
     */
    where?: PackageTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PackageTypes to fetch.
     */
    orderBy?: PackageTypeOrderByWithRelationInput | PackageTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for PackageTypes.
     */
    cursor?: PackageTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PackageTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PackageTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of PackageTypes.
     */
    distinct?: PackageTypeScalarFieldEnum | PackageTypeScalarFieldEnum[]
  }

  /**
   * PackageType findFirstOrThrow
   */
  export type PackageTypeFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PackageType
     */
    select?: PackageTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PackageTypeInclude<ExtArgs> | null
    /**
     * Filter, which PackageType to fetch.
     */
    where?: PackageTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PackageTypes to fetch.
     */
    orderBy?: PackageTypeOrderByWithRelationInput | PackageTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for PackageTypes.
     */
    cursor?: PackageTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PackageTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PackageTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of PackageTypes.
     */
    distinct?: PackageTypeScalarFieldEnum | PackageTypeScalarFieldEnum[]
  }

  /**
   * PackageType findMany
   */
  export type PackageTypeFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PackageType
     */
    select?: PackageTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PackageTypeInclude<ExtArgs> | null
    /**
     * Filter, which PackageTypes to fetch.
     */
    where?: PackageTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PackageTypes to fetch.
     */
    orderBy?: PackageTypeOrderByWithRelationInput | PackageTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing PackageTypes.
     */
    cursor?: PackageTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PackageTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PackageTypes.
     */
    skip?: number
    distinct?: PackageTypeScalarFieldEnum | PackageTypeScalarFieldEnum[]
  }

  /**
   * PackageType create
   */
  export type PackageTypeCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PackageType
     */
    select?: PackageTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PackageTypeInclude<ExtArgs> | null
    /**
     * The data needed to create a PackageType.
     */
    data: XOR<PackageTypeCreateInput, PackageTypeUncheckedCreateInput>
  }

  /**
   * PackageType createMany
   */
  export type PackageTypeCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many PackageTypes.
     */
    data: PackageTypeCreateManyInput | PackageTypeCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * PackageType update
   */
  export type PackageTypeUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PackageType
     */
    select?: PackageTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PackageTypeInclude<ExtArgs> | null
    /**
     * The data needed to update a PackageType.
     */
    data: XOR<PackageTypeUpdateInput, PackageTypeUncheckedUpdateInput>
    /**
     * Choose, which PackageType to update.
     */
    where: PackageTypeWhereUniqueInput
  }

  /**
   * PackageType updateMany
   */
  export type PackageTypeUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update PackageTypes.
     */
    data: XOR<PackageTypeUpdateManyMutationInput, PackageTypeUncheckedUpdateManyInput>
    /**
     * Filter which PackageTypes to update
     */
    where?: PackageTypeWhereInput
  }

  /**
   * PackageType upsert
   */
  export type PackageTypeUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PackageType
     */
    select?: PackageTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PackageTypeInclude<ExtArgs> | null
    /**
     * The filter to search for the PackageType to update in case it exists.
     */
    where: PackageTypeWhereUniqueInput
    /**
     * In case the PackageType found by the `where` argument doesn't exist, create a new PackageType with this data.
     */
    create: XOR<PackageTypeCreateInput, PackageTypeUncheckedCreateInput>
    /**
     * In case the PackageType was found with the provided `where` argument, update it with this data.
     */
    update: XOR<PackageTypeUpdateInput, PackageTypeUncheckedUpdateInput>
  }

  /**
   * PackageType delete
   */
  export type PackageTypeDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PackageType
     */
    select?: PackageTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PackageTypeInclude<ExtArgs> | null
    /**
     * Filter which PackageType to delete.
     */
    where: PackageTypeWhereUniqueInput
  }

  /**
   * PackageType deleteMany
   */
  export type PackageTypeDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which PackageTypes to delete
     */
    where?: PackageTypeWhereInput
  }

  /**
   * PackageType.UserPackageOptions
   */
  export type PackageType$UserPackageOptionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    where?: UserPackageOptionWhereInput
    orderBy?: UserPackageOptionOrderByWithRelationInput | UserPackageOptionOrderByWithRelationInput[]
    cursor?: UserPackageOptionWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserPackageOptionScalarFieldEnum | UserPackageOptionScalarFieldEnum[]
  }

  /**
   * PackageType without action
   */
  export type PackageTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PackageType
     */
    select?: PackageTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PackageTypeInclude<ExtArgs> | null
  }


  /**
   * Model UserPackageOption
   */

  export type AggregateUserPackageOption = {
    _count: UserPackageOptionCountAggregateOutputType | null
    _avg: UserPackageOptionAvgAggregateOutputType | null
    _sum: UserPackageOptionSumAggregateOutputType | null
    _min: UserPackageOptionMinAggregateOutputType | null
    _max: UserPackageOptionMaxAggregateOutputType | null
  }

  export type UserPackageOptionAvgAggregateOutputType = {
    price: Decimal | null
    order_number: number | null
  }

  export type UserPackageOptionSumAggregateOutputType = {
    price: Decimal | null
    order_number: number | null
  }

  export type UserPackageOptionMinAggregateOutputType = {
    id: string | null
    package_type_id: string | null
    name: string | null
    price: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type UserPackageOptionMaxAggregateOutputType = {
    id: string | null
    package_type_id: string | null
    name: string | null
    price: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type UserPackageOptionCountAggregateOutputType = {
    id: number
    package_type_id: number
    name: number
    price: number
    order_number: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type UserPackageOptionAvgAggregateInputType = {
    price?: true
    order_number?: true
  }

  export type UserPackageOptionSumAggregateInputType = {
    price?: true
    order_number?: true
  }

  export type UserPackageOptionMinAggregateInputType = {
    id?: true
    package_type_id?: true
    name?: true
    price?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type UserPackageOptionMaxAggregateInputType = {
    id?: true
    package_type_id?: true
    name?: true
    price?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type UserPackageOptionCountAggregateInputType = {
    id?: true
    package_type_id?: true
    name?: true
    price?: true
    order_number?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type UserPackageOptionAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserPackageOption to aggregate.
     */
    where?: UserPackageOptionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPackageOptions to fetch.
     */
    orderBy?: UserPackageOptionOrderByWithRelationInput | UserPackageOptionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserPackageOptionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPackageOptions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPackageOptions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserPackageOptions
    **/
    _count?: true | UserPackageOptionCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserPackageOptionAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserPackageOptionSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserPackageOptionMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserPackageOptionMaxAggregateInputType
  }

  export type GetUserPackageOptionAggregateType<T extends UserPackageOptionAggregateArgs> = {
        [P in keyof T & keyof AggregateUserPackageOption]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserPackageOption[P]>
      : GetScalarType<T[P], AggregateUserPackageOption[P]>
  }




  export type UserPackageOptionGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPackageOptionWhereInput
    orderBy?: UserPackageOptionOrderByWithAggregationInput | UserPackageOptionOrderByWithAggregationInput[]
    by: UserPackageOptionScalarFieldEnum[] | UserPackageOptionScalarFieldEnum
    having?: UserPackageOptionScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserPackageOptionCountAggregateInputType | true
    _avg?: UserPackageOptionAvgAggregateInputType
    _sum?: UserPackageOptionSumAggregateInputType
    _min?: UserPackageOptionMinAggregateInputType
    _max?: UserPackageOptionMaxAggregateInputType
  }

  export type UserPackageOptionGroupByOutputType = {
    id: string
    package_type_id: string
    name: string
    price: Decimal
    order_number: number
    created_at: Date
    updated_at: Date
    _count: UserPackageOptionCountAggregateOutputType | null
    _avg: UserPackageOptionAvgAggregateOutputType | null
    _sum: UserPackageOptionSumAggregateOutputType | null
    _min: UserPackageOptionMinAggregateOutputType | null
    _max: UserPackageOptionMaxAggregateOutputType | null
  }

  type GetUserPackageOptionGroupByPayload<T extends UserPackageOptionGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserPackageOptionGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserPackageOptionGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserPackageOptionGroupByOutputType[P]>
            : GetScalarType<T[P], UserPackageOptionGroupByOutputType[P]>
        }
      >
    >


  export type UserPackageOptionSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    package_type_id?: boolean
    name?: boolean
    price?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
    transportations?: boolean | UserPackageOption$transportationsArgs<ExtArgs>
    flights?: boolean | UserPackageOption$flightsArgs<ExtArgs>
    hotelMekkahs?: boolean | UserPackageOption$hotelMekkahsArgs<ExtArgs>
    hotelMadinahs?: boolean | UserPackageOption$hotelMadinahsArgs<ExtArgs>
    muthawifs?: boolean | UserPackageOption$muthawifsArgs<ExtArgs>
    handlings?: boolean | UserPackageOption$handlingsArgs<ExtArgs>
    PackageType?: boolean | PackageTypeDefaultArgs<ExtArgs>
    _count?: boolean | UserPackageOptionCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userPackageOption"]>


  export type UserPackageOptionSelectScalar = {
    id?: boolean
    package_type_id?: boolean
    name?: boolean
    price?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type UserPackageOptionInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    transportations?: boolean | UserPackageOption$transportationsArgs<ExtArgs>
    flights?: boolean | UserPackageOption$flightsArgs<ExtArgs>
    hotelMekkahs?: boolean | UserPackageOption$hotelMekkahsArgs<ExtArgs>
    hotelMadinahs?: boolean | UserPackageOption$hotelMadinahsArgs<ExtArgs>
    muthawifs?: boolean | UserPackageOption$muthawifsArgs<ExtArgs>
    handlings?: boolean | UserPackageOption$handlingsArgs<ExtArgs>
    PackageType?: boolean | PackageTypeDefaultArgs<ExtArgs>
    _count?: boolean | UserPackageOptionCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $UserPackageOptionPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "UserPackageOption"
    objects: {
      transportations: Prisma.$UserPackagePayload<ExtArgs>[]
      flights: Prisma.$UserPackagePayload<ExtArgs>[]
      hotelMekkahs: Prisma.$UserPackagePayload<ExtArgs>[]
      hotelMadinahs: Prisma.$UserPackagePayload<ExtArgs>[]
      muthawifs: Prisma.$UserPackagePayload<ExtArgs>[]
      handlings: Prisma.$UserPackagePayload<ExtArgs>[]
      PackageType: Prisma.$PackageTypePayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      package_type_id: string
      name: string
      price: Prisma.Decimal
      order_number: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["userPackageOption"]>
    composites: {}
  }

  type UserPackageOptionGetPayload<S extends boolean | null | undefined | UserPackageOptionDefaultArgs> = $Result.GetResult<Prisma.$UserPackageOptionPayload, S>

  type UserPackageOptionCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UserPackageOptionFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: UserPackageOptionCountAggregateInputType | true
    }

  export interface UserPackageOptionDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['UserPackageOption'], meta: { name: 'UserPackageOption' } }
    /**
     * Find zero or one UserPackageOption that matches the filter.
     * @param {UserPackageOptionFindUniqueArgs} args - Arguments to find a UserPackageOption
     * @example
     * // Get one UserPackageOption
     * const userPackageOption = await prisma.userPackageOption.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends UserPackageOptionFindUniqueArgs>(args: SelectSubset<T, UserPackageOptionFindUniqueArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one UserPackageOption that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {UserPackageOptionFindUniqueOrThrowArgs} args - Arguments to find a UserPackageOption
     * @example
     * // Get one UserPackageOption
     * const userPackageOption = await prisma.userPackageOption.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends UserPackageOptionFindUniqueOrThrowArgs>(args: SelectSubset<T, UserPackageOptionFindUniqueOrThrowArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first UserPackageOption that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOptionFindFirstArgs} args - Arguments to find a UserPackageOption
     * @example
     * // Get one UserPackageOption
     * const userPackageOption = await prisma.userPackageOption.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends UserPackageOptionFindFirstArgs>(args?: SelectSubset<T, UserPackageOptionFindFirstArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first UserPackageOption that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOptionFindFirstOrThrowArgs} args - Arguments to find a UserPackageOption
     * @example
     * // Get one UserPackageOption
     * const userPackageOption = await prisma.userPackageOption.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends UserPackageOptionFindFirstOrThrowArgs>(args?: SelectSubset<T, UserPackageOptionFindFirstOrThrowArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more UserPackageOptions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOptionFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserPackageOptions
     * const userPackageOptions = await prisma.userPackageOption.findMany()
     * 
     * // Get first 10 UserPackageOptions
     * const userPackageOptions = await prisma.userPackageOption.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userPackageOptionWithIdOnly = await prisma.userPackageOption.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends UserPackageOptionFindManyArgs>(args?: SelectSubset<T, UserPackageOptionFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a UserPackageOption.
     * @param {UserPackageOptionCreateArgs} args - Arguments to create a UserPackageOption.
     * @example
     * // Create one UserPackageOption
     * const UserPackageOption = await prisma.userPackageOption.create({
     *   data: {
     *     // ... data to create a UserPackageOption
     *   }
     * })
     * 
     */
    create<T extends UserPackageOptionCreateArgs>(args: SelectSubset<T, UserPackageOptionCreateArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many UserPackageOptions.
     * @param {UserPackageOptionCreateManyArgs} args - Arguments to create many UserPackageOptions.
     * @example
     * // Create many UserPackageOptions
     * const userPackageOption = await prisma.userPackageOption.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends UserPackageOptionCreateManyArgs>(args?: SelectSubset<T, UserPackageOptionCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a UserPackageOption.
     * @param {UserPackageOptionDeleteArgs} args - Arguments to delete one UserPackageOption.
     * @example
     * // Delete one UserPackageOption
     * const UserPackageOption = await prisma.userPackageOption.delete({
     *   where: {
     *     // ... filter to delete one UserPackageOption
     *   }
     * })
     * 
     */
    delete<T extends UserPackageOptionDeleteArgs>(args: SelectSubset<T, UserPackageOptionDeleteArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one UserPackageOption.
     * @param {UserPackageOptionUpdateArgs} args - Arguments to update one UserPackageOption.
     * @example
     * // Update one UserPackageOption
     * const userPackageOption = await prisma.userPackageOption.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends UserPackageOptionUpdateArgs>(args: SelectSubset<T, UserPackageOptionUpdateArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more UserPackageOptions.
     * @param {UserPackageOptionDeleteManyArgs} args - Arguments to filter UserPackageOptions to delete.
     * @example
     * // Delete a few UserPackageOptions
     * const { count } = await prisma.userPackageOption.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends UserPackageOptionDeleteManyArgs>(args?: SelectSubset<T, UserPackageOptionDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserPackageOptions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOptionUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserPackageOptions
     * const userPackageOption = await prisma.userPackageOption.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends UserPackageOptionUpdateManyArgs>(args: SelectSubset<T, UserPackageOptionUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one UserPackageOption.
     * @param {UserPackageOptionUpsertArgs} args - Arguments to update or create a UserPackageOption.
     * @example
     * // Update or create a UserPackageOption
     * const userPackageOption = await prisma.userPackageOption.upsert({
     *   create: {
     *     // ... data to create a UserPackageOption
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserPackageOption we want to update
     *   }
     * })
     */
    upsert<T extends UserPackageOptionUpsertArgs>(args: SelectSubset<T, UserPackageOptionUpsertArgs<ExtArgs>>): Prisma__UserPackageOptionClient<$Result.GetResult<Prisma.$UserPackageOptionPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of UserPackageOptions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOptionCountArgs} args - Arguments to filter UserPackageOptions to count.
     * @example
     * // Count the number of UserPackageOptions
     * const count = await prisma.userPackageOption.count({
     *   where: {
     *     // ... the filter for the UserPackageOptions we want to count
     *   }
     * })
    **/
    count<T extends UserPackageOptionCountArgs>(
      args?: Subset<T, UserPackageOptionCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserPackageOptionCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserPackageOption.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOptionAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserPackageOptionAggregateArgs>(args: Subset<T, UserPackageOptionAggregateArgs>): Prisma.PrismaPromise<GetUserPackageOptionAggregateType<T>>

    /**
     * Group by UserPackageOption.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOptionGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserPackageOptionGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserPackageOptionGroupByArgs['orderBy'] }
        : { orderBy?: UserPackageOptionGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserPackageOptionGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserPackageOptionGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the UserPackageOption model
   */
  readonly fields: UserPackageOptionFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for UserPackageOption.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserPackageOptionClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    transportations<T extends UserPackageOption$transportationsArgs<ExtArgs> = {}>(args?: Subset<T, UserPackageOption$transportationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "findMany"> | Null>
    flights<T extends UserPackageOption$flightsArgs<ExtArgs> = {}>(args?: Subset<T, UserPackageOption$flightsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "findMany"> | Null>
    hotelMekkahs<T extends UserPackageOption$hotelMekkahsArgs<ExtArgs> = {}>(args?: Subset<T, UserPackageOption$hotelMekkahsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "findMany"> | Null>
    hotelMadinahs<T extends UserPackageOption$hotelMadinahsArgs<ExtArgs> = {}>(args?: Subset<T, UserPackageOption$hotelMadinahsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "findMany"> | Null>
    muthawifs<T extends UserPackageOption$muthawifsArgs<ExtArgs> = {}>(args?: Subset<T, UserPackageOption$muthawifsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "findMany"> | Null>
    handlings<T extends UserPackageOption$handlingsArgs<ExtArgs> = {}>(args?: Subset<T, UserPackageOption$handlingsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "findMany"> | Null>
    PackageType<T extends PackageTypeDefaultArgs<ExtArgs> = {}>(args?: Subset<T, PackageTypeDefaultArgs<ExtArgs>>): Prisma__PackageTypeClient<$Result.GetResult<Prisma.$PackageTypePayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the UserPackageOption model
   */ 
  interface UserPackageOptionFieldRefs {
    readonly id: FieldRef<"UserPackageOption", 'String'>
    readonly package_type_id: FieldRef<"UserPackageOption", 'String'>
    readonly name: FieldRef<"UserPackageOption", 'String'>
    readonly price: FieldRef<"UserPackageOption", 'Decimal'>
    readonly order_number: FieldRef<"UserPackageOption", 'Int'>
    readonly created_at: FieldRef<"UserPackageOption", 'DateTime'>
    readonly updated_at: FieldRef<"UserPackageOption", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * UserPackageOption findUnique
   */
  export type UserPackageOptionFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    /**
     * Filter, which UserPackageOption to fetch.
     */
    where: UserPackageOptionWhereUniqueInput
  }

  /**
   * UserPackageOption findUniqueOrThrow
   */
  export type UserPackageOptionFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    /**
     * Filter, which UserPackageOption to fetch.
     */
    where: UserPackageOptionWhereUniqueInput
  }

  /**
   * UserPackageOption findFirst
   */
  export type UserPackageOptionFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    /**
     * Filter, which UserPackageOption to fetch.
     */
    where?: UserPackageOptionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPackageOptions to fetch.
     */
    orderBy?: UserPackageOptionOrderByWithRelationInput | UserPackageOptionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserPackageOptions.
     */
    cursor?: UserPackageOptionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPackageOptions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPackageOptions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserPackageOptions.
     */
    distinct?: UserPackageOptionScalarFieldEnum | UserPackageOptionScalarFieldEnum[]
  }

  /**
   * UserPackageOption findFirstOrThrow
   */
  export type UserPackageOptionFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    /**
     * Filter, which UserPackageOption to fetch.
     */
    where?: UserPackageOptionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPackageOptions to fetch.
     */
    orderBy?: UserPackageOptionOrderByWithRelationInput | UserPackageOptionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserPackageOptions.
     */
    cursor?: UserPackageOptionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPackageOptions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPackageOptions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserPackageOptions.
     */
    distinct?: UserPackageOptionScalarFieldEnum | UserPackageOptionScalarFieldEnum[]
  }

  /**
   * UserPackageOption findMany
   */
  export type UserPackageOptionFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    /**
     * Filter, which UserPackageOptions to fetch.
     */
    where?: UserPackageOptionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPackageOptions to fetch.
     */
    orderBy?: UserPackageOptionOrderByWithRelationInput | UserPackageOptionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserPackageOptions.
     */
    cursor?: UserPackageOptionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPackageOptions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPackageOptions.
     */
    skip?: number
    distinct?: UserPackageOptionScalarFieldEnum | UserPackageOptionScalarFieldEnum[]
  }

  /**
   * UserPackageOption create
   */
  export type UserPackageOptionCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    /**
     * The data needed to create a UserPackageOption.
     */
    data: XOR<UserPackageOptionCreateInput, UserPackageOptionUncheckedCreateInput>
  }

  /**
   * UserPackageOption createMany
   */
  export type UserPackageOptionCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many UserPackageOptions.
     */
    data: UserPackageOptionCreateManyInput | UserPackageOptionCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * UserPackageOption update
   */
  export type UserPackageOptionUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    /**
     * The data needed to update a UserPackageOption.
     */
    data: XOR<UserPackageOptionUpdateInput, UserPackageOptionUncheckedUpdateInput>
    /**
     * Choose, which UserPackageOption to update.
     */
    where: UserPackageOptionWhereUniqueInput
  }

  /**
   * UserPackageOption updateMany
   */
  export type UserPackageOptionUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update UserPackageOptions.
     */
    data: XOR<UserPackageOptionUpdateManyMutationInput, UserPackageOptionUncheckedUpdateManyInput>
    /**
     * Filter which UserPackageOptions to update
     */
    where?: UserPackageOptionWhereInput
  }

  /**
   * UserPackageOption upsert
   */
  export type UserPackageOptionUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    /**
     * The filter to search for the UserPackageOption to update in case it exists.
     */
    where: UserPackageOptionWhereUniqueInput
    /**
     * In case the UserPackageOption found by the `where` argument doesn't exist, create a new UserPackageOption with this data.
     */
    create: XOR<UserPackageOptionCreateInput, UserPackageOptionUncheckedCreateInput>
    /**
     * In case the UserPackageOption was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserPackageOptionUpdateInput, UserPackageOptionUncheckedUpdateInput>
  }

  /**
   * UserPackageOption delete
   */
  export type UserPackageOptionDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
    /**
     * Filter which UserPackageOption to delete.
     */
    where: UserPackageOptionWhereUniqueInput
  }

  /**
   * UserPackageOption deleteMany
   */
  export type UserPackageOptionDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserPackageOptions to delete
     */
    where?: UserPackageOptionWhereInput
  }

  /**
   * UserPackageOption.transportations
   */
  export type UserPackageOption$transportationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    where?: UserPackageWhereInput
    orderBy?: UserPackageOrderByWithRelationInput | UserPackageOrderByWithRelationInput[]
    cursor?: UserPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserPackageScalarFieldEnum | UserPackageScalarFieldEnum[]
  }

  /**
   * UserPackageOption.flights
   */
  export type UserPackageOption$flightsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    where?: UserPackageWhereInput
    orderBy?: UserPackageOrderByWithRelationInput | UserPackageOrderByWithRelationInput[]
    cursor?: UserPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserPackageScalarFieldEnum | UserPackageScalarFieldEnum[]
  }

  /**
   * UserPackageOption.hotelMekkahs
   */
  export type UserPackageOption$hotelMekkahsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    where?: UserPackageWhereInput
    orderBy?: UserPackageOrderByWithRelationInput | UserPackageOrderByWithRelationInput[]
    cursor?: UserPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserPackageScalarFieldEnum | UserPackageScalarFieldEnum[]
  }

  /**
   * UserPackageOption.hotelMadinahs
   */
  export type UserPackageOption$hotelMadinahsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    where?: UserPackageWhereInput
    orderBy?: UserPackageOrderByWithRelationInput | UserPackageOrderByWithRelationInput[]
    cursor?: UserPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserPackageScalarFieldEnum | UserPackageScalarFieldEnum[]
  }

  /**
   * UserPackageOption.muthawifs
   */
  export type UserPackageOption$muthawifsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    where?: UserPackageWhereInput
    orderBy?: UserPackageOrderByWithRelationInput | UserPackageOrderByWithRelationInput[]
    cursor?: UserPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserPackageScalarFieldEnum | UserPackageScalarFieldEnum[]
  }

  /**
   * UserPackageOption.handlings
   */
  export type UserPackageOption$handlingsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackage
     */
    select?: UserPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageInclude<ExtArgs> | null
    where?: UserPackageWhereInput
    orderBy?: UserPackageOrderByWithRelationInput | UserPackageOrderByWithRelationInput[]
    cursor?: UserPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserPackageScalarFieldEnum | UserPackageScalarFieldEnum[]
  }

  /**
   * UserPackageOption without action
   */
  export type UserPackageOptionDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOption
     */
    select?: UserPackageOptionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOptionInclude<ExtArgs> | null
  }


  /**
   * Model UserPackageOrder
   */

  export type AggregateUserPackageOrder = {
    _count: UserPackageOrderCountAggregateOutputType | null
    _min: UserPackageOrderMinAggregateOutputType | null
    _max: UserPackageOrderMaxAggregateOutputType | null
  }

  export type UserPackageOrderMinAggregateOutputType = {
    id: string | null
    full_name: string | null
    email: string | null
    whatsapp_number: string | null
    user_package_id: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type UserPackageOrderMaxAggregateOutputType = {
    id: string | null
    full_name: string | null
    email: string | null
    whatsapp_number: string | null
    user_package_id: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type UserPackageOrderCountAggregateOutputType = {
    id: number
    full_name: number
    email: number
    whatsapp_number: number
    user_package_id: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type UserPackageOrderMinAggregateInputType = {
    id?: true
    full_name?: true
    email?: true
    whatsapp_number?: true
    user_package_id?: true
    created_at?: true
    updated_at?: true
  }

  export type UserPackageOrderMaxAggregateInputType = {
    id?: true
    full_name?: true
    email?: true
    whatsapp_number?: true
    user_package_id?: true
    created_at?: true
    updated_at?: true
  }

  export type UserPackageOrderCountAggregateInputType = {
    id?: true
    full_name?: true
    email?: true
    whatsapp_number?: true
    user_package_id?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type UserPackageOrderAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserPackageOrder to aggregate.
     */
    where?: UserPackageOrderWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPackageOrders to fetch.
     */
    orderBy?: UserPackageOrderOrderByWithRelationInput | UserPackageOrderOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserPackageOrderWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPackageOrders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPackageOrders.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserPackageOrders
    **/
    _count?: true | UserPackageOrderCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserPackageOrderMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserPackageOrderMaxAggregateInputType
  }

  export type GetUserPackageOrderAggregateType<T extends UserPackageOrderAggregateArgs> = {
        [P in keyof T & keyof AggregateUserPackageOrder]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserPackageOrder[P]>
      : GetScalarType<T[P], AggregateUserPackageOrder[P]>
  }




  export type UserPackageOrderGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPackageOrderWhereInput
    orderBy?: UserPackageOrderOrderByWithAggregationInput | UserPackageOrderOrderByWithAggregationInput[]
    by: UserPackageOrderScalarFieldEnum[] | UserPackageOrderScalarFieldEnum
    having?: UserPackageOrderScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserPackageOrderCountAggregateInputType | true
    _min?: UserPackageOrderMinAggregateInputType
    _max?: UserPackageOrderMaxAggregateInputType
  }

  export type UserPackageOrderGroupByOutputType = {
    id: string
    full_name: string
    email: string
    whatsapp_number: string
    user_package_id: string
    created_at: Date
    updated_at: Date
    _count: UserPackageOrderCountAggregateOutputType | null
    _min: UserPackageOrderMinAggregateOutputType | null
    _max: UserPackageOrderMaxAggregateOutputType | null
  }

  type GetUserPackageOrderGroupByPayload<T extends UserPackageOrderGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserPackageOrderGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserPackageOrderGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserPackageOrderGroupByOutputType[P]>
            : GetScalarType<T[P], UserPackageOrderGroupByOutputType[P]>
        }
      >
    >


  export type UserPackageOrderSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    full_name?: boolean
    email?: boolean
    whatsapp_number?: boolean
    user_package_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    UserPackage?: boolean | UserPackageDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userPackageOrder"]>


  export type UserPackageOrderSelectScalar = {
    id?: boolean
    full_name?: boolean
    email?: boolean
    whatsapp_number?: boolean
    user_package_id?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type UserPackageOrderInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    UserPackage?: boolean | UserPackageDefaultArgs<ExtArgs>
  }

  export type $UserPackageOrderPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "UserPackageOrder"
    objects: {
      UserPackage: Prisma.$UserPackagePayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      full_name: string
      email: string
      whatsapp_number: string
      user_package_id: string
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["userPackageOrder"]>
    composites: {}
  }

  type UserPackageOrderGetPayload<S extends boolean | null | undefined | UserPackageOrderDefaultArgs> = $Result.GetResult<Prisma.$UserPackageOrderPayload, S>

  type UserPackageOrderCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UserPackageOrderFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: UserPackageOrderCountAggregateInputType | true
    }

  export interface UserPackageOrderDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['UserPackageOrder'], meta: { name: 'UserPackageOrder' } }
    /**
     * Find zero or one UserPackageOrder that matches the filter.
     * @param {UserPackageOrderFindUniqueArgs} args - Arguments to find a UserPackageOrder
     * @example
     * // Get one UserPackageOrder
     * const userPackageOrder = await prisma.userPackageOrder.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends UserPackageOrderFindUniqueArgs>(args: SelectSubset<T, UserPackageOrderFindUniqueArgs<ExtArgs>>): Prisma__UserPackageOrderClient<$Result.GetResult<Prisma.$UserPackageOrderPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one UserPackageOrder that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {UserPackageOrderFindUniqueOrThrowArgs} args - Arguments to find a UserPackageOrder
     * @example
     * // Get one UserPackageOrder
     * const userPackageOrder = await prisma.userPackageOrder.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends UserPackageOrderFindUniqueOrThrowArgs>(args: SelectSubset<T, UserPackageOrderFindUniqueOrThrowArgs<ExtArgs>>): Prisma__UserPackageOrderClient<$Result.GetResult<Prisma.$UserPackageOrderPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first UserPackageOrder that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOrderFindFirstArgs} args - Arguments to find a UserPackageOrder
     * @example
     * // Get one UserPackageOrder
     * const userPackageOrder = await prisma.userPackageOrder.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends UserPackageOrderFindFirstArgs>(args?: SelectSubset<T, UserPackageOrderFindFirstArgs<ExtArgs>>): Prisma__UserPackageOrderClient<$Result.GetResult<Prisma.$UserPackageOrderPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first UserPackageOrder that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOrderFindFirstOrThrowArgs} args - Arguments to find a UserPackageOrder
     * @example
     * // Get one UserPackageOrder
     * const userPackageOrder = await prisma.userPackageOrder.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends UserPackageOrderFindFirstOrThrowArgs>(args?: SelectSubset<T, UserPackageOrderFindFirstOrThrowArgs<ExtArgs>>): Prisma__UserPackageOrderClient<$Result.GetResult<Prisma.$UserPackageOrderPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more UserPackageOrders that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOrderFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserPackageOrders
     * const userPackageOrders = await prisma.userPackageOrder.findMany()
     * 
     * // Get first 10 UserPackageOrders
     * const userPackageOrders = await prisma.userPackageOrder.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userPackageOrderWithIdOnly = await prisma.userPackageOrder.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends UserPackageOrderFindManyArgs>(args?: SelectSubset<T, UserPackageOrderFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPackageOrderPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a UserPackageOrder.
     * @param {UserPackageOrderCreateArgs} args - Arguments to create a UserPackageOrder.
     * @example
     * // Create one UserPackageOrder
     * const UserPackageOrder = await prisma.userPackageOrder.create({
     *   data: {
     *     // ... data to create a UserPackageOrder
     *   }
     * })
     * 
     */
    create<T extends UserPackageOrderCreateArgs>(args: SelectSubset<T, UserPackageOrderCreateArgs<ExtArgs>>): Prisma__UserPackageOrderClient<$Result.GetResult<Prisma.$UserPackageOrderPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many UserPackageOrders.
     * @param {UserPackageOrderCreateManyArgs} args - Arguments to create many UserPackageOrders.
     * @example
     * // Create many UserPackageOrders
     * const userPackageOrder = await prisma.userPackageOrder.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends UserPackageOrderCreateManyArgs>(args?: SelectSubset<T, UserPackageOrderCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a UserPackageOrder.
     * @param {UserPackageOrderDeleteArgs} args - Arguments to delete one UserPackageOrder.
     * @example
     * // Delete one UserPackageOrder
     * const UserPackageOrder = await prisma.userPackageOrder.delete({
     *   where: {
     *     // ... filter to delete one UserPackageOrder
     *   }
     * })
     * 
     */
    delete<T extends UserPackageOrderDeleteArgs>(args: SelectSubset<T, UserPackageOrderDeleteArgs<ExtArgs>>): Prisma__UserPackageOrderClient<$Result.GetResult<Prisma.$UserPackageOrderPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one UserPackageOrder.
     * @param {UserPackageOrderUpdateArgs} args - Arguments to update one UserPackageOrder.
     * @example
     * // Update one UserPackageOrder
     * const userPackageOrder = await prisma.userPackageOrder.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends UserPackageOrderUpdateArgs>(args: SelectSubset<T, UserPackageOrderUpdateArgs<ExtArgs>>): Prisma__UserPackageOrderClient<$Result.GetResult<Prisma.$UserPackageOrderPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more UserPackageOrders.
     * @param {UserPackageOrderDeleteManyArgs} args - Arguments to filter UserPackageOrders to delete.
     * @example
     * // Delete a few UserPackageOrders
     * const { count } = await prisma.userPackageOrder.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends UserPackageOrderDeleteManyArgs>(args?: SelectSubset<T, UserPackageOrderDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserPackageOrders.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOrderUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserPackageOrders
     * const userPackageOrder = await prisma.userPackageOrder.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends UserPackageOrderUpdateManyArgs>(args: SelectSubset<T, UserPackageOrderUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one UserPackageOrder.
     * @param {UserPackageOrderUpsertArgs} args - Arguments to update or create a UserPackageOrder.
     * @example
     * // Update or create a UserPackageOrder
     * const userPackageOrder = await prisma.userPackageOrder.upsert({
     *   create: {
     *     // ... data to create a UserPackageOrder
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserPackageOrder we want to update
     *   }
     * })
     */
    upsert<T extends UserPackageOrderUpsertArgs>(args: SelectSubset<T, UserPackageOrderUpsertArgs<ExtArgs>>): Prisma__UserPackageOrderClient<$Result.GetResult<Prisma.$UserPackageOrderPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of UserPackageOrders.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOrderCountArgs} args - Arguments to filter UserPackageOrders to count.
     * @example
     * // Count the number of UserPackageOrders
     * const count = await prisma.userPackageOrder.count({
     *   where: {
     *     // ... the filter for the UserPackageOrders we want to count
     *   }
     * })
    **/
    count<T extends UserPackageOrderCountArgs>(
      args?: Subset<T, UserPackageOrderCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserPackageOrderCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserPackageOrder.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOrderAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserPackageOrderAggregateArgs>(args: Subset<T, UserPackageOrderAggregateArgs>): Prisma.PrismaPromise<GetUserPackageOrderAggregateType<T>>

    /**
     * Group by UserPackageOrder.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPackageOrderGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserPackageOrderGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserPackageOrderGroupByArgs['orderBy'] }
        : { orderBy?: UserPackageOrderGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserPackageOrderGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserPackageOrderGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the UserPackageOrder model
   */
  readonly fields: UserPackageOrderFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for UserPackageOrder.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserPackageOrderClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    UserPackage<T extends UserPackageDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserPackageDefaultArgs<ExtArgs>>): Prisma__UserPackageClient<$Result.GetResult<Prisma.$UserPackagePayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the UserPackageOrder model
   */ 
  interface UserPackageOrderFieldRefs {
    readonly id: FieldRef<"UserPackageOrder", 'String'>
    readonly full_name: FieldRef<"UserPackageOrder", 'String'>
    readonly email: FieldRef<"UserPackageOrder", 'String'>
    readonly whatsapp_number: FieldRef<"UserPackageOrder", 'String'>
    readonly user_package_id: FieldRef<"UserPackageOrder", 'String'>
    readonly created_at: FieldRef<"UserPackageOrder", 'DateTime'>
    readonly updated_at: FieldRef<"UserPackageOrder", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * UserPackageOrder findUnique
   */
  export type UserPackageOrderFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOrder
     */
    select?: UserPackageOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOrderInclude<ExtArgs> | null
    /**
     * Filter, which UserPackageOrder to fetch.
     */
    where: UserPackageOrderWhereUniqueInput
  }

  /**
   * UserPackageOrder findUniqueOrThrow
   */
  export type UserPackageOrderFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOrder
     */
    select?: UserPackageOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOrderInclude<ExtArgs> | null
    /**
     * Filter, which UserPackageOrder to fetch.
     */
    where: UserPackageOrderWhereUniqueInput
  }

  /**
   * UserPackageOrder findFirst
   */
  export type UserPackageOrderFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOrder
     */
    select?: UserPackageOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOrderInclude<ExtArgs> | null
    /**
     * Filter, which UserPackageOrder to fetch.
     */
    where?: UserPackageOrderWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPackageOrders to fetch.
     */
    orderBy?: UserPackageOrderOrderByWithRelationInput | UserPackageOrderOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserPackageOrders.
     */
    cursor?: UserPackageOrderWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPackageOrders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPackageOrders.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserPackageOrders.
     */
    distinct?: UserPackageOrderScalarFieldEnum | UserPackageOrderScalarFieldEnum[]
  }

  /**
   * UserPackageOrder findFirstOrThrow
   */
  export type UserPackageOrderFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOrder
     */
    select?: UserPackageOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOrderInclude<ExtArgs> | null
    /**
     * Filter, which UserPackageOrder to fetch.
     */
    where?: UserPackageOrderWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPackageOrders to fetch.
     */
    orderBy?: UserPackageOrderOrderByWithRelationInput | UserPackageOrderOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserPackageOrders.
     */
    cursor?: UserPackageOrderWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPackageOrders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPackageOrders.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserPackageOrders.
     */
    distinct?: UserPackageOrderScalarFieldEnum | UserPackageOrderScalarFieldEnum[]
  }

  /**
   * UserPackageOrder findMany
   */
  export type UserPackageOrderFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOrder
     */
    select?: UserPackageOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOrderInclude<ExtArgs> | null
    /**
     * Filter, which UserPackageOrders to fetch.
     */
    where?: UserPackageOrderWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPackageOrders to fetch.
     */
    orderBy?: UserPackageOrderOrderByWithRelationInput | UserPackageOrderOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserPackageOrders.
     */
    cursor?: UserPackageOrderWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPackageOrders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPackageOrders.
     */
    skip?: number
    distinct?: UserPackageOrderScalarFieldEnum | UserPackageOrderScalarFieldEnum[]
  }

  /**
   * UserPackageOrder create
   */
  export type UserPackageOrderCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOrder
     */
    select?: UserPackageOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOrderInclude<ExtArgs> | null
    /**
     * The data needed to create a UserPackageOrder.
     */
    data: XOR<UserPackageOrderCreateInput, UserPackageOrderUncheckedCreateInput>
  }

  /**
   * UserPackageOrder createMany
   */
  export type UserPackageOrderCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many UserPackageOrders.
     */
    data: UserPackageOrderCreateManyInput | UserPackageOrderCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * UserPackageOrder update
   */
  export type UserPackageOrderUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOrder
     */
    select?: UserPackageOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOrderInclude<ExtArgs> | null
    /**
     * The data needed to update a UserPackageOrder.
     */
    data: XOR<UserPackageOrderUpdateInput, UserPackageOrderUncheckedUpdateInput>
    /**
     * Choose, which UserPackageOrder to update.
     */
    where: UserPackageOrderWhereUniqueInput
  }

  /**
   * UserPackageOrder updateMany
   */
  export type UserPackageOrderUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update UserPackageOrders.
     */
    data: XOR<UserPackageOrderUpdateManyMutationInput, UserPackageOrderUncheckedUpdateManyInput>
    /**
     * Filter which UserPackageOrders to update
     */
    where?: UserPackageOrderWhereInput
  }

  /**
   * UserPackageOrder upsert
   */
  export type UserPackageOrderUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOrder
     */
    select?: UserPackageOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOrderInclude<ExtArgs> | null
    /**
     * The filter to search for the UserPackageOrder to update in case it exists.
     */
    where: UserPackageOrderWhereUniqueInput
    /**
     * In case the UserPackageOrder found by the `where` argument doesn't exist, create a new UserPackageOrder with this data.
     */
    create: XOR<UserPackageOrderCreateInput, UserPackageOrderUncheckedCreateInput>
    /**
     * In case the UserPackageOrder was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserPackageOrderUpdateInput, UserPackageOrderUncheckedUpdateInput>
  }

  /**
   * UserPackageOrder delete
   */
  export type UserPackageOrderDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOrder
     */
    select?: UserPackageOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOrderInclude<ExtArgs> | null
    /**
     * Filter which UserPackageOrder to delete.
     */
    where: UserPackageOrderWhereUniqueInput
  }

  /**
   * UserPackageOrder deleteMany
   */
  export type UserPackageOrderDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserPackageOrders to delete
     */
    where?: UserPackageOrderWhereInput
  }

  /**
   * UserPackageOrder without action
   */
  export type UserPackageOrderDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPackageOrder
     */
    select?: UserPackageOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPackageOrderInclude<ExtArgs> | null
  }


  /**
   * Model Category
   */

  export type AggregateCategory = {
    _count: CategoryCountAggregateOutputType | null
    _min: CategoryMinAggregateOutputType | null
    _max: CategoryMaxAggregateOutputType | null
  }

  export type CategoryMinAggregateOutputType = {
    id: string | null
    name: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type CategoryMaxAggregateOutputType = {
    id: string | null
    name: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type CategoryCountAggregateOutputType = {
    id: number
    name: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type CategoryMinAggregateInputType = {
    id?: true
    name?: true
    created_at?: true
    updated_at?: true
  }

  export type CategoryMaxAggregateInputType = {
    id?: true
    name?: true
    created_at?: true
    updated_at?: true
  }

  export type CategoryCountAggregateInputType = {
    id?: true
    name?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type CategoryAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Category to aggregate.
     */
    where?: CategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categories to fetch.
     */
    orderBy?: CategoryOrderByWithRelationInput | CategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: CategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Categories
    **/
    _count?: true | CategoryCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: CategoryMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: CategoryMaxAggregateInputType
  }

  export type GetCategoryAggregateType<T extends CategoryAggregateArgs> = {
        [P in keyof T & keyof AggregateCategory]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateCategory[P]>
      : GetScalarType<T[P], AggregateCategory[P]>
  }




  export type CategoryGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoryWhereInput
    orderBy?: CategoryOrderByWithAggregationInput | CategoryOrderByWithAggregationInput[]
    by: CategoryScalarFieldEnum[] | CategoryScalarFieldEnum
    having?: CategoryScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: CategoryCountAggregateInputType | true
    _min?: CategoryMinAggregateInputType
    _max?: CategoryMaxAggregateInputType
  }

  export type CategoryGroupByOutputType = {
    id: string
    name: string
    created_at: Date
    updated_at: Date
    _count: CategoryCountAggregateOutputType | null
    _min: CategoryMinAggregateOutputType | null
    _max: CategoryMaxAggregateOutputType | null
  }

  type GetCategoryGroupByPayload<T extends CategoryGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<CategoryGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof CategoryGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], CategoryGroupByOutputType[P]>
            : GetScalarType<T[P], CategoryGroupByOutputType[P]>
        }
      >
    >


  export type CategorySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    created_at?: boolean
    updated_at?: boolean
    ProductCategories?: boolean | Category$ProductCategoriesArgs<ExtArgs>
    _count?: boolean | CategoryCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["category"]>


  export type CategorySelectScalar = {
    id?: boolean
    name?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type CategoryInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ProductCategories?: boolean | Category$ProductCategoriesArgs<ExtArgs>
    _count?: boolean | CategoryCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $CategoryPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Category"
    objects: {
      ProductCategories: Prisma.$ProductCategoryPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["category"]>
    composites: {}
  }

  type CategoryGetPayload<S extends boolean | null | undefined | CategoryDefaultArgs> = $Result.GetResult<Prisma.$CategoryPayload, S>

  type CategoryCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<CategoryFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: CategoryCountAggregateInputType | true
    }

  export interface CategoryDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Category'], meta: { name: 'Category' } }
    /**
     * Find zero or one Category that matches the filter.
     * @param {CategoryFindUniqueArgs} args - Arguments to find a Category
     * @example
     * // Get one Category
     * const category = await prisma.category.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends CategoryFindUniqueArgs>(args: SelectSubset<T, CategoryFindUniqueArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Category that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {CategoryFindUniqueOrThrowArgs} args - Arguments to find a Category
     * @example
     * // Get one Category
     * const category = await prisma.category.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends CategoryFindUniqueOrThrowArgs>(args: SelectSubset<T, CategoryFindUniqueOrThrowArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Category that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryFindFirstArgs} args - Arguments to find a Category
     * @example
     * // Get one Category
     * const category = await prisma.category.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends CategoryFindFirstArgs>(args?: SelectSubset<T, CategoryFindFirstArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Category that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryFindFirstOrThrowArgs} args - Arguments to find a Category
     * @example
     * // Get one Category
     * const category = await prisma.category.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends CategoryFindFirstOrThrowArgs>(args?: SelectSubset<T, CategoryFindFirstOrThrowArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Categories that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Categories
     * const categories = await prisma.category.findMany()
     * 
     * // Get first 10 Categories
     * const categories = await prisma.category.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const categoryWithIdOnly = await prisma.category.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends CategoryFindManyArgs>(args?: SelectSubset<T, CategoryFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Category.
     * @param {CategoryCreateArgs} args - Arguments to create a Category.
     * @example
     * // Create one Category
     * const Category = await prisma.category.create({
     *   data: {
     *     // ... data to create a Category
     *   }
     * })
     * 
     */
    create<T extends CategoryCreateArgs>(args: SelectSubset<T, CategoryCreateArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Categories.
     * @param {CategoryCreateManyArgs} args - Arguments to create many Categories.
     * @example
     * // Create many Categories
     * const category = await prisma.category.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends CategoryCreateManyArgs>(args?: SelectSubset<T, CategoryCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Category.
     * @param {CategoryDeleteArgs} args - Arguments to delete one Category.
     * @example
     * // Delete one Category
     * const Category = await prisma.category.delete({
     *   where: {
     *     // ... filter to delete one Category
     *   }
     * })
     * 
     */
    delete<T extends CategoryDeleteArgs>(args: SelectSubset<T, CategoryDeleteArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Category.
     * @param {CategoryUpdateArgs} args - Arguments to update one Category.
     * @example
     * // Update one Category
     * const category = await prisma.category.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends CategoryUpdateArgs>(args: SelectSubset<T, CategoryUpdateArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Categories.
     * @param {CategoryDeleteManyArgs} args - Arguments to filter Categories to delete.
     * @example
     * // Delete a few Categories
     * const { count } = await prisma.category.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends CategoryDeleteManyArgs>(args?: SelectSubset<T, CategoryDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Categories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Categories
     * const category = await prisma.category.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends CategoryUpdateManyArgs>(args: SelectSubset<T, CategoryUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Category.
     * @param {CategoryUpsertArgs} args - Arguments to update or create a Category.
     * @example
     * // Update or create a Category
     * const category = await prisma.category.upsert({
     *   create: {
     *     // ... data to create a Category
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Category we want to update
     *   }
     * })
     */
    upsert<T extends CategoryUpsertArgs>(args: SelectSubset<T, CategoryUpsertArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Categories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryCountArgs} args - Arguments to filter Categories to count.
     * @example
     * // Count the number of Categories
     * const count = await prisma.category.count({
     *   where: {
     *     // ... the filter for the Categories we want to count
     *   }
     * })
    **/
    count<T extends CategoryCountArgs>(
      args?: Subset<T, CategoryCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], CategoryCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Category.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends CategoryAggregateArgs>(args: Subset<T, CategoryAggregateArgs>): Prisma.PrismaPromise<GetCategoryAggregateType<T>>

    /**
     * Group by Category.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends CategoryGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: CategoryGroupByArgs['orderBy'] }
        : { orderBy?: CategoryGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, CategoryGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetCategoryGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Category model
   */
  readonly fields: CategoryFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Category.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__CategoryClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    ProductCategories<T extends Category$ProductCategoriesArgs<ExtArgs> = {}>(args?: Subset<T, Category$ProductCategoriesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductCategoryPayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Category model
   */ 
  interface CategoryFieldRefs {
    readonly id: FieldRef<"Category", 'String'>
    readonly name: FieldRef<"Category", 'String'>
    readonly created_at: FieldRef<"Category", 'DateTime'>
    readonly updated_at: FieldRef<"Category", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Category findUnique
   */
  export type CategoryFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * Filter, which Category to fetch.
     */
    where: CategoryWhereUniqueInput
  }

  /**
   * Category findUniqueOrThrow
   */
  export type CategoryFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * Filter, which Category to fetch.
     */
    where: CategoryWhereUniqueInput
  }

  /**
   * Category findFirst
   */
  export type CategoryFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * Filter, which Category to fetch.
     */
    where?: CategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categories to fetch.
     */
    orderBy?: CategoryOrderByWithRelationInput | CategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Categories.
     */
    cursor?: CategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Categories.
     */
    distinct?: CategoryScalarFieldEnum | CategoryScalarFieldEnum[]
  }

  /**
   * Category findFirstOrThrow
   */
  export type CategoryFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * Filter, which Category to fetch.
     */
    where?: CategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categories to fetch.
     */
    orderBy?: CategoryOrderByWithRelationInput | CategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Categories.
     */
    cursor?: CategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Categories.
     */
    distinct?: CategoryScalarFieldEnum | CategoryScalarFieldEnum[]
  }

  /**
   * Category findMany
   */
  export type CategoryFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * Filter, which Categories to fetch.
     */
    where?: CategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categories to fetch.
     */
    orderBy?: CategoryOrderByWithRelationInput | CategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Categories.
     */
    cursor?: CategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categories.
     */
    skip?: number
    distinct?: CategoryScalarFieldEnum | CategoryScalarFieldEnum[]
  }

  /**
   * Category create
   */
  export type CategoryCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * The data needed to create a Category.
     */
    data: XOR<CategoryCreateInput, CategoryUncheckedCreateInput>
  }

  /**
   * Category createMany
   */
  export type CategoryCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Categories.
     */
    data: CategoryCreateManyInput | CategoryCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Category update
   */
  export type CategoryUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * The data needed to update a Category.
     */
    data: XOR<CategoryUpdateInput, CategoryUncheckedUpdateInput>
    /**
     * Choose, which Category to update.
     */
    where: CategoryWhereUniqueInput
  }

  /**
   * Category updateMany
   */
  export type CategoryUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Categories.
     */
    data: XOR<CategoryUpdateManyMutationInput, CategoryUncheckedUpdateManyInput>
    /**
     * Filter which Categories to update
     */
    where?: CategoryWhereInput
  }

  /**
   * Category upsert
   */
  export type CategoryUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * The filter to search for the Category to update in case it exists.
     */
    where: CategoryWhereUniqueInput
    /**
     * In case the Category found by the `where` argument doesn't exist, create a new Category with this data.
     */
    create: XOR<CategoryCreateInput, CategoryUncheckedCreateInput>
    /**
     * In case the Category was found with the provided `where` argument, update it with this data.
     */
    update: XOR<CategoryUpdateInput, CategoryUncheckedUpdateInput>
  }

  /**
   * Category delete
   */
  export type CategoryDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * Filter which Category to delete.
     */
    where: CategoryWhereUniqueInput
  }

  /**
   * Category deleteMany
   */
  export type CategoryDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Categories to delete
     */
    where?: CategoryWhereInput
  }

  /**
   * Category.ProductCategories
   */
  export type Category$ProductCategoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductCategory
     */
    select?: ProductCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductCategoryInclude<ExtArgs> | null
    where?: ProductCategoryWhereInput
    orderBy?: ProductCategoryOrderByWithRelationInput | ProductCategoryOrderByWithRelationInput[]
    cursor?: ProductCategoryWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProductCategoryScalarFieldEnum | ProductCategoryScalarFieldEnum[]
  }

  /**
   * Category without action
   */
  export type CategoryDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
  }


  /**
   * Model Product
   */

  export type AggregateProduct = {
    _count: ProductCountAggregateOutputType | null
    _avg: ProductAvgAggregateOutputType | null
    _sum: ProductSumAggregateOutputType | null
    _min: ProductMinAggregateOutputType | null
    _max: ProductMaxAggregateOutputType | null
  }

  export type ProductAvgAggregateOutputType = {
    price: Decimal | null
  }

  export type ProductSumAggregateOutputType = {
    price: Decimal | null
  }

  export type ProductMinAggregateOutputType = {
    id: string | null
    name: string | null
    description: string | null
    price: Decimal | null
    has_variation: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type ProductMaxAggregateOutputType = {
    id: string | null
    name: string | null
    description: string | null
    price: Decimal | null
    has_variation: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type ProductCountAggregateOutputType = {
    id: number
    name: number
    description: number
    price: number
    has_variation: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type ProductAvgAggregateInputType = {
    price?: true
  }

  export type ProductSumAggregateInputType = {
    price?: true
  }

  export type ProductMinAggregateInputType = {
    id?: true
    name?: true
    description?: true
    price?: true
    has_variation?: true
    created_at?: true
    updated_at?: true
  }

  export type ProductMaxAggregateInputType = {
    id?: true
    name?: true
    description?: true
    price?: true
    has_variation?: true
    created_at?: true
    updated_at?: true
  }

  export type ProductCountAggregateInputType = {
    id?: true
    name?: true
    description?: true
    price?: true
    has_variation?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type ProductAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Product to aggregate.
     */
    where?: ProductWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Products to fetch.
     */
    orderBy?: ProductOrderByWithRelationInput | ProductOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProductWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Products from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Products.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Products
    **/
    _count?: true | ProductCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ProductAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ProductSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProductMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProductMaxAggregateInputType
  }

  export type GetProductAggregateType<T extends ProductAggregateArgs> = {
        [P in keyof T & keyof AggregateProduct]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProduct[P]>
      : GetScalarType<T[P], AggregateProduct[P]>
  }




  export type ProductGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductWhereInput
    orderBy?: ProductOrderByWithAggregationInput | ProductOrderByWithAggregationInput[]
    by: ProductScalarFieldEnum[] | ProductScalarFieldEnum
    having?: ProductScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProductCountAggregateInputType | true
    _avg?: ProductAvgAggregateInputType
    _sum?: ProductSumAggregateInputType
    _min?: ProductMinAggregateInputType
    _max?: ProductMaxAggregateInputType
  }

  export type ProductGroupByOutputType = {
    id: string
    name: string
    description: string | null
    price: Decimal
    has_variation: boolean
    created_at: Date
    updated_at: Date
    _count: ProductCountAggregateOutputType | null
    _avg: ProductAvgAggregateOutputType | null
    _sum: ProductSumAggregateOutputType | null
    _min: ProductMinAggregateOutputType | null
    _max: ProductMaxAggregateOutputType | null
  }

  type GetProductGroupByPayload<T extends ProductGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProductGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProductGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProductGroupByOutputType[P]>
            : GetScalarType<T[P], ProductGroupByOutputType[P]>
        }
      >
    >


  export type ProductSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    description?: boolean
    price?: boolean
    has_variation?: boolean
    created_at?: boolean
    updated_at?: boolean
    ProductThumbnails?: boolean | Product$ProductThumbnailsArgs<ExtArgs>
    ProductCategories?: boolean | Product$ProductCategoriesArgs<ExtArgs>
    ProductVariations?: boolean | Product$ProductVariationsArgs<ExtArgs>
    ProductIncludes?: boolean | Product$ProductIncludesArgs<ExtArgs>
    ProductExcludes?: boolean | Product$ProductExcludesArgs<ExtArgs>
    ProductOrders?: boolean | Product$ProductOrdersArgs<ExtArgs>
    _count?: boolean | ProductCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["product"]>


  export type ProductSelectScalar = {
    id?: boolean
    name?: boolean
    description?: boolean
    price?: boolean
    has_variation?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type ProductInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ProductThumbnails?: boolean | Product$ProductThumbnailsArgs<ExtArgs>
    ProductCategories?: boolean | Product$ProductCategoriesArgs<ExtArgs>
    ProductVariations?: boolean | Product$ProductVariationsArgs<ExtArgs>
    ProductIncludes?: boolean | Product$ProductIncludesArgs<ExtArgs>
    ProductExcludes?: boolean | Product$ProductExcludesArgs<ExtArgs>
    ProductOrders?: boolean | Product$ProductOrdersArgs<ExtArgs>
    _count?: boolean | ProductCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $ProductPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Product"
    objects: {
      ProductThumbnails: Prisma.$ProductThumbnailPayload<ExtArgs>[]
      ProductCategories: Prisma.$ProductCategoryPayload<ExtArgs>[]
      ProductVariations: Prisma.$ProductVariationPayload<ExtArgs>[]
      ProductIncludes: Prisma.$ProductIncludePayload<ExtArgs>[]
      ProductExcludes: Prisma.$ProductExcludePayload<ExtArgs>[]
      ProductOrders: Prisma.$ProductOrderPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      description: string | null
      price: Prisma.Decimal
      has_variation: boolean
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["product"]>
    composites: {}
  }

  type ProductGetPayload<S extends boolean | null | undefined | ProductDefaultArgs> = $Result.GetResult<Prisma.$ProductPayload, S>

  type ProductCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<ProductFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: ProductCountAggregateInputType | true
    }

  export interface ProductDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Product'], meta: { name: 'Product' } }
    /**
     * Find zero or one Product that matches the filter.
     * @param {ProductFindUniqueArgs} args - Arguments to find a Product
     * @example
     * // Get one Product
     * const product = await prisma.product.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProductFindUniqueArgs>(args: SelectSubset<T, ProductFindUniqueArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Product that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {ProductFindUniqueOrThrowArgs} args - Arguments to find a Product
     * @example
     * // Get one Product
     * const product = await prisma.product.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProductFindUniqueOrThrowArgs>(args: SelectSubset<T, ProductFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Product that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductFindFirstArgs} args - Arguments to find a Product
     * @example
     * // Get one Product
     * const product = await prisma.product.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProductFindFirstArgs>(args?: SelectSubset<T, ProductFindFirstArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Product that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductFindFirstOrThrowArgs} args - Arguments to find a Product
     * @example
     * // Get one Product
     * const product = await prisma.product.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProductFindFirstOrThrowArgs>(args?: SelectSubset<T, ProductFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Products that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Products
     * const products = await prisma.product.findMany()
     * 
     * // Get first 10 Products
     * const products = await prisma.product.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const productWithIdOnly = await prisma.product.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProductFindManyArgs>(args?: SelectSubset<T, ProductFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Product.
     * @param {ProductCreateArgs} args - Arguments to create a Product.
     * @example
     * // Create one Product
     * const Product = await prisma.product.create({
     *   data: {
     *     // ... data to create a Product
     *   }
     * })
     * 
     */
    create<T extends ProductCreateArgs>(args: SelectSubset<T, ProductCreateArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Products.
     * @param {ProductCreateManyArgs} args - Arguments to create many Products.
     * @example
     * // Create many Products
     * const product = await prisma.product.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProductCreateManyArgs>(args?: SelectSubset<T, ProductCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Product.
     * @param {ProductDeleteArgs} args - Arguments to delete one Product.
     * @example
     * // Delete one Product
     * const Product = await prisma.product.delete({
     *   where: {
     *     // ... filter to delete one Product
     *   }
     * })
     * 
     */
    delete<T extends ProductDeleteArgs>(args: SelectSubset<T, ProductDeleteArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Product.
     * @param {ProductUpdateArgs} args - Arguments to update one Product.
     * @example
     * // Update one Product
     * const product = await prisma.product.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProductUpdateArgs>(args: SelectSubset<T, ProductUpdateArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Products.
     * @param {ProductDeleteManyArgs} args - Arguments to filter Products to delete.
     * @example
     * // Delete a few Products
     * const { count } = await prisma.product.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProductDeleteManyArgs>(args?: SelectSubset<T, ProductDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Products.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Products
     * const product = await prisma.product.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProductUpdateManyArgs>(args: SelectSubset<T, ProductUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Product.
     * @param {ProductUpsertArgs} args - Arguments to update or create a Product.
     * @example
     * // Update or create a Product
     * const product = await prisma.product.upsert({
     *   create: {
     *     // ... data to create a Product
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Product we want to update
     *   }
     * })
     */
    upsert<T extends ProductUpsertArgs>(args: SelectSubset<T, ProductUpsertArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Products.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductCountArgs} args - Arguments to filter Products to count.
     * @example
     * // Count the number of Products
     * const count = await prisma.product.count({
     *   where: {
     *     // ... the filter for the Products we want to count
     *   }
     * })
    **/
    count<T extends ProductCountArgs>(
      args?: Subset<T, ProductCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProductCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Product.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProductAggregateArgs>(args: Subset<T, ProductAggregateArgs>): Prisma.PrismaPromise<GetProductAggregateType<T>>

    /**
     * Group by Product.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProductGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProductGroupByArgs['orderBy'] }
        : { orderBy?: ProductGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProductGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProductGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Product model
   */
  readonly fields: ProductFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Product.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProductClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    ProductThumbnails<T extends Product$ProductThumbnailsArgs<ExtArgs> = {}>(args?: Subset<T, Product$ProductThumbnailsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductThumbnailPayload<ExtArgs>, T, "findMany"> | Null>
    ProductCategories<T extends Product$ProductCategoriesArgs<ExtArgs> = {}>(args?: Subset<T, Product$ProductCategoriesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductCategoryPayload<ExtArgs>, T, "findMany"> | Null>
    ProductVariations<T extends Product$ProductVariationsArgs<ExtArgs> = {}>(args?: Subset<T, Product$ProductVariationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductVariationPayload<ExtArgs>, T, "findMany"> | Null>
    ProductIncludes<T extends Product$ProductIncludesArgs<ExtArgs> = {}>(args?: Subset<T, Product$ProductIncludesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductIncludePayload<ExtArgs>, T, "findMany"> | Null>
    ProductExcludes<T extends Product$ProductExcludesArgs<ExtArgs> = {}>(args?: Subset<T, Product$ProductExcludesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductExcludePayload<ExtArgs>, T, "findMany"> | Null>
    ProductOrders<T extends Product$ProductOrdersArgs<ExtArgs> = {}>(args?: Subset<T, Product$ProductOrdersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductOrderPayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Product model
   */ 
  interface ProductFieldRefs {
    readonly id: FieldRef<"Product", 'String'>
    readonly name: FieldRef<"Product", 'String'>
    readonly description: FieldRef<"Product", 'String'>
    readonly price: FieldRef<"Product", 'Decimal'>
    readonly has_variation: FieldRef<"Product", 'Boolean'>
    readonly created_at: FieldRef<"Product", 'DateTime'>
    readonly updated_at: FieldRef<"Product", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Product findUnique
   */
  export type ProductFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Product
     */
    select?: ProductSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductInclude<ExtArgs> | null
    /**
     * Filter, which Product to fetch.
     */
    where: ProductWhereUniqueInput
  }

  /**
   * Product findUniqueOrThrow
   */
  export type ProductFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Product
     */
    select?: ProductSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductInclude<ExtArgs> | null
    /**
     * Filter, which Product to fetch.
     */
    where: ProductWhereUniqueInput
  }

  /**
   * Product findFirst
   */
  export type ProductFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Product
     */
    select?: ProductSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductInclude<ExtArgs> | null
    /**
     * Filter, which Product to fetch.
     */
    where?: ProductWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Products to fetch.
     */
    orderBy?: ProductOrderByWithRelationInput | ProductOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Products.
     */
    cursor?: ProductWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Products from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Products.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Products.
     */
    distinct?: ProductScalarFieldEnum | ProductScalarFieldEnum[]
  }

  /**
   * Product findFirstOrThrow
   */
  export type ProductFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Product
     */
    select?: ProductSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductInclude<ExtArgs> | null
    /**
     * Filter, which Product to fetch.
     */
    where?: ProductWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Products to fetch.
     */
    orderBy?: ProductOrderByWithRelationInput | ProductOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Products.
     */
    cursor?: ProductWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Products from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Products.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Products.
     */
    distinct?: ProductScalarFieldEnum | ProductScalarFieldEnum[]
  }

  /**
   * Product findMany
   */
  export type ProductFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Product
     */
    select?: ProductSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductInclude<ExtArgs> | null
    /**
     * Filter, which Products to fetch.
     */
    where?: ProductWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Products to fetch.
     */
    orderBy?: ProductOrderByWithRelationInput | ProductOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Products.
     */
    cursor?: ProductWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Products from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Products.
     */
    skip?: number
    distinct?: ProductScalarFieldEnum | ProductScalarFieldEnum[]
  }

  /**
   * Product create
   */
  export type ProductCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Product
     */
    select?: ProductSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductInclude<ExtArgs> | null
    /**
     * The data needed to create a Product.
     */
    data: XOR<ProductCreateInput, ProductUncheckedCreateInput>
  }

  /**
   * Product createMany
   */
  export type ProductCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Products.
     */
    data: ProductCreateManyInput | ProductCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Product update
   */
  export type ProductUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Product
     */
    select?: ProductSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductInclude<ExtArgs> | null
    /**
     * The data needed to update a Product.
     */
    data: XOR<ProductUpdateInput, ProductUncheckedUpdateInput>
    /**
     * Choose, which Product to update.
     */
    where: ProductWhereUniqueInput
  }

  /**
   * Product updateMany
   */
  export type ProductUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Products.
     */
    data: XOR<ProductUpdateManyMutationInput, ProductUncheckedUpdateManyInput>
    /**
     * Filter which Products to update
     */
    where?: ProductWhereInput
  }

  /**
   * Product upsert
   */
  export type ProductUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Product
     */
    select?: ProductSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductInclude<ExtArgs> | null
    /**
     * The filter to search for the Product to update in case it exists.
     */
    where: ProductWhereUniqueInput
    /**
     * In case the Product found by the `where` argument doesn't exist, create a new Product with this data.
     */
    create: XOR<ProductCreateInput, ProductUncheckedCreateInput>
    /**
     * In case the Product was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProductUpdateInput, ProductUncheckedUpdateInput>
  }

  /**
   * Product delete
   */
  export type ProductDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Product
     */
    select?: ProductSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductInclude<ExtArgs> | null
    /**
     * Filter which Product to delete.
     */
    where: ProductWhereUniqueInput
  }

  /**
   * Product deleteMany
   */
  export type ProductDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Products to delete
     */
    where?: ProductWhereInput
  }

  /**
   * Product.ProductThumbnails
   */
  export type Product$ProductThumbnailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductThumbnail
     */
    select?: ProductThumbnailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductThumbnailInclude<ExtArgs> | null
    where?: ProductThumbnailWhereInput
    orderBy?: ProductThumbnailOrderByWithRelationInput | ProductThumbnailOrderByWithRelationInput[]
    cursor?: ProductThumbnailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProductThumbnailScalarFieldEnum | ProductThumbnailScalarFieldEnum[]
  }

  /**
   * Product.ProductCategories
   */
  export type Product$ProductCategoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductCategory
     */
    select?: ProductCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductCategoryInclude<ExtArgs> | null
    where?: ProductCategoryWhereInput
    orderBy?: ProductCategoryOrderByWithRelationInput | ProductCategoryOrderByWithRelationInput[]
    cursor?: ProductCategoryWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProductCategoryScalarFieldEnum | ProductCategoryScalarFieldEnum[]
  }

  /**
   * Product.ProductVariations
   */
  export type Product$ProductVariationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductVariation
     */
    select?: ProductVariationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductVariationInclude<ExtArgs> | null
    where?: ProductVariationWhereInput
    orderBy?: ProductVariationOrderByWithRelationInput | ProductVariationOrderByWithRelationInput[]
    cursor?: ProductVariationWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProductVariationScalarFieldEnum | ProductVariationScalarFieldEnum[]
  }

  /**
   * Product.ProductIncludes
   */
  export type Product$ProductIncludesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductInclude
     */
    select?: ProductIncludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductIncludeInclude<ExtArgs> | null
    where?: ProductIncludeWhereInput
    orderBy?: ProductIncludeOrderByWithRelationInput | ProductIncludeOrderByWithRelationInput[]
    cursor?: ProductIncludeWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProductIncludeScalarFieldEnum | ProductIncludeScalarFieldEnum[]
  }

  /**
   * Product.ProductExcludes
   */
  export type Product$ProductExcludesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductExclude
     */
    select?: ProductExcludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductExcludeInclude<ExtArgs> | null
    where?: ProductExcludeWhereInput
    orderBy?: ProductExcludeOrderByWithRelationInput | ProductExcludeOrderByWithRelationInput[]
    cursor?: ProductExcludeWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProductExcludeScalarFieldEnum | ProductExcludeScalarFieldEnum[]
  }

  /**
   * Product.ProductOrders
   */
  export type Product$ProductOrdersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductOrder
     */
    select?: ProductOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductOrderInclude<ExtArgs> | null
    where?: ProductOrderWhereInput
    orderBy?: ProductOrderOrderByWithRelationInput | ProductOrderOrderByWithRelationInput[]
    cursor?: ProductOrderWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProductOrderScalarFieldEnum | ProductOrderScalarFieldEnum[]
  }

  /**
   * Product without action
   */
  export type ProductDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Product
     */
    select?: ProductSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductInclude<ExtArgs> | null
  }


  /**
   * Model ProductThumbnail
   */

  export type AggregateProductThumbnail = {
    _count: ProductThumbnailCountAggregateOutputType | null
    _min: ProductThumbnailMinAggregateOutputType | null
    _max: ProductThumbnailMaxAggregateOutputType | null
  }

  export type ProductThumbnailMinAggregateOutputType = {
    id: string | null
    product_id: string | null
    image_url: string | null
  }

  export type ProductThumbnailMaxAggregateOutputType = {
    id: string | null
    product_id: string | null
    image_url: string | null
  }

  export type ProductThumbnailCountAggregateOutputType = {
    id: number
    product_id: number
    image_url: number
    _all: number
  }


  export type ProductThumbnailMinAggregateInputType = {
    id?: true
    product_id?: true
    image_url?: true
  }

  export type ProductThumbnailMaxAggregateInputType = {
    id?: true
    product_id?: true
    image_url?: true
  }

  export type ProductThumbnailCountAggregateInputType = {
    id?: true
    product_id?: true
    image_url?: true
    _all?: true
  }

  export type ProductThumbnailAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProductThumbnail to aggregate.
     */
    where?: ProductThumbnailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductThumbnails to fetch.
     */
    orderBy?: ProductThumbnailOrderByWithRelationInput | ProductThumbnailOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProductThumbnailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductThumbnails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductThumbnails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ProductThumbnails
    **/
    _count?: true | ProductThumbnailCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProductThumbnailMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProductThumbnailMaxAggregateInputType
  }

  export type GetProductThumbnailAggregateType<T extends ProductThumbnailAggregateArgs> = {
        [P in keyof T & keyof AggregateProductThumbnail]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProductThumbnail[P]>
      : GetScalarType<T[P], AggregateProductThumbnail[P]>
  }




  export type ProductThumbnailGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductThumbnailWhereInput
    orderBy?: ProductThumbnailOrderByWithAggregationInput | ProductThumbnailOrderByWithAggregationInput[]
    by: ProductThumbnailScalarFieldEnum[] | ProductThumbnailScalarFieldEnum
    having?: ProductThumbnailScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProductThumbnailCountAggregateInputType | true
    _min?: ProductThumbnailMinAggregateInputType
    _max?: ProductThumbnailMaxAggregateInputType
  }

  export type ProductThumbnailGroupByOutputType = {
    id: string
    product_id: string
    image_url: string
    _count: ProductThumbnailCountAggregateOutputType | null
    _min: ProductThumbnailMinAggregateOutputType | null
    _max: ProductThumbnailMaxAggregateOutputType | null
  }

  type GetProductThumbnailGroupByPayload<T extends ProductThumbnailGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProductThumbnailGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProductThumbnailGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProductThumbnailGroupByOutputType[P]>
            : GetScalarType<T[P], ProductThumbnailGroupByOutputType[P]>
        }
      >
    >


  export type ProductThumbnailSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    product_id?: boolean
    image_url?: boolean
    Product?: boolean | ProductDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["productThumbnail"]>


  export type ProductThumbnailSelectScalar = {
    id?: boolean
    product_id?: boolean
    image_url?: boolean
  }

  export type ProductThumbnailInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Product?: boolean | ProductDefaultArgs<ExtArgs>
  }

  export type $ProductThumbnailPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ProductThumbnail"
    objects: {
      Product: Prisma.$ProductPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      product_id: string
      image_url: string
    }, ExtArgs["result"]["productThumbnail"]>
    composites: {}
  }

  type ProductThumbnailGetPayload<S extends boolean | null | undefined | ProductThumbnailDefaultArgs> = $Result.GetResult<Prisma.$ProductThumbnailPayload, S>

  type ProductThumbnailCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<ProductThumbnailFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: ProductThumbnailCountAggregateInputType | true
    }

  export interface ProductThumbnailDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ProductThumbnail'], meta: { name: 'ProductThumbnail' } }
    /**
     * Find zero or one ProductThumbnail that matches the filter.
     * @param {ProductThumbnailFindUniqueArgs} args - Arguments to find a ProductThumbnail
     * @example
     * // Get one ProductThumbnail
     * const productThumbnail = await prisma.productThumbnail.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProductThumbnailFindUniqueArgs>(args: SelectSubset<T, ProductThumbnailFindUniqueArgs<ExtArgs>>): Prisma__ProductThumbnailClient<$Result.GetResult<Prisma.$ProductThumbnailPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one ProductThumbnail that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {ProductThumbnailFindUniqueOrThrowArgs} args - Arguments to find a ProductThumbnail
     * @example
     * // Get one ProductThumbnail
     * const productThumbnail = await prisma.productThumbnail.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProductThumbnailFindUniqueOrThrowArgs>(args: SelectSubset<T, ProductThumbnailFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProductThumbnailClient<$Result.GetResult<Prisma.$ProductThumbnailPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first ProductThumbnail that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductThumbnailFindFirstArgs} args - Arguments to find a ProductThumbnail
     * @example
     * // Get one ProductThumbnail
     * const productThumbnail = await prisma.productThumbnail.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProductThumbnailFindFirstArgs>(args?: SelectSubset<T, ProductThumbnailFindFirstArgs<ExtArgs>>): Prisma__ProductThumbnailClient<$Result.GetResult<Prisma.$ProductThumbnailPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first ProductThumbnail that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductThumbnailFindFirstOrThrowArgs} args - Arguments to find a ProductThumbnail
     * @example
     * // Get one ProductThumbnail
     * const productThumbnail = await prisma.productThumbnail.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProductThumbnailFindFirstOrThrowArgs>(args?: SelectSubset<T, ProductThumbnailFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProductThumbnailClient<$Result.GetResult<Prisma.$ProductThumbnailPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more ProductThumbnails that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductThumbnailFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ProductThumbnails
     * const productThumbnails = await prisma.productThumbnail.findMany()
     * 
     * // Get first 10 ProductThumbnails
     * const productThumbnails = await prisma.productThumbnail.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const productThumbnailWithIdOnly = await prisma.productThumbnail.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProductThumbnailFindManyArgs>(args?: SelectSubset<T, ProductThumbnailFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductThumbnailPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a ProductThumbnail.
     * @param {ProductThumbnailCreateArgs} args - Arguments to create a ProductThumbnail.
     * @example
     * // Create one ProductThumbnail
     * const ProductThumbnail = await prisma.productThumbnail.create({
     *   data: {
     *     // ... data to create a ProductThumbnail
     *   }
     * })
     * 
     */
    create<T extends ProductThumbnailCreateArgs>(args: SelectSubset<T, ProductThumbnailCreateArgs<ExtArgs>>): Prisma__ProductThumbnailClient<$Result.GetResult<Prisma.$ProductThumbnailPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many ProductThumbnails.
     * @param {ProductThumbnailCreateManyArgs} args - Arguments to create many ProductThumbnails.
     * @example
     * // Create many ProductThumbnails
     * const productThumbnail = await prisma.productThumbnail.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProductThumbnailCreateManyArgs>(args?: SelectSubset<T, ProductThumbnailCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a ProductThumbnail.
     * @param {ProductThumbnailDeleteArgs} args - Arguments to delete one ProductThumbnail.
     * @example
     * // Delete one ProductThumbnail
     * const ProductThumbnail = await prisma.productThumbnail.delete({
     *   where: {
     *     // ... filter to delete one ProductThumbnail
     *   }
     * })
     * 
     */
    delete<T extends ProductThumbnailDeleteArgs>(args: SelectSubset<T, ProductThumbnailDeleteArgs<ExtArgs>>): Prisma__ProductThumbnailClient<$Result.GetResult<Prisma.$ProductThumbnailPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one ProductThumbnail.
     * @param {ProductThumbnailUpdateArgs} args - Arguments to update one ProductThumbnail.
     * @example
     * // Update one ProductThumbnail
     * const productThumbnail = await prisma.productThumbnail.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProductThumbnailUpdateArgs>(args: SelectSubset<T, ProductThumbnailUpdateArgs<ExtArgs>>): Prisma__ProductThumbnailClient<$Result.GetResult<Prisma.$ProductThumbnailPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more ProductThumbnails.
     * @param {ProductThumbnailDeleteManyArgs} args - Arguments to filter ProductThumbnails to delete.
     * @example
     * // Delete a few ProductThumbnails
     * const { count } = await prisma.productThumbnail.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProductThumbnailDeleteManyArgs>(args?: SelectSubset<T, ProductThumbnailDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProductThumbnails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductThumbnailUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ProductThumbnails
     * const productThumbnail = await prisma.productThumbnail.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProductThumbnailUpdateManyArgs>(args: SelectSubset<T, ProductThumbnailUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one ProductThumbnail.
     * @param {ProductThumbnailUpsertArgs} args - Arguments to update or create a ProductThumbnail.
     * @example
     * // Update or create a ProductThumbnail
     * const productThumbnail = await prisma.productThumbnail.upsert({
     *   create: {
     *     // ... data to create a ProductThumbnail
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ProductThumbnail we want to update
     *   }
     * })
     */
    upsert<T extends ProductThumbnailUpsertArgs>(args: SelectSubset<T, ProductThumbnailUpsertArgs<ExtArgs>>): Prisma__ProductThumbnailClient<$Result.GetResult<Prisma.$ProductThumbnailPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of ProductThumbnails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductThumbnailCountArgs} args - Arguments to filter ProductThumbnails to count.
     * @example
     * // Count the number of ProductThumbnails
     * const count = await prisma.productThumbnail.count({
     *   where: {
     *     // ... the filter for the ProductThumbnails we want to count
     *   }
     * })
    **/
    count<T extends ProductThumbnailCountArgs>(
      args?: Subset<T, ProductThumbnailCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProductThumbnailCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ProductThumbnail.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductThumbnailAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProductThumbnailAggregateArgs>(args: Subset<T, ProductThumbnailAggregateArgs>): Prisma.PrismaPromise<GetProductThumbnailAggregateType<T>>

    /**
     * Group by ProductThumbnail.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductThumbnailGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProductThumbnailGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProductThumbnailGroupByArgs['orderBy'] }
        : { orderBy?: ProductThumbnailGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProductThumbnailGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProductThumbnailGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ProductThumbnail model
   */
  readonly fields: ProductThumbnailFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ProductThumbnail.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProductThumbnailClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    Product<T extends ProductDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProductDefaultArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ProductThumbnail model
   */ 
  interface ProductThumbnailFieldRefs {
    readonly id: FieldRef<"ProductThumbnail", 'String'>
    readonly product_id: FieldRef<"ProductThumbnail", 'String'>
    readonly image_url: FieldRef<"ProductThumbnail", 'String'>
  }
    

  // Custom InputTypes
  /**
   * ProductThumbnail findUnique
   */
  export type ProductThumbnailFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductThumbnail
     */
    select?: ProductThumbnailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductThumbnailInclude<ExtArgs> | null
    /**
     * Filter, which ProductThumbnail to fetch.
     */
    where: ProductThumbnailWhereUniqueInput
  }

  /**
   * ProductThumbnail findUniqueOrThrow
   */
  export type ProductThumbnailFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductThumbnail
     */
    select?: ProductThumbnailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductThumbnailInclude<ExtArgs> | null
    /**
     * Filter, which ProductThumbnail to fetch.
     */
    where: ProductThumbnailWhereUniqueInput
  }

  /**
   * ProductThumbnail findFirst
   */
  export type ProductThumbnailFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductThumbnail
     */
    select?: ProductThumbnailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductThumbnailInclude<ExtArgs> | null
    /**
     * Filter, which ProductThumbnail to fetch.
     */
    where?: ProductThumbnailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductThumbnails to fetch.
     */
    orderBy?: ProductThumbnailOrderByWithRelationInput | ProductThumbnailOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProductThumbnails.
     */
    cursor?: ProductThumbnailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductThumbnails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductThumbnails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProductThumbnails.
     */
    distinct?: ProductThumbnailScalarFieldEnum | ProductThumbnailScalarFieldEnum[]
  }

  /**
   * ProductThumbnail findFirstOrThrow
   */
  export type ProductThumbnailFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductThumbnail
     */
    select?: ProductThumbnailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductThumbnailInclude<ExtArgs> | null
    /**
     * Filter, which ProductThumbnail to fetch.
     */
    where?: ProductThumbnailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductThumbnails to fetch.
     */
    orderBy?: ProductThumbnailOrderByWithRelationInput | ProductThumbnailOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProductThumbnails.
     */
    cursor?: ProductThumbnailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductThumbnails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductThumbnails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProductThumbnails.
     */
    distinct?: ProductThumbnailScalarFieldEnum | ProductThumbnailScalarFieldEnum[]
  }

  /**
   * ProductThumbnail findMany
   */
  export type ProductThumbnailFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductThumbnail
     */
    select?: ProductThumbnailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductThumbnailInclude<ExtArgs> | null
    /**
     * Filter, which ProductThumbnails to fetch.
     */
    where?: ProductThumbnailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductThumbnails to fetch.
     */
    orderBy?: ProductThumbnailOrderByWithRelationInput | ProductThumbnailOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ProductThumbnails.
     */
    cursor?: ProductThumbnailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductThumbnails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductThumbnails.
     */
    skip?: number
    distinct?: ProductThumbnailScalarFieldEnum | ProductThumbnailScalarFieldEnum[]
  }

  /**
   * ProductThumbnail create
   */
  export type ProductThumbnailCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductThumbnail
     */
    select?: ProductThumbnailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductThumbnailInclude<ExtArgs> | null
    /**
     * The data needed to create a ProductThumbnail.
     */
    data: XOR<ProductThumbnailCreateInput, ProductThumbnailUncheckedCreateInput>
  }

  /**
   * ProductThumbnail createMany
   */
  export type ProductThumbnailCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ProductThumbnails.
     */
    data: ProductThumbnailCreateManyInput | ProductThumbnailCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ProductThumbnail update
   */
  export type ProductThumbnailUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductThumbnail
     */
    select?: ProductThumbnailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductThumbnailInclude<ExtArgs> | null
    /**
     * The data needed to update a ProductThumbnail.
     */
    data: XOR<ProductThumbnailUpdateInput, ProductThumbnailUncheckedUpdateInput>
    /**
     * Choose, which ProductThumbnail to update.
     */
    where: ProductThumbnailWhereUniqueInput
  }

  /**
   * ProductThumbnail updateMany
   */
  export type ProductThumbnailUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ProductThumbnails.
     */
    data: XOR<ProductThumbnailUpdateManyMutationInput, ProductThumbnailUncheckedUpdateManyInput>
    /**
     * Filter which ProductThumbnails to update
     */
    where?: ProductThumbnailWhereInput
  }

  /**
   * ProductThumbnail upsert
   */
  export type ProductThumbnailUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductThumbnail
     */
    select?: ProductThumbnailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductThumbnailInclude<ExtArgs> | null
    /**
     * The filter to search for the ProductThumbnail to update in case it exists.
     */
    where: ProductThumbnailWhereUniqueInput
    /**
     * In case the ProductThumbnail found by the `where` argument doesn't exist, create a new ProductThumbnail with this data.
     */
    create: XOR<ProductThumbnailCreateInput, ProductThumbnailUncheckedCreateInput>
    /**
     * In case the ProductThumbnail was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProductThumbnailUpdateInput, ProductThumbnailUncheckedUpdateInput>
  }

  /**
   * ProductThumbnail delete
   */
  export type ProductThumbnailDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductThumbnail
     */
    select?: ProductThumbnailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductThumbnailInclude<ExtArgs> | null
    /**
     * Filter which ProductThumbnail to delete.
     */
    where: ProductThumbnailWhereUniqueInput
  }

  /**
   * ProductThumbnail deleteMany
   */
  export type ProductThumbnailDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProductThumbnails to delete
     */
    where?: ProductThumbnailWhereInput
  }

  /**
   * ProductThumbnail without action
   */
  export type ProductThumbnailDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductThumbnail
     */
    select?: ProductThumbnailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductThumbnailInclude<ExtArgs> | null
  }


  /**
   * Model ProductCategory
   */

  export type AggregateProductCategory = {
    _count: ProductCategoryCountAggregateOutputType | null
    _min: ProductCategoryMinAggregateOutputType | null
    _max: ProductCategoryMaxAggregateOutputType | null
  }

  export type ProductCategoryMinAggregateOutputType = {
    id: string | null
    product_id: string | null
    category_id: string | null
  }

  export type ProductCategoryMaxAggregateOutputType = {
    id: string | null
    product_id: string | null
    category_id: string | null
  }

  export type ProductCategoryCountAggregateOutputType = {
    id: number
    product_id: number
    category_id: number
    _all: number
  }


  export type ProductCategoryMinAggregateInputType = {
    id?: true
    product_id?: true
    category_id?: true
  }

  export type ProductCategoryMaxAggregateInputType = {
    id?: true
    product_id?: true
    category_id?: true
  }

  export type ProductCategoryCountAggregateInputType = {
    id?: true
    product_id?: true
    category_id?: true
    _all?: true
  }

  export type ProductCategoryAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProductCategory to aggregate.
     */
    where?: ProductCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductCategories to fetch.
     */
    orderBy?: ProductCategoryOrderByWithRelationInput | ProductCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProductCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ProductCategories
    **/
    _count?: true | ProductCategoryCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProductCategoryMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProductCategoryMaxAggregateInputType
  }

  export type GetProductCategoryAggregateType<T extends ProductCategoryAggregateArgs> = {
        [P in keyof T & keyof AggregateProductCategory]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProductCategory[P]>
      : GetScalarType<T[P], AggregateProductCategory[P]>
  }




  export type ProductCategoryGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductCategoryWhereInput
    orderBy?: ProductCategoryOrderByWithAggregationInput | ProductCategoryOrderByWithAggregationInput[]
    by: ProductCategoryScalarFieldEnum[] | ProductCategoryScalarFieldEnum
    having?: ProductCategoryScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProductCategoryCountAggregateInputType | true
    _min?: ProductCategoryMinAggregateInputType
    _max?: ProductCategoryMaxAggregateInputType
  }

  export type ProductCategoryGroupByOutputType = {
    id: string
    product_id: string
    category_id: string
    _count: ProductCategoryCountAggregateOutputType | null
    _min: ProductCategoryMinAggregateOutputType | null
    _max: ProductCategoryMaxAggregateOutputType | null
  }

  type GetProductCategoryGroupByPayload<T extends ProductCategoryGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProductCategoryGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProductCategoryGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProductCategoryGroupByOutputType[P]>
            : GetScalarType<T[P], ProductCategoryGroupByOutputType[P]>
        }
      >
    >


  export type ProductCategorySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    product_id?: boolean
    category_id?: boolean
    Product?: boolean | ProductDefaultArgs<ExtArgs>
    Category?: boolean | CategoryDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["productCategory"]>


  export type ProductCategorySelectScalar = {
    id?: boolean
    product_id?: boolean
    category_id?: boolean
  }

  export type ProductCategoryInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Product?: boolean | ProductDefaultArgs<ExtArgs>
    Category?: boolean | CategoryDefaultArgs<ExtArgs>
  }

  export type $ProductCategoryPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ProductCategory"
    objects: {
      Product: Prisma.$ProductPayload<ExtArgs>
      Category: Prisma.$CategoryPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      product_id: string
      category_id: string
    }, ExtArgs["result"]["productCategory"]>
    composites: {}
  }

  type ProductCategoryGetPayload<S extends boolean | null | undefined | ProductCategoryDefaultArgs> = $Result.GetResult<Prisma.$ProductCategoryPayload, S>

  type ProductCategoryCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<ProductCategoryFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: ProductCategoryCountAggregateInputType | true
    }

  export interface ProductCategoryDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ProductCategory'], meta: { name: 'ProductCategory' } }
    /**
     * Find zero or one ProductCategory that matches the filter.
     * @param {ProductCategoryFindUniqueArgs} args - Arguments to find a ProductCategory
     * @example
     * // Get one ProductCategory
     * const productCategory = await prisma.productCategory.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProductCategoryFindUniqueArgs>(args: SelectSubset<T, ProductCategoryFindUniqueArgs<ExtArgs>>): Prisma__ProductCategoryClient<$Result.GetResult<Prisma.$ProductCategoryPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one ProductCategory that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {ProductCategoryFindUniqueOrThrowArgs} args - Arguments to find a ProductCategory
     * @example
     * // Get one ProductCategory
     * const productCategory = await prisma.productCategory.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProductCategoryFindUniqueOrThrowArgs>(args: SelectSubset<T, ProductCategoryFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProductCategoryClient<$Result.GetResult<Prisma.$ProductCategoryPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first ProductCategory that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductCategoryFindFirstArgs} args - Arguments to find a ProductCategory
     * @example
     * // Get one ProductCategory
     * const productCategory = await prisma.productCategory.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProductCategoryFindFirstArgs>(args?: SelectSubset<T, ProductCategoryFindFirstArgs<ExtArgs>>): Prisma__ProductCategoryClient<$Result.GetResult<Prisma.$ProductCategoryPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first ProductCategory that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductCategoryFindFirstOrThrowArgs} args - Arguments to find a ProductCategory
     * @example
     * // Get one ProductCategory
     * const productCategory = await prisma.productCategory.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProductCategoryFindFirstOrThrowArgs>(args?: SelectSubset<T, ProductCategoryFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProductCategoryClient<$Result.GetResult<Prisma.$ProductCategoryPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more ProductCategories that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductCategoryFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ProductCategories
     * const productCategories = await prisma.productCategory.findMany()
     * 
     * // Get first 10 ProductCategories
     * const productCategories = await prisma.productCategory.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const productCategoryWithIdOnly = await prisma.productCategory.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProductCategoryFindManyArgs>(args?: SelectSubset<T, ProductCategoryFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductCategoryPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a ProductCategory.
     * @param {ProductCategoryCreateArgs} args - Arguments to create a ProductCategory.
     * @example
     * // Create one ProductCategory
     * const ProductCategory = await prisma.productCategory.create({
     *   data: {
     *     // ... data to create a ProductCategory
     *   }
     * })
     * 
     */
    create<T extends ProductCategoryCreateArgs>(args: SelectSubset<T, ProductCategoryCreateArgs<ExtArgs>>): Prisma__ProductCategoryClient<$Result.GetResult<Prisma.$ProductCategoryPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many ProductCategories.
     * @param {ProductCategoryCreateManyArgs} args - Arguments to create many ProductCategories.
     * @example
     * // Create many ProductCategories
     * const productCategory = await prisma.productCategory.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProductCategoryCreateManyArgs>(args?: SelectSubset<T, ProductCategoryCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a ProductCategory.
     * @param {ProductCategoryDeleteArgs} args - Arguments to delete one ProductCategory.
     * @example
     * // Delete one ProductCategory
     * const ProductCategory = await prisma.productCategory.delete({
     *   where: {
     *     // ... filter to delete one ProductCategory
     *   }
     * })
     * 
     */
    delete<T extends ProductCategoryDeleteArgs>(args: SelectSubset<T, ProductCategoryDeleteArgs<ExtArgs>>): Prisma__ProductCategoryClient<$Result.GetResult<Prisma.$ProductCategoryPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one ProductCategory.
     * @param {ProductCategoryUpdateArgs} args - Arguments to update one ProductCategory.
     * @example
     * // Update one ProductCategory
     * const productCategory = await prisma.productCategory.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProductCategoryUpdateArgs>(args: SelectSubset<T, ProductCategoryUpdateArgs<ExtArgs>>): Prisma__ProductCategoryClient<$Result.GetResult<Prisma.$ProductCategoryPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more ProductCategories.
     * @param {ProductCategoryDeleteManyArgs} args - Arguments to filter ProductCategories to delete.
     * @example
     * // Delete a few ProductCategories
     * const { count } = await prisma.productCategory.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProductCategoryDeleteManyArgs>(args?: SelectSubset<T, ProductCategoryDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProductCategories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductCategoryUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ProductCategories
     * const productCategory = await prisma.productCategory.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProductCategoryUpdateManyArgs>(args: SelectSubset<T, ProductCategoryUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one ProductCategory.
     * @param {ProductCategoryUpsertArgs} args - Arguments to update or create a ProductCategory.
     * @example
     * // Update or create a ProductCategory
     * const productCategory = await prisma.productCategory.upsert({
     *   create: {
     *     // ... data to create a ProductCategory
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ProductCategory we want to update
     *   }
     * })
     */
    upsert<T extends ProductCategoryUpsertArgs>(args: SelectSubset<T, ProductCategoryUpsertArgs<ExtArgs>>): Prisma__ProductCategoryClient<$Result.GetResult<Prisma.$ProductCategoryPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of ProductCategories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductCategoryCountArgs} args - Arguments to filter ProductCategories to count.
     * @example
     * // Count the number of ProductCategories
     * const count = await prisma.productCategory.count({
     *   where: {
     *     // ... the filter for the ProductCategories we want to count
     *   }
     * })
    **/
    count<T extends ProductCategoryCountArgs>(
      args?: Subset<T, ProductCategoryCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProductCategoryCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ProductCategory.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductCategoryAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProductCategoryAggregateArgs>(args: Subset<T, ProductCategoryAggregateArgs>): Prisma.PrismaPromise<GetProductCategoryAggregateType<T>>

    /**
     * Group by ProductCategory.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductCategoryGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProductCategoryGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProductCategoryGroupByArgs['orderBy'] }
        : { orderBy?: ProductCategoryGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProductCategoryGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProductCategoryGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ProductCategory model
   */
  readonly fields: ProductCategoryFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ProductCategory.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProductCategoryClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    Product<T extends ProductDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProductDefaultArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    Category<T extends CategoryDefaultArgs<ExtArgs> = {}>(args?: Subset<T, CategoryDefaultArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ProductCategory model
   */ 
  interface ProductCategoryFieldRefs {
    readonly id: FieldRef<"ProductCategory", 'String'>
    readonly product_id: FieldRef<"ProductCategory", 'String'>
    readonly category_id: FieldRef<"ProductCategory", 'String'>
  }
    

  // Custom InputTypes
  /**
   * ProductCategory findUnique
   */
  export type ProductCategoryFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductCategory
     */
    select?: ProductCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ProductCategory to fetch.
     */
    where: ProductCategoryWhereUniqueInput
  }

  /**
   * ProductCategory findUniqueOrThrow
   */
  export type ProductCategoryFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductCategory
     */
    select?: ProductCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ProductCategory to fetch.
     */
    where: ProductCategoryWhereUniqueInput
  }

  /**
   * ProductCategory findFirst
   */
  export type ProductCategoryFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductCategory
     */
    select?: ProductCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ProductCategory to fetch.
     */
    where?: ProductCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductCategories to fetch.
     */
    orderBy?: ProductCategoryOrderByWithRelationInput | ProductCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProductCategories.
     */
    cursor?: ProductCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProductCategories.
     */
    distinct?: ProductCategoryScalarFieldEnum | ProductCategoryScalarFieldEnum[]
  }

  /**
   * ProductCategory findFirstOrThrow
   */
  export type ProductCategoryFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductCategory
     */
    select?: ProductCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ProductCategory to fetch.
     */
    where?: ProductCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductCategories to fetch.
     */
    orderBy?: ProductCategoryOrderByWithRelationInput | ProductCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProductCategories.
     */
    cursor?: ProductCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProductCategories.
     */
    distinct?: ProductCategoryScalarFieldEnum | ProductCategoryScalarFieldEnum[]
  }

  /**
   * ProductCategory findMany
   */
  export type ProductCategoryFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductCategory
     */
    select?: ProductCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ProductCategories to fetch.
     */
    where?: ProductCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductCategories to fetch.
     */
    orderBy?: ProductCategoryOrderByWithRelationInput | ProductCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ProductCategories.
     */
    cursor?: ProductCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductCategories.
     */
    skip?: number
    distinct?: ProductCategoryScalarFieldEnum | ProductCategoryScalarFieldEnum[]
  }

  /**
   * ProductCategory create
   */
  export type ProductCategoryCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductCategory
     */
    select?: ProductCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductCategoryInclude<ExtArgs> | null
    /**
     * The data needed to create a ProductCategory.
     */
    data: XOR<ProductCategoryCreateInput, ProductCategoryUncheckedCreateInput>
  }

  /**
   * ProductCategory createMany
   */
  export type ProductCategoryCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ProductCategories.
     */
    data: ProductCategoryCreateManyInput | ProductCategoryCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ProductCategory update
   */
  export type ProductCategoryUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductCategory
     */
    select?: ProductCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductCategoryInclude<ExtArgs> | null
    /**
     * The data needed to update a ProductCategory.
     */
    data: XOR<ProductCategoryUpdateInput, ProductCategoryUncheckedUpdateInput>
    /**
     * Choose, which ProductCategory to update.
     */
    where: ProductCategoryWhereUniqueInput
  }

  /**
   * ProductCategory updateMany
   */
  export type ProductCategoryUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ProductCategories.
     */
    data: XOR<ProductCategoryUpdateManyMutationInput, ProductCategoryUncheckedUpdateManyInput>
    /**
     * Filter which ProductCategories to update
     */
    where?: ProductCategoryWhereInput
  }

  /**
   * ProductCategory upsert
   */
  export type ProductCategoryUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductCategory
     */
    select?: ProductCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductCategoryInclude<ExtArgs> | null
    /**
     * The filter to search for the ProductCategory to update in case it exists.
     */
    where: ProductCategoryWhereUniqueInput
    /**
     * In case the ProductCategory found by the `where` argument doesn't exist, create a new ProductCategory with this data.
     */
    create: XOR<ProductCategoryCreateInput, ProductCategoryUncheckedCreateInput>
    /**
     * In case the ProductCategory was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProductCategoryUpdateInput, ProductCategoryUncheckedUpdateInput>
  }

  /**
   * ProductCategory delete
   */
  export type ProductCategoryDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductCategory
     */
    select?: ProductCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductCategoryInclude<ExtArgs> | null
    /**
     * Filter which ProductCategory to delete.
     */
    where: ProductCategoryWhereUniqueInput
  }

  /**
   * ProductCategory deleteMany
   */
  export type ProductCategoryDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProductCategories to delete
     */
    where?: ProductCategoryWhereInput
  }

  /**
   * ProductCategory without action
   */
  export type ProductCategoryDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductCategory
     */
    select?: ProductCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductCategoryInclude<ExtArgs> | null
  }


  /**
   * Model ProductVariation
   */

  export type AggregateProductVariation = {
    _count: ProductVariationCountAggregateOutputType | null
    _avg: ProductVariationAvgAggregateOutputType | null
    _sum: ProductVariationSumAggregateOutputType | null
    _min: ProductVariationMinAggregateOutputType | null
    _max: ProductVariationMaxAggregateOutputType | null
  }

  export type ProductVariationAvgAggregateOutputType = {
    price: Decimal | null
  }

  export type ProductVariationSumAggregateOutputType = {
    price: Decimal | null
  }

  export type ProductVariationMinAggregateOutputType = {
    id: string | null
    product_id: string | null
    name: string | null
    price: Decimal | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type ProductVariationMaxAggregateOutputType = {
    id: string | null
    product_id: string | null
    name: string | null
    price: Decimal | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type ProductVariationCountAggregateOutputType = {
    id: number
    product_id: number
    name: number
    price: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type ProductVariationAvgAggregateInputType = {
    price?: true
  }

  export type ProductVariationSumAggregateInputType = {
    price?: true
  }

  export type ProductVariationMinAggregateInputType = {
    id?: true
    product_id?: true
    name?: true
    price?: true
    created_at?: true
    updated_at?: true
  }

  export type ProductVariationMaxAggregateInputType = {
    id?: true
    product_id?: true
    name?: true
    price?: true
    created_at?: true
    updated_at?: true
  }

  export type ProductVariationCountAggregateInputType = {
    id?: true
    product_id?: true
    name?: true
    price?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type ProductVariationAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProductVariation to aggregate.
     */
    where?: ProductVariationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductVariations to fetch.
     */
    orderBy?: ProductVariationOrderByWithRelationInput | ProductVariationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProductVariationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductVariations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductVariations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ProductVariations
    **/
    _count?: true | ProductVariationCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ProductVariationAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ProductVariationSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProductVariationMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProductVariationMaxAggregateInputType
  }

  export type GetProductVariationAggregateType<T extends ProductVariationAggregateArgs> = {
        [P in keyof T & keyof AggregateProductVariation]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProductVariation[P]>
      : GetScalarType<T[P], AggregateProductVariation[P]>
  }




  export type ProductVariationGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductVariationWhereInput
    orderBy?: ProductVariationOrderByWithAggregationInput | ProductVariationOrderByWithAggregationInput[]
    by: ProductVariationScalarFieldEnum[] | ProductVariationScalarFieldEnum
    having?: ProductVariationScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProductVariationCountAggregateInputType | true
    _avg?: ProductVariationAvgAggregateInputType
    _sum?: ProductVariationSumAggregateInputType
    _min?: ProductVariationMinAggregateInputType
    _max?: ProductVariationMaxAggregateInputType
  }

  export type ProductVariationGroupByOutputType = {
    id: string
    product_id: string
    name: string
    price: Decimal
    created_at: Date
    updated_at: Date
    _count: ProductVariationCountAggregateOutputType | null
    _avg: ProductVariationAvgAggregateOutputType | null
    _sum: ProductVariationSumAggregateOutputType | null
    _min: ProductVariationMinAggregateOutputType | null
    _max: ProductVariationMaxAggregateOutputType | null
  }

  type GetProductVariationGroupByPayload<T extends ProductVariationGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProductVariationGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProductVariationGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProductVariationGroupByOutputType[P]>
            : GetScalarType<T[P], ProductVariationGroupByOutputType[P]>
        }
      >
    >


  export type ProductVariationSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    product_id?: boolean
    name?: boolean
    price?: boolean
    created_at?: boolean
    updated_at?: boolean
    ProductOrders?: boolean | ProductVariation$ProductOrdersArgs<ExtArgs>
    Product?: boolean | ProductDefaultArgs<ExtArgs>
    _count?: boolean | ProductVariationCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["productVariation"]>


  export type ProductVariationSelectScalar = {
    id?: boolean
    product_id?: boolean
    name?: boolean
    price?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type ProductVariationInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ProductOrders?: boolean | ProductVariation$ProductOrdersArgs<ExtArgs>
    Product?: boolean | ProductDefaultArgs<ExtArgs>
    _count?: boolean | ProductVariationCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $ProductVariationPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ProductVariation"
    objects: {
      ProductOrders: Prisma.$ProductOrderPayload<ExtArgs>[]
      Product: Prisma.$ProductPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      product_id: string
      name: string
      price: Prisma.Decimal
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["productVariation"]>
    composites: {}
  }

  type ProductVariationGetPayload<S extends boolean | null | undefined | ProductVariationDefaultArgs> = $Result.GetResult<Prisma.$ProductVariationPayload, S>

  type ProductVariationCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<ProductVariationFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: ProductVariationCountAggregateInputType | true
    }

  export interface ProductVariationDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ProductVariation'], meta: { name: 'ProductVariation' } }
    /**
     * Find zero or one ProductVariation that matches the filter.
     * @param {ProductVariationFindUniqueArgs} args - Arguments to find a ProductVariation
     * @example
     * // Get one ProductVariation
     * const productVariation = await prisma.productVariation.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProductVariationFindUniqueArgs>(args: SelectSubset<T, ProductVariationFindUniqueArgs<ExtArgs>>): Prisma__ProductVariationClient<$Result.GetResult<Prisma.$ProductVariationPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one ProductVariation that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {ProductVariationFindUniqueOrThrowArgs} args - Arguments to find a ProductVariation
     * @example
     * // Get one ProductVariation
     * const productVariation = await prisma.productVariation.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProductVariationFindUniqueOrThrowArgs>(args: SelectSubset<T, ProductVariationFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProductVariationClient<$Result.GetResult<Prisma.$ProductVariationPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first ProductVariation that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductVariationFindFirstArgs} args - Arguments to find a ProductVariation
     * @example
     * // Get one ProductVariation
     * const productVariation = await prisma.productVariation.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProductVariationFindFirstArgs>(args?: SelectSubset<T, ProductVariationFindFirstArgs<ExtArgs>>): Prisma__ProductVariationClient<$Result.GetResult<Prisma.$ProductVariationPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first ProductVariation that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductVariationFindFirstOrThrowArgs} args - Arguments to find a ProductVariation
     * @example
     * // Get one ProductVariation
     * const productVariation = await prisma.productVariation.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProductVariationFindFirstOrThrowArgs>(args?: SelectSubset<T, ProductVariationFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProductVariationClient<$Result.GetResult<Prisma.$ProductVariationPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more ProductVariations that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductVariationFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ProductVariations
     * const productVariations = await prisma.productVariation.findMany()
     * 
     * // Get first 10 ProductVariations
     * const productVariations = await prisma.productVariation.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const productVariationWithIdOnly = await prisma.productVariation.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProductVariationFindManyArgs>(args?: SelectSubset<T, ProductVariationFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductVariationPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a ProductVariation.
     * @param {ProductVariationCreateArgs} args - Arguments to create a ProductVariation.
     * @example
     * // Create one ProductVariation
     * const ProductVariation = await prisma.productVariation.create({
     *   data: {
     *     // ... data to create a ProductVariation
     *   }
     * })
     * 
     */
    create<T extends ProductVariationCreateArgs>(args: SelectSubset<T, ProductVariationCreateArgs<ExtArgs>>): Prisma__ProductVariationClient<$Result.GetResult<Prisma.$ProductVariationPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many ProductVariations.
     * @param {ProductVariationCreateManyArgs} args - Arguments to create many ProductVariations.
     * @example
     * // Create many ProductVariations
     * const productVariation = await prisma.productVariation.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProductVariationCreateManyArgs>(args?: SelectSubset<T, ProductVariationCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a ProductVariation.
     * @param {ProductVariationDeleteArgs} args - Arguments to delete one ProductVariation.
     * @example
     * // Delete one ProductVariation
     * const ProductVariation = await prisma.productVariation.delete({
     *   where: {
     *     // ... filter to delete one ProductVariation
     *   }
     * })
     * 
     */
    delete<T extends ProductVariationDeleteArgs>(args: SelectSubset<T, ProductVariationDeleteArgs<ExtArgs>>): Prisma__ProductVariationClient<$Result.GetResult<Prisma.$ProductVariationPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one ProductVariation.
     * @param {ProductVariationUpdateArgs} args - Arguments to update one ProductVariation.
     * @example
     * // Update one ProductVariation
     * const productVariation = await prisma.productVariation.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProductVariationUpdateArgs>(args: SelectSubset<T, ProductVariationUpdateArgs<ExtArgs>>): Prisma__ProductVariationClient<$Result.GetResult<Prisma.$ProductVariationPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more ProductVariations.
     * @param {ProductVariationDeleteManyArgs} args - Arguments to filter ProductVariations to delete.
     * @example
     * // Delete a few ProductVariations
     * const { count } = await prisma.productVariation.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProductVariationDeleteManyArgs>(args?: SelectSubset<T, ProductVariationDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProductVariations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductVariationUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ProductVariations
     * const productVariation = await prisma.productVariation.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProductVariationUpdateManyArgs>(args: SelectSubset<T, ProductVariationUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one ProductVariation.
     * @param {ProductVariationUpsertArgs} args - Arguments to update or create a ProductVariation.
     * @example
     * // Update or create a ProductVariation
     * const productVariation = await prisma.productVariation.upsert({
     *   create: {
     *     // ... data to create a ProductVariation
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ProductVariation we want to update
     *   }
     * })
     */
    upsert<T extends ProductVariationUpsertArgs>(args: SelectSubset<T, ProductVariationUpsertArgs<ExtArgs>>): Prisma__ProductVariationClient<$Result.GetResult<Prisma.$ProductVariationPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of ProductVariations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductVariationCountArgs} args - Arguments to filter ProductVariations to count.
     * @example
     * // Count the number of ProductVariations
     * const count = await prisma.productVariation.count({
     *   where: {
     *     // ... the filter for the ProductVariations we want to count
     *   }
     * })
    **/
    count<T extends ProductVariationCountArgs>(
      args?: Subset<T, ProductVariationCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProductVariationCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ProductVariation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductVariationAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProductVariationAggregateArgs>(args: Subset<T, ProductVariationAggregateArgs>): Prisma.PrismaPromise<GetProductVariationAggregateType<T>>

    /**
     * Group by ProductVariation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductVariationGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProductVariationGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProductVariationGroupByArgs['orderBy'] }
        : { orderBy?: ProductVariationGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProductVariationGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProductVariationGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ProductVariation model
   */
  readonly fields: ProductVariationFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ProductVariation.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProductVariationClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    ProductOrders<T extends ProductVariation$ProductOrdersArgs<ExtArgs> = {}>(args?: Subset<T, ProductVariation$ProductOrdersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductOrderPayload<ExtArgs>, T, "findMany"> | Null>
    Product<T extends ProductDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProductDefaultArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ProductVariation model
   */ 
  interface ProductVariationFieldRefs {
    readonly id: FieldRef<"ProductVariation", 'String'>
    readonly product_id: FieldRef<"ProductVariation", 'String'>
    readonly name: FieldRef<"ProductVariation", 'String'>
    readonly price: FieldRef<"ProductVariation", 'Decimal'>
    readonly created_at: FieldRef<"ProductVariation", 'DateTime'>
    readonly updated_at: FieldRef<"ProductVariation", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * ProductVariation findUnique
   */
  export type ProductVariationFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductVariation
     */
    select?: ProductVariationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductVariationInclude<ExtArgs> | null
    /**
     * Filter, which ProductVariation to fetch.
     */
    where: ProductVariationWhereUniqueInput
  }

  /**
   * ProductVariation findUniqueOrThrow
   */
  export type ProductVariationFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductVariation
     */
    select?: ProductVariationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductVariationInclude<ExtArgs> | null
    /**
     * Filter, which ProductVariation to fetch.
     */
    where: ProductVariationWhereUniqueInput
  }

  /**
   * ProductVariation findFirst
   */
  export type ProductVariationFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductVariation
     */
    select?: ProductVariationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductVariationInclude<ExtArgs> | null
    /**
     * Filter, which ProductVariation to fetch.
     */
    where?: ProductVariationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductVariations to fetch.
     */
    orderBy?: ProductVariationOrderByWithRelationInput | ProductVariationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProductVariations.
     */
    cursor?: ProductVariationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductVariations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductVariations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProductVariations.
     */
    distinct?: ProductVariationScalarFieldEnum | ProductVariationScalarFieldEnum[]
  }

  /**
   * ProductVariation findFirstOrThrow
   */
  export type ProductVariationFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductVariation
     */
    select?: ProductVariationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductVariationInclude<ExtArgs> | null
    /**
     * Filter, which ProductVariation to fetch.
     */
    where?: ProductVariationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductVariations to fetch.
     */
    orderBy?: ProductVariationOrderByWithRelationInput | ProductVariationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProductVariations.
     */
    cursor?: ProductVariationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductVariations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductVariations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProductVariations.
     */
    distinct?: ProductVariationScalarFieldEnum | ProductVariationScalarFieldEnum[]
  }

  /**
   * ProductVariation findMany
   */
  export type ProductVariationFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductVariation
     */
    select?: ProductVariationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductVariationInclude<ExtArgs> | null
    /**
     * Filter, which ProductVariations to fetch.
     */
    where?: ProductVariationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductVariations to fetch.
     */
    orderBy?: ProductVariationOrderByWithRelationInput | ProductVariationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ProductVariations.
     */
    cursor?: ProductVariationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductVariations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductVariations.
     */
    skip?: number
    distinct?: ProductVariationScalarFieldEnum | ProductVariationScalarFieldEnum[]
  }

  /**
   * ProductVariation create
   */
  export type ProductVariationCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductVariation
     */
    select?: ProductVariationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductVariationInclude<ExtArgs> | null
    /**
     * The data needed to create a ProductVariation.
     */
    data: XOR<ProductVariationCreateInput, ProductVariationUncheckedCreateInput>
  }

  /**
   * ProductVariation createMany
   */
  export type ProductVariationCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ProductVariations.
     */
    data: ProductVariationCreateManyInput | ProductVariationCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ProductVariation update
   */
  export type ProductVariationUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductVariation
     */
    select?: ProductVariationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductVariationInclude<ExtArgs> | null
    /**
     * The data needed to update a ProductVariation.
     */
    data: XOR<ProductVariationUpdateInput, ProductVariationUncheckedUpdateInput>
    /**
     * Choose, which ProductVariation to update.
     */
    where: ProductVariationWhereUniqueInput
  }

  /**
   * ProductVariation updateMany
   */
  export type ProductVariationUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ProductVariations.
     */
    data: XOR<ProductVariationUpdateManyMutationInput, ProductVariationUncheckedUpdateManyInput>
    /**
     * Filter which ProductVariations to update
     */
    where?: ProductVariationWhereInput
  }

  /**
   * ProductVariation upsert
   */
  export type ProductVariationUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductVariation
     */
    select?: ProductVariationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductVariationInclude<ExtArgs> | null
    /**
     * The filter to search for the ProductVariation to update in case it exists.
     */
    where: ProductVariationWhereUniqueInput
    /**
     * In case the ProductVariation found by the `where` argument doesn't exist, create a new ProductVariation with this data.
     */
    create: XOR<ProductVariationCreateInput, ProductVariationUncheckedCreateInput>
    /**
     * In case the ProductVariation was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProductVariationUpdateInput, ProductVariationUncheckedUpdateInput>
  }

  /**
   * ProductVariation delete
   */
  export type ProductVariationDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductVariation
     */
    select?: ProductVariationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductVariationInclude<ExtArgs> | null
    /**
     * Filter which ProductVariation to delete.
     */
    where: ProductVariationWhereUniqueInput
  }

  /**
   * ProductVariation deleteMany
   */
  export type ProductVariationDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProductVariations to delete
     */
    where?: ProductVariationWhereInput
  }

  /**
   * ProductVariation.ProductOrders
   */
  export type ProductVariation$ProductOrdersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductOrder
     */
    select?: ProductOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductOrderInclude<ExtArgs> | null
    where?: ProductOrderWhereInput
    orderBy?: ProductOrderOrderByWithRelationInput | ProductOrderOrderByWithRelationInput[]
    cursor?: ProductOrderWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProductOrderScalarFieldEnum | ProductOrderScalarFieldEnum[]
  }

  /**
   * ProductVariation without action
   */
  export type ProductVariationDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductVariation
     */
    select?: ProductVariationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductVariationInclude<ExtArgs> | null
  }


  /**
   * Model ProductInclude
   */

  export type AggregateProductInclude = {
    _count: ProductIncludeCountAggregateOutputType | null
    _min: ProductIncludeMinAggregateOutputType | null
    _max: ProductIncludeMaxAggregateOutputType | null
  }

  export type ProductIncludeMinAggregateOutputType = {
    id: string | null
    product_id: string | null
    description: string | null
  }

  export type ProductIncludeMaxAggregateOutputType = {
    id: string | null
    product_id: string | null
    description: string | null
  }

  export type ProductIncludeCountAggregateOutputType = {
    id: number
    product_id: number
    description: number
    _all: number
  }


  export type ProductIncludeMinAggregateInputType = {
    id?: true
    product_id?: true
    description?: true
  }

  export type ProductIncludeMaxAggregateInputType = {
    id?: true
    product_id?: true
    description?: true
  }

  export type ProductIncludeCountAggregateInputType = {
    id?: true
    product_id?: true
    description?: true
    _all?: true
  }

  export type ProductIncludeAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProductInclude to aggregate.
     */
    where?: ProductIncludeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductIncludes to fetch.
     */
    orderBy?: ProductIncludeOrderByWithRelationInput | ProductIncludeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProductIncludeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductIncludes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductIncludes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ProductIncludes
    **/
    _count?: true | ProductIncludeCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProductIncludeMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProductIncludeMaxAggregateInputType
  }

  export type GetProductIncludeAggregateType<T extends ProductIncludeAggregateArgs> = {
        [P in keyof T & keyof AggregateProductInclude]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProductInclude[P]>
      : GetScalarType<T[P], AggregateProductInclude[P]>
  }




  export type ProductIncludeGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductIncludeWhereInput
    orderBy?: ProductIncludeOrderByWithAggregationInput | ProductIncludeOrderByWithAggregationInput[]
    by: ProductIncludeScalarFieldEnum[] | ProductIncludeScalarFieldEnum
    having?: ProductIncludeScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProductIncludeCountAggregateInputType | true
    _min?: ProductIncludeMinAggregateInputType
    _max?: ProductIncludeMaxAggregateInputType
  }

  export type ProductIncludeGroupByOutputType = {
    id: string
    product_id: string
    description: string
    _count: ProductIncludeCountAggregateOutputType | null
    _min: ProductIncludeMinAggregateOutputType | null
    _max: ProductIncludeMaxAggregateOutputType | null
  }

  type GetProductIncludeGroupByPayload<T extends ProductIncludeGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProductIncludeGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProductIncludeGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProductIncludeGroupByOutputType[P]>
            : GetScalarType<T[P], ProductIncludeGroupByOutputType[P]>
        }
      >
    >


  export type ProductIncludeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    product_id?: boolean
    description?: boolean
    Product?: boolean | ProductDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["productInclude"]>


  export type ProductIncludeSelectScalar = {
    id?: boolean
    product_id?: boolean
    description?: boolean
  }

  export type ProductIncludeInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Product?: boolean | ProductDefaultArgs<ExtArgs>
  }

  export type $ProductIncludePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ProductInclude"
    objects: {
      Product: Prisma.$ProductPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      product_id: string
      description: string
    }, ExtArgs["result"]["productInclude"]>
    composites: {}
  }

  type ProductIncludeGetPayload<S extends boolean | null | undefined | ProductIncludeDefaultArgs> = $Result.GetResult<Prisma.$ProductIncludePayload, S>

  type ProductIncludeCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<ProductIncludeFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: ProductIncludeCountAggregateInputType | true
    }

  export interface ProductIncludeDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ProductInclude'], meta: { name: 'ProductInclude' } }
    /**
     * Find zero or one ProductInclude that matches the filter.
     * @param {ProductIncludeFindUniqueArgs} args - Arguments to find a ProductInclude
     * @example
     * // Get one ProductInclude
     * const productInclude = await prisma.productInclude.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProductIncludeFindUniqueArgs>(args: SelectSubset<T, ProductIncludeFindUniqueArgs<ExtArgs>>): Prisma__ProductIncludeClient<$Result.GetResult<Prisma.$ProductIncludePayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one ProductInclude that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {ProductIncludeFindUniqueOrThrowArgs} args - Arguments to find a ProductInclude
     * @example
     * // Get one ProductInclude
     * const productInclude = await prisma.productInclude.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProductIncludeFindUniqueOrThrowArgs>(args: SelectSubset<T, ProductIncludeFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProductIncludeClient<$Result.GetResult<Prisma.$ProductIncludePayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first ProductInclude that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductIncludeFindFirstArgs} args - Arguments to find a ProductInclude
     * @example
     * // Get one ProductInclude
     * const productInclude = await prisma.productInclude.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProductIncludeFindFirstArgs>(args?: SelectSubset<T, ProductIncludeFindFirstArgs<ExtArgs>>): Prisma__ProductIncludeClient<$Result.GetResult<Prisma.$ProductIncludePayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first ProductInclude that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductIncludeFindFirstOrThrowArgs} args - Arguments to find a ProductInclude
     * @example
     * // Get one ProductInclude
     * const productInclude = await prisma.productInclude.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProductIncludeFindFirstOrThrowArgs>(args?: SelectSubset<T, ProductIncludeFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProductIncludeClient<$Result.GetResult<Prisma.$ProductIncludePayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more ProductIncludes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductIncludeFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ProductIncludes
     * const productIncludes = await prisma.productInclude.findMany()
     * 
     * // Get first 10 ProductIncludes
     * const productIncludes = await prisma.productInclude.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const productIncludeWithIdOnly = await prisma.productInclude.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProductIncludeFindManyArgs>(args?: SelectSubset<T, ProductIncludeFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductIncludePayload<ExtArgs>, T, "findMany">>

    /**
     * Create a ProductInclude.
     * @param {ProductIncludeCreateArgs} args - Arguments to create a ProductInclude.
     * @example
     * // Create one ProductInclude
     * const ProductInclude = await prisma.productInclude.create({
     *   data: {
     *     // ... data to create a ProductInclude
     *   }
     * })
     * 
     */
    create<T extends ProductIncludeCreateArgs>(args: SelectSubset<T, ProductIncludeCreateArgs<ExtArgs>>): Prisma__ProductIncludeClient<$Result.GetResult<Prisma.$ProductIncludePayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many ProductIncludes.
     * @param {ProductIncludeCreateManyArgs} args - Arguments to create many ProductIncludes.
     * @example
     * // Create many ProductIncludes
     * const productInclude = await prisma.productInclude.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProductIncludeCreateManyArgs>(args?: SelectSubset<T, ProductIncludeCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a ProductInclude.
     * @param {ProductIncludeDeleteArgs} args - Arguments to delete one ProductInclude.
     * @example
     * // Delete one ProductInclude
     * const ProductInclude = await prisma.productInclude.delete({
     *   where: {
     *     // ... filter to delete one ProductInclude
     *   }
     * })
     * 
     */
    delete<T extends ProductIncludeDeleteArgs>(args: SelectSubset<T, ProductIncludeDeleteArgs<ExtArgs>>): Prisma__ProductIncludeClient<$Result.GetResult<Prisma.$ProductIncludePayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one ProductInclude.
     * @param {ProductIncludeUpdateArgs} args - Arguments to update one ProductInclude.
     * @example
     * // Update one ProductInclude
     * const productInclude = await prisma.productInclude.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProductIncludeUpdateArgs>(args: SelectSubset<T, ProductIncludeUpdateArgs<ExtArgs>>): Prisma__ProductIncludeClient<$Result.GetResult<Prisma.$ProductIncludePayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more ProductIncludes.
     * @param {ProductIncludeDeleteManyArgs} args - Arguments to filter ProductIncludes to delete.
     * @example
     * // Delete a few ProductIncludes
     * const { count } = await prisma.productInclude.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProductIncludeDeleteManyArgs>(args?: SelectSubset<T, ProductIncludeDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProductIncludes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductIncludeUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ProductIncludes
     * const productInclude = await prisma.productInclude.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProductIncludeUpdateManyArgs>(args: SelectSubset<T, ProductIncludeUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one ProductInclude.
     * @param {ProductIncludeUpsertArgs} args - Arguments to update or create a ProductInclude.
     * @example
     * // Update or create a ProductInclude
     * const productInclude = await prisma.productInclude.upsert({
     *   create: {
     *     // ... data to create a ProductInclude
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ProductInclude we want to update
     *   }
     * })
     */
    upsert<T extends ProductIncludeUpsertArgs>(args: SelectSubset<T, ProductIncludeUpsertArgs<ExtArgs>>): Prisma__ProductIncludeClient<$Result.GetResult<Prisma.$ProductIncludePayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of ProductIncludes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductIncludeCountArgs} args - Arguments to filter ProductIncludes to count.
     * @example
     * // Count the number of ProductIncludes
     * const count = await prisma.productInclude.count({
     *   where: {
     *     // ... the filter for the ProductIncludes we want to count
     *   }
     * })
    **/
    count<T extends ProductIncludeCountArgs>(
      args?: Subset<T, ProductIncludeCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProductIncludeCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ProductInclude.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductIncludeAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProductIncludeAggregateArgs>(args: Subset<T, ProductIncludeAggregateArgs>): Prisma.PrismaPromise<GetProductIncludeAggregateType<T>>

    /**
     * Group by ProductInclude.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductIncludeGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProductIncludeGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProductIncludeGroupByArgs['orderBy'] }
        : { orderBy?: ProductIncludeGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProductIncludeGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProductIncludeGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ProductInclude model
   */
  readonly fields: ProductIncludeFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ProductInclude.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProductIncludeClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    Product<T extends ProductDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProductDefaultArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ProductInclude model
   */ 
  interface ProductIncludeFieldRefs {
    readonly id: FieldRef<"ProductInclude", 'String'>
    readonly product_id: FieldRef<"ProductInclude", 'String'>
    readonly description: FieldRef<"ProductInclude", 'String'>
  }
    

  // Custom InputTypes
  /**
   * ProductInclude findUnique
   */
  export type ProductIncludeFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductInclude
     */
    select?: ProductIncludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductIncludeInclude<ExtArgs> | null
    /**
     * Filter, which ProductInclude to fetch.
     */
    where: ProductIncludeWhereUniqueInput
  }

  /**
   * ProductInclude findUniqueOrThrow
   */
  export type ProductIncludeFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductInclude
     */
    select?: ProductIncludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductIncludeInclude<ExtArgs> | null
    /**
     * Filter, which ProductInclude to fetch.
     */
    where: ProductIncludeWhereUniqueInput
  }

  /**
   * ProductInclude findFirst
   */
  export type ProductIncludeFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductInclude
     */
    select?: ProductIncludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductIncludeInclude<ExtArgs> | null
    /**
     * Filter, which ProductInclude to fetch.
     */
    where?: ProductIncludeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductIncludes to fetch.
     */
    orderBy?: ProductIncludeOrderByWithRelationInput | ProductIncludeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProductIncludes.
     */
    cursor?: ProductIncludeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductIncludes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductIncludes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProductIncludes.
     */
    distinct?: ProductIncludeScalarFieldEnum | ProductIncludeScalarFieldEnum[]
  }

  /**
   * ProductInclude findFirstOrThrow
   */
  export type ProductIncludeFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductInclude
     */
    select?: ProductIncludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductIncludeInclude<ExtArgs> | null
    /**
     * Filter, which ProductInclude to fetch.
     */
    where?: ProductIncludeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductIncludes to fetch.
     */
    orderBy?: ProductIncludeOrderByWithRelationInput | ProductIncludeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProductIncludes.
     */
    cursor?: ProductIncludeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductIncludes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductIncludes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProductIncludes.
     */
    distinct?: ProductIncludeScalarFieldEnum | ProductIncludeScalarFieldEnum[]
  }

  /**
   * ProductInclude findMany
   */
  export type ProductIncludeFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductInclude
     */
    select?: ProductIncludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductIncludeInclude<ExtArgs> | null
    /**
     * Filter, which ProductIncludes to fetch.
     */
    where?: ProductIncludeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductIncludes to fetch.
     */
    orderBy?: ProductIncludeOrderByWithRelationInput | ProductIncludeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ProductIncludes.
     */
    cursor?: ProductIncludeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductIncludes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductIncludes.
     */
    skip?: number
    distinct?: ProductIncludeScalarFieldEnum | ProductIncludeScalarFieldEnum[]
  }

  /**
   * ProductInclude create
   */
  export type ProductIncludeCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductInclude
     */
    select?: ProductIncludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductIncludeInclude<ExtArgs> | null
    /**
     * The data needed to create a ProductInclude.
     */
    data: XOR<ProductIncludeCreateInput, ProductIncludeUncheckedCreateInput>
  }

  /**
   * ProductInclude createMany
   */
  export type ProductIncludeCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ProductIncludes.
     */
    data: ProductIncludeCreateManyInput | ProductIncludeCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ProductInclude update
   */
  export type ProductIncludeUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductInclude
     */
    select?: ProductIncludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductIncludeInclude<ExtArgs> | null
    /**
     * The data needed to update a ProductInclude.
     */
    data: XOR<ProductIncludeUpdateInput, ProductIncludeUncheckedUpdateInput>
    /**
     * Choose, which ProductInclude to update.
     */
    where: ProductIncludeWhereUniqueInput
  }

  /**
   * ProductInclude updateMany
   */
  export type ProductIncludeUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ProductIncludes.
     */
    data: XOR<ProductIncludeUpdateManyMutationInput, ProductIncludeUncheckedUpdateManyInput>
    /**
     * Filter which ProductIncludes to update
     */
    where?: ProductIncludeWhereInput
  }

  /**
   * ProductInclude upsert
   */
  export type ProductIncludeUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductInclude
     */
    select?: ProductIncludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductIncludeInclude<ExtArgs> | null
    /**
     * The filter to search for the ProductInclude to update in case it exists.
     */
    where: ProductIncludeWhereUniqueInput
    /**
     * In case the ProductInclude found by the `where` argument doesn't exist, create a new ProductInclude with this data.
     */
    create: XOR<ProductIncludeCreateInput, ProductIncludeUncheckedCreateInput>
    /**
     * In case the ProductInclude was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProductIncludeUpdateInput, ProductIncludeUncheckedUpdateInput>
  }

  /**
   * ProductInclude delete
   */
  export type ProductIncludeDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductInclude
     */
    select?: ProductIncludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductIncludeInclude<ExtArgs> | null
    /**
     * Filter which ProductInclude to delete.
     */
    where: ProductIncludeWhereUniqueInput
  }

  /**
   * ProductInclude deleteMany
   */
  export type ProductIncludeDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProductIncludes to delete
     */
    where?: ProductIncludeWhereInput
  }

  /**
   * ProductInclude without action
   */
  export type ProductIncludeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductInclude
     */
    select?: ProductIncludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductIncludeInclude<ExtArgs> | null
  }


  /**
   * Model ProductExclude
   */

  export type AggregateProductExclude = {
    _count: ProductExcludeCountAggregateOutputType | null
    _min: ProductExcludeMinAggregateOutputType | null
    _max: ProductExcludeMaxAggregateOutputType | null
  }

  export type ProductExcludeMinAggregateOutputType = {
    id: string | null
    product_id: string | null
    description: string | null
  }

  export type ProductExcludeMaxAggregateOutputType = {
    id: string | null
    product_id: string | null
    description: string | null
  }

  export type ProductExcludeCountAggregateOutputType = {
    id: number
    product_id: number
    description: number
    _all: number
  }


  export type ProductExcludeMinAggregateInputType = {
    id?: true
    product_id?: true
    description?: true
  }

  export type ProductExcludeMaxAggregateInputType = {
    id?: true
    product_id?: true
    description?: true
  }

  export type ProductExcludeCountAggregateInputType = {
    id?: true
    product_id?: true
    description?: true
    _all?: true
  }

  export type ProductExcludeAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProductExclude to aggregate.
     */
    where?: ProductExcludeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductExcludes to fetch.
     */
    orderBy?: ProductExcludeOrderByWithRelationInput | ProductExcludeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProductExcludeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductExcludes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductExcludes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ProductExcludes
    **/
    _count?: true | ProductExcludeCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProductExcludeMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProductExcludeMaxAggregateInputType
  }

  export type GetProductExcludeAggregateType<T extends ProductExcludeAggregateArgs> = {
        [P in keyof T & keyof AggregateProductExclude]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProductExclude[P]>
      : GetScalarType<T[P], AggregateProductExclude[P]>
  }




  export type ProductExcludeGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductExcludeWhereInput
    orderBy?: ProductExcludeOrderByWithAggregationInput | ProductExcludeOrderByWithAggregationInput[]
    by: ProductExcludeScalarFieldEnum[] | ProductExcludeScalarFieldEnum
    having?: ProductExcludeScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProductExcludeCountAggregateInputType | true
    _min?: ProductExcludeMinAggregateInputType
    _max?: ProductExcludeMaxAggregateInputType
  }

  export type ProductExcludeGroupByOutputType = {
    id: string
    product_id: string
    description: string
    _count: ProductExcludeCountAggregateOutputType | null
    _min: ProductExcludeMinAggregateOutputType | null
    _max: ProductExcludeMaxAggregateOutputType | null
  }

  type GetProductExcludeGroupByPayload<T extends ProductExcludeGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProductExcludeGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProductExcludeGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProductExcludeGroupByOutputType[P]>
            : GetScalarType<T[P], ProductExcludeGroupByOutputType[P]>
        }
      >
    >


  export type ProductExcludeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    product_id?: boolean
    description?: boolean
    Product?: boolean | ProductDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["productExclude"]>


  export type ProductExcludeSelectScalar = {
    id?: boolean
    product_id?: boolean
    description?: boolean
  }

  export type ProductExcludeInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Product?: boolean | ProductDefaultArgs<ExtArgs>
  }

  export type $ProductExcludePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ProductExclude"
    objects: {
      Product: Prisma.$ProductPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      product_id: string
      description: string
    }, ExtArgs["result"]["productExclude"]>
    composites: {}
  }

  type ProductExcludeGetPayload<S extends boolean | null | undefined | ProductExcludeDefaultArgs> = $Result.GetResult<Prisma.$ProductExcludePayload, S>

  type ProductExcludeCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<ProductExcludeFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: ProductExcludeCountAggregateInputType | true
    }

  export interface ProductExcludeDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ProductExclude'], meta: { name: 'ProductExclude' } }
    /**
     * Find zero or one ProductExclude that matches the filter.
     * @param {ProductExcludeFindUniqueArgs} args - Arguments to find a ProductExclude
     * @example
     * // Get one ProductExclude
     * const productExclude = await prisma.productExclude.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProductExcludeFindUniqueArgs>(args: SelectSubset<T, ProductExcludeFindUniqueArgs<ExtArgs>>): Prisma__ProductExcludeClient<$Result.GetResult<Prisma.$ProductExcludePayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one ProductExclude that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {ProductExcludeFindUniqueOrThrowArgs} args - Arguments to find a ProductExclude
     * @example
     * // Get one ProductExclude
     * const productExclude = await prisma.productExclude.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProductExcludeFindUniqueOrThrowArgs>(args: SelectSubset<T, ProductExcludeFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProductExcludeClient<$Result.GetResult<Prisma.$ProductExcludePayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first ProductExclude that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductExcludeFindFirstArgs} args - Arguments to find a ProductExclude
     * @example
     * // Get one ProductExclude
     * const productExclude = await prisma.productExclude.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProductExcludeFindFirstArgs>(args?: SelectSubset<T, ProductExcludeFindFirstArgs<ExtArgs>>): Prisma__ProductExcludeClient<$Result.GetResult<Prisma.$ProductExcludePayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first ProductExclude that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductExcludeFindFirstOrThrowArgs} args - Arguments to find a ProductExclude
     * @example
     * // Get one ProductExclude
     * const productExclude = await prisma.productExclude.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProductExcludeFindFirstOrThrowArgs>(args?: SelectSubset<T, ProductExcludeFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProductExcludeClient<$Result.GetResult<Prisma.$ProductExcludePayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more ProductExcludes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductExcludeFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ProductExcludes
     * const productExcludes = await prisma.productExclude.findMany()
     * 
     * // Get first 10 ProductExcludes
     * const productExcludes = await prisma.productExclude.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const productExcludeWithIdOnly = await prisma.productExclude.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProductExcludeFindManyArgs>(args?: SelectSubset<T, ProductExcludeFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductExcludePayload<ExtArgs>, T, "findMany">>

    /**
     * Create a ProductExclude.
     * @param {ProductExcludeCreateArgs} args - Arguments to create a ProductExclude.
     * @example
     * // Create one ProductExclude
     * const ProductExclude = await prisma.productExclude.create({
     *   data: {
     *     // ... data to create a ProductExclude
     *   }
     * })
     * 
     */
    create<T extends ProductExcludeCreateArgs>(args: SelectSubset<T, ProductExcludeCreateArgs<ExtArgs>>): Prisma__ProductExcludeClient<$Result.GetResult<Prisma.$ProductExcludePayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many ProductExcludes.
     * @param {ProductExcludeCreateManyArgs} args - Arguments to create many ProductExcludes.
     * @example
     * // Create many ProductExcludes
     * const productExclude = await prisma.productExclude.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProductExcludeCreateManyArgs>(args?: SelectSubset<T, ProductExcludeCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a ProductExclude.
     * @param {ProductExcludeDeleteArgs} args - Arguments to delete one ProductExclude.
     * @example
     * // Delete one ProductExclude
     * const ProductExclude = await prisma.productExclude.delete({
     *   where: {
     *     // ... filter to delete one ProductExclude
     *   }
     * })
     * 
     */
    delete<T extends ProductExcludeDeleteArgs>(args: SelectSubset<T, ProductExcludeDeleteArgs<ExtArgs>>): Prisma__ProductExcludeClient<$Result.GetResult<Prisma.$ProductExcludePayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one ProductExclude.
     * @param {ProductExcludeUpdateArgs} args - Arguments to update one ProductExclude.
     * @example
     * // Update one ProductExclude
     * const productExclude = await prisma.productExclude.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProductExcludeUpdateArgs>(args: SelectSubset<T, ProductExcludeUpdateArgs<ExtArgs>>): Prisma__ProductExcludeClient<$Result.GetResult<Prisma.$ProductExcludePayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more ProductExcludes.
     * @param {ProductExcludeDeleteManyArgs} args - Arguments to filter ProductExcludes to delete.
     * @example
     * // Delete a few ProductExcludes
     * const { count } = await prisma.productExclude.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProductExcludeDeleteManyArgs>(args?: SelectSubset<T, ProductExcludeDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProductExcludes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductExcludeUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ProductExcludes
     * const productExclude = await prisma.productExclude.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProductExcludeUpdateManyArgs>(args: SelectSubset<T, ProductExcludeUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one ProductExclude.
     * @param {ProductExcludeUpsertArgs} args - Arguments to update or create a ProductExclude.
     * @example
     * // Update or create a ProductExclude
     * const productExclude = await prisma.productExclude.upsert({
     *   create: {
     *     // ... data to create a ProductExclude
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ProductExclude we want to update
     *   }
     * })
     */
    upsert<T extends ProductExcludeUpsertArgs>(args: SelectSubset<T, ProductExcludeUpsertArgs<ExtArgs>>): Prisma__ProductExcludeClient<$Result.GetResult<Prisma.$ProductExcludePayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of ProductExcludes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductExcludeCountArgs} args - Arguments to filter ProductExcludes to count.
     * @example
     * // Count the number of ProductExcludes
     * const count = await prisma.productExclude.count({
     *   where: {
     *     // ... the filter for the ProductExcludes we want to count
     *   }
     * })
    **/
    count<T extends ProductExcludeCountArgs>(
      args?: Subset<T, ProductExcludeCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProductExcludeCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ProductExclude.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductExcludeAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProductExcludeAggregateArgs>(args: Subset<T, ProductExcludeAggregateArgs>): Prisma.PrismaPromise<GetProductExcludeAggregateType<T>>

    /**
     * Group by ProductExclude.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductExcludeGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProductExcludeGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProductExcludeGroupByArgs['orderBy'] }
        : { orderBy?: ProductExcludeGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProductExcludeGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProductExcludeGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ProductExclude model
   */
  readonly fields: ProductExcludeFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ProductExclude.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProductExcludeClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    Product<T extends ProductDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProductDefaultArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ProductExclude model
   */ 
  interface ProductExcludeFieldRefs {
    readonly id: FieldRef<"ProductExclude", 'String'>
    readonly product_id: FieldRef<"ProductExclude", 'String'>
    readonly description: FieldRef<"ProductExclude", 'String'>
  }
    

  // Custom InputTypes
  /**
   * ProductExclude findUnique
   */
  export type ProductExcludeFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductExclude
     */
    select?: ProductExcludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductExcludeInclude<ExtArgs> | null
    /**
     * Filter, which ProductExclude to fetch.
     */
    where: ProductExcludeWhereUniqueInput
  }

  /**
   * ProductExclude findUniqueOrThrow
   */
  export type ProductExcludeFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductExclude
     */
    select?: ProductExcludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductExcludeInclude<ExtArgs> | null
    /**
     * Filter, which ProductExclude to fetch.
     */
    where: ProductExcludeWhereUniqueInput
  }

  /**
   * ProductExclude findFirst
   */
  export type ProductExcludeFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductExclude
     */
    select?: ProductExcludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductExcludeInclude<ExtArgs> | null
    /**
     * Filter, which ProductExclude to fetch.
     */
    where?: ProductExcludeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductExcludes to fetch.
     */
    orderBy?: ProductExcludeOrderByWithRelationInput | ProductExcludeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProductExcludes.
     */
    cursor?: ProductExcludeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductExcludes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductExcludes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProductExcludes.
     */
    distinct?: ProductExcludeScalarFieldEnum | ProductExcludeScalarFieldEnum[]
  }

  /**
   * ProductExclude findFirstOrThrow
   */
  export type ProductExcludeFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductExclude
     */
    select?: ProductExcludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductExcludeInclude<ExtArgs> | null
    /**
     * Filter, which ProductExclude to fetch.
     */
    where?: ProductExcludeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductExcludes to fetch.
     */
    orderBy?: ProductExcludeOrderByWithRelationInput | ProductExcludeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProductExcludes.
     */
    cursor?: ProductExcludeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductExcludes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductExcludes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProductExcludes.
     */
    distinct?: ProductExcludeScalarFieldEnum | ProductExcludeScalarFieldEnum[]
  }

  /**
   * ProductExclude findMany
   */
  export type ProductExcludeFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductExclude
     */
    select?: ProductExcludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductExcludeInclude<ExtArgs> | null
    /**
     * Filter, which ProductExcludes to fetch.
     */
    where?: ProductExcludeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductExcludes to fetch.
     */
    orderBy?: ProductExcludeOrderByWithRelationInput | ProductExcludeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ProductExcludes.
     */
    cursor?: ProductExcludeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductExcludes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductExcludes.
     */
    skip?: number
    distinct?: ProductExcludeScalarFieldEnum | ProductExcludeScalarFieldEnum[]
  }

  /**
   * ProductExclude create
   */
  export type ProductExcludeCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductExclude
     */
    select?: ProductExcludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductExcludeInclude<ExtArgs> | null
    /**
     * The data needed to create a ProductExclude.
     */
    data: XOR<ProductExcludeCreateInput, ProductExcludeUncheckedCreateInput>
  }

  /**
   * ProductExclude createMany
   */
  export type ProductExcludeCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ProductExcludes.
     */
    data: ProductExcludeCreateManyInput | ProductExcludeCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ProductExclude update
   */
  export type ProductExcludeUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductExclude
     */
    select?: ProductExcludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductExcludeInclude<ExtArgs> | null
    /**
     * The data needed to update a ProductExclude.
     */
    data: XOR<ProductExcludeUpdateInput, ProductExcludeUncheckedUpdateInput>
    /**
     * Choose, which ProductExclude to update.
     */
    where: ProductExcludeWhereUniqueInput
  }

  /**
   * ProductExclude updateMany
   */
  export type ProductExcludeUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ProductExcludes.
     */
    data: XOR<ProductExcludeUpdateManyMutationInput, ProductExcludeUncheckedUpdateManyInput>
    /**
     * Filter which ProductExcludes to update
     */
    where?: ProductExcludeWhereInput
  }

  /**
   * ProductExclude upsert
   */
  export type ProductExcludeUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductExclude
     */
    select?: ProductExcludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductExcludeInclude<ExtArgs> | null
    /**
     * The filter to search for the ProductExclude to update in case it exists.
     */
    where: ProductExcludeWhereUniqueInput
    /**
     * In case the ProductExclude found by the `where` argument doesn't exist, create a new ProductExclude with this data.
     */
    create: XOR<ProductExcludeCreateInput, ProductExcludeUncheckedCreateInput>
    /**
     * In case the ProductExclude was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProductExcludeUpdateInput, ProductExcludeUncheckedUpdateInput>
  }

  /**
   * ProductExclude delete
   */
  export type ProductExcludeDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductExclude
     */
    select?: ProductExcludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductExcludeInclude<ExtArgs> | null
    /**
     * Filter which ProductExclude to delete.
     */
    where: ProductExcludeWhereUniqueInput
  }

  /**
   * ProductExclude deleteMany
   */
  export type ProductExcludeDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProductExcludes to delete
     */
    where?: ProductExcludeWhereInput
  }

  /**
   * ProductExclude without action
   */
  export type ProductExcludeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductExclude
     */
    select?: ProductExcludeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductExcludeInclude<ExtArgs> | null
  }


  /**
   * Model ProductOrder
   */

  export type AggregateProductOrder = {
    _count: ProductOrderCountAggregateOutputType | null
    _avg: ProductOrderAvgAggregateOutputType | null
    _sum: ProductOrderSumAggregateOutputType | null
    _min: ProductOrderMinAggregateOutputType | null
    _max: ProductOrderMaxAggregateOutputType | null
  }

  export type ProductOrderAvgAggregateOutputType = {
    number_of_pax: number | null
    per_pax_price: Decimal | null
    total_price: Decimal | null
  }

  export type ProductOrderSumAggregateOutputType = {
    number_of_pax: number | null
    per_pax_price: Decimal | null
    total_price: Decimal | null
  }

  export type ProductOrderMinAggregateOutputType = {
    id: string | null
    user_id: string | null
    product_id: string | null
    variation_id: string | null
    departure: Date | null
    number_of_pax: number | null
    per_pax_price: Decimal | null
    total_price: Decimal | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type ProductOrderMaxAggregateOutputType = {
    id: string | null
    user_id: string | null
    product_id: string | null
    variation_id: string | null
    departure: Date | null
    number_of_pax: number | null
    per_pax_price: Decimal | null
    total_price: Decimal | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type ProductOrderCountAggregateOutputType = {
    id: number
    user_id: number
    product_id: number
    variation_id: number
    departure: number
    number_of_pax: number
    per_pax_price: number
    total_price: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type ProductOrderAvgAggregateInputType = {
    number_of_pax?: true
    per_pax_price?: true
    total_price?: true
  }

  export type ProductOrderSumAggregateInputType = {
    number_of_pax?: true
    per_pax_price?: true
    total_price?: true
  }

  export type ProductOrderMinAggregateInputType = {
    id?: true
    user_id?: true
    product_id?: true
    variation_id?: true
    departure?: true
    number_of_pax?: true
    per_pax_price?: true
    total_price?: true
    created_at?: true
    updated_at?: true
  }

  export type ProductOrderMaxAggregateInputType = {
    id?: true
    user_id?: true
    product_id?: true
    variation_id?: true
    departure?: true
    number_of_pax?: true
    per_pax_price?: true
    total_price?: true
    created_at?: true
    updated_at?: true
  }

  export type ProductOrderCountAggregateInputType = {
    id?: true
    user_id?: true
    product_id?: true
    variation_id?: true
    departure?: true
    number_of_pax?: true
    per_pax_price?: true
    total_price?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type ProductOrderAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProductOrder to aggregate.
     */
    where?: ProductOrderWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductOrders to fetch.
     */
    orderBy?: ProductOrderOrderByWithRelationInput | ProductOrderOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProductOrderWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductOrders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductOrders.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ProductOrders
    **/
    _count?: true | ProductOrderCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ProductOrderAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ProductOrderSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProductOrderMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProductOrderMaxAggregateInputType
  }

  export type GetProductOrderAggregateType<T extends ProductOrderAggregateArgs> = {
        [P in keyof T & keyof AggregateProductOrder]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProductOrder[P]>
      : GetScalarType<T[P], AggregateProductOrder[P]>
  }




  export type ProductOrderGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProductOrderWhereInput
    orderBy?: ProductOrderOrderByWithAggregationInput | ProductOrderOrderByWithAggregationInput[]
    by: ProductOrderScalarFieldEnum[] | ProductOrderScalarFieldEnum
    having?: ProductOrderScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProductOrderCountAggregateInputType | true
    _avg?: ProductOrderAvgAggregateInputType
    _sum?: ProductOrderSumAggregateInputType
    _min?: ProductOrderMinAggregateInputType
    _max?: ProductOrderMaxAggregateInputType
  }

  export type ProductOrderGroupByOutputType = {
    id: string
    user_id: string
    product_id: string
    variation_id: string | null
    departure: Date
    number_of_pax: number
    per_pax_price: Decimal
    total_price: Decimal
    created_at: Date
    updated_at: Date
    _count: ProductOrderCountAggregateOutputType | null
    _avg: ProductOrderAvgAggregateOutputType | null
    _sum: ProductOrderSumAggregateOutputType | null
    _min: ProductOrderMinAggregateOutputType | null
    _max: ProductOrderMaxAggregateOutputType | null
  }

  type GetProductOrderGroupByPayload<T extends ProductOrderGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProductOrderGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProductOrderGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProductOrderGroupByOutputType[P]>
            : GetScalarType<T[P], ProductOrderGroupByOutputType[P]>
        }
      >
    >


  export type ProductOrderSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    product_id?: boolean
    variation_id?: boolean
    departure?: boolean
    number_of_pax?: boolean
    per_pax_price?: boolean
    total_price?: boolean
    created_at?: boolean
    updated_at?: boolean
    User?: boolean | UserDefaultArgs<ExtArgs>
    Product?: boolean | ProductDefaultArgs<ExtArgs>
    ProductVariation?: boolean | ProductOrder$ProductVariationArgs<ExtArgs>
  }, ExtArgs["result"]["productOrder"]>


  export type ProductOrderSelectScalar = {
    id?: boolean
    user_id?: boolean
    product_id?: boolean
    variation_id?: boolean
    departure?: boolean
    number_of_pax?: boolean
    per_pax_price?: boolean
    total_price?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type ProductOrderInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    User?: boolean | UserDefaultArgs<ExtArgs>
    Product?: boolean | ProductDefaultArgs<ExtArgs>
    ProductVariation?: boolean | ProductOrder$ProductVariationArgs<ExtArgs>
  }

  export type $ProductOrderPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ProductOrder"
    objects: {
      User: Prisma.$UserPayload<ExtArgs>
      Product: Prisma.$ProductPayload<ExtArgs>
      ProductVariation: Prisma.$ProductVariationPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      user_id: string
      product_id: string
      variation_id: string | null
      departure: Date
      number_of_pax: number
      per_pax_price: Prisma.Decimal
      total_price: Prisma.Decimal
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["productOrder"]>
    composites: {}
  }

  type ProductOrderGetPayload<S extends boolean | null | undefined | ProductOrderDefaultArgs> = $Result.GetResult<Prisma.$ProductOrderPayload, S>

  type ProductOrderCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<ProductOrderFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: ProductOrderCountAggregateInputType | true
    }

  export interface ProductOrderDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ProductOrder'], meta: { name: 'ProductOrder' } }
    /**
     * Find zero or one ProductOrder that matches the filter.
     * @param {ProductOrderFindUniqueArgs} args - Arguments to find a ProductOrder
     * @example
     * // Get one ProductOrder
     * const productOrder = await prisma.productOrder.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProductOrderFindUniqueArgs>(args: SelectSubset<T, ProductOrderFindUniqueArgs<ExtArgs>>): Prisma__ProductOrderClient<$Result.GetResult<Prisma.$ProductOrderPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one ProductOrder that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {ProductOrderFindUniqueOrThrowArgs} args - Arguments to find a ProductOrder
     * @example
     * // Get one ProductOrder
     * const productOrder = await prisma.productOrder.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProductOrderFindUniqueOrThrowArgs>(args: SelectSubset<T, ProductOrderFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProductOrderClient<$Result.GetResult<Prisma.$ProductOrderPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first ProductOrder that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductOrderFindFirstArgs} args - Arguments to find a ProductOrder
     * @example
     * // Get one ProductOrder
     * const productOrder = await prisma.productOrder.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProductOrderFindFirstArgs>(args?: SelectSubset<T, ProductOrderFindFirstArgs<ExtArgs>>): Prisma__ProductOrderClient<$Result.GetResult<Prisma.$ProductOrderPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first ProductOrder that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductOrderFindFirstOrThrowArgs} args - Arguments to find a ProductOrder
     * @example
     * // Get one ProductOrder
     * const productOrder = await prisma.productOrder.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProductOrderFindFirstOrThrowArgs>(args?: SelectSubset<T, ProductOrderFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProductOrderClient<$Result.GetResult<Prisma.$ProductOrderPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more ProductOrders that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductOrderFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ProductOrders
     * const productOrders = await prisma.productOrder.findMany()
     * 
     * // Get first 10 ProductOrders
     * const productOrders = await prisma.productOrder.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const productOrderWithIdOnly = await prisma.productOrder.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProductOrderFindManyArgs>(args?: SelectSubset<T, ProductOrderFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProductOrderPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a ProductOrder.
     * @param {ProductOrderCreateArgs} args - Arguments to create a ProductOrder.
     * @example
     * // Create one ProductOrder
     * const ProductOrder = await prisma.productOrder.create({
     *   data: {
     *     // ... data to create a ProductOrder
     *   }
     * })
     * 
     */
    create<T extends ProductOrderCreateArgs>(args: SelectSubset<T, ProductOrderCreateArgs<ExtArgs>>): Prisma__ProductOrderClient<$Result.GetResult<Prisma.$ProductOrderPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many ProductOrders.
     * @param {ProductOrderCreateManyArgs} args - Arguments to create many ProductOrders.
     * @example
     * // Create many ProductOrders
     * const productOrder = await prisma.productOrder.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProductOrderCreateManyArgs>(args?: SelectSubset<T, ProductOrderCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a ProductOrder.
     * @param {ProductOrderDeleteArgs} args - Arguments to delete one ProductOrder.
     * @example
     * // Delete one ProductOrder
     * const ProductOrder = await prisma.productOrder.delete({
     *   where: {
     *     // ... filter to delete one ProductOrder
     *   }
     * })
     * 
     */
    delete<T extends ProductOrderDeleteArgs>(args: SelectSubset<T, ProductOrderDeleteArgs<ExtArgs>>): Prisma__ProductOrderClient<$Result.GetResult<Prisma.$ProductOrderPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one ProductOrder.
     * @param {ProductOrderUpdateArgs} args - Arguments to update one ProductOrder.
     * @example
     * // Update one ProductOrder
     * const productOrder = await prisma.productOrder.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProductOrderUpdateArgs>(args: SelectSubset<T, ProductOrderUpdateArgs<ExtArgs>>): Prisma__ProductOrderClient<$Result.GetResult<Prisma.$ProductOrderPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more ProductOrders.
     * @param {ProductOrderDeleteManyArgs} args - Arguments to filter ProductOrders to delete.
     * @example
     * // Delete a few ProductOrders
     * const { count } = await prisma.productOrder.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProductOrderDeleteManyArgs>(args?: SelectSubset<T, ProductOrderDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProductOrders.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductOrderUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ProductOrders
     * const productOrder = await prisma.productOrder.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProductOrderUpdateManyArgs>(args: SelectSubset<T, ProductOrderUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one ProductOrder.
     * @param {ProductOrderUpsertArgs} args - Arguments to update or create a ProductOrder.
     * @example
     * // Update or create a ProductOrder
     * const productOrder = await prisma.productOrder.upsert({
     *   create: {
     *     // ... data to create a ProductOrder
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ProductOrder we want to update
     *   }
     * })
     */
    upsert<T extends ProductOrderUpsertArgs>(args: SelectSubset<T, ProductOrderUpsertArgs<ExtArgs>>): Prisma__ProductOrderClient<$Result.GetResult<Prisma.$ProductOrderPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of ProductOrders.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductOrderCountArgs} args - Arguments to filter ProductOrders to count.
     * @example
     * // Count the number of ProductOrders
     * const count = await prisma.productOrder.count({
     *   where: {
     *     // ... the filter for the ProductOrders we want to count
     *   }
     * })
    **/
    count<T extends ProductOrderCountArgs>(
      args?: Subset<T, ProductOrderCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProductOrderCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ProductOrder.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductOrderAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProductOrderAggregateArgs>(args: Subset<T, ProductOrderAggregateArgs>): Prisma.PrismaPromise<GetProductOrderAggregateType<T>>

    /**
     * Group by ProductOrder.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProductOrderGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProductOrderGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProductOrderGroupByArgs['orderBy'] }
        : { orderBy?: ProductOrderGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProductOrderGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProductOrderGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ProductOrder model
   */
  readonly fields: ProductOrderFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ProductOrder.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProductOrderClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    User<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    Product<T extends ProductDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProductDefaultArgs<ExtArgs>>): Prisma__ProductClient<$Result.GetResult<Prisma.$ProductPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    ProductVariation<T extends ProductOrder$ProductVariationArgs<ExtArgs> = {}>(args?: Subset<T, ProductOrder$ProductVariationArgs<ExtArgs>>): Prisma__ProductVariationClient<$Result.GetResult<Prisma.$ProductVariationPayload<ExtArgs>, T, "findUniqueOrThrow"> | null, null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ProductOrder model
   */ 
  interface ProductOrderFieldRefs {
    readonly id: FieldRef<"ProductOrder", 'String'>
    readonly user_id: FieldRef<"ProductOrder", 'String'>
    readonly product_id: FieldRef<"ProductOrder", 'String'>
    readonly variation_id: FieldRef<"ProductOrder", 'String'>
    readonly departure: FieldRef<"ProductOrder", 'DateTime'>
    readonly number_of_pax: FieldRef<"ProductOrder", 'Int'>
    readonly per_pax_price: FieldRef<"ProductOrder", 'Decimal'>
    readonly total_price: FieldRef<"ProductOrder", 'Decimal'>
    readonly created_at: FieldRef<"ProductOrder", 'DateTime'>
    readonly updated_at: FieldRef<"ProductOrder", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * ProductOrder findUnique
   */
  export type ProductOrderFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductOrder
     */
    select?: ProductOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductOrderInclude<ExtArgs> | null
    /**
     * Filter, which ProductOrder to fetch.
     */
    where: ProductOrderWhereUniqueInput
  }

  /**
   * ProductOrder findUniqueOrThrow
   */
  export type ProductOrderFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductOrder
     */
    select?: ProductOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductOrderInclude<ExtArgs> | null
    /**
     * Filter, which ProductOrder to fetch.
     */
    where: ProductOrderWhereUniqueInput
  }

  /**
   * ProductOrder findFirst
   */
  export type ProductOrderFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductOrder
     */
    select?: ProductOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductOrderInclude<ExtArgs> | null
    /**
     * Filter, which ProductOrder to fetch.
     */
    where?: ProductOrderWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductOrders to fetch.
     */
    orderBy?: ProductOrderOrderByWithRelationInput | ProductOrderOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProductOrders.
     */
    cursor?: ProductOrderWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductOrders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductOrders.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProductOrders.
     */
    distinct?: ProductOrderScalarFieldEnum | ProductOrderScalarFieldEnum[]
  }

  /**
   * ProductOrder findFirstOrThrow
   */
  export type ProductOrderFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductOrder
     */
    select?: ProductOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductOrderInclude<ExtArgs> | null
    /**
     * Filter, which ProductOrder to fetch.
     */
    where?: ProductOrderWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductOrders to fetch.
     */
    orderBy?: ProductOrderOrderByWithRelationInput | ProductOrderOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProductOrders.
     */
    cursor?: ProductOrderWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductOrders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductOrders.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProductOrders.
     */
    distinct?: ProductOrderScalarFieldEnum | ProductOrderScalarFieldEnum[]
  }

  /**
   * ProductOrder findMany
   */
  export type ProductOrderFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductOrder
     */
    select?: ProductOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductOrderInclude<ExtArgs> | null
    /**
     * Filter, which ProductOrders to fetch.
     */
    where?: ProductOrderWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProductOrders to fetch.
     */
    orderBy?: ProductOrderOrderByWithRelationInput | ProductOrderOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ProductOrders.
     */
    cursor?: ProductOrderWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProductOrders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProductOrders.
     */
    skip?: number
    distinct?: ProductOrderScalarFieldEnum | ProductOrderScalarFieldEnum[]
  }

  /**
   * ProductOrder create
   */
  export type ProductOrderCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductOrder
     */
    select?: ProductOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductOrderInclude<ExtArgs> | null
    /**
     * The data needed to create a ProductOrder.
     */
    data: XOR<ProductOrderCreateInput, ProductOrderUncheckedCreateInput>
  }

  /**
   * ProductOrder createMany
   */
  export type ProductOrderCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ProductOrders.
     */
    data: ProductOrderCreateManyInput | ProductOrderCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ProductOrder update
   */
  export type ProductOrderUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductOrder
     */
    select?: ProductOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductOrderInclude<ExtArgs> | null
    /**
     * The data needed to update a ProductOrder.
     */
    data: XOR<ProductOrderUpdateInput, ProductOrderUncheckedUpdateInput>
    /**
     * Choose, which ProductOrder to update.
     */
    where: ProductOrderWhereUniqueInput
  }

  /**
   * ProductOrder updateMany
   */
  export type ProductOrderUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ProductOrders.
     */
    data: XOR<ProductOrderUpdateManyMutationInput, ProductOrderUncheckedUpdateManyInput>
    /**
     * Filter which ProductOrders to update
     */
    where?: ProductOrderWhereInput
  }

  /**
   * ProductOrder upsert
   */
  export type ProductOrderUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductOrder
     */
    select?: ProductOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductOrderInclude<ExtArgs> | null
    /**
     * The filter to search for the ProductOrder to update in case it exists.
     */
    where: ProductOrderWhereUniqueInput
    /**
     * In case the ProductOrder found by the `where` argument doesn't exist, create a new ProductOrder with this data.
     */
    create: XOR<ProductOrderCreateInput, ProductOrderUncheckedCreateInput>
    /**
     * In case the ProductOrder was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProductOrderUpdateInput, ProductOrderUncheckedUpdateInput>
  }

  /**
   * ProductOrder delete
   */
  export type ProductOrderDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductOrder
     */
    select?: ProductOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductOrderInclude<ExtArgs> | null
    /**
     * Filter which ProductOrder to delete.
     */
    where: ProductOrderWhereUniqueInput
  }

  /**
   * ProductOrder deleteMany
   */
  export type ProductOrderDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProductOrders to delete
     */
    where?: ProductOrderWhereInput
  }

  /**
   * ProductOrder.ProductVariation
   */
  export type ProductOrder$ProductVariationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductVariation
     */
    select?: ProductVariationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductVariationInclude<ExtArgs> | null
    where?: ProductVariationWhereInput
  }

  /**
   * ProductOrder without action
   */
  export type ProductOrderDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProductOrder
     */
    select?: ProductOrderSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProductOrderInclude<ExtArgs> | null
  }


  /**
   * Model Vendor
   */

  export type AggregateVendor = {
    _count: VendorCountAggregateOutputType | null
    _min: VendorMinAggregateOutputType | null
    _max: VendorMaxAggregateOutputType | null
  }

  export type VendorMinAggregateOutputType = {
    id: string | null
    name: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type VendorMaxAggregateOutputType = {
    id: string | null
    name: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type VendorCountAggregateOutputType = {
    id: number
    name: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type VendorMinAggregateInputType = {
    id?: true
    name?: true
    created_at?: true
    updated_at?: true
  }

  export type VendorMaxAggregateInputType = {
    id?: true
    name?: true
    created_at?: true
    updated_at?: true
  }

  export type VendorCountAggregateInputType = {
    id?: true
    name?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type VendorAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Vendor to aggregate.
     */
    where?: VendorWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Vendors to fetch.
     */
    orderBy?: VendorOrderByWithRelationInput | VendorOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: VendorWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Vendors from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Vendors.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Vendors
    **/
    _count?: true | VendorCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: VendorMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: VendorMaxAggregateInputType
  }

  export type GetVendorAggregateType<T extends VendorAggregateArgs> = {
        [P in keyof T & keyof AggregateVendor]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateVendor[P]>
      : GetScalarType<T[P], AggregateVendor[P]>
  }




  export type VendorGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: VendorWhereInput
    orderBy?: VendorOrderByWithAggregationInput | VendorOrderByWithAggregationInput[]
    by: VendorScalarFieldEnum[] | VendorScalarFieldEnum
    having?: VendorScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: VendorCountAggregateInputType | true
    _min?: VendorMinAggregateInputType
    _max?: VendorMaxAggregateInputType
  }

  export type VendorGroupByOutputType = {
    id: string
    name: string
    created_at: Date
    updated_at: Date
    _count: VendorCountAggregateOutputType | null
    _min: VendorMinAggregateOutputType | null
    _max: VendorMaxAggregateOutputType | null
  }

  type GetVendorGroupByPayload<T extends VendorGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<VendorGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof VendorGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], VendorGroupByOutputType[P]>
            : GetScalarType<T[P], VendorGroupByOutputType[P]>
        }
      >
    >


  export type VendorSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    created_at?: boolean
    updated_at?: boolean
    Hotels?: boolean | Vendor$HotelsArgs<ExtArgs>
    MitraPackages?: boolean | Vendor$MitraPackagesArgs<ExtArgs>
    _count?: boolean | VendorCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["vendor"]>


  export type VendorSelectScalar = {
    id?: boolean
    name?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type VendorInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Hotels?: boolean | Vendor$HotelsArgs<ExtArgs>
    MitraPackages?: boolean | Vendor$MitraPackagesArgs<ExtArgs>
    _count?: boolean | VendorCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $VendorPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Vendor"
    objects: {
      Hotels: Prisma.$HotelPayload<ExtArgs>[]
      MitraPackages: Prisma.$MitraPackagePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["vendor"]>
    composites: {}
  }

  type VendorGetPayload<S extends boolean | null | undefined | VendorDefaultArgs> = $Result.GetResult<Prisma.$VendorPayload, S>

  type VendorCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<VendorFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: VendorCountAggregateInputType | true
    }

  export interface VendorDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Vendor'], meta: { name: 'Vendor' } }
    /**
     * Find zero or one Vendor that matches the filter.
     * @param {VendorFindUniqueArgs} args - Arguments to find a Vendor
     * @example
     * // Get one Vendor
     * const vendor = await prisma.vendor.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends VendorFindUniqueArgs>(args: SelectSubset<T, VendorFindUniqueArgs<ExtArgs>>): Prisma__VendorClient<$Result.GetResult<Prisma.$VendorPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Vendor that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {VendorFindUniqueOrThrowArgs} args - Arguments to find a Vendor
     * @example
     * // Get one Vendor
     * const vendor = await prisma.vendor.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends VendorFindUniqueOrThrowArgs>(args: SelectSubset<T, VendorFindUniqueOrThrowArgs<ExtArgs>>): Prisma__VendorClient<$Result.GetResult<Prisma.$VendorPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Vendor that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VendorFindFirstArgs} args - Arguments to find a Vendor
     * @example
     * // Get one Vendor
     * const vendor = await prisma.vendor.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends VendorFindFirstArgs>(args?: SelectSubset<T, VendorFindFirstArgs<ExtArgs>>): Prisma__VendorClient<$Result.GetResult<Prisma.$VendorPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Vendor that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VendorFindFirstOrThrowArgs} args - Arguments to find a Vendor
     * @example
     * // Get one Vendor
     * const vendor = await prisma.vendor.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends VendorFindFirstOrThrowArgs>(args?: SelectSubset<T, VendorFindFirstOrThrowArgs<ExtArgs>>): Prisma__VendorClient<$Result.GetResult<Prisma.$VendorPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Vendors that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VendorFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Vendors
     * const vendors = await prisma.vendor.findMany()
     * 
     * // Get first 10 Vendors
     * const vendors = await prisma.vendor.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const vendorWithIdOnly = await prisma.vendor.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends VendorFindManyArgs>(args?: SelectSubset<T, VendorFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$VendorPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Vendor.
     * @param {VendorCreateArgs} args - Arguments to create a Vendor.
     * @example
     * // Create one Vendor
     * const Vendor = await prisma.vendor.create({
     *   data: {
     *     // ... data to create a Vendor
     *   }
     * })
     * 
     */
    create<T extends VendorCreateArgs>(args: SelectSubset<T, VendorCreateArgs<ExtArgs>>): Prisma__VendorClient<$Result.GetResult<Prisma.$VendorPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Vendors.
     * @param {VendorCreateManyArgs} args - Arguments to create many Vendors.
     * @example
     * // Create many Vendors
     * const vendor = await prisma.vendor.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends VendorCreateManyArgs>(args?: SelectSubset<T, VendorCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Vendor.
     * @param {VendorDeleteArgs} args - Arguments to delete one Vendor.
     * @example
     * // Delete one Vendor
     * const Vendor = await prisma.vendor.delete({
     *   where: {
     *     // ... filter to delete one Vendor
     *   }
     * })
     * 
     */
    delete<T extends VendorDeleteArgs>(args: SelectSubset<T, VendorDeleteArgs<ExtArgs>>): Prisma__VendorClient<$Result.GetResult<Prisma.$VendorPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Vendor.
     * @param {VendorUpdateArgs} args - Arguments to update one Vendor.
     * @example
     * // Update one Vendor
     * const vendor = await prisma.vendor.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends VendorUpdateArgs>(args: SelectSubset<T, VendorUpdateArgs<ExtArgs>>): Prisma__VendorClient<$Result.GetResult<Prisma.$VendorPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Vendors.
     * @param {VendorDeleteManyArgs} args - Arguments to filter Vendors to delete.
     * @example
     * // Delete a few Vendors
     * const { count } = await prisma.vendor.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends VendorDeleteManyArgs>(args?: SelectSubset<T, VendorDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Vendors.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VendorUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Vendors
     * const vendor = await prisma.vendor.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends VendorUpdateManyArgs>(args: SelectSubset<T, VendorUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Vendor.
     * @param {VendorUpsertArgs} args - Arguments to update or create a Vendor.
     * @example
     * // Update or create a Vendor
     * const vendor = await prisma.vendor.upsert({
     *   create: {
     *     // ... data to create a Vendor
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Vendor we want to update
     *   }
     * })
     */
    upsert<T extends VendorUpsertArgs>(args: SelectSubset<T, VendorUpsertArgs<ExtArgs>>): Prisma__VendorClient<$Result.GetResult<Prisma.$VendorPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Vendors.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VendorCountArgs} args - Arguments to filter Vendors to count.
     * @example
     * // Count the number of Vendors
     * const count = await prisma.vendor.count({
     *   where: {
     *     // ... the filter for the Vendors we want to count
     *   }
     * })
    **/
    count<T extends VendorCountArgs>(
      args?: Subset<T, VendorCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], VendorCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Vendor.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VendorAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends VendorAggregateArgs>(args: Subset<T, VendorAggregateArgs>): Prisma.PrismaPromise<GetVendorAggregateType<T>>

    /**
     * Group by Vendor.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VendorGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends VendorGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: VendorGroupByArgs['orderBy'] }
        : { orderBy?: VendorGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, VendorGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetVendorGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Vendor model
   */
  readonly fields: VendorFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Vendor.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__VendorClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    Hotels<T extends Vendor$HotelsArgs<ExtArgs> = {}>(args?: Subset<T, Vendor$HotelsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$HotelPayload<ExtArgs>, T, "findMany"> | Null>
    MitraPackages<T extends Vendor$MitraPackagesArgs<ExtArgs> = {}>(args?: Subset<T, Vendor$MitraPackagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraPackagePayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Vendor model
   */ 
  interface VendorFieldRefs {
    readonly id: FieldRef<"Vendor", 'String'>
    readonly name: FieldRef<"Vendor", 'String'>
    readonly created_at: FieldRef<"Vendor", 'DateTime'>
    readonly updated_at: FieldRef<"Vendor", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Vendor findUnique
   */
  export type VendorFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Vendor
     */
    select?: VendorSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VendorInclude<ExtArgs> | null
    /**
     * Filter, which Vendor to fetch.
     */
    where: VendorWhereUniqueInput
  }

  /**
   * Vendor findUniqueOrThrow
   */
  export type VendorFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Vendor
     */
    select?: VendorSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VendorInclude<ExtArgs> | null
    /**
     * Filter, which Vendor to fetch.
     */
    where: VendorWhereUniqueInput
  }

  /**
   * Vendor findFirst
   */
  export type VendorFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Vendor
     */
    select?: VendorSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VendorInclude<ExtArgs> | null
    /**
     * Filter, which Vendor to fetch.
     */
    where?: VendorWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Vendors to fetch.
     */
    orderBy?: VendorOrderByWithRelationInput | VendorOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Vendors.
     */
    cursor?: VendorWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Vendors from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Vendors.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Vendors.
     */
    distinct?: VendorScalarFieldEnum | VendorScalarFieldEnum[]
  }

  /**
   * Vendor findFirstOrThrow
   */
  export type VendorFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Vendor
     */
    select?: VendorSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VendorInclude<ExtArgs> | null
    /**
     * Filter, which Vendor to fetch.
     */
    where?: VendorWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Vendors to fetch.
     */
    orderBy?: VendorOrderByWithRelationInput | VendorOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Vendors.
     */
    cursor?: VendorWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Vendors from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Vendors.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Vendors.
     */
    distinct?: VendorScalarFieldEnum | VendorScalarFieldEnum[]
  }

  /**
   * Vendor findMany
   */
  export type VendorFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Vendor
     */
    select?: VendorSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VendorInclude<ExtArgs> | null
    /**
     * Filter, which Vendors to fetch.
     */
    where?: VendorWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Vendors to fetch.
     */
    orderBy?: VendorOrderByWithRelationInput | VendorOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Vendors.
     */
    cursor?: VendorWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Vendors from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Vendors.
     */
    skip?: number
    distinct?: VendorScalarFieldEnum | VendorScalarFieldEnum[]
  }

  /**
   * Vendor create
   */
  export type VendorCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Vendor
     */
    select?: VendorSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VendorInclude<ExtArgs> | null
    /**
     * The data needed to create a Vendor.
     */
    data: XOR<VendorCreateInput, VendorUncheckedCreateInput>
  }

  /**
   * Vendor createMany
   */
  export type VendorCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Vendors.
     */
    data: VendorCreateManyInput | VendorCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Vendor update
   */
  export type VendorUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Vendor
     */
    select?: VendorSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VendorInclude<ExtArgs> | null
    /**
     * The data needed to update a Vendor.
     */
    data: XOR<VendorUpdateInput, VendorUncheckedUpdateInput>
    /**
     * Choose, which Vendor to update.
     */
    where: VendorWhereUniqueInput
  }

  /**
   * Vendor updateMany
   */
  export type VendorUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Vendors.
     */
    data: XOR<VendorUpdateManyMutationInput, VendorUncheckedUpdateManyInput>
    /**
     * Filter which Vendors to update
     */
    where?: VendorWhereInput
  }

  /**
   * Vendor upsert
   */
  export type VendorUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Vendor
     */
    select?: VendorSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VendorInclude<ExtArgs> | null
    /**
     * The filter to search for the Vendor to update in case it exists.
     */
    where: VendorWhereUniqueInput
    /**
     * In case the Vendor found by the `where` argument doesn't exist, create a new Vendor with this data.
     */
    create: XOR<VendorCreateInput, VendorUncheckedCreateInput>
    /**
     * In case the Vendor was found with the provided `where` argument, update it with this data.
     */
    update: XOR<VendorUpdateInput, VendorUncheckedUpdateInput>
  }

  /**
   * Vendor delete
   */
  export type VendorDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Vendor
     */
    select?: VendorSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VendorInclude<ExtArgs> | null
    /**
     * Filter which Vendor to delete.
     */
    where: VendorWhereUniqueInput
  }

  /**
   * Vendor deleteMany
   */
  export type VendorDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Vendors to delete
     */
    where?: VendorWhereInput
  }

  /**
   * Vendor.Hotels
   */
  export type Vendor$HotelsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hotel
     */
    select?: HotelSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelInclude<ExtArgs> | null
    where?: HotelWhereInput
    orderBy?: HotelOrderByWithRelationInput | HotelOrderByWithRelationInput[]
    cursor?: HotelWhereUniqueInput
    take?: number
    skip?: number
    distinct?: HotelScalarFieldEnum | HotelScalarFieldEnum[]
  }

  /**
   * Vendor.MitraPackages
   */
  export type Vendor$MitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraPackage
     */
    select?: MitraPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraPackageInclude<ExtArgs> | null
    where?: MitraPackageWhereInput
    orderBy?: MitraPackageOrderByWithRelationInput | MitraPackageOrderByWithRelationInput[]
    cursor?: MitraPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MitraPackageScalarFieldEnum | MitraPackageScalarFieldEnum[]
  }

  /**
   * Vendor without action
   */
  export type VendorDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Vendor
     */
    select?: VendorSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VendorInclude<ExtArgs> | null
  }


  /**
   * Model Hotel
   */

  export type AggregateHotel = {
    _count: HotelCountAggregateOutputType | null
    _avg: HotelAvgAggregateOutputType | null
    _sum: HotelSumAggregateOutputType | null
    _min: HotelMinAggregateOutputType | null
    _max: HotelMaxAggregateOutputType | null
  }

  export type HotelAvgAggregateOutputType = {
    order_number: number | null
  }

  export type HotelSumAggregateOutputType = {
    order_number: number | null
  }

  export type HotelMinAggregateOutputType = {
    id: string | null
    vendor_id: string | null
    name: string | null
    city: $Enums.City | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type HotelMaxAggregateOutputType = {
    id: string | null
    vendor_id: string | null
    name: string | null
    city: $Enums.City | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type HotelCountAggregateOutputType = {
    id: number
    vendor_id: number
    name: number
    city: number
    order_number: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type HotelAvgAggregateInputType = {
    order_number?: true
  }

  export type HotelSumAggregateInputType = {
    order_number?: true
  }

  export type HotelMinAggregateInputType = {
    id?: true
    vendor_id?: true
    name?: true
    city?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type HotelMaxAggregateInputType = {
    id?: true
    vendor_id?: true
    name?: true
    city?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type HotelCountAggregateInputType = {
    id?: true
    vendor_id?: true
    name?: true
    city?: true
    order_number?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type HotelAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Hotel to aggregate.
     */
    where?: HotelWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Hotels to fetch.
     */
    orderBy?: HotelOrderByWithRelationInput | HotelOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: HotelWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Hotels from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Hotels.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Hotels
    **/
    _count?: true | HotelCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: HotelAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: HotelSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: HotelMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: HotelMaxAggregateInputType
  }

  export type GetHotelAggregateType<T extends HotelAggregateArgs> = {
        [P in keyof T & keyof AggregateHotel]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateHotel[P]>
      : GetScalarType<T[P], AggregateHotel[P]>
  }




  export type HotelGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: HotelWhereInput
    orderBy?: HotelOrderByWithAggregationInput | HotelOrderByWithAggregationInput[]
    by: HotelScalarFieldEnum[] | HotelScalarFieldEnum
    having?: HotelScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: HotelCountAggregateInputType | true
    _avg?: HotelAvgAggregateInputType
    _sum?: HotelSumAggregateInputType
    _min?: HotelMinAggregateInputType
    _max?: HotelMaxAggregateInputType
  }

  export type HotelGroupByOutputType = {
    id: string
    vendor_id: string
    name: string
    city: $Enums.City
    order_number: number
    created_at: Date
    updated_at: Date
    _count: HotelCountAggregateOutputType | null
    _avg: HotelAvgAggregateOutputType | null
    _sum: HotelSumAggregateOutputType | null
    _min: HotelMinAggregateOutputType | null
    _max: HotelMaxAggregateOutputType | null
  }

  type GetHotelGroupByPayload<T extends HotelGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<HotelGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof HotelGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], HotelGroupByOutputType[P]>
            : GetScalarType<T[P], HotelGroupByOutputType[P]>
        }
      >
    >


  export type HotelSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    vendor_id?: boolean
    name?: boolean
    city?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
    Vendor?: boolean | VendorDefaultArgs<ExtArgs>
    HotelPeriodPrices?: boolean | Hotel$HotelPeriodPricesArgs<ExtArgs>
    MitraPackagesMekkah?: boolean | Hotel$MitraPackagesMekkahArgs<ExtArgs>
    MitraPackagesMadinah?: boolean | Hotel$MitraPackagesMadinahArgs<ExtArgs>
    _count?: boolean | HotelCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["hotel"]>


  export type HotelSelectScalar = {
    id?: boolean
    vendor_id?: boolean
    name?: boolean
    city?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type HotelInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Vendor?: boolean | VendorDefaultArgs<ExtArgs>
    HotelPeriodPrices?: boolean | Hotel$HotelPeriodPricesArgs<ExtArgs>
    MitraPackagesMekkah?: boolean | Hotel$MitraPackagesMekkahArgs<ExtArgs>
    MitraPackagesMadinah?: boolean | Hotel$MitraPackagesMadinahArgs<ExtArgs>
    _count?: boolean | HotelCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $HotelPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Hotel"
    objects: {
      Vendor: Prisma.$VendorPayload<ExtArgs>
      HotelPeriodPrices: Prisma.$HotelPeriodPricePayload<ExtArgs>[]
      MitraPackagesMekkah: Prisma.$MitraPackagePayload<ExtArgs>[]
      MitraPackagesMadinah: Prisma.$MitraPackagePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      vendor_id: string
      name: string
      city: $Enums.City
      order_number: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["hotel"]>
    composites: {}
  }

  type HotelGetPayload<S extends boolean | null | undefined | HotelDefaultArgs> = $Result.GetResult<Prisma.$HotelPayload, S>

  type HotelCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<HotelFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: HotelCountAggregateInputType | true
    }

  export interface HotelDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Hotel'], meta: { name: 'Hotel' } }
    /**
     * Find zero or one Hotel that matches the filter.
     * @param {HotelFindUniqueArgs} args - Arguments to find a Hotel
     * @example
     * // Get one Hotel
     * const hotel = await prisma.hotel.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends HotelFindUniqueArgs>(args: SelectSubset<T, HotelFindUniqueArgs<ExtArgs>>): Prisma__HotelClient<$Result.GetResult<Prisma.$HotelPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Hotel that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {HotelFindUniqueOrThrowArgs} args - Arguments to find a Hotel
     * @example
     * // Get one Hotel
     * const hotel = await prisma.hotel.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends HotelFindUniqueOrThrowArgs>(args: SelectSubset<T, HotelFindUniqueOrThrowArgs<ExtArgs>>): Prisma__HotelClient<$Result.GetResult<Prisma.$HotelPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Hotel that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelFindFirstArgs} args - Arguments to find a Hotel
     * @example
     * // Get one Hotel
     * const hotel = await prisma.hotel.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends HotelFindFirstArgs>(args?: SelectSubset<T, HotelFindFirstArgs<ExtArgs>>): Prisma__HotelClient<$Result.GetResult<Prisma.$HotelPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Hotel that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelFindFirstOrThrowArgs} args - Arguments to find a Hotel
     * @example
     * // Get one Hotel
     * const hotel = await prisma.hotel.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends HotelFindFirstOrThrowArgs>(args?: SelectSubset<T, HotelFindFirstOrThrowArgs<ExtArgs>>): Prisma__HotelClient<$Result.GetResult<Prisma.$HotelPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Hotels that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Hotels
     * const hotels = await prisma.hotel.findMany()
     * 
     * // Get first 10 Hotels
     * const hotels = await prisma.hotel.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const hotelWithIdOnly = await prisma.hotel.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends HotelFindManyArgs>(args?: SelectSubset<T, HotelFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$HotelPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Hotel.
     * @param {HotelCreateArgs} args - Arguments to create a Hotel.
     * @example
     * // Create one Hotel
     * const Hotel = await prisma.hotel.create({
     *   data: {
     *     // ... data to create a Hotel
     *   }
     * })
     * 
     */
    create<T extends HotelCreateArgs>(args: SelectSubset<T, HotelCreateArgs<ExtArgs>>): Prisma__HotelClient<$Result.GetResult<Prisma.$HotelPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Hotels.
     * @param {HotelCreateManyArgs} args - Arguments to create many Hotels.
     * @example
     * // Create many Hotels
     * const hotel = await prisma.hotel.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends HotelCreateManyArgs>(args?: SelectSubset<T, HotelCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Hotel.
     * @param {HotelDeleteArgs} args - Arguments to delete one Hotel.
     * @example
     * // Delete one Hotel
     * const Hotel = await prisma.hotel.delete({
     *   where: {
     *     // ... filter to delete one Hotel
     *   }
     * })
     * 
     */
    delete<T extends HotelDeleteArgs>(args: SelectSubset<T, HotelDeleteArgs<ExtArgs>>): Prisma__HotelClient<$Result.GetResult<Prisma.$HotelPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Hotel.
     * @param {HotelUpdateArgs} args - Arguments to update one Hotel.
     * @example
     * // Update one Hotel
     * const hotel = await prisma.hotel.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends HotelUpdateArgs>(args: SelectSubset<T, HotelUpdateArgs<ExtArgs>>): Prisma__HotelClient<$Result.GetResult<Prisma.$HotelPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Hotels.
     * @param {HotelDeleteManyArgs} args - Arguments to filter Hotels to delete.
     * @example
     * // Delete a few Hotels
     * const { count } = await prisma.hotel.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends HotelDeleteManyArgs>(args?: SelectSubset<T, HotelDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Hotels.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Hotels
     * const hotel = await prisma.hotel.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends HotelUpdateManyArgs>(args: SelectSubset<T, HotelUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Hotel.
     * @param {HotelUpsertArgs} args - Arguments to update or create a Hotel.
     * @example
     * // Update or create a Hotel
     * const hotel = await prisma.hotel.upsert({
     *   create: {
     *     // ... data to create a Hotel
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Hotel we want to update
     *   }
     * })
     */
    upsert<T extends HotelUpsertArgs>(args: SelectSubset<T, HotelUpsertArgs<ExtArgs>>): Prisma__HotelClient<$Result.GetResult<Prisma.$HotelPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Hotels.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelCountArgs} args - Arguments to filter Hotels to count.
     * @example
     * // Count the number of Hotels
     * const count = await prisma.hotel.count({
     *   where: {
     *     // ... the filter for the Hotels we want to count
     *   }
     * })
    **/
    count<T extends HotelCountArgs>(
      args?: Subset<T, HotelCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], HotelCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Hotel.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends HotelAggregateArgs>(args: Subset<T, HotelAggregateArgs>): Prisma.PrismaPromise<GetHotelAggregateType<T>>

    /**
     * Group by Hotel.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends HotelGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: HotelGroupByArgs['orderBy'] }
        : { orderBy?: HotelGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, HotelGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetHotelGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Hotel model
   */
  readonly fields: HotelFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Hotel.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__HotelClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    Vendor<T extends VendorDefaultArgs<ExtArgs> = {}>(args?: Subset<T, VendorDefaultArgs<ExtArgs>>): Prisma__VendorClient<$Result.GetResult<Prisma.$VendorPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    HotelPeriodPrices<T extends Hotel$HotelPeriodPricesArgs<ExtArgs> = {}>(args?: Subset<T, Hotel$HotelPeriodPricesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$HotelPeriodPricePayload<ExtArgs>, T, "findMany"> | Null>
    MitraPackagesMekkah<T extends Hotel$MitraPackagesMekkahArgs<ExtArgs> = {}>(args?: Subset<T, Hotel$MitraPackagesMekkahArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraPackagePayload<ExtArgs>, T, "findMany"> | Null>
    MitraPackagesMadinah<T extends Hotel$MitraPackagesMadinahArgs<ExtArgs> = {}>(args?: Subset<T, Hotel$MitraPackagesMadinahArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraPackagePayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Hotel model
   */ 
  interface HotelFieldRefs {
    readonly id: FieldRef<"Hotel", 'String'>
    readonly vendor_id: FieldRef<"Hotel", 'String'>
    readonly name: FieldRef<"Hotel", 'String'>
    readonly city: FieldRef<"Hotel", 'City'>
    readonly order_number: FieldRef<"Hotel", 'Int'>
    readonly created_at: FieldRef<"Hotel", 'DateTime'>
    readonly updated_at: FieldRef<"Hotel", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Hotel findUnique
   */
  export type HotelFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hotel
     */
    select?: HotelSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelInclude<ExtArgs> | null
    /**
     * Filter, which Hotel to fetch.
     */
    where: HotelWhereUniqueInput
  }

  /**
   * Hotel findUniqueOrThrow
   */
  export type HotelFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hotel
     */
    select?: HotelSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelInclude<ExtArgs> | null
    /**
     * Filter, which Hotel to fetch.
     */
    where: HotelWhereUniqueInput
  }

  /**
   * Hotel findFirst
   */
  export type HotelFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hotel
     */
    select?: HotelSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelInclude<ExtArgs> | null
    /**
     * Filter, which Hotel to fetch.
     */
    where?: HotelWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Hotels to fetch.
     */
    orderBy?: HotelOrderByWithRelationInput | HotelOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Hotels.
     */
    cursor?: HotelWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Hotels from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Hotels.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Hotels.
     */
    distinct?: HotelScalarFieldEnum | HotelScalarFieldEnum[]
  }

  /**
   * Hotel findFirstOrThrow
   */
  export type HotelFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hotel
     */
    select?: HotelSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelInclude<ExtArgs> | null
    /**
     * Filter, which Hotel to fetch.
     */
    where?: HotelWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Hotels to fetch.
     */
    orderBy?: HotelOrderByWithRelationInput | HotelOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Hotels.
     */
    cursor?: HotelWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Hotels from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Hotels.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Hotels.
     */
    distinct?: HotelScalarFieldEnum | HotelScalarFieldEnum[]
  }

  /**
   * Hotel findMany
   */
  export type HotelFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hotel
     */
    select?: HotelSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelInclude<ExtArgs> | null
    /**
     * Filter, which Hotels to fetch.
     */
    where?: HotelWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Hotels to fetch.
     */
    orderBy?: HotelOrderByWithRelationInput | HotelOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Hotels.
     */
    cursor?: HotelWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Hotels from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Hotels.
     */
    skip?: number
    distinct?: HotelScalarFieldEnum | HotelScalarFieldEnum[]
  }

  /**
   * Hotel create
   */
  export type HotelCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hotel
     */
    select?: HotelSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelInclude<ExtArgs> | null
    /**
     * The data needed to create a Hotel.
     */
    data: XOR<HotelCreateInput, HotelUncheckedCreateInput>
  }

  /**
   * Hotel createMany
   */
  export type HotelCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Hotels.
     */
    data: HotelCreateManyInput | HotelCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Hotel update
   */
  export type HotelUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hotel
     */
    select?: HotelSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelInclude<ExtArgs> | null
    /**
     * The data needed to update a Hotel.
     */
    data: XOR<HotelUpdateInput, HotelUncheckedUpdateInput>
    /**
     * Choose, which Hotel to update.
     */
    where: HotelWhereUniqueInput
  }

  /**
   * Hotel updateMany
   */
  export type HotelUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Hotels.
     */
    data: XOR<HotelUpdateManyMutationInput, HotelUncheckedUpdateManyInput>
    /**
     * Filter which Hotels to update
     */
    where?: HotelWhereInput
  }

  /**
   * Hotel upsert
   */
  export type HotelUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hotel
     */
    select?: HotelSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelInclude<ExtArgs> | null
    /**
     * The filter to search for the Hotel to update in case it exists.
     */
    where: HotelWhereUniqueInput
    /**
     * In case the Hotel found by the `where` argument doesn't exist, create a new Hotel with this data.
     */
    create: XOR<HotelCreateInput, HotelUncheckedCreateInput>
    /**
     * In case the Hotel was found with the provided `where` argument, update it with this data.
     */
    update: XOR<HotelUpdateInput, HotelUncheckedUpdateInput>
  }

  /**
   * Hotel delete
   */
  export type HotelDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hotel
     */
    select?: HotelSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelInclude<ExtArgs> | null
    /**
     * Filter which Hotel to delete.
     */
    where: HotelWhereUniqueInput
  }

  /**
   * Hotel deleteMany
   */
  export type HotelDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Hotels to delete
     */
    where?: HotelWhereInput
  }

  /**
   * Hotel.HotelPeriodPrices
   */
  export type Hotel$HotelPeriodPricesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HotelPeriodPrice
     */
    select?: HotelPeriodPriceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelPeriodPriceInclude<ExtArgs> | null
    where?: HotelPeriodPriceWhereInput
    orderBy?: HotelPeriodPriceOrderByWithRelationInput | HotelPeriodPriceOrderByWithRelationInput[]
    cursor?: HotelPeriodPriceWhereUniqueInput
    take?: number
    skip?: number
    distinct?: HotelPeriodPriceScalarFieldEnum | HotelPeriodPriceScalarFieldEnum[]
  }

  /**
   * Hotel.MitraPackagesMekkah
   */
  export type Hotel$MitraPackagesMekkahArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraPackage
     */
    select?: MitraPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraPackageInclude<ExtArgs> | null
    where?: MitraPackageWhereInput
    orderBy?: MitraPackageOrderByWithRelationInput | MitraPackageOrderByWithRelationInput[]
    cursor?: MitraPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MitraPackageScalarFieldEnum | MitraPackageScalarFieldEnum[]
  }

  /**
   * Hotel.MitraPackagesMadinah
   */
  export type Hotel$MitraPackagesMadinahArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraPackage
     */
    select?: MitraPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraPackageInclude<ExtArgs> | null
    where?: MitraPackageWhereInput
    orderBy?: MitraPackageOrderByWithRelationInput | MitraPackageOrderByWithRelationInput[]
    cursor?: MitraPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MitraPackageScalarFieldEnum | MitraPackageScalarFieldEnum[]
  }

  /**
   * Hotel without action
   */
  export type HotelDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hotel
     */
    select?: HotelSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelInclude<ExtArgs> | null
  }


  /**
   * Model Period
   */

  export type AggregatePeriod = {
    _count: PeriodCountAggregateOutputType | null
    _min: PeriodMinAggregateOutputType | null
    _max: PeriodMaxAggregateOutputType | null
  }

  export type PeriodMinAggregateOutputType = {
    id: string | null
    category: $Enums.PeriodCategory | null
    start_date: Date | null
    end_date: Date | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type PeriodMaxAggregateOutputType = {
    id: string | null
    category: $Enums.PeriodCategory | null
    start_date: Date | null
    end_date: Date | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type PeriodCountAggregateOutputType = {
    id: number
    category: number
    start_date: number
    end_date: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type PeriodMinAggregateInputType = {
    id?: true
    category?: true
    start_date?: true
    end_date?: true
    created_at?: true
    updated_at?: true
  }

  export type PeriodMaxAggregateInputType = {
    id?: true
    category?: true
    start_date?: true
    end_date?: true
    created_at?: true
    updated_at?: true
  }

  export type PeriodCountAggregateInputType = {
    id?: true
    category?: true
    start_date?: true
    end_date?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type PeriodAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Period to aggregate.
     */
    where?: PeriodWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Periods to fetch.
     */
    orderBy?: PeriodOrderByWithRelationInput | PeriodOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: PeriodWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Periods from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Periods.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Periods
    **/
    _count?: true | PeriodCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: PeriodMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: PeriodMaxAggregateInputType
  }

  export type GetPeriodAggregateType<T extends PeriodAggregateArgs> = {
        [P in keyof T & keyof AggregatePeriod]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregatePeriod[P]>
      : GetScalarType<T[P], AggregatePeriod[P]>
  }




  export type PeriodGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PeriodWhereInput
    orderBy?: PeriodOrderByWithAggregationInput | PeriodOrderByWithAggregationInput[]
    by: PeriodScalarFieldEnum[] | PeriodScalarFieldEnum
    having?: PeriodScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: PeriodCountAggregateInputType | true
    _min?: PeriodMinAggregateInputType
    _max?: PeriodMaxAggregateInputType
  }

  export type PeriodGroupByOutputType = {
    id: string
    category: $Enums.PeriodCategory
    start_date: Date
    end_date: Date
    created_at: Date
    updated_at: Date
    _count: PeriodCountAggregateOutputType | null
    _min: PeriodMinAggregateOutputType | null
    _max: PeriodMaxAggregateOutputType | null
  }

  type GetPeriodGroupByPayload<T extends PeriodGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<PeriodGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof PeriodGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], PeriodGroupByOutputType[P]>
            : GetScalarType<T[P], PeriodGroupByOutputType[P]>
        }
      >
    >


  export type PeriodSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category?: boolean
    start_date?: boolean
    end_date?: boolean
    created_at?: boolean
    updated_at?: boolean
    HotelPeriodPrices?: boolean | Period$HotelPeriodPricesArgs<ExtArgs>
    MitraPackages?: boolean | Period$MitraPackagesArgs<ExtArgs>
    _count?: boolean | PeriodCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["period"]>


  export type PeriodSelectScalar = {
    id?: boolean
    category?: boolean
    start_date?: boolean
    end_date?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type PeriodInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    HotelPeriodPrices?: boolean | Period$HotelPeriodPricesArgs<ExtArgs>
    MitraPackages?: boolean | Period$MitraPackagesArgs<ExtArgs>
    _count?: boolean | PeriodCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $PeriodPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Period"
    objects: {
      HotelPeriodPrices: Prisma.$HotelPeriodPricePayload<ExtArgs>[]
      MitraPackages: Prisma.$MitraPackagePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      category: $Enums.PeriodCategory
      start_date: Date
      end_date: Date
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["period"]>
    composites: {}
  }

  type PeriodGetPayload<S extends boolean | null | undefined | PeriodDefaultArgs> = $Result.GetResult<Prisma.$PeriodPayload, S>

  type PeriodCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<PeriodFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: PeriodCountAggregateInputType | true
    }

  export interface PeriodDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Period'], meta: { name: 'Period' } }
    /**
     * Find zero or one Period that matches the filter.
     * @param {PeriodFindUniqueArgs} args - Arguments to find a Period
     * @example
     * // Get one Period
     * const period = await prisma.period.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends PeriodFindUniqueArgs>(args: SelectSubset<T, PeriodFindUniqueArgs<ExtArgs>>): Prisma__PeriodClient<$Result.GetResult<Prisma.$PeriodPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Period that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {PeriodFindUniqueOrThrowArgs} args - Arguments to find a Period
     * @example
     * // Get one Period
     * const period = await prisma.period.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends PeriodFindUniqueOrThrowArgs>(args: SelectSubset<T, PeriodFindUniqueOrThrowArgs<ExtArgs>>): Prisma__PeriodClient<$Result.GetResult<Prisma.$PeriodPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Period that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PeriodFindFirstArgs} args - Arguments to find a Period
     * @example
     * // Get one Period
     * const period = await prisma.period.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends PeriodFindFirstArgs>(args?: SelectSubset<T, PeriodFindFirstArgs<ExtArgs>>): Prisma__PeriodClient<$Result.GetResult<Prisma.$PeriodPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Period that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PeriodFindFirstOrThrowArgs} args - Arguments to find a Period
     * @example
     * // Get one Period
     * const period = await prisma.period.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends PeriodFindFirstOrThrowArgs>(args?: SelectSubset<T, PeriodFindFirstOrThrowArgs<ExtArgs>>): Prisma__PeriodClient<$Result.GetResult<Prisma.$PeriodPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Periods that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PeriodFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Periods
     * const periods = await prisma.period.findMany()
     * 
     * // Get first 10 Periods
     * const periods = await prisma.period.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const periodWithIdOnly = await prisma.period.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends PeriodFindManyArgs>(args?: SelectSubset<T, PeriodFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$PeriodPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Period.
     * @param {PeriodCreateArgs} args - Arguments to create a Period.
     * @example
     * // Create one Period
     * const Period = await prisma.period.create({
     *   data: {
     *     // ... data to create a Period
     *   }
     * })
     * 
     */
    create<T extends PeriodCreateArgs>(args: SelectSubset<T, PeriodCreateArgs<ExtArgs>>): Prisma__PeriodClient<$Result.GetResult<Prisma.$PeriodPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Periods.
     * @param {PeriodCreateManyArgs} args - Arguments to create many Periods.
     * @example
     * // Create many Periods
     * const period = await prisma.period.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends PeriodCreateManyArgs>(args?: SelectSubset<T, PeriodCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Period.
     * @param {PeriodDeleteArgs} args - Arguments to delete one Period.
     * @example
     * // Delete one Period
     * const Period = await prisma.period.delete({
     *   where: {
     *     // ... filter to delete one Period
     *   }
     * })
     * 
     */
    delete<T extends PeriodDeleteArgs>(args: SelectSubset<T, PeriodDeleteArgs<ExtArgs>>): Prisma__PeriodClient<$Result.GetResult<Prisma.$PeriodPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Period.
     * @param {PeriodUpdateArgs} args - Arguments to update one Period.
     * @example
     * // Update one Period
     * const period = await prisma.period.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends PeriodUpdateArgs>(args: SelectSubset<T, PeriodUpdateArgs<ExtArgs>>): Prisma__PeriodClient<$Result.GetResult<Prisma.$PeriodPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Periods.
     * @param {PeriodDeleteManyArgs} args - Arguments to filter Periods to delete.
     * @example
     * // Delete a few Periods
     * const { count } = await prisma.period.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends PeriodDeleteManyArgs>(args?: SelectSubset<T, PeriodDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Periods.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PeriodUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Periods
     * const period = await prisma.period.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends PeriodUpdateManyArgs>(args: SelectSubset<T, PeriodUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Period.
     * @param {PeriodUpsertArgs} args - Arguments to update or create a Period.
     * @example
     * // Update or create a Period
     * const period = await prisma.period.upsert({
     *   create: {
     *     // ... data to create a Period
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Period we want to update
     *   }
     * })
     */
    upsert<T extends PeriodUpsertArgs>(args: SelectSubset<T, PeriodUpsertArgs<ExtArgs>>): Prisma__PeriodClient<$Result.GetResult<Prisma.$PeriodPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Periods.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PeriodCountArgs} args - Arguments to filter Periods to count.
     * @example
     * // Count the number of Periods
     * const count = await prisma.period.count({
     *   where: {
     *     // ... the filter for the Periods we want to count
     *   }
     * })
    **/
    count<T extends PeriodCountArgs>(
      args?: Subset<T, PeriodCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], PeriodCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Period.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PeriodAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends PeriodAggregateArgs>(args: Subset<T, PeriodAggregateArgs>): Prisma.PrismaPromise<GetPeriodAggregateType<T>>

    /**
     * Group by Period.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PeriodGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends PeriodGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: PeriodGroupByArgs['orderBy'] }
        : { orderBy?: PeriodGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, PeriodGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetPeriodGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Period model
   */
  readonly fields: PeriodFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Period.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__PeriodClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    HotelPeriodPrices<T extends Period$HotelPeriodPricesArgs<ExtArgs> = {}>(args?: Subset<T, Period$HotelPeriodPricesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$HotelPeriodPricePayload<ExtArgs>, T, "findMany"> | Null>
    MitraPackages<T extends Period$MitraPackagesArgs<ExtArgs> = {}>(args?: Subset<T, Period$MitraPackagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraPackagePayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Period model
   */ 
  interface PeriodFieldRefs {
    readonly id: FieldRef<"Period", 'String'>
    readonly category: FieldRef<"Period", 'PeriodCategory'>
    readonly start_date: FieldRef<"Period", 'DateTime'>
    readonly end_date: FieldRef<"Period", 'DateTime'>
    readonly created_at: FieldRef<"Period", 'DateTime'>
    readonly updated_at: FieldRef<"Period", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Period findUnique
   */
  export type PeriodFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Period
     */
    select?: PeriodSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PeriodInclude<ExtArgs> | null
    /**
     * Filter, which Period to fetch.
     */
    where: PeriodWhereUniqueInput
  }

  /**
   * Period findUniqueOrThrow
   */
  export type PeriodFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Period
     */
    select?: PeriodSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PeriodInclude<ExtArgs> | null
    /**
     * Filter, which Period to fetch.
     */
    where: PeriodWhereUniqueInput
  }

  /**
   * Period findFirst
   */
  export type PeriodFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Period
     */
    select?: PeriodSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PeriodInclude<ExtArgs> | null
    /**
     * Filter, which Period to fetch.
     */
    where?: PeriodWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Periods to fetch.
     */
    orderBy?: PeriodOrderByWithRelationInput | PeriodOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Periods.
     */
    cursor?: PeriodWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Periods from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Periods.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Periods.
     */
    distinct?: PeriodScalarFieldEnum | PeriodScalarFieldEnum[]
  }

  /**
   * Period findFirstOrThrow
   */
  export type PeriodFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Period
     */
    select?: PeriodSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PeriodInclude<ExtArgs> | null
    /**
     * Filter, which Period to fetch.
     */
    where?: PeriodWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Periods to fetch.
     */
    orderBy?: PeriodOrderByWithRelationInput | PeriodOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Periods.
     */
    cursor?: PeriodWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Periods from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Periods.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Periods.
     */
    distinct?: PeriodScalarFieldEnum | PeriodScalarFieldEnum[]
  }

  /**
   * Period findMany
   */
  export type PeriodFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Period
     */
    select?: PeriodSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PeriodInclude<ExtArgs> | null
    /**
     * Filter, which Periods to fetch.
     */
    where?: PeriodWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Periods to fetch.
     */
    orderBy?: PeriodOrderByWithRelationInput | PeriodOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Periods.
     */
    cursor?: PeriodWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Periods from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Periods.
     */
    skip?: number
    distinct?: PeriodScalarFieldEnum | PeriodScalarFieldEnum[]
  }

  /**
   * Period create
   */
  export type PeriodCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Period
     */
    select?: PeriodSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PeriodInclude<ExtArgs> | null
    /**
     * The data needed to create a Period.
     */
    data: XOR<PeriodCreateInput, PeriodUncheckedCreateInput>
  }

  /**
   * Period createMany
   */
  export type PeriodCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Periods.
     */
    data: PeriodCreateManyInput | PeriodCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Period update
   */
  export type PeriodUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Period
     */
    select?: PeriodSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PeriodInclude<ExtArgs> | null
    /**
     * The data needed to update a Period.
     */
    data: XOR<PeriodUpdateInput, PeriodUncheckedUpdateInput>
    /**
     * Choose, which Period to update.
     */
    where: PeriodWhereUniqueInput
  }

  /**
   * Period updateMany
   */
  export type PeriodUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Periods.
     */
    data: XOR<PeriodUpdateManyMutationInput, PeriodUncheckedUpdateManyInput>
    /**
     * Filter which Periods to update
     */
    where?: PeriodWhereInput
  }

  /**
   * Period upsert
   */
  export type PeriodUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Period
     */
    select?: PeriodSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PeriodInclude<ExtArgs> | null
    /**
     * The filter to search for the Period to update in case it exists.
     */
    where: PeriodWhereUniqueInput
    /**
     * In case the Period found by the `where` argument doesn't exist, create a new Period with this data.
     */
    create: XOR<PeriodCreateInput, PeriodUncheckedCreateInput>
    /**
     * In case the Period was found with the provided `where` argument, update it with this data.
     */
    update: XOR<PeriodUpdateInput, PeriodUncheckedUpdateInput>
  }

  /**
   * Period delete
   */
  export type PeriodDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Period
     */
    select?: PeriodSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PeriodInclude<ExtArgs> | null
    /**
     * Filter which Period to delete.
     */
    where: PeriodWhereUniqueInput
  }

  /**
   * Period deleteMany
   */
  export type PeriodDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Periods to delete
     */
    where?: PeriodWhereInput
  }

  /**
   * Period.HotelPeriodPrices
   */
  export type Period$HotelPeriodPricesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HotelPeriodPrice
     */
    select?: HotelPeriodPriceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelPeriodPriceInclude<ExtArgs> | null
    where?: HotelPeriodPriceWhereInput
    orderBy?: HotelPeriodPriceOrderByWithRelationInput | HotelPeriodPriceOrderByWithRelationInput[]
    cursor?: HotelPeriodPriceWhereUniqueInput
    take?: number
    skip?: number
    distinct?: HotelPeriodPriceScalarFieldEnum | HotelPeriodPriceScalarFieldEnum[]
  }

  /**
   * Period.MitraPackages
   */
  export type Period$MitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraPackage
     */
    select?: MitraPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraPackageInclude<ExtArgs> | null
    where?: MitraPackageWhereInput
    orderBy?: MitraPackageOrderByWithRelationInput | MitraPackageOrderByWithRelationInput[]
    cursor?: MitraPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MitraPackageScalarFieldEnum | MitraPackageScalarFieldEnum[]
  }

  /**
   * Period without action
   */
  export type PeriodDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Period
     */
    select?: PeriodSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PeriodInclude<ExtArgs> | null
  }


  /**
   * Model HotelPeriodPrice
   */

  export type AggregateHotelPeriodPrice = {
    _count: HotelPeriodPriceCountAggregateOutputType | null
    _avg: HotelPeriodPriceAvgAggregateOutputType | null
    _sum: HotelPeriodPriceSumAggregateOutputType | null
    _min: HotelPeriodPriceMinAggregateOutputType | null
    _max: HotelPeriodPriceMaxAggregateOutputType | null
  }

  export type HotelPeriodPriceAvgAggregateOutputType = {
    price_double: Decimal | null
    price_triple: Decimal | null
    price_quad: Decimal | null
  }

  export type HotelPeriodPriceSumAggregateOutputType = {
    price_double: Decimal | null
    price_triple: Decimal | null
    price_quad: Decimal | null
  }

  export type HotelPeriodPriceMinAggregateOutputType = {
    id: string | null
    hotel_id: string | null
    period_id: string | null
    price_double: Decimal | null
    price_triple: Decimal | null
    price_quad: Decimal | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type HotelPeriodPriceMaxAggregateOutputType = {
    id: string | null
    hotel_id: string | null
    period_id: string | null
    price_double: Decimal | null
    price_triple: Decimal | null
    price_quad: Decimal | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type HotelPeriodPriceCountAggregateOutputType = {
    id: number
    hotel_id: number
    period_id: number
    price_double: number
    price_triple: number
    price_quad: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type HotelPeriodPriceAvgAggregateInputType = {
    price_double?: true
    price_triple?: true
    price_quad?: true
  }

  export type HotelPeriodPriceSumAggregateInputType = {
    price_double?: true
    price_triple?: true
    price_quad?: true
  }

  export type HotelPeriodPriceMinAggregateInputType = {
    id?: true
    hotel_id?: true
    period_id?: true
    price_double?: true
    price_triple?: true
    price_quad?: true
    created_at?: true
    updated_at?: true
  }

  export type HotelPeriodPriceMaxAggregateInputType = {
    id?: true
    hotel_id?: true
    period_id?: true
    price_double?: true
    price_triple?: true
    price_quad?: true
    created_at?: true
    updated_at?: true
  }

  export type HotelPeriodPriceCountAggregateInputType = {
    id?: true
    hotel_id?: true
    period_id?: true
    price_double?: true
    price_triple?: true
    price_quad?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type HotelPeriodPriceAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which HotelPeriodPrice to aggregate.
     */
    where?: HotelPeriodPriceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of HotelPeriodPrices to fetch.
     */
    orderBy?: HotelPeriodPriceOrderByWithRelationInput | HotelPeriodPriceOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: HotelPeriodPriceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` HotelPeriodPrices from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` HotelPeriodPrices.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned HotelPeriodPrices
    **/
    _count?: true | HotelPeriodPriceCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: HotelPeriodPriceAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: HotelPeriodPriceSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: HotelPeriodPriceMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: HotelPeriodPriceMaxAggregateInputType
  }

  export type GetHotelPeriodPriceAggregateType<T extends HotelPeriodPriceAggregateArgs> = {
        [P in keyof T & keyof AggregateHotelPeriodPrice]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateHotelPeriodPrice[P]>
      : GetScalarType<T[P], AggregateHotelPeriodPrice[P]>
  }




  export type HotelPeriodPriceGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: HotelPeriodPriceWhereInput
    orderBy?: HotelPeriodPriceOrderByWithAggregationInput | HotelPeriodPriceOrderByWithAggregationInput[]
    by: HotelPeriodPriceScalarFieldEnum[] | HotelPeriodPriceScalarFieldEnum
    having?: HotelPeriodPriceScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: HotelPeriodPriceCountAggregateInputType | true
    _avg?: HotelPeriodPriceAvgAggregateInputType
    _sum?: HotelPeriodPriceSumAggregateInputType
    _min?: HotelPeriodPriceMinAggregateInputType
    _max?: HotelPeriodPriceMaxAggregateInputType
  }

  export type HotelPeriodPriceGroupByOutputType = {
    id: string
    hotel_id: string
    period_id: string
    price_double: Decimal
    price_triple: Decimal
    price_quad: Decimal
    created_at: Date
    updated_at: Date
    _count: HotelPeriodPriceCountAggregateOutputType | null
    _avg: HotelPeriodPriceAvgAggregateOutputType | null
    _sum: HotelPeriodPriceSumAggregateOutputType | null
    _min: HotelPeriodPriceMinAggregateOutputType | null
    _max: HotelPeriodPriceMaxAggregateOutputType | null
  }

  type GetHotelPeriodPriceGroupByPayload<T extends HotelPeriodPriceGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<HotelPeriodPriceGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof HotelPeriodPriceGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], HotelPeriodPriceGroupByOutputType[P]>
            : GetScalarType<T[P], HotelPeriodPriceGroupByOutputType[P]>
        }
      >
    >


  export type HotelPeriodPriceSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    hotel_id?: boolean
    period_id?: boolean
    price_double?: boolean
    price_triple?: boolean
    price_quad?: boolean
    created_at?: boolean
    updated_at?: boolean
    Hotel?: boolean | HotelDefaultArgs<ExtArgs>
    Period?: boolean | PeriodDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["hotelPeriodPrice"]>


  export type HotelPeriodPriceSelectScalar = {
    id?: boolean
    hotel_id?: boolean
    period_id?: boolean
    price_double?: boolean
    price_triple?: boolean
    price_quad?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type HotelPeriodPriceInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Hotel?: boolean | HotelDefaultArgs<ExtArgs>
    Period?: boolean | PeriodDefaultArgs<ExtArgs>
  }

  export type $HotelPeriodPricePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "HotelPeriodPrice"
    objects: {
      Hotel: Prisma.$HotelPayload<ExtArgs>
      Period: Prisma.$PeriodPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      hotel_id: string
      period_id: string
      price_double: Prisma.Decimal
      price_triple: Prisma.Decimal
      price_quad: Prisma.Decimal
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["hotelPeriodPrice"]>
    composites: {}
  }

  type HotelPeriodPriceGetPayload<S extends boolean | null | undefined | HotelPeriodPriceDefaultArgs> = $Result.GetResult<Prisma.$HotelPeriodPricePayload, S>

  type HotelPeriodPriceCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<HotelPeriodPriceFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: HotelPeriodPriceCountAggregateInputType | true
    }

  export interface HotelPeriodPriceDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['HotelPeriodPrice'], meta: { name: 'HotelPeriodPrice' } }
    /**
     * Find zero or one HotelPeriodPrice that matches the filter.
     * @param {HotelPeriodPriceFindUniqueArgs} args - Arguments to find a HotelPeriodPrice
     * @example
     * // Get one HotelPeriodPrice
     * const hotelPeriodPrice = await prisma.hotelPeriodPrice.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends HotelPeriodPriceFindUniqueArgs>(args: SelectSubset<T, HotelPeriodPriceFindUniqueArgs<ExtArgs>>): Prisma__HotelPeriodPriceClient<$Result.GetResult<Prisma.$HotelPeriodPricePayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one HotelPeriodPrice that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {HotelPeriodPriceFindUniqueOrThrowArgs} args - Arguments to find a HotelPeriodPrice
     * @example
     * // Get one HotelPeriodPrice
     * const hotelPeriodPrice = await prisma.hotelPeriodPrice.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends HotelPeriodPriceFindUniqueOrThrowArgs>(args: SelectSubset<T, HotelPeriodPriceFindUniqueOrThrowArgs<ExtArgs>>): Prisma__HotelPeriodPriceClient<$Result.GetResult<Prisma.$HotelPeriodPricePayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first HotelPeriodPrice that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelPeriodPriceFindFirstArgs} args - Arguments to find a HotelPeriodPrice
     * @example
     * // Get one HotelPeriodPrice
     * const hotelPeriodPrice = await prisma.hotelPeriodPrice.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends HotelPeriodPriceFindFirstArgs>(args?: SelectSubset<T, HotelPeriodPriceFindFirstArgs<ExtArgs>>): Prisma__HotelPeriodPriceClient<$Result.GetResult<Prisma.$HotelPeriodPricePayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first HotelPeriodPrice that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelPeriodPriceFindFirstOrThrowArgs} args - Arguments to find a HotelPeriodPrice
     * @example
     * // Get one HotelPeriodPrice
     * const hotelPeriodPrice = await prisma.hotelPeriodPrice.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends HotelPeriodPriceFindFirstOrThrowArgs>(args?: SelectSubset<T, HotelPeriodPriceFindFirstOrThrowArgs<ExtArgs>>): Prisma__HotelPeriodPriceClient<$Result.GetResult<Prisma.$HotelPeriodPricePayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more HotelPeriodPrices that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelPeriodPriceFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all HotelPeriodPrices
     * const hotelPeriodPrices = await prisma.hotelPeriodPrice.findMany()
     * 
     * // Get first 10 HotelPeriodPrices
     * const hotelPeriodPrices = await prisma.hotelPeriodPrice.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const hotelPeriodPriceWithIdOnly = await prisma.hotelPeriodPrice.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends HotelPeriodPriceFindManyArgs>(args?: SelectSubset<T, HotelPeriodPriceFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$HotelPeriodPricePayload<ExtArgs>, T, "findMany">>

    /**
     * Create a HotelPeriodPrice.
     * @param {HotelPeriodPriceCreateArgs} args - Arguments to create a HotelPeriodPrice.
     * @example
     * // Create one HotelPeriodPrice
     * const HotelPeriodPrice = await prisma.hotelPeriodPrice.create({
     *   data: {
     *     // ... data to create a HotelPeriodPrice
     *   }
     * })
     * 
     */
    create<T extends HotelPeriodPriceCreateArgs>(args: SelectSubset<T, HotelPeriodPriceCreateArgs<ExtArgs>>): Prisma__HotelPeriodPriceClient<$Result.GetResult<Prisma.$HotelPeriodPricePayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many HotelPeriodPrices.
     * @param {HotelPeriodPriceCreateManyArgs} args - Arguments to create many HotelPeriodPrices.
     * @example
     * // Create many HotelPeriodPrices
     * const hotelPeriodPrice = await prisma.hotelPeriodPrice.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends HotelPeriodPriceCreateManyArgs>(args?: SelectSubset<T, HotelPeriodPriceCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a HotelPeriodPrice.
     * @param {HotelPeriodPriceDeleteArgs} args - Arguments to delete one HotelPeriodPrice.
     * @example
     * // Delete one HotelPeriodPrice
     * const HotelPeriodPrice = await prisma.hotelPeriodPrice.delete({
     *   where: {
     *     // ... filter to delete one HotelPeriodPrice
     *   }
     * })
     * 
     */
    delete<T extends HotelPeriodPriceDeleteArgs>(args: SelectSubset<T, HotelPeriodPriceDeleteArgs<ExtArgs>>): Prisma__HotelPeriodPriceClient<$Result.GetResult<Prisma.$HotelPeriodPricePayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one HotelPeriodPrice.
     * @param {HotelPeriodPriceUpdateArgs} args - Arguments to update one HotelPeriodPrice.
     * @example
     * // Update one HotelPeriodPrice
     * const hotelPeriodPrice = await prisma.hotelPeriodPrice.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends HotelPeriodPriceUpdateArgs>(args: SelectSubset<T, HotelPeriodPriceUpdateArgs<ExtArgs>>): Prisma__HotelPeriodPriceClient<$Result.GetResult<Prisma.$HotelPeriodPricePayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more HotelPeriodPrices.
     * @param {HotelPeriodPriceDeleteManyArgs} args - Arguments to filter HotelPeriodPrices to delete.
     * @example
     * // Delete a few HotelPeriodPrices
     * const { count } = await prisma.hotelPeriodPrice.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends HotelPeriodPriceDeleteManyArgs>(args?: SelectSubset<T, HotelPeriodPriceDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more HotelPeriodPrices.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelPeriodPriceUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many HotelPeriodPrices
     * const hotelPeriodPrice = await prisma.hotelPeriodPrice.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends HotelPeriodPriceUpdateManyArgs>(args: SelectSubset<T, HotelPeriodPriceUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one HotelPeriodPrice.
     * @param {HotelPeriodPriceUpsertArgs} args - Arguments to update or create a HotelPeriodPrice.
     * @example
     * // Update or create a HotelPeriodPrice
     * const hotelPeriodPrice = await prisma.hotelPeriodPrice.upsert({
     *   create: {
     *     // ... data to create a HotelPeriodPrice
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the HotelPeriodPrice we want to update
     *   }
     * })
     */
    upsert<T extends HotelPeriodPriceUpsertArgs>(args: SelectSubset<T, HotelPeriodPriceUpsertArgs<ExtArgs>>): Prisma__HotelPeriodPriceClient<$Result.GetResult<Prisma.$HotelPeriodPricePayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of HotelPeriodPrices.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelPeriodPriceCountArgs} args - Arguments to filter HotelPeriodPrices to count.
     * @example
     * // Count the number of HotelPeriodPrices
     * const count = await prisma.hotelPeriodPrice.count({
     *   where: {
     *     // ... the filter for the HotelPeriodPrices we want to count
     *   }
     * })
    **/
    count<T extends HotelPeriodPriceCountArgs>(
      args?: Subset<T, HotelPeriodPriceCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], HotelPeriodPriceCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a HotelPeriodPrice.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelPeriodPriceAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends HotelPeriodPriceAggregateArgs>(args: Subset<T, HotelPeriodPriceAggregateArgs>): Prisma.PrismaPromise<GetHotelPeriodPriceAggregateType<T>>

    /**
     * Group by HotelPeriodPrice.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HotelPeriodPriceGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends HotelPeriodPriceGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: HotelPeriodPriceGroupByArgs['orderBy'] }
        : { orderBy?: HotelPeriodPriceGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, HotelPeriodPriceGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetHotelPeriodPriceGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the HotelPeriodPrice model
   */
  readonly fields: HotelPeriodPriceFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for HotelPeriodPrice.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__HotelPeriodPriceClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    Hotel<T extends HotelDefaultArgs<ExtArgs> = {}>(args?: Subset<T, HotelDefaultArgs<ExtArgs>>): Prisma__HotelClient<$Result.GetResult<Prisma.$HotelPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    Period<T extends PeriodDefaultArgs<ExtArgs> = {}>(args?: Subset<T, PeriodDefaultArgs<ExtArgs>>): Prisma__PeriodClient<$Result.GetResult<Prisma.$PeriodPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the HotelPeriodPrice model
   */ 
  interface HotelPeriodPriceFieldRefs {
    readonly id: FieldRef<"HotelPeriodPrice", 'String'>
    readonly hotel_id: FieldRef<"HotelPeriodPrice", 'String'>
    readonly period_id: FieldRef<"HotelPeriodPrice", 'String'>
    readonly price_double: FieldRef<"HotelPeriodPrice", 'Decimal'>
    readonly price_triple: FieldRef<"HotelPeriodPrice", 'Decimal'>
    readonly price_quad: FieldRef<"HotelPeriodPrice", 'Decimal'>
    readonly created_at: FieldRef<"HotelPeriodPrice", 'DateTime'>
    readonly updated_at: FieldRef<"HotelPeriodPrice", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * HotelPeriodPrice findUnique
   */
  export type HotelPeriodPriceFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HotelPeriodPrice
     */
    select?: HotelPeriodPriceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelPeriodPriceInclude<ExtArgs> | null
    /**
     * Filter, which HotelPeriodPrice to fetch.
     */
    where: HotelPeriodPriceWhereUniqueInput
  }

  /**
   * HotelPeriodPrice findUniqueOrThrow
   */
  export type HotelPeriodPriceFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HotelPeriodPrice
     */
    select?: HotelPeriodPriceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelPeriodPriceInclude<ExtArgs> | null
    /**
     * Filter, which HotelPeriodPrice to fetch.
     */
    where: HotelPeriodPriceWhereUniqueInput
  }

  /**
   * HotelPeriodPrice findFirst
   */
  export type HotelPeriodPriceFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HotelPeriodPrice
     */
    select?: HotelPeriodPriceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelPeriodPriceInclude<ExtArgs> | null
    /**
     * Filter, which HotelPeriodPrice to fetch.
     */
    where?: HotelPeriodPriceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of HotelPeriodPrices to fetch.
     */
    orderBy?: HotelPeriodPriceOrderByWithRelationInput | HotelPeriodPriceOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for HotelPeriodPrices.
     */
    cursor?: HotelPeriodPriceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` HotelPeriodPrices from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` HotelPeriodPrices.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of HotelPeriodPrices.
     */
    distinct?: HotelPeriodPriceScalarFieldEnum | HotelPeriodPriceScalarFieldEnum[]
  }

  /**
   * HotelPeriodPrice findFirstOrThrow
   */
  export type HotelPeriodPriceFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HotelPeriodPrice
     */
    select?: HotelPeriodPriceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelPeriodPriceInclude<ExtArgs> | null
    /**
     * Filter, which HotelPeriodPrice to fetch.
     */
    where?: HotelPeriodPriceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of HotelPeriodPrices to fetch.
     */
    orderBy?: HotelPeriodPriceOrderByWithRelationInput | HotelPeriodPriceOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for HotelPeriodPrices.
     */
    cursor?: HotelPeriodPriceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` HotelPeriodPrices from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` HotelPeriodPrices.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of HotelPeriodPrices.
     */
    distinct?: HotelPeriodPriceScalarFieldEnum | HotelPeriodPriceScalarFieldEnum[]
  }

  /**
   * HotelPeriodPrice findMany
   */
  export type HotelPeriodPriceFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HotelPeriodPrice
     */
    select?: HotelPeriodPriceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelPeriodPriceInclude<ExtArgs> | null
    /**
     * Filter, which HotelPeriodPrices to fetch.
     */
    where?: HotelPeriodPriceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of HotelPeriodPrices to fetch.
     */
    orderBy?: HotelPeriodPriceOrderByWithRelationInput | HotelPeriodPriceOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing HotelPeriodPrices.
     */
    cursor?: HotelPeriodPriceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` HotelPeriodPrices from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` HotelPeriodPrices.
     */
    skip?: number
    distinct?: HotelPeriodPriceScalarFieldEnum | HotelPeriodPriceScalarFieldEnum[]
  }

  /**
   * HotelPeriodPrice create
   */
  export type HotelPeriodPriceCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HotelPeriodPrice
     */
    select?: HotelPeriodPriceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelPeriodPriceInclude<ExtArgs> | null
    /**
     * The data needed to create a HotelPeriodPrice.
     */
    data: XOR<HotelPeriodPriceCreateInput, HotelPeriodPriceUncheckedCreateInput>
  }

  /**
   * HotelPeriodPrice createMany
   */
  export type HotelPeriodPriceCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many HotelPeriodPrices.
     */
    data: HotelPeriodPriceCreateManyInput | HotelPeriodPriceCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * HotelPeriodPrice update
   */
  export type HotelPeriodPriceUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HotelPeriodPrice
     */
    select?: HotelPeriodPriceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelPeriodPriceInclude<ExtArgs> | null
    /**
     * The data needed to update a HotelPeriodPrice.
     */
    data: XOR<HotelPeriodPriceUpdateInput, HotelPeriodPriceUncheckedUpdateInput>
    /**
     * Choose, which HotelPeriodPrice to update.
     */
    where: HotelPeriodPriceWhereUniqueInput
  }

  /**
   * HotelPeriodPrice updateMany
   */
  export type HotelPeriodPriceUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update HotelPeriodPrices.
     */
    data: XOR<HotelPeriodPriceUpdateManyMutationInput, HotelPeriodPriceUncheckedUpdateManyInput>
    /**
     * Filter which HotelPeriodPrices to update
     */
    where?: HotelPeriodPriceWhereInput
  }

  /**
   * HotelPeriodPrice upsert
   */
  export type HotelPeriodPriceUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HotelPeriodPrice
     */
    select?: HotelPeriodPriceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelPeriodPriceInclude<ExtArgs> | null
    /**
     * The filter to search for the HotelPeriodPrice to update in case it exists.
     */
    where: HotelPeriodPriceWhereUniqueInput
    /**
     * In case the HotelPeriodPrice found by the `where` argument doesn't exist, create a new HotelPeriodPrice with this data.
     */
    create: XOR<HotelPeriodPriceCreateInput, HotelPeriodPriceUncheckedCreateInput>
    /**
     * In case the HotelPeriodPrice was found with the provided `where` argument, update it with this data.
     */
    update: XOR<HotelPeriodPriceUpdateInput, HotelPeriodPriceUncheckedUpdateInput>
  }

  /**
   * HotelPeriodPrice delete
   */
  export type HotelPeriodPriceDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HotelPeriodPrice
     */
    select?: HotelPeriodPriceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelPeriodPriceInclude<ExtArgs> | null
    /**
     * Filter which HotelPeriodPrice to delete.
     */
    where: HotelPeriodPriceWhereUniqueInput
  }

  /**
   * HotelPeriodPrice deleteMany
   */
  export type HotelPeriodPriceDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which HotelPeriodPrices to delete
     */
    where?: HotelPeriodPriceWhereInput
  }

  /**
   * HotelPeriodPrice without action
   */
  export type HotelPeriodPriceDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HotelPeriodPrice
     */
    select?: HotelPeriodPriceSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HotelPeriodPriceInclude<ExtArgs> | null
  }


  /**
   * Model Airline
   */

  export type AggregateAirline = {
    _count: AirlineCountAggregateOutputType | null
    _avg: AirlineAvgAggregateOutputType | null
    _sum: AirlineSumAggregateOutputType | null
    _min: AirlineMinAggregateOutputType | null
    _max: AirlineMaxAggregateOutputType | null
  }

  export type AirlineAvgAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type AirlineSumAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type AirlineMinAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type AirlineMaxAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type AirlineCountAggregateOutputType = {
    id: number
    name: number
    price_idr: number
    order_number: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type AirlineAvgAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type AirlineSumAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type AirlineMinAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type AirlineMaxAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type AirlineCountAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type AirlineAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Airline to aggregate.
     */
    where?: AirlineWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Airlines to fetch.
     */
    orderBy?: AirlineOrderByWithRelationInput | AirlineOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: AirlineWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Airlines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Airlines.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Airlines
    **/
    _count?: true | AirlineCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: AirlineAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: AirlineSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: AirlineMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: AirlineMaxAggregateInputType
  }

  export type GetAirlineAggregateType<T extends AirlineAggregateArgs> = {
        [P in keyof T & keyof AggregateAirline]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAirline[P]>
      : GetScalarType<T[P], AggregateAirline[P]>
  }




  export type AirlineGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AirlineWhereInput
    orderBy?: AirlineOrderByWithAggregationInput | AirlineOrderByWithAggregationInput[]
    by: AirlineScalarFieldEnum[] | AirlineScalarFieldEnum
    having?: AirlineScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: AirlineCountAggregateInputType | true
    _avg?: AirlineAvgAggregateInputType
    _sum?: AirlineSumAggregateInputType
    _min?: AirlineMinAggregateInputType
    _max?: AirlineMaxAggregateInputType
  }

  export type AirlineGroupByOutputType = {
    id: string
    name: string
    price_idr: Decimal
    order_number: number
    created_at: Date
    updated_at: Date
    _count: AirlineCountAggregateOutputType | null
    _avg: AirlineAvgAggregateOutputType | null
    _sum: AirlineSumAggregateOutputType | null
    _min: AirlineMinAggregateOutputType | null
    _max: AirlineMaxAggregateOutputType | null
  }

  type GetAirlineGroupByPayload<T extends AirlineGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<AirlineGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof AirlineGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], AirlineGroupByOutputType[P]>
            : GetScalarType<T[P], AirlineGroupByOutputType[P]>
        }
      >
    >


  export type AirlineSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
    MitraPackages?: boolean | Airline$MitraPackagesArgs<ExtArgs>
    _count?: boolean | AirlineCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["airline"]>


  export type AirlineSelectScalar = {
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type AirlineInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | Airline$MitraPackagesArgs<ExtArgs>
    _count?: boolean | AirlineCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $AirlinePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Airline"
    objects: {
      MitraPackages: Prisma.$MitraPackagePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      price_idr: Prisma.Decimal
      order_number: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["airline"]>
    composites: {}
  }

  type AirlineGetPayload<S extends boolean | null | undefined | AirlineDefaultArgs> = $Result.GetResult<Prisma.$AirlinePayload, S>

  type AirlineCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<AirlineFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: AirlineCountAggregateInputType | true
    }

  export interface AirlineDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Airline'], meta: { name: 'Airline' } }
    /**
     * Find zero or one Airline that matches the filter.
     * @param {AirlineFindUniqueArgs} args - Arguments to find a Airline
     * @example
     * // Get one Airline
     * const airline = await prisma.airline.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends AirlineFindUniqueArgs>(args: SelectSubset<T, AirlineFindUniqueArgs<ExtArgs>>): Prisma__AirlineClient<$Result.GetResult<Prisma.$AirlinePayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Airline that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {AirlineFindUniqueOrThrowArgs} args - Arguments to find a Airline
     * @example
     * // Get one Airline
     * const airline = await prisma.airline.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends AirlineFindUniqueOrThrowArgs>(args: SelectSubset<T, AirlineFindUniqueOrThrowArgs<ExtArgs>>): Prisma__AirlineClient<$Result.GetResult<Prisma.$AirlinePayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Airline that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AirlineFindFirstArgs} args - Arguments to find a Airline
     * @example
     * // Get one Airline
     * const airline = await prisma.airline.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends AirlineFindFirstArgs>(args?: SelectSubset<T, AirlineFindFirstArgs<ExtArgs>>): Prisma__AirlineClient<$Result.GetResult<Prisma.$AirlinePayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Airline that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AirlineFindFirstOrThrowArgs} args - Arguments to find a Airline
     * @example
     * // Get one Airline
     * const airline = await prisma.airline.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends AirlineFindFirstOrThrowArgs>(args?: SelectSubset<T, AirlineFindFirstOrThrowArgs<ExtArgs>>): Prisma__AirlineClient<$Result.GetResult<Prisma.$AirlinePayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Airlines that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AirlineFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Airlines
     * const airlines = await prisma.airline.findMany()
     * 
     * // Get first 10 Airlines
     * const airlines = await prisma.airline.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const airlineWithIdOnly = await prisma.airline.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends AirlineFindManyArgs>(args?: SelectSubset<T, AirlineFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AirlinePayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Airline.
     * @param {AirlineCreateArgs} args - Arguments to create a Airline.
     * @example
     * // Create one Airline
     * const Airline = await prisma.airline.create({
     *   data: {
     *     // ... data to create a Airline
     *   }
     * })
     * 
     */
    create<T extends AirlineCreateArgs>(args: SelectSubset<T, AirlineCreateArgs<ExtArgs>>): Prisma__AirlineClient<$Result.GetResult<Prisma.$AirlinePayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Airlines.
     * @param {AirlineCreateManyArgs} args - Arguments to create many Airlines.
     * @example
     * // Create many Airlines
     * const airline = await prisma.airline.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends AirlineCreateManyArgs>(args?: SelectSubset<T, AirlineCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Airline.
     * @param {AirlineDeleteArgs} args - Arguments to delete one Airline.
     * @example
     * // Delete one Airline
     * const Airline = await prisma.airline.delete({
     *   where: {
     *     // ... filter to delete one Airline
     *   }
     * })
     * 
     */
    delete<T extends AirlineDeleteArgs>(args: SelectSubset<T, AirlineDeleteArgs<ExtArgs>>): Prisma__AirlineClient<$Result.GetResult<Prisma.$AirlinePayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Airline.
     * @param {AirlineUpdateArgs} args - Arguments to update one Airline.
     * @example
     * // Update one Airline
     * const airline = await prisma.airline.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends AirlineUpdateArgs>(args: SelectSubset<T, AirlineUpdateArgs<ExtArgs>>): Prisma__AirlineClient<$Result.GetResult<Prisma.$AirlinePayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Airlines.
     * @param {AirlineDeleteManyArgs} args - Arguments to filter Airlines to delete.
     * @example
     * // Delete a few Airlines
     * const { count } = await prisma.airline.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends AirlineDeleteManyArgs>(args?: SelectSubset<T, AirlineDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Airlines.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AirlineUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Airlines
     * const airline = await prisma.airline.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends AirlineUpdateManyArgs>(args: SelectSubset<T, AirlineUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Airline.
     * @param {AirlineUpsertArgs} args - Arguments to update or create a Airline.
     * @example
     * // Update or create a Airline
     * const airline = await prisma.airline.upsert({
     *   create: {
     *     // ... data to create a Airline
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Airline we want to update
     *   }
     * })
     */
    upsert<T extends AirlineUpsertArgs>(args: SelectSubset<T, AirlineUpsertArgs<ExtArgs>>): Prisma__AirlineClient<$Result.GetResult<Prisma.$AirlinePayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Airlines.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AirlineCountArgs} args - Arguments to filter Airlines to count.
     * @example
     * // Count the number of Airlines
     * const count = await prisma.airline.count({
     *   where: {
     *     // ... the filter for the Airlines we want to count
     *   }
     * })
    **/
    count<T extends AirlineCountArgs>(
      args?: Subset<T, AirlineCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], AirlineCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Airline.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AirlineAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends AirlineAggregateArgs>(args: Subset<T, AirlineAggregateArgs>): Prisma.PrismaPromise<GetAirlineAggregateType<T>>

    /**
     * Group by Airline.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AirlineGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends AirlineGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: AirlineGroupByArgs['orderBy'] }
        : { orderBy?: AirlineGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, AirlineGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAirlineGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Airline model
   */
  readonly fields: AirlineFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Airline.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__AirlineClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    MitraPackages<T extends Airline$MitraPackagesArgs<ExtArgs> = {}>(args?: Subset<T, Airline$MitraPackagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraPackagePayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Airline model
   */ 
  interface AirlineFieldRefs {
    readonly id: FieldRef<"Airline", 'String'>
    readonly name: FieldRef<"Airline", 'String'>
    readonly price_idr: FieldRef<"Airline", 'Decimal'>
    readonly order_number: FieldRef<"Airline", 'Int'>
    readonly created_at: FieldRef<"Airline", 'DateTime'>
    readonly updated_at: FieldRef<"Airline", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Airline findUnique
   */
  export type AirlineFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Airline
     */
    select?: AirlineSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AirlineInclude<ExtArgs> | null
    /**
     * Filter, which Airline to fetch.
     */
    where: AirlineWhereUniqueInput
  }

  /**
   * Airline findUniqueOrThrow
   */
  export type AirlineFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Airline
     */
    select?: AirlineSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AirlineInclude<ExtArgs> | null
    /**
     * Filter, which Airline to fetch.
     */
    where: AirlineWhereUniqueInput
  }

  /**
   * Airline findFirst
   */
  export type AirlineFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Airline
     */
    select?: AirlineSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AirlineInclude<ExtArgs> | null
    /**
     * Filter, which Airline to fetch.
     */
    where?: AirlineWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Airlines to fetch.
     */
    orderBy?: AirlineOrderByWithRelationInput | AirlineOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Airlines.
     */
    cursor?: AirlineWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Airlines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Airlines.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Airlines.
     */
    distinct?: AirlineScalarFieldEnum | AirlineScalarFieldEnum[]
  }

  /**
   * Airline findFirstOrThrow
   */
  export type AirlineFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Airline
     */
    select?: AirlineSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AirlineInclude<ExtArgs> | null
    /**
     * Filter, which Airline to fetch.
     */
    where?: AirlineWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Airlines to fetch.
     */
    orderBy?: AirlineOrderByWithRelationInput | AirlineOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Airlines.
     */
    cursor?: AirlineWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Airlines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Airlines.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Airlines.
     */
    distinct?: AirlineScalarFieldEnum | AirlineScalarFieldEnum[]
  }

  /**
   * Airline findMany
   */
  export type AirlineFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Airline
     */
    select?: AirlineSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AirlineInclude<ExtArgs> | null
    /**
     * Filter, which Airlines to fetch.
     */
    where?: AirlineWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Airlines to fetch.
     */
    orderBy?: AirlineOrderByWithRelationInput | AirlineOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Airlines.
     */
    cursor?: AirlineWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Airlines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Airlines.
     */
    skip?: number
    distinct?: AirlineScalarFieldEnum | AirlineScalarFieldEnum[]
  }

  /**
   * Airline create
   */
  export type AirlineCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Airline
     */
    select?: AirlineSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AirlineInclude<ExtArgs> | null
    /**
     * The data needed to create a Airline.
     */
    data: XOR<AirlineCreateInput, AirlineUncheckedCreateInput>
  }

  /**
   * Airline createMany
   */
  export type AirlineCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Airlines.
     */
    data: AirlineCreateManyInput | AirlineCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Airline update
   */
  export type AirlineUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Airline
     */
    select?: AirlineSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AirlineInclude<ExtArgs> | null
    /**
     * The data needed to update a Airline.
     */
    data: XOR<AirlineUpdateInput, AirlineUncheckedUpdateInput>
    /**
     * Choose, which Airline to update.
     */
    where: AirlineWhereUniqueInput
  }

  /**
   * Airline updateMany
   */
  export type AirlineUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Airlines.
     */
    data: XOR<AirlineUpdateManyMutationInput, AirlineUncheckedUpdateManyInput>
    /**
     * Filter which Airlines to update
     */
    where?: AirlineWhereInput
  }

  /**
   * Airline upsert
   */
  export type AirlineUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Airline
     */
    select?: AirlineSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AirlineInclude<ExtArgs> | null
    /**
     * The filter to search for the Airline to update in case it exists.
     */
    where: AirlineWhereUniqueInput
    /**
     * In case the Airline found by the `where` argument doesn't exist, create a new Airline with this data.
     */
    create: XOR<AirlineCreateInput, AirlineUncheckedCreateInput>
    /**
     * In case the Airline was found with the provided `where` argument, update it with this data.
     */
    update: XOR<AirlineUpdateInput, AirlineUncheckedUpdateInput>
  }

  /**
   * Airline delete
   */
  export type AirlineDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Airline
     */
    select?: AirlineSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AirlineInclude<ExtArgs> | null
    /**
     * Filter which Airline to delete.
     */
    where: AirlineWhereUniqueInput
  }

  /**
   * Airline deleteMany
   */
  export type AirlineDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Airlines to delete
     */
    where?: AirlineWhereInput
  }

  /**
   * Airline.MitraPackages
   */
  export type Airline$MitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraPackage
     */
    select?: MitraPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraPackageInclude<ExtArgs> | null
    where?: MitraPackageWhereInput
    orderBy?: MitraPackageOrderByWithRelationInput | MitraPackageOrderByWithRelationInput[]
    cursor?: MitraPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MitraPackageScalarFieldEnum | MitraPackageScalarFieldEnum[]
  }

  /**
   * Airline without action
   */
  export type AirlineDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Airline
     */
    select?: AirlineSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AirlineInclude<ExtArgs> | null
  }


  /**
   * Model Visa
   */

  export type AggregateVisa = {
    _count: VisaCountAggregateOutputType | null
    _avg: VisaAvgAggregateOutputType | null
    _sum: VisaSumAggregateOutputType | null
    _min: VisaMinAggregateOutputType | null
    _max: VisaMaxAggregateOutputType | null
  }

  export type VisaAvgAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type VisaSumAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type VisaMinAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type VisaMaxAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type VisaCountAggregateOutputType = {
    id: number
    name: number
    price_idr: number
    order_number: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type VisaAvgAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type VisaSumAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type VisaMinAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type VisaMaxAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type VisaCountAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type VisaAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Visa to aggregate.
     */
    where?: VisaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Visas to fetch.
     */
    orderBy?: VisaOrderByWithRelationInput | VisaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: VisaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Visas from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Visas.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Visas
    **/
    _count?: true | VisaCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: VisaAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: VisaSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: VisaMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: VisaMaxAggregateInputType
  }

  export type GetVisaAggregateType<T extends VisaAggregateArgs> = {
        [P in keyof T & keyof AggregateVisa]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateVisa[P]>
      : GetScalarType<T[P], AggregateVisa[P]>
  }




  export type VisaGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: VisaWhereInput
    orderBy?: VisaOrderByWithAggregationInput | VisaOrderByWithAggregationInput[]
    by: VisaScalarFieldEnum[] | VisaScalarFieldEnum
    having?: VisaScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: VisaCountAggregateInputType | true
    _avg?: VisaAvgAggregateInputType
    _sum?: VisaSumAggregateInputType
    _min?: VisaMinAggregateInputType
    _max?: VisaMaxAggregateInputType
  }

  export type VisaGroupByOutputType = {
    id: string
    name: string
    price_idr: Decimal
    order_number: number
    created_at: Date
    updated_at: Date
    _count: VisaCountAggregateOutputType | null
    _avg: VisaAvgAggregateOutputType | null
    _sum: VisaSumAggregateOutputType | null
    _min: VisaMinAggregateOutputType | null
    _max: VisaMaxAggregateOutputType | null
  }

  type GetVisaGroupByPayload<T extends VisaGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<VisaGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof VisaGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], VisaGroupByOutputType[P]>
            : GetScalarType<T[P], VisaGroupByOutputType[P]>
        }
      >
    >


  export type VisaSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
    MitraPackages?: boolean | Visa$MitraPackagesArgs<ExtArgs>
    _count?: boolean | VisaCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["visa"]>


  export type VisaSelectScalar = {
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type VisaInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | Visa$MitraPackagesArgs<ExtArgs>
    _count?: boolean | VisaCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $VisaPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Visa"
    objects: {
      MitraPackages: Prisma.$MitraPackagePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      price_idr: Prisma.Decimal
      order_number: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["visa"]>
    composites: {}
  }

  type VisaGetPayload<S extends boolean | null | undefined | VisaDefaultArgs> = $Result.GetResult<Prisma.$VisaPayload, S>

  type VisaCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<VisaFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: VisaCountAggregateInputType | true
    }

  export interface VisaDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Visa'], meta: { name: 'Visa' } }
    /**
     * Find zero or one Visa that matches the filter.
     * @param {VisaFindUniqueArgs} args - Arguments to find a Visa
     * @example
     * // Get one Visa
     * const visa = await prisma.visa.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends VisaFindUniqueArgs>(args: SelectSubset<T, VisaFindUniqueArgs<ExtArgs>>): Prisma__VisaClient<$Result.GetResult<Prisma.$VisaPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Visa that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {VisaFindUniqueOrThrowArgs} args - Arguments to find a Visa
     * @example
     * // Get one Visa
     * const visa = await prisma.visa.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends VisaFindUniqueOrThrowArgs>(args: SelectSubset<T, VisaFindUniqueOrThrowArgs<ExtArgs>>): Prisma__VisaClient<$Result.GetResult<Prisma.$VisaPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Visa that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VisaFindFirstArgs} args - Arguments to find a Visa
     * @example
     * // Get one Visa
     * const visa = await prisma.visa.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends VisaFindFirstArgs>(args?: SelectSubset<T, VisaFindFirstArgs<ExtArgs>>): Prisma__VisaClient<$Result.GetResult<Prisma.$VisaPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Visa that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VisaFindFirstOrThrowArgs} args - Arguments to find a Visa
     * @example
     * // Get one Visa
     * const visa = await prisma.visa.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends VisaFindFirstOrThrowArgs>(args?: SelectSubset<T, VisaFindFirstOrThrowArgs<ExtArgs>>): Prisma__VisaClient<$Result.GetResult<Prisma.$VisaPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Visas that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VisaFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Visas
     * const visas = await prisma.visa.findMany()
     * 
     * // Get first 10 Visas
     * const visas = await prisma.visa.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const visaWithIdOnly = await prisma.visa.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends VisaFindManyArgs>(args?: SelectSubset<T, VisaFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$VisaPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Visa.
     * @param {VisaCreateArgs} args - Arguments to create a Visa.
     * @example
     * // Create one Visa
     * const Visa = await prisma.visa.create({
     *   data: {
     *     // ... data to create a Visa
     *   }
     * })
     * 
     */
    create<T extends VisaCreateArgs>(args: SelectSubset<T, VisaCreateArgs<ExtArgs>>): Prisma__VisaClient<$Result.GetResult<Prisma.$VisaPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Visas.
     * @param {VisaCreateManyArgs} args - Arguments to create many Visas.
     * @example
     * // Create many Visas
     * const visa = await prisma.visa.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends VisaCreateManyArgs>(args?: SelectSubset<T, VisaCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Visa.
     * @param {VisaDeleteArgs} args - Arguments to delete one Visa.
     * @example
     * // Delete one Visa
     * const Visa = await prisma.visa.delete({
     *   where: {
     *     // ... filter to delete one Visa
     *   }
     * })
     * 
     */
    delete<T extends VisaDeleteArgs>(args: SelectSubset<T, VisaDeleteArgs<ExtArgs>>): Prisma__VisaClient<$Result.GetResult<Prisma.$VisaPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Visa.
     * @param {VisaUpdateArgs} args - Arguments to update one Visa.
     * @example
     * // Update one Visa
     * const visa = await prisma.visa.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends VisaUpdateArgs>(args: SelectSubset<T, VisaUpdateArgs<ExtArgs>>): Prisma__VisaClient<$Result.GetResult<Prisma.$VisaPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Visas.
     * @param {VisaDeleteManyArgs} args - Arguments to filter Visas to delete.
     * @example
     * // Delete a few Visas
     * const { count } = await prisma.visa.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends VisaDeleteManyArgs>(args?: SelectSubset<T, VisaDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Visas.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VisaUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Visas
     * const visa = await prisma.visa.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends VisaUpdateManyArgs>(args: SelectSubset<T, VisaUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Visa.
     * @param {VisaUpsertArgs} args - Arguments to update or create a Visa.
     * @example
     * // Update or create a Visa
     * const visa = await prisma.visa.upsert({
     *   create: {
     *     // ... data to create a Visa
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Visa we want to update
     *   }
     * })
     */
    upsert<T extends VisaUpsertArgs>(args: SelectSubset<T, VisaUpsertArgs<ExtArgs>>): Prisma__VisaClient<$Result.GetResult<Prisma.$VisaPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Visas.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VisaCountArgs} args - Arguments to filter Visas to count.
     * @example
     * // Count the number of Visas
     * const count = await prisma.visa.count({
     *   where: {
     *     // ... the filter for the Visas we want to count
     *   }
     * })
    **/
    count<T extends VisaCountArgs>(
      args?: Subset<T, VisaCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], VisaCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Visa.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VisaAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends VisaAggregateArgs>(args: Subset<T, VisaAggregateArgs>): Prisma.PrismaPromise<GetVisaAggregateType<T>>

    /**
     * Group by Visa.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VisaGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends VisaGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: VisaGroupByArgs['orderBy'] }
        : { orderBy?: VisaGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, VisaGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetVisaGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Visa model
   */
  readonly fields: VisaFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Visa.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__VisaClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    MitraPackages<T extends Visa$MitraPackagesArgs<ExtArgs> = {}>(args?: Subset<T, Visa$MitraPackagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraPackagePayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Visa model
   */ 
  interface VisaFieldRefs {
    readonly id: FieldRef<"Visa", 'String'>
    readonly name: FieldRef<"Visa", 'String'>
    readonly price_idr: FieldRef<"Visa", 'Decimal'>
    readonly order_number: FieldRef<"Visa", 'Int'>
    readonly created_at: FieldRef<"Visa", 'DateTime'>
    readonly updated_at: FieldRef<"Visa", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Visa findUnique
   */
  export type VisaFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Visa
     */
    select?: VisaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VisaInclude<ExtArgs> | null
    /**
     * Filter, which Visa to fetch.
     */
    where: VisaWhereUniqueInput
  }

  /**
   * Visa findUniqueOrThrow
   */
  export type VisaFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Visa
     */
    select?: VisaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VisaInclude<ExtArgs> | null
    /**
     * Filter, which Visa to fetch.
     */
    where: VisaWhereUniqueInput
  }

  /**
   * Visa findFirst
   */
  export type VisaFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Visa
     */
    select?: VisaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VisaInclude<ExtArgs> | null
    /**
     * Filter, which Visa to fetch.
     */
    where?: VisaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Visas to fetch.
     */
    orderBy?: VisaOrderByWithRelationInput | VisaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Visas.
     */
    cursor?: VisaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Visas from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Visas.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Visas.
     */
    distinct?: VisaScalarFieldEnum | VisaScalarFieldEnum[]
  }

  /**
   * Visa findFirstOrThrow
   */
  export type VisaFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Visa
     */
    select?: VisaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VisaInclude<ExtArgs> | null
    /**
     * Filter, which Visa to fetch.
     */
    where?: VisaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Visas to fetch.
     */
    orderBy?: VisaOrderByWithRelationInput | VisaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Visas.
     */
    cursor?: VisaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Visas from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Visas.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Visas.
     */
    distinct?: VisaScalarFieldEnum | VisaScalarFieldEnum[]
  }

  /**
   * Visa findMany
   */
  export type VisaFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Visa
     */
    select?: VisaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VisaInclude<ExtArgs> | null
    /**
     * Filter, which Visas to fetch.
     */
    where?: VisaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Visas to fetch.
     */
    orderBy?: VisaOrderByWithRelationInput | VisaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Visas.
     */
    cursor?: VisaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Visas from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Visas.
     */
    skip?: number
    distinct?: VisaScalarFieldEnum | VisaScalarFieldEnum[]
  }

  /**
   * Visa create
   */
  export type VisaCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Visa
     */
    select?: VisaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VisaInclude<ExtArgs> | null
    /**
     * The data needed to create a Visa.
     */
    data: XOR<VisaCreateInput, VisaUncheckedCreateInput>
  }

  /**
   * Visa createMany
   */
  export type VisaCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Visas.
     */
    data: VisaCreateManyInput | VisaCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Visa update
   */
  export type VisaUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Visa
     */
    select?: VisaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VisaInclude<ExtArgs> | null
    /**
     * The data needed to update a Visa.
     */
    data: XOR<VisaUpdateInput, VisaUncheckedUpdateInput>
    /**
     * Choose, which Visa to update.
     */
    where: VisaWhereUniqueInput
  }

  /**
   * Visa updateMany
   */
  export type VisaUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Visas.
     */
    data: XOR<VisaUpdateManyMutationInput, VisaUncheckedUpdateManyInput>
    /**
     * Filter which Visas to update
     */
    where?: VisaWhereInput
  }

  /**
   * Visa upsert
   */
  export type VisaUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Visa
     */
    select?: VisaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VisaInclude<ExtArgs> | null
    /**
     * The filter to search for the Visa to update in case it exists.
     */
    where: VisaWhereUniqueInput
    /**
     * In case the Visa found by the `where` argument doesn't exist, create a new Visa with this data.
     */
    create: XOR<VisaCreateInput, VisaUncheckedCreateInput>
    /**
     * In case the Visa was found with the provided `where` argument, update it with this data.
     */
    update: XOR<VisaUpdateInput, VisaUncheckedUpdateInput>
  }

  /**
   * Visa delete
   */
  export type VisaDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Visa
     */
    select?: VisaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VisaInclude<ExtArgs> | null
    /**
     * Filter which Visa to delete.
     */
    where: VisaWhereUniqueInput
  }

  /**
   * Visa deleteMany
   */
  export type VisaDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Visas to delete
     */
    where?: VisaWhereInput
  }

  /**
   * Visa.MitraPackages
   */
  export type Visa$MitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraPackage
     */
    select?: MitraPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraPackageInclude<ExtArgs> | null
    where?: MitraPackageWhereInput
    orderBy?: MitraPackageOrderByWithRelationInput | MitraPackageOrderByWithRelationInput[]
    cursor?: MitraPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MitraPackageScalarFieldEnum | MitraPackageScalarFieldEnum[]
  }

  /**
   * Visa without action
   */
  export type VisaDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Visa
     */
    select?: VisaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: VisaInclude<ExtArgs> | null
  }


  /**
   * Model Transportation
   */

  export type AggregateTransportation = {
    _count: TransportationCountAggregateOutputType | null
    _avg: TransportationAvgAggregateOutputType | null
    _sum: TransportationSumAggregateOutputType | null
    _min: TransportationMinAggregateOutputType | null
    _max: TransportationMaxAggregateOutputType | null
  }

  export type TransportationAvgAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type TransportationSumAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type TransportationMinAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type TransportationMaxAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type TransportationCountAggregateOutputType = {
    id: number
    name: number
    price_idr: number
    order_number: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type TransportationAvgAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type TransportationSumAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type TransportationMinAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type TransportationMaxAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type TransportationCountAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type TransportationAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Transportation to aggregate.
     */
    where?: TransportationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Transportation to fetch.
     */
    orderBy?: TransportationOrderByWithRelationInput | TransportationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: TransportationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Transportation from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Transportation.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Transportation
    **/
    _count?: true | TransportationCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: TransportationAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: TransportationSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: TransportationMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: TransportationMaxAggregateInputType
  }

  export type GetTransportationAggregateType<T extends TransportationAggregateArgs> = {
        [P in keyof T & keyof AggregateTransportation]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateTransportation[P]>
      : GetScalarType<T[P], AggregateTransportation[P]>
  }




  export type TransportationGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TransportationWhereInput
    orderBy?: TransportationOrderByWithAggregationInput | TransportationOrderByWithAggregationInput[]
    by: TransportationScalarFieldEnum[] | TransportationScalarFieldEnum
    having?: TransportationScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: TransportationCountAggregateInputType | true
    _avg?: TransportationAvgAggregateInputType
    _sum?: TransportationSumAggregateInputType
    _min?: TransportationMinAggregateInputType
    _max?: TransportationMaxAggregateInputType
  }

  export type TransportationGroupByOutputType = {
    id: string
    name: string
    price_idr: Decimal
    order_number: number
    created_at: Date
    updated_at: Date
    _count: TransportationCountAggregateOutputType | null
    _avg: TransportationAvgAggregateOutputType | null
    _sum: TransportationSumAggregateOutputType | null
    _min: TransportationMinAggregateOutputType | null
    _max: TransportationMaxAggregateOutputType | null
  }

  type GetTransportationGroupByPayload<T extends TransportationGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<TransportationGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof TransportationGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], TransportationGroupByOutputType[P]>
            : GetScalarType<T[P], TransportationGroupByOutputType[P]>
        }
      >
    >


  export type TransportationSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
    MitraPackage?: boolean | Transportation$MitraPackageArgs<ExtArgs>
    _count?: boolean | TransportationCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["transportation"]>


  export type TransportationSelectScalar = {
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type TransportationInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackage?: boolean | Transportation$MitraPackageArgs<ExtArgs>
    _count?: boolean | TransportationCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $TransportationPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Transportation"
    objects: {
      MitraPackage: Prisma.$MitraPackagePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      price_idr: Prisma.Decimal
      order_number: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["transportation"]>
    composites: {}
  }

  type TransportationGetPayload<S extends boolean | null | undefined | TransportationDefaultArgs> = $Result.GetResult<Prisma.$TransportationPayload, S>

  type TransportationCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<TransportationFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: TransportationCountAggregateInputType | true
    }

  export interface TransportationDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Transportation'], meta: { name: 'Transportation' } }
    /**
     * Find zero or one Transportation that matches the filter.
     * @param {TransportationFindUniqueArgs} args - Arguments to find a Transportation
     * @example
     * // Get one Transportation
     * const transportation = await prisma.transportation.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends TransportationFindUniqueArgs>(args: SelectSubset<T, TransportationFindUniqueArgs<ExtArgs>>): Prisma__TransportationClient<$Result.GetResult<Prisma.$TransportationPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Transportation that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {TransportationFindUniqueOrThrowArgs} args - Arguments to find a Transportation
     * @example
     * // Get one Transportation
     * const transportation = await prisma.transportation.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends TransportationFindUniqueOrThrowArgs>(args: SelectSubset<T, TransportationFindUniqueOrThrowArgs<ExtArgs>>): Prisma__TransportationClient<$Result.GetResult<Prisma.$TransportationPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Transportation that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransportationFindFirstArgs} args - Arguments to find a Transportation
     * @example
     * // Get one Transportation
     * const transportation = await prisma.transportation.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends TransportationFindFirstArgs>(args?: SelectSubset<T, TransportationFindFirstArgs<ExtArgs>>): Prisma__TransportationClient<$Result.GetResult<Prisma.$TransportationPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Transportation that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransportationFindFirstOrThrowArgs} args - Arguments to find a Transportation
     * @example
     * // Get one Transportation
     * const transportation = await prisma.transportation.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends TransportationFindFirstOrThrowArgs>(args?: SelectSubset<T, TransportationFindFirstOrThrowArgs<ExtArgs>>): Prisma__TransportationClient<$Result.GetResult<Prisma.$TransportationPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Transportation that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransportationFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Transportation
     * const transportation = await prisma.transportation.findMany()
     * 
     * // Get first 10 Transportation
     * const transportation = await prisma.transportation.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const transportationWithIdOnly = await prisma.transportation.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends TransportationFindManyArgs>(args?: SelectSubset<T, TransportationFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TransportationPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Transportation.
     * @param {TransportationCreateArgs} args - Arguments to create a Transportation.
     * @example
     * // Create one Transportation
     * const Transportation = await prisma.transportation.create({
     *   data: {
     *     // ... data to create a Transportation
     *   }
     * })
     * 
     */
    create<T extends TransportationCreateArgs>(args: SelectSubset<T, TransportationCreateArgs<ExtArgs>>): Prisma__TransportationClient<$Result.GetResult<Prisma.$TransportationPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Transportation.
     * @param {TransportationCreateManyArgs} args - Arguments to create many Transportation.
     * @example
     * // Create many Transportation
     * const transportation = await prisma.transportation.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends TransportationCreateManyArgs>(args?: SelectSubset<T, TransportationCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Transportation.
     * @param {TransportationDeleteArgs} args - Arguments to delete one Transportation.
     * @example
     * // Delete one Transportation
     * const Transportation = await prisma.transportation.delete({
     *   where: {
     *     // ... filter to delete one Transportation
     *   }
     * })
     * 
     */
    delete<T extends TransportationDeleteArgs>(args: SelectSubset<T, TransportationDeleteArgs<ExtArgs>>): Prisma__TransportationClient<$Result.GetResult<Prisma.$TransportationPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Transportation.
     * @param {TransportationUpdateArgs} args - Arguments to update one Transportation.
     * @example
     * // Update one Transportation
     * const transportation = await prisma.transportation.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends TransportationUpdateArgs>(args: SelectSubset<T, TransportationUpdateArgs<ExtArgs>>): Prisma__TransportationClient<$Result.GetResult<Prisma.$TransportationPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Transportation.
     * @param {TransportationDeleteManyArgs} args - Arguments to filter Transportation to delete.
     * @example
     * // Delete a few Transportation
     * const { count } = await prisma.transportation.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends TransportationDeleteManyArgs>(args?: SelectSubset<T, TransportationDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Transportation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransportationUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Transportation
     * const transportation = await prisma.transportation.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends TransportationUpdateManyArgs>(args: SelectSubset<T, TransportationUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Transportation.
     * @param {TransportationUpsertArgs} args - Arguments to update or create a Transportation.
     * @example
     * // Update or create a Transportation
     * const transportation = await prisma.transportation.upsert({
     *   create: {
     *     // ... data to create a Transportation
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Transportation we want to update
     *   }
     * })
     */
    upsert<T extends TransportationUpsertArgs>(args: SelectSubset<T, TransportationUpsertArgs<ExtArgs>>): Prisma__TransportationClient<$Result.GetResult<Prisma.$TransportationPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Transportation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransportationCountArgs} args - Arguments to filter Transportation to count.
     * @example
     * // Count the number of Transportation
     * const count = await prisma.transportation.count({
     *   where: {
     *     // ... the filter for the Transportation we want to count
     *   }
     * })
    **/
    count<T extends TransportationCountArgs>(
      args?: Subset<T, TransportationCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], TransportationCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Transportation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransportationAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends TransportationAggregateArgs>(args: Subset<T, TransportationAggregateArgs>): Prisma.PrismaPromise<GetTransportationAggregateType<T>>

    /**
     * Group by Transportation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransportationGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends TransportationGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: TransportationGroupByArgs['orderBy'] }
        : { orderBy?: TransportationGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, TransportationGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetTransportationGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Transportation model
   */
  readonly fields: TransportationFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Transportation.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__TransportationClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    MitraPackage<T extends Transportation$MitraPackageArgs<ExtArgs> = {}>(args?: Subset<T, Transportation$MitraPackageArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraPackagePayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Transportation model
   */ 
  interface TransportationFieldRefs {
    readonly id: FieldRef<"Transportation", 'String'>
    readonly name: FieldRef<"Transportation", 'String'>
    readonly price_idr: FieldRef<"Transportation", 'Decimal'>
    readonly order_number: FieldRef<"Transportation", 'Int'>
    readonly created_at: FieldRef<"Transportation", 'DateTime'>
    readonly updated_at: FieldRef<"Transportation", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Transportation findUnique
   */
  export type TransportationFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transportation
     */
    select?: TransportationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TransportationInclude<ExtArgs> | null
    /**
     * Filter, which Transportation to fetch.
     */
    where: TransportationWhereUniqueInput
  }

  /**
   * Transportation findUniqueOrThrow
   */
  export type TransportationFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transportation
     */
    select?: TransportationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TransportationInclude<ExtArgs> | null
    /**
     * Filter, which Transportation to fetch.
     */
    where: TransportationWhereUniqueInput
  }

  /**
   * Transportation findFirst
   */
  export type TransportationFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transportation
     */
    select?: TransportationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TransportationInclude<ExtArgs> | null
    /**
     * Filter, which Transportation to fetch.
     */
    where?: TransportationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Transportation to fetch.
     */
    orderBy?: TransportationOrderByWithRelationInput | TransportationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Transportation.
     */
    cursor?: TransportationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Transportation from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Transportation.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Transportation.
     */
    distinct?: TransportationScalarFieldEnum | TransportationScalarFieldEnum[]
  }

  /**
   * Transportation findFirstOrThrow
   */
  export type TransportationFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transportation
     */
    select?: TransportationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TransportationInclude<ExtArgs> | null
    /**
     * Filter, which Transportation to fetch.
     */
    where?: TransportationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Transportation to fetch.
     */
    orderBy?: TransportationOrderByWithRelationInput | TransportationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Transportation.
     */
    cursor?: TransportationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Transportation from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Transportation.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Transportation.
     */
    distinct?: TransportationScalarFieldEnum | TransportationScalarFieldEnum[]
  }

  /**
   * Transportation findMany
   */
  export type TransportationFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transportation
     */
    select?: TransportationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TransportationInclude<ExtArgs> | null
    /**
     * Filter, which Transportation to fetch.
     */
    where?: TransportationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Transportation to fetch.
     */
    orderBy?: TransportationOrderByWithRelationInput | TransportationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Transportation.
     */
    cursor?: TransportationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Transportation from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Transportation.
     */
    skip?: number
    distinct?: TransportationScalarFieldEnum | TransportationScalarFieldEnum[]
  }

  /**
   * Transportation create
   */
  export type TransportationCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transportation
     */
    select?: TransportationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TransportationInclude<ExtArgs> | null
    /**
     * The data needed to create a Transportation.
     */
    data: XOR<TransportationCreateInput, TransportationUncheckedCreateInput>
  }

  /**
   * Transportation createMany
   */
  export type TransportationCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Transportation.
     */
    data: TransportationCreateManyInput | TransportationCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Transportation update
   */
  export type TransportationUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transportation
     */
    select?: TransportationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TransportationInclude<ExtArgs> | null
    /**
     * The data needed to update a Transportation.
     */
    data: XOR<TransportationUpdateInput, TransportationUncheckedUpdateInput>
    /**
     * Choose, which Transportation to update.
     */
    where: TransportationWhereUniqueInput
  }

  /**
   * Transportation updateMany
   */
  export type TransportationUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Transportation.
     */
    data: XOR<TransportationUpdateManyMutationInput, TransportationUncheckedUpdateManyInput>
    /**
     * Filter which Transportation to update
     */
    where?: TransportationWhereInput
  }

  /**
   * Transportation upsert
   */
  export type TransportationUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transportation
     */
    select?: TransportationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TransportationInclude<ExtArgs> | null
    /**
     * The filter to search for the Transportation to update in case it exists.
     */
    where: TransportationWhereUniqueInput
    /**
     * In case the Transportation found by the `where` argument doesn't exist, create a new Transportation with this data.
     */
    create: XOR<TransportationCreateInput, TransportationUncheckedCreateInput>
    /**
     * In case the Transportation was found with the provided `where` argument, update it with this data.
     */
    update: XOR<TransportationUpdateInput, TransportationUncheckedUpdateInput>
  }

  /**
   * Transportation delete
   */
  export type TransportationDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transportation
     */
    select?: TransportationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TransportationInclude<ExtArgs> | null
    /**
     * Filter which Transportation to delete.
     */
    where: TransportationWhereUniqueInput
  }

  /**
   * Transportation deleteMany
   */
  export type TransportationDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Transportation to delete
     */
    where?: TransportationWhereInput
  }

  /**
   * Transportation.MitraPackage
   */
  export type Transportation$MitraPackageArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraPackage
     */
    select?: MitraPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraPackageInclude<ExtArgs> | null
    where?: MitraPackageWhereInput
    orderBy?: MitraPackageOrderByWithRelationInput | MitraPackageOrderByWithRelationInput[]
    cursor?: MitraPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MitraPackageScalarFieldEnum | MitraPackageScalarFieldEnum[]
  }

  /**
   * Transportation without action
   */
  export type TransportationDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transportation
     */
    select?: TransportationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TransportationInclude<ExtArgs> | null
  }


  /**
   * Model Muthawif
   */

  export type AggregateMuthawif = {
    _count: MuthawifCountAggregateOutputType | null
    _avg: MuthawifAvgAggregateOutputType | null
    _sum: MuthawifSumAggregateOutputType | null
    _min: MuthawifMinAggregateOutputType | null
    _max: MuthawifMaxAggregateOutputType | null
  }

  export type MuthawifAvgAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type MuthawifSumAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type MuthawifMinAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type MuthawifMaxAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type MuthawifCountAggregateOutputType = {
    id: number
    name: number
    price_idr: number
    order_number: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type MuthawifAvgAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type MuthawifSumAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type MuthawifMinAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type MuthawifMaxAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type MuthawifCountAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type MuthawifAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Muthawif to aggregate.
     */
    where?: MuthawifWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Muthawifs to fetch.
     */
    orderBy?: MuthawifOrderByWithRelationInput | MuthawifOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: MuthawifWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Muthawifs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Muthawifs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Muthawifs
    **/
    _count?: true | MuthawifCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: MuthawifAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: MuthawifSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: MuthawifMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: MuthawifMaxAggregateInputType
  }

  export type GetMuthawifAggregateType<T extends MuthawifAggregateArgs> = {
        [P in keyof T & keyof AggregateMuthawif]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateMuthawif[P]>
      : GetScalarType<T[P], AggregateMuthawif[P]>
  }




  export type MuthawifGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MuthawifWhereInput
    orderBy?: MuthawifOrderByWithAggregationInput | MuthawifOrderByWithAggregationInput[]
    by: MuthawifScalarFieldEnum[] | MuthawifScalarFieldEnum
    having?: MuthawifScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: MuthawifCountAggregateInputType | true
    _avg?: MuthawifAvgAggregateInputType
    _sum?: MuthawifSumAggregateInputType
    _min?: MuthawifMinAggregateInputType
    _max?: MuthawifMaxAggregateInputType
  }

  export type MuthawifGroupByOutputType = {
    id: string
    name: string
    price_idr: Decimal
    order_number: number
    created_at: Date
    updated_at: Date
    _count: MuthawifCountAggregateOutputType | null
    _avg: MuthawifAvgAggregateOutputType | null
    _sum: MuthawifSumAggregateOutputType | null
    _min: MuthawifMinAggregateOutputType | null
    _max: MuthawifMaxAggregateOutputType | null
  }

  type GetMuthawifGroupByPayload<T extends MuthawifGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<MuthawifGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof MuthawifGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], MuthawifGroupByOutputType[P]>
            : GetScalarType<T[P], MuthawifGroupByOutputType[P]>
        }
      >
    >


  export type MuthawifSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
    MitraPackages?: boolean | Muthawif$MitraPackagesArgs<ExtArgs>
    _count?: boolean | MuthawifCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["muthawif"]>


  export type MuthawifSelectScalar = {
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type MuthawifInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | Muthawif$MitraPackagesArgs<ExtArgs>
    _count?: boolean | MuthawifCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $MuthawifPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Muthawif"
    objects: {
      MitraPackages: Prisma.$MitraPackagePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      price_idr: Prisma.Decimal
      order_number: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["muthawif"]>
    composites: {}
  }

  type MuthawifGetPayload<S extends boolean | null | undefined | MuthawifDefaultArgs> = $Result.GetResult<Prisma.$MuthawifPayload, S>

  type MuthawifCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<MuthawifFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: MuthawifCountAggregateInputType | true
    }

  export interface MuthawifDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Muthawif'], meta: { name: 'Muthawif' } }
    /**
     * Find zero or one Muthawif that matches the filter.
     * @param {MuthawifFindUniqueArgs} args - Arguments to find a Muthawif
     * @example
     * // Get one Muthawif
     * const muthawif = await prisma.muthawif.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends MuthawifFindUniqueArgs>(args: SelectSubset<T, MuthawifFindUniqueArgs<ExtArgs>>): Prisma__MuthawifClient<$Result.GetResult<Prisma.$MuthawifPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Muthawif that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {MuthawifFindUniqueOrThrowArgs} args - Arguments to find a Muthawif
     * @example
     * // Get one Muthawif
     * const muthawif = await prisma.muthawif.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends MuthawifFindUniqueOrThrowArgs>(args: SelectSubset<T, MuthawifFindUniqueOrThrowArgs<ExtArgs>>): Prisma__MuthawifClient<$Result.GetResult<Prisma.$MuthawifPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Muthawif that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MuthawifFindFirstArgs} args - Arguments to find a Muthawif
     * @example
     * // Get one Muthawif
     * const muthawif = await prisma.muthawif.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends MuthawifFindFirstArgs>(args?: SelectSubset<T, MuthawifFindFirstArgs<ExtArgs>>): Prisma__MuthawifClient<$Result.GetResult<Prisma.$MuthawifPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Muthawif that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MuthawifFindFirstOrThrowArgs} args - Arguments to find a Muthawif
     * @example
     * // Get one Muthawif
     * const muthawif = await prisma.muthawif.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends MuthawifFindFirstOrThrowArgs>(args?: SelectSubset<T, MuthawifFindFirstOrThrowArgs<ExtArgs>>): Prisma__MuthawifClient<$Result.GetResult<Prisma.$MuthawifPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Muthawifs that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MuthawifFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Muthawifs
     * const muthawifs = await prisma.muthawif.findMany()
     * 
     * // Get first 10 Muthawifs
     * const muthawifs = await prisma.muthawif.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const muthawifWithIdOnly = await prisma.muthawif.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends MuthawifFindManyArgs>(args?: SelectSubset<T, MuthawifFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MuthawifPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Muthawif.
     * @param {MuthawifCreateArgs} args - Arguments to create a Muthawif.
     * @example
     * // Create one Muthawif
     * const Muthawif = await prisma.muthawif.create({
     *   data: {
     *     // ... data to create a Muthawif
     *   }
     * })
     * 
     */
    create<T extends MuthawifCreateArgs>(args: SelectSubset<T, MuthawifCreateArgs<ExtArgs>>): Prisma__MuthawifClient<$Result.GetResult<Prisma.$MuthawifPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Muthawifs.
     * @param {MuthawifCreateManyArgs} args - Arguments to create many Muthawifs.
     * @example
     * // Create many Muthawifs
     * const muthawif = await prisma.muthawif.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends MuthawifCreateManyArgs>(args?: SelectSubset<T, MuthawifCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Muthawif.
     * @param {MuthawifDeleteArgs} args - Arguments to delete one Muthawif.
     * @example
     * // Delete one Muthawif
     * const Muthawif = await prisma.muthawif.delete({
     *   where: {
     *     // ... filter to delete one Muthawif
     *   }
     * })
     * 
     */
    delete<T extends MuthawifDeleteArgs>(args: SelectSubset<T, MuthawifDeleteArgs<ExtArgs>>): Prisma__MuthawifClient<$Result.GetResult<Prisma.$MuthawifPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Muthawif.
     * @param {MuthawifUpdateArgs} args - Arguments to update one Muthawif.
     * @example
     * // Update one Muthawif
     * const muthawif = await prisma.muthawif.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends MuthawifUpdateArgs>(args: SelectSubset<T, MuthawifUpdateArgs<ExtArgs>>): Prisma__MuthawifClient<$Result.GetResult<Prisma.$MuthawifPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Muthawifs.
     * @param {MuthawifDeleteManyArgs} args - Arguments to filter Muthawifs to delete.
     * @example
     * // Delete a few Muthawifs
     * const { count } = await prisma.muthawif.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends MuthawifDeleteManyArgs>(args?: SelectSubset<T, MuthawifDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Muthawifs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MuthawifUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Muthawifs
     * const muthawif = await prisma.muthawif.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends MuthawifUpdateManyArgs>(args: SelectSubset<T, MuthawifUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Muthawif.
     * @param {MuthawifUpsertArgs} args - Arguments to update or create a Muthawif.
     * @example
     * // Update or create a Muthawif
     * const muthawif = await prisma.muthawif.upsert({
     *   create: {
     *     // ... data to create a Muthawif
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Muthawif we want to update
     *   }
     * })
     */
    upsert<T extends MuthawifUpsertArgs>(args: SelectSubset<T, MuthawifUpsertArgs<ExtArgs>>): Prisma__MuthawifClient<$Result.GetResult<Prisma.$MuthawifPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Muthawifs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MuthawifCountArgs} args - Arguments to filter Muthawifs to count.
     * @example
     * // Count the number of Muthawifs
     * const count = await prisma.muthawif.count({
     *   where: {
     *     // ... the filter for the Muthawifs we want to count
     *   }
     * })
    **/
    count<T extends MuthawifCountArgs>(
      args?: Subset<T, MuthawifCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], MuthawifCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Muthawif.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MuthawifAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends MuthawifAggregateArgs>(args: Subset<T, MuthawifAggregateArgs>): Prisma.PrismaPromise<GetMuthawifAggregateType<T>>

    /**
     * Group by Muthawif.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MuthawifGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends MuthawifGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: MuthawifGroupByArgs['orderBy'] }
        : { orderBy?: MuthawifGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, MuthawifGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetMuthawifGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Muthawif model
   */
  readonly fields: MuthawifFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Muthawif.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__MuthawifClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    MitraPackages<T extends Muthawif$MitraPackagesArgs<ExtArgs> = {}>(args?: Subset<T, Muthawif$MitraPackagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraPackagePayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Muthawif model
   */ 
  interface MuthawifFieldRefs {
    readonly id: FieldRef<"Muthawif", 'String'>
    readonly name: FieldRef<"Muthawif", 'String'>
    readonly price_idr: FieldRef<"Muthawif", 'Decimal'>
    readonly order_number: FieldRef<"Muthawif", 'Int'>
    readonly created_at: FieldRef<"Muthawif", 'DateTime'>
    readonly updated_at: FieldRef<"Muthawif", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Muthawif findUnique
   */
  export type MuthawifFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Muthawif
     */
    select?: MuthawifSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MuthawifInclude<ExtArgs> | null
    /**
     * Filter, which Muthawif to fetch.
     */
    where: MuthawifWhereUniqueInput
  }

  /**
   * Muthawif findUniqueOrThrow
   */
  export type MuthawifFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Muthawif
     */
    select?: MuthawifSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MuthawifInclude<ExtArgs> | null
    /**
     * Filter, which Muthawif to fetch.
     */
    where: MuthawifWhereUniqueInput
  }

  /**
   * Muthawif findFirst
   */
  export type MuthawifFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Muthawif
     */
    select?: MuthawifSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MuthawifInclude<ExtArgs> | null
    /**
     * Filter, which Muthawif to fetch.
     */
    where?: MuthawifWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Muthawifs to fetch.
     */
    orderBy?: MuthawifOrderByWithRelationInput | MuthawifOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Muthawifs.
     */
    cursor?: MuthawifWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Muthawifs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Muthawifs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Muthawifs.
     */
    distinct?: MuthawifScalarFieldEnum | MuthawifScalarFieldEnum[]
  }

  /**
   * Muthawif findFirstOrThrow
   */
  export type MuthawifFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Muthawif
     */
    select?: MuthawifSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MuthawifInclude<ExtArgs> | null
    /**
     * Filter, which Muthawif to fetch.
     */
    where?: MuthawifWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Muthawifs to fetch.
     */
    orderBy?: MuthawifOrderByWithRelationInput | MuthawifOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Muthawifs.
     */
    cursor?: MuthawifWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Muthawifs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Muthawifs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Muthawifs.
     */
    distinct?: MuthawifScalarFieldEnum | MuthawifScalarFieldEnum[]
  }

  /**
   * Muthawif findMany
   */
  export type MuthawifFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Muthawif
     */
    select?: MuthawifSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MuthawifInclude<ExtArgs> | null
    /**
     * Filter, which Muthawifs to fetch.
     */
    where?: MuthawifWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Muthawifs to fetch.
     */
    orderBy?: MuthawifOrderByWithRelationInput | MuthawifOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Muthawifs.
     */
    cursor?: MuthawifWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Muthawifs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Muthawifs.
     */
    skip?: number
    distinct?: MuthawifScalarFieldEnum | MuthawifScalarFieldEnum[]
  }

  /**
   * Muthawif create
   */
  export type MuthawifCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Muthawif
     */
    select?: MuthawifSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MuthawifInclude<ExtArgs> | null
    /**
     * The data needed to create a Muthawif.
     */
    data: XOR<MuthawifCreateInput, MuthawifUncheckedCreateInput>
  }

  /**
   * Muthawif createMany
   */
  export type MuthawifCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Muthawifs.
     */
    data: MuthawifCreateManyInput | MuthawifCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Muthawif update
   */
  export type MuthawifUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Muthawif
     */
    select?: MuthawifSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MuthawifInclude<ExtArgs> | null
    /**
     * The data needed to update a Muthawif.
     */
    data: XOR<MuthawifUpdateInput, MuthawifUncheckedUpdateInput>
    /**
     * Choose, which Muthawif to update.
     */
    where: MuthawifWhereUniqueInput
  }

  /**
   * Muthawif updateMany
   */
  export type MuthawifUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Muthawifs.
     */
    data: XOR<MuthawifUpdateManyMutationInput, MuthawifUncheckedUpdateManyInput>
    /**
     * Filter which Muthawifs to update
     */
    where?: MuthawifWhereInput
  }

  /**
   * Muthawif upsert
   */
  export type MuthawifUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Muthawif
     */
    select?: MuthawifSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MuthawifInclude<ExtArgs> | null
    /**
     * The filter to search for the Muthawif to update in case it exists.
     */
    where: MuthawifWhereUniqueInput
    /**
     * In case the Muthawif found by the `where` argument doesn't exist, create a new Muthawif with this data.
     */
    create: XOR<MuthawifCreateInput, MuthawifUncheckedCreateInput>
    /**
     * In case the Muthawif was found with the provided `where` argument, update it with this data.
     */
    update: XOR<MuthawifUpdateInput, MuthawifUncheckedUpdateInput>
  }

  /**
   * Muthawif delete
   */
  export type MuthawifDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Muthawif
     */
    select?: MuthawifSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MuthawifInclude<ExtArgs> | null
    /**
     * Filter which Muthawif to delete.
     */
    where: MuthawifWhereUniqueInput
  }

  /**
   * Muthawif deleteMany
   */
  export type MuthawifDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Muthawifs to delete
     */
    where?: MuthawifWhereInput
  }

  /**
   * Muthawif.MitraPackages
   */
  export type Muthawif$MitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraPackage
     */
    select?: MitraPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraPackageInclude<ExtArgs> | null
    where?: MitraPackageWhereInput
    orderBy?: MitraPackageOrderByWithRelationInput | MitraPackageOrderByWithRelationInput[]
    cursor?: MitraPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MitraPackageScalarFieldEnum | MitraPackageScalarFieldEnum[]
  }

  /**
   * Muthawif without action
   */
  export type MuthawifDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Muthawif
     */
    select?: MuthawifSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MuthawifInclude<ExtArgs> | null
  }


  /**
   * Model HandlingSaudi
   */

  export type AggregateHandlingSaudi = {
    _count: HandlingSaudiCountAggregateOutputType | null
    _avg: HandlingSaudiAvgAggregateOutputType | null
    _sum: HandlingSaudiSumAggregateOutputType | null
    _min: HandlingSaudiMinAggregateOutputType | null
    _max: HandlingSaudiMaxAggregateOutputType | null
  }

  export type HandlingSaudiAvgAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type HandlingSaudiSumAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type HandlingSaudiMinAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type HandlingSaudiMaxAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type HandlingSaudiCountAggregateOutputType = {
    id: number
    name: number
    price_idr: number
    order_number: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type HandlingSaudiAvgAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type HandlingSaudiSumAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type HandlingSaudiMinAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type HandlingSaudiMaxAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type HandlingSaudiCountAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type HandlingSaudiAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which HandlingSaudi to aggregate.
     */
    where?: HandlingSaudiWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of HandlingSaudis to fetch.
     */
    orderBy?: HandlingSaudiOrderByWithRelationInput | HandlingSaudiOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: HandlingSaudiWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` HandlingSaudis from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` HandlingSaudis.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned HandlingSaudis
    **/
    _count?: true | HandlingSaudiCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: HandlingSaudiAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: HandlingSaudiSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: HandlingSaudiMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: HandlingSaudiMaxAggregateInputType
  }

  export type GetHandlingSaudiAggregateType<T extends HandlingSaudiAggregateArgs> = {
        [P in keyof T & keyof AggregateHandlingSaudi]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateHandlingSaudi[P]>
      : GetScalarType<T[P], AggregateHandlingSaudi[P]>
  }




  export type HandlingSaudiGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: HandlingSaudiWhereInput
    orderBy?: HandlingSaudiOrderByWithAggregationInput | HandlingSaudiOrderByWithAggregationInput[]
    by: HandlingSaudiScalarFieldEnum[] | HandlingSaudiScalarFieldEnum
    having?: HandlingSaudiScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: HandlingSaudiCountAggregateInputType | true
    _avg?: HandlingSaudiAvgAggregateInputType
    _sum?: HandlingSaudiSumAggregateInputType
    _min?: HandlingSaudiMinAggregateInputType
    _max?: HandlingSaudiMaxAggregateInputType
  }

  export type HandlingSaudiGroupByOutputType = {
    id: string
    name: string
    price_idr: Decimal
    order_number: number
    created_at: Date
    updated_at: Date
    _count: HandlingSaudiCountAggregateOutputType | null
    _avg: HandlingSaudiAvgAggregateOutputType | null
    _sum: HandlingSaudiSumAggregateOutputType | null
    _min: HandlingSaudiMinAggregateOutputType | null
    _max: HandlingSaudiMaxAggregateOutputType | null
  }

  type GetHandlingSaudiGroupByPayload<T extends HandlingSaudiGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<HandlingSaudiGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof HandlingSaudiGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], HandlingSaudiGroupByOutputType[P]>
            : GetScalarType<T[P], HandlingSaudiGroupByOutputType[P]>
        }
      >
    >


  export type HandlingSaudiSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
    MitraPackages?: boolean | HandlingSaudi$MitraPackagesArgs<ExtArgs>
    _count?: boolean | HandlingSaudiCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["handlingSaudi"]>


  export type HandlingSaudiSelectScalar = {
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type HandlingSaudiInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | HandlingSaudi$MitraPackagesArgs<ExtArgs>
    _count?: boolean | HandlingSaudiCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $HandlingSaudiPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "HandlingSaudi"
    objects: {
      MitraPackages: Prisma.$MitraPackagePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      price_idr: Prisma.Decimal
      order_number: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["handlingSaudi"]>
    composites: {}
  }

  type HandlingSaudiGetPayload<S extends boolean | null | undefined | HandlingSaudiDefaultArgs> = $Result.GetResult<Prisma.$HandlingSaudiPayload, S>

  type HandlingSaudiCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<HandlingSaudiFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: HandlingSaudiCountAggregateInputType | true
    }

  export interface HandlingSaudiDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['HandlingSaudi'], meta: { name: 'HandlingSaudi' } }
    /**
     * Find zero or one HandlingSaudi that matches the filter.
     * @param {HandlingSaudiFindUniqueArgs} args - Arguments to find a HandlingSaudi
     * @example
     * // Get one HandlingSaudi
     * const handlingSaudi = await prisma.handlingSaudi.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends HandlingSaudiFindUniqueArgs>(args: SelectSubset<T, HandlingSaudiFindUniqueArgs<ExtArgs>>): Prisma__HandlingSaudiClient<$Result.GetResult<Prisma.$HandlingSaudiPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one HandlingSaudi that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {HandlingSaudiFindUniqueOrThrowArgs} args - Arguments to find a HandlingSaudi
     * @example
     * // Get one HandlingSaudi
     * const handlingSaudi = await prisma.handlingSaudi.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends HandlingSaudiFindUniqueOrThrowArgs>(args: SelectSubset<T, HandlingSaudiFindUniqueOrThrowArgs<ExtArgs>>): Prisma__HandlingSaudiClient<$Result.GetResult<Prisma.$HandlingSaudiPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first HandlingSaudi that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingSaudiFindFirstArgs} args - Arguments to find a HandlingSaudi
     * @example
     * // Get one HandlingSaudi
     * const handlingSaudi = await prisma.handlingSaudi.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends HandlingSaudiFindFirstArgs>(args?: SelectSubset<T, HandlingSaudiFindFirstArgs<ExtArgs>>): Prisma__HandlingSaudiClient<$Result.GetResult<Prisma.$HandlingSaudiPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first HandlingSaudi that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingSaudiFindFirstOrThrowArgs} args - Arguments to find a HandlingSaudi
     * @example
     * // Get one HandlingSaudi
     * const handlingSaudi = await prisma.handlingSaudi.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends HandlingSaudiFindFirstOrThrowArgs>(args?: SelectSubset<T, HandlingSaudiFindFirstOrThrowArgs<ExtArgs>>): Prisma__HandlingSaudiClient<$Result.GetResult<Prisma.$HandlingSaudiPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more HandlingSaudis that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingSaudiFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all HandlingSaudis
     * const handlingSaudis = await prisma.handlingSaudi.findMany()
     * 
     * // Get first 10 HandlingSaudis
     * const handlingSaudis = await prisma.handlingSaudi.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const handlingSaudiWithIdOnly = await prisma.handlingSaudi.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends HandlingSaudiFindManyArgs>(args?: SelectSubset<T, HandlingSaudiFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$HandlingSaudiPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a HandlingSaudi.
     * @param {HandlingSaudiCreateArgs} args - Arguments to create a HandlingSaudi.
     * @example
     * // Create one HandlingSaudi
     * const HandlingSaudi = await prisma.handlingSaudi.create({
     *   data: {
     *     // ... data to create a HandlingSaudi
     *   }
     * })
     * 
     */
    create<T extends HandlingSaudiCreateArgs>(args: SelectSubset<T, HandlingSaudiCreateArgs<ExtArgs>>): Prisma__HandlingSaudiClient<$Result.GetResult<Prisma.$HandlingSaudiPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many HandlingSaudis.
     * @param {HandlingSaudiCreateManyArgs} args - Arguments to create many HandlingSaudis.
     * @example
     * // Create many HandlingSaudis
     * const handlingSaudi = await prisma.handlingSaudi.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends HandlingSaudiCreateManyArgs>(args?: SelectSubset<T, HandlingSaudiCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a HandlingSaudi.
     * @param {HandlingSaudiDeleteArgs} args - Arguments to delete one HandlingSaudi.
     * @example
     * // Delete one HandlingSaudi
     * const HandlingSaudi = await prisma.handlingSaudi.delete({
     *   where: {
     *     // ... filter to delete one HandlingSaudi
     *   }
     * })
     * 
     */
    delete<T extends HandlingSaudiDeleteArgs>(args: SelectSubset<T, HandlingSaudiDeleteArgs<ExtArgs>>): Prisma__HandlingSaudiClient<$Result.GetResult<Prisma.$HandlingSaudiPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one HandlingSaudi.
     * @param {HandlingSaudiUpdateArgs} args - Arguments to update one HandlingSaudi.
     * @example
     * // Update one HandlingSaudi
     * const handlingSaudi = await prisma.handlingSaudi.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends HandlingSaudiUpdateArgs>(args: SelectSubset<T, HandlingSaudiUpdateArgs<ExtArgs>>): Prisma__HandlingSaudiClient<$Result.GetResult<Prisma.$HandlingSaudiPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more HandlingSaudis.
     * @param {HandlingSaudiDeleteManyArgs} args - Arguments to filter HandlingSaudis to delete.
     * @example
     * // Delete a few HandlingSaudis
     * const { count } = await prisma.handlingSaudi.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends HandlingSaudiDeleteManyArgs>(args?: SelectSubset<T, HandlingSaudiDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more HandlingSaudis.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingSaudiUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many HandlingSaudis
     * const handlingSaudi = await prisma.handlingSaudi.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends HandlingSaudiUpdateManyArgs>(args: SelectSubset<T, HandlingSaudiUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one HandlingSaudi.
     * @param {HandlingSaudiUpsertArgs} args - Arguments to update or create a HandlingSaudi.
     * @example
     * // Update or create a HandlingSaudi
     * const handlingSaudi = await prisma.handlingSaudi.upsert({
     *   create: {
     *     // ... data to create a HandlingSaudi
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the HandlingSaudi we want to update
     *   }
     * })
     */
    upsert<T extends HandlingSaudiUpsertArgs>(args: SelectSubset<T, HandlingSaudiUpsertArgs<ExtArgs>>): Prisma__HandlingSaudiClient<$Result.GetResult<Prisma.$HandlingSaudiPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of HandlingSaudis.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingSaudiCountArgs} args - Arguments to filter HandlingSaudis to count.
     * @example
     * // Count the number of HandlingSaudis
     * const count = await prisma.handlingSaudi.count({
     *   where: {
     *     // ... the filter for the HandlingSaudis we want to count
     *   }
     * })
    **/
    count<T extends HandlingSaudiCountArgs>(
      args?: Subset<T, HandlingSaudiCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], HandlingSaudiCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a HandlingSaudi.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingSaudiAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends HandlingSaudiAggregateArgs>(args: Subset<T, HandlingSaudiAggregateArgs>): Prisma.PrismaPromise<GetHandlingSaudiAggregateType<T>>

    /**
     * Group by HandlingSaudi.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingSaudiGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends HandlingSaudiGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: HandlingSaudiGroupByArgs['orderBy'] }
        : { orderBy?: HandlingSaudiGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, HandlingSaudiGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetHandlingSaudiGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the HandlingSaudi model
   */
  readonly fields: HandlingSaudiFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for HandlingSaudi.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__HandlingSaudiClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    MitraPackages<T extends HandlingSaudi$MitraPackagesArgs<ExtArgs> = {}>(args?: Subset<T, HandlingSaudi$MitraPackagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraPackagePayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the HandlingSaudi model
   */ 
  interface HandlingSaudiFieldRefs {
    readonly id: FieldRef<"HandlingSaudi", 'String'>
    readonly name: FieldRef<"HandlingSaudi", 'String'>
    readonly price_idr: FieldRef<"HandlingSaudi", 'Decimal'>
    readonly order_number: FieldRef<"HandlingSaudi", 'Int'>
    readonly created_at: FieldRef<"HandlingSaudi", 'DateTime'>
    readonly updated_at: FieldRef<"HandlingSaudi", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * HandlingSaudi findUnique
   */
  export type HandlingSaudiFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingSaudi
     */
    select?: HandlingSaudiSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingSaudiInclude<ExtArgs> | null
    /**
     * Filter, which HandlingSaudi to fetch.
     */
    where: HandlingSaudiWhereUniqueInput
  }

  /**
   * HandlingSaudi findUniqueOrThrow
   */
  export type HandlingSaudiFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingSaudi
     */
    select?: HandlingSaudiSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingSaudiInclude<ExtArgs> | null
    /**
     * Filter, which HandlingSaudi to fetch.
     */
    where: HandlingSaudiWhereUniqueInput
  }

  /**
   * HandlingSaudi findFirst
   */
  export type HandlingSaudiFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingSaudi
     */
    select?: HandlingSaudiSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingSaudiInclude<ExtArgs> | null
    /**
     * Filter, which HandlingSaudi to fetch.
     */
    where?: HandlingSaudiWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of HandlingSaudis to fetch.
     */
    orderBy?: HandlingSaudiOrderByWithRelationInput | HandlingSaudiOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for HandlingSaudis.
     */
    cursor?: HandlingSaudiWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` HandlingSaudis from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` HandlingSaudis.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of HandlingSaudis.
     */
    distinct?: HandlingSaudiScalarFieldEnum | HandlingSaudiScalarFieldEnum[]
  }

  /**
   * HandlingSaudi findFirstOrThrow
   */
  export type HandlingSaudiFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingSaudi
     */
    select?: HandlingSaudiSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingSaudiInclude<ExtArgs> | null
    /**
     * Filter, which HandlingSaudi to fetch.
     */
    where?: HandlingSaudiWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of HandlingSaudis to fetch.
     */
    orderBy?: HandlingSaudiOrderByWithRelationInput | HandlingSaudiOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for HandlingSaudis.
     */
    cursor?: HandlingSaudiWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` HandlingSaudis from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` HandlingSaudis.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of HandlingSaudis.
     */
    distinct?: HandlingSaudiScalarFieldEnum | HandlingSaudiScalarFieldEnum[]
  }

  /**
   * HandlingSaudi findMany
   */
  export type HandlingSaudiFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingSaudi
     */
    select?: HandlingSaudiSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingSaudiInclude<ExtArgs> | null
    /**
     * Filter, which HandlingSaudis to fetch.
     */
    where?: HandlingSaudiWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of HandlingSaudis to fetch.
     */
    orderBy?: HandlingSaudiOrderByWithRelationInput | HandlingSaudiOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing HandlingSaudis.
     */
    cursor?: HandlingSaudiWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` HandlingSaudis from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` HandlingSaudis.
     */
    skip?: number
    distinct?: HandlingSaudiScalarFieldEnum | HandlingSaudiScalarFieldEnum[]
  }

  /**
   * HandlingSaudi create
   */
  export type HandlingSaudiCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingSaudi
     */
    select?: HandlingSaudiSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingSaudiInclude<ExtArgs> | null
    /**
     * The data needed to create a HandlingSaudi.
     */
    data: XOR<HandlingSaudiCreateInput, HandlingSaudiUncheckedCreateInput>
  }

  /**
   * HandlingSaudi createMany
   */
  export type HandlingSaudiCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many HandlingSaudis.
     */
    data: HandlingSaudiCreateManyInput | HandlingSaudiCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * HandlingSaudi update
   */
  export type HandlingSaudiUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingSaudi
     */
    select?: HandlingSaudiSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingSaudiInclude<ExtArgs> | null
    /**
     * The data needed to update a HandlingSaudi.
     */
    data: XOR<HandlingSaudiUpdateInput, HandlingSaudiUncheckedUpdateInput>
    /**
     * Choose, which HandlingSaudi to update.
     */
    where: HandlingSaudiWhereUniqueInput
  }

  /**
   * HandlingSaudi updateMany
   */
  export type HandlingSaudiUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update HandlingSaudis.
     */
    data: XOR<HandlingSaudiUpdateManyMutationInput, HandlingSaudiUncheckedUpdateManyInput>
    /**
     * Filter which HandlingSaudis to update
     */
    where?: HandlingSaudiWhereInput
  }

  /**
   * HandlingSaudi upsert
   */
  export type HandlingSaudiUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingSaudi
     */
    select?: HandlingSaudiSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingSaudiInclude<ExtArgs> | null
    /**
     * The filter to search for the HandlingSaudi to update in case it exists.
     */
    where: HandlingSaudiWhereUniqueInput
    /**
     * In case the HandlingSaudi found by the `where` argument doesn't exist, create a new HandlingSaudi with this data.
     */
    create: XOR<HandlingSaudiCreateInput, HandlingSaudiUncheckedCreateInput>
    /**
     * In case the HandlingSaudi was found with the provided `where` argument, update it with this data.
     */
    update: XOR<HandlingSaudiUpdateInput, HandlingSaudiUncheckedUpdateInput>
  }

  /**
   * HandlingSaudi delete
   */
  export type HandlingSaudiDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingSaudi
     */
    select?: HandlingSaudiSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingSaudiInclude<ExtArgs> | null
    /**
     * Filter which HandlingSaudi to delete.
     */
    where: HandlingSaudiWhereUniqueInput
  }

  /**
   * HandlingSaudi deleteMany
   */
  export type HandlingSaudiDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which HandlingSaudis to delete
     */
    where?: HandlingSaudiWhereInput
  }

  /**
   * HandlingSaudi.MitraPackages
   */
  export type HandlingSaudi$MitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraPackage
     */
    select?: MitraPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraPackageInclude<ExtArgs> | null
    where?: MitraPackageWhereInput
    orderBy?: MitraPackageOrderByWithRelationInput | MitraPackageOrderByWithRelationInput[]
    cursor?: MitraPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MitraPackageScalarFieldEnum | MitraPackageScalarFieldEnum[]
  }

  /**
   * HandlingSaudi without action
   */
  export type HandlingSaudiDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingSaudi
     */
    select?: HandlingSaudiSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingSaudiInclude<ExtArgs> | null
  }


  /**
   * Model HandlingDomestic
   */

  export type AggregateHandlingDomestic = {
    _count: HandlingDomesticCountAggregateOutputType | null
    _avg: HandlingDomesticAvgAggregateOutputType | null
    _sum: HandlingDomesticSumAggregateOutputType | null
    _min: HandlingDomesticMinAggregateOutputType | null
    _max: HandlingDomesticMaxAggregateOutputType | null
  }

  export type HandlingDomesticAvgAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type HandlingDomesticSumAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type HandlingDomesticMinAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type HandlingDomesticMaxAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type HandlingDomesticCountAggregateOutputType = {
    id: number
    name: number
    price_idr: number
    order_number: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type HandlingDomesticAvgAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type HandlingDomesticSumAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type HandlingDomesticMinAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type HandlingDomesticMaxAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type HandlingDomesticCountAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type HandlingDomesticAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which HandlingDomestic to aggregate.
     */
    where?: HandlingDomesticWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of HandlingDomestics to fetch.
     */
    orderBy?: HandlingDomesticOrderByWithRelationInput | HandlingDomesticOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: HandlingDomesticWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` HandlingDomestics from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` HandlingDomestics.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned HandlingDomestics
    **/
    _count?: true | HandlingDomesticCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: HandlingDomesticAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: HandlingDomesticSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: HandlingDomesticMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: HandlingDomesticMaxAggregateInputType
  }

  export type GetHandlingDomesticAggregateType<T extends HandlingDomesticAggregateArgs> = {
        [P in keyof T & keyof AggregateHandlingDomestic]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateHandlingDomestic[P]>
      : GetScalarType<T[P], AggregateHandlingDomestic[P]>
  }




  export type HandlingDomesticGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: HandlingDomesticWhereInput
    orderBy?: HandlingDomesticOrderByWithAggregationInput | HandlingDomesticOrderByWithAggregationInput[]
    by: HandlingDomesticScalarFieldEnum[] | HandlingDomesticScalarFieldEnum
    having?: HandlingDomesticScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: HandlingDomesticCountAggregateInputType | true
    _avg?: HandlingDomesticAvgAggregateInputType
    _sum?: HandlingDomesticSumAggregateInputType
    _min?: HandlingDomesticMinAggregateInputType
    _max?: HandlingDomesticMaxAggregateInputType
  }

  export type HandlingDomesticGroupByOutputType = {
    id: string
    name: string
    price_idr: Decimal
    order_number: number
    created_at: Date
    updated_at: Date
    _count: HandlingDomesticCountAggregateOutputType | null
    _avg: HandlingDomesticAvgAggregateOutputType | null
    _sum: HandlingDomesticSumAggregateOutputType | null
    _min: HandlingDomesticMinAggregateOutputType | null
    _max: HandlingDomesticMaxAggregateOutputType | null
  }

  type GetHandlingDomesticGroupByPayload<T extends HandlingDomesticGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<HandlingDomesticGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof HandlingDomesticGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], HandlingDomesticGroupByOutputType[P]>
            : GetScalarType<T[P], HandlingDomesticGroupByOutputType[P]>
        }
      >
    >


  export type HandlingDomesticSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
    MitraPackages?: boolean | HandlingDomestic$MitraPackagesArgs<ExtArgs>
    _count?: boolean | HandlingDomesticCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["handlingDomestic"]>


  export type HandlingDomesticSelectScalar = {
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type HandlingDomesticInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | HandlingDomestic$MitraPackagesArgs<ExtArgs>
    _count?: boolean | HandlingDomesticCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $HandlingDomesticPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "HandlingDomestic"
    objects: {
      MitraPackages: Prisma.$MitraPackagePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      price_idr: Prisma.Decimal
      order_number: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["handlingDomestic"]>
    composites: {}
  }

  type HandlingDomesticGetPayload<S extends boolean | null | undefined | HandlingDomesticDefaultArgs> = $Result.GetResult<Prisma.$HandlingDomesticPayload, S>

  type HandlingDomesticCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<HandlingDomesticFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: HandlingDomesticCountAggregateInputType | true
    }

  export interface HandlingDomesticDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['HandlingDomestic'], meta: { name: 'HandlingDomestic' } }
    /**
     * Find zero or one HandlingDomestic that matches the filter.
     * @param {HandlingDomesticFindUniqueArgs} args - Arguments to find a HandlingDomestic
     * @example
     * // Get one HandlingDomestic
     * const handlingDomestic = await prisma.handlingDomestic.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends HandlingDomesticFindUniqueArgs>(args: SelectSubset<T, HandlingDomesticFindUniqueArgs<ExtArgs>>): Prisma__HandlingDomesticClient<$Result.GetResult<Prisma.$HandlingDomesticPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one HandlingDomestic that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {HandlingDomesticFindUniqueOrThrowArgs} args - Arguments to find a HandlingDomestic
     * @example
     * // Get one HandlingDomestic
     * const handlingDomestic = await prisma.handlingDomestic.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends HandlingDomesticFindUniqueOrThrowArgs>(args: SelectSubset<T, HandlingDomesticFindUniqueOrThrowArgs<ExtArgs>>): Prisma__HandlingDomesticClient<$Result.GetResult<Prisma.$HandlingDomesticPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first HandlingDomestic that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingDomesticFindFirstArgs} args - Arguments to find a HandlingDomestic
     * @example
     * // Get one HandlingDomestic
     * const handlingDomestic = await prisma.handlingDomestic.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends HandlingDomesticFindFirstArgs>(args?: SelectSubset<T, HandlingDomesticFindFirstArgs<ExtArgs>>): Prisma__HandlingDomesticClient<$Result.GetResult<Prisma.$HandlingDomesticPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first HandlingDomestic that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingDomesticFindFirstOrThrowArgs} args - Arguments to find a HandlingDomestic
     * @example
     * // Get one HandlingDomestic
     * const handlingDomestic = await prisma.handlingDomestic.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends HandlingDomesticFindFirstOrThrowArgs>(args?: SelectSubset<T, HandlingDomesticFindFirstOrThrowArgs<ExtArgs>>): Prisma__HandlingDomesticClient<$Result.GetResult<Prisma.$HandlingDomesticPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more HandlingDomestics that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingDomesticFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all HandlingDomestics
     * const handlingDomestics = await prisma.handlingDomestic.findMany()
     * 
     * // Get first 10 HandlingDomestics
     * const handlingDomestics = await prisma.handlingDomestic.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const handlingDomesticWithIdOnly = await prisma.handlingDomestic.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends HandlingDomesticFindManyArgs>(args?: SelectSubset<T, HandlingDomesticFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$HandlingDomesticPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a HandlingDomestic.
     * @param {HandlingDomesticCreateArgs} args - Arguments to create a HandlingDomestic.
     * @example
     * // Create one HandlingDomestic
     * const HandlingDomestic = await prisma.handlingDomestic.create({
     *   data: {
     *     // ... data to create a HandlingDomestic
     *   }
     * })
     * 
     */
    create<T extends HandlingDomesticCreateArgs>(args: SelectSubset<T, HandlingDomesticCreateArgs<ExtArgs>>): Prisma__HandlingDomesticClient<$Result.GetResult<Prisma.$HandlingDomesticPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many HandlingDomestics.
     * @param {HandlingDomesticCreateManyArgs} args - Arguments to create many HandlingDomestics.
     * @example
     * // Create many HandlingDomestics
     * const handlingDomestic = await prisma.handlingDomestic.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends HandlingDomesticCreateManyArgs>(args?: SelectSubset<T, HandlingDomesticCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a HandlingDomestic.
     * @param {HandlingDomesticDeleteArgs} args - Arguments to delete one HandlingDomestic.
     * @example
     * // Delete one HandlingDomestic
     * const HandlingDomestic = await prisma.handlingDomestic.delete({
     *   where: {
     *     // ... filter to delete one HandlingDomestic
     *   }
     * })
     * 
     */
    delete<T extends HandlingDomesticDeleteArgs>(args: SelectSubset<T, HandlingDomesticDeleteArgs<ExtArgs>>): Prisma__HandlingDomesticClient<$Result.GetResult<Prisma.$HandlingDomesticPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one HandlingDomestic.
     * @param {HandlingDomesticUpdateArgs} args - Arguments to update one HandlingDomestic.
     * @example
     * // Update one HandlingDomestic
     * const handlingDomestic = await prisma.handlingDomestic.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends HandlingDomesticUpdateArgs>(args: SelectSubset<T, HandlingDomesticUpdateArgs<ExtArgs>>): Prisma__HandlingDomesticClient<$Result.GetResult<Prisma.$HandlingDomesticPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more HandlingDomestics.
     * @param {HandlingDomesticDeleteManyArgs} args - Arguments to filter HandlingDomestics to delete.
     * @example
     * // Delete a few HandlingDomestics
     * const { count } = await prisma.handlingDomestic.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends HandlingDomesticDeleteManyArgs>(args?: SelectSubset<T, HandlingDomesticDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more HandlingDomestics.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingDomesticUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many HandlingDomestics
     * const handlingDomestic = await prisma.handlingDomestic.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends HandlingDomesticUpdateManyArgs>(args: SelectSubset<T, HandlingDomesticUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one HandlingDomestic.
     * @param {HandlingDomesticUpsertArgs} args - Arguments to update or create a HandlingDomestic.
     * @example
     * // Update or create a HandlingDomestic
     * const handlingDomestic = await prisma.handlingDomestic.upsert({
     *   create: {
     *     // ... data to create a HandlingDomestic
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the HandlingDomestic we want to update
     *   }
     * })
     */
    upsert<T extends HandlingDomesticUpsertArgs>(args: SelectSubset<T, HandlingDomesticUpsertArgs<ExtArgs>>): Prisma__HandlingDomesticClient<$Result.GetResult<Prisma.$HandlingDomesticPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of HandlingDomestics.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingDomesticCountArgs} args - Arguments to filter HandlingDomestics to count.
     * @example
     * // Count the number of HandlingDomestics
     * const count = await prisma.handlingDomestic.count({
     *   where: {
     *     // ... the filter for the HandlingDomestics we want to count
     *   }
     * })
    **/
    count<T extends HandlingDomesticCountArgs>(
      args?: Subset<T, HandlingDomesticCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], HandlingDomesticCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a HandlingDomestic.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingDomesticAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends HandlingDomesticAggregateArgs>(args: Subset<T, HandlingDomesticAggregateArgs>): Prisma.PrismaPromise<GetHandlingDomesticAggregateType<T>>

    /**
     * Group by HandlingDomestic.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HandlingDomesticGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends HandlingDomesticGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: HandlingDomesticGroupByArgs['orderBy'] }
        : { orderBy?: HandlingDomesticGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, HandlingDomesticGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetHandlingDomesticGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the HandlingDomestic model
   */
  readonly fields: HandlingDomesticFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for HandlingDomestic.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__HandlingDomesticClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    MitraPackages<T extends HandlingDomestic$MitraPackagesArgs<ExtArgs> = {}>(args?: Subset<T, HandlingDomestic$MitraPackagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraPackagePayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the HandlingDomestic model
   */ 
  interface HandlingDomesticFieldRefs {
    readonly id: FieldRef<"HandlingDomestic", 'String'>
    readonly name: FieldRef<"HandlingDomestic", 'String'>
    readonly price_idr: FieldRef<"HandlingDomestic", 'Decimal'>
    readonly order_number: FieldRef<"HandlingDomestic", 'Int'>
    readonly created_at: FieldRef<"HandlingDomestic", 'DateTime'>
    readonly updated_at: FieldRef<"HandlingDomestic", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * HandlingDomestic findUnique
   */
  export type HandlingDomesticFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingDomestic
     */
    select?: HandlingDomesticSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingDomesticInclude<ExtArgs> | null
    /**
     * Filter, which HandlingDomestic to fetch.
     */
    where: HandlingDomesticWhereUniqueInput
  }

  /**
   * HandlingDomestic findUniqueOrThrow
   */
  export type HandlingDomesticFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingDomestic
     */
    select?: HandlingDomesticSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingDomesticInclude<ExtArgs> | null
    /**
     * Filter, which HandlingDomestic to fetch.
     */
    where: HandlingDomesticWhereUniqueInput
  }

  /**
   * HandlingDomestic findFirst
   */
  export type HandlingDomesticFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingDomestic
     */
    select?: HandlingDomesticSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingDomesticInclude<ExtArgs> | null
    /**
     * Filter, which HandlingDomestic to fetch.
     */
    where?: HandlingDomesticWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of HandlingDomestics to fetch.
     */
    orderBy?: HandlingDomesticOrderByWithRelationInput | HandlingDomesticOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for HandlingDomestics.
     */
    cursor?: HandlingDomesticWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` HandlingDomestics from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` HandlingDomestics.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of HandlingDomestics.
     */
    distinct?: HandlingDomesticScalarFieldEnum | HandlingDomesticScalarFieldEnum[]
  }

  /**
   * HandlingDomestic findFirstOrThrow
   */
  export type HandlingDomesticFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingDomestic
     */
    select?: HandlingDomesticSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingDomesticInclude<ExtArgs> | null
    /**
     * Filter, which HandlingDomestic to fetch.
     */
    where?: HandlingDomesticWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of HandlingDomestics to fetch.
     */
    orderBy?: HandlingDomesticOrderByWithRelationInput | HandlingDomesticOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for HandlingDomestics.
     */
    cursor?: HandlingDomesticWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` HandlingDomestics from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` HandlingDomestics.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of HandlingDomestics.
     */
    distinct?: HandlingDomesticScalarFieldEnum | HandlingDomesticScalarFieldEnum[]
  }

  /**
   * HandlingDomestic findMany
   */
  export type HandlingDomesticFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingDomestic
     */
    select?: HandlingDomesticSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingDomesticInclude<ExtArgs> | null
    /**
     * Filter, which HandlingDomestics to fetch.
     */
    where?: HandlingDomesticWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of HandlingDomestics to fetch.
     */
    orderBy?: HandlingDomesticOrderByWithRelationInput | HandlingDomesticOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing HandlingDomestics.
     */
    cursor?: HandlingDomesticWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` HandlingDomestics from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` HandlingDomestics.
     */
    skip?: number
    distinct?: HandlingDomesticScalarFieldEnum | HandlingDomesticScalarFieldEnum[]
  }

  /**
   * HandlingDomestic create
   */
  export type HandlingDomesticCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingDomestic
     */
    select?: HandlingDomesticSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingDomesticInclude<ExtArgs> | null
    /**
     * The data needed to create a HandlingDomestic.
     */
    data: XOR<HandlingDomesticCreateInput, HandlingDomesticUncheckedCreateInput>
  }

  /**
   * HandlingDomestic createMany
   */
  export type HandlingDomesticCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many HandlingDomestics.
     */
    data: HandlingDomesticCreateManyInput | HandlingDomesticCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * HandlingDomestic update
   */
  export type HandlingDomesticUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingDomestic
     */
    select?: HandlingDomesticSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingDomesticInclude<ExtArgs> | null
    /**
     * The data needed to update a HandlingDomestic.
     */
    data: XOR<HandlingDomesticUpdateInput, HandlingDomesticUncheckedUpdateInput>
    /**
     * Choose, which HandlingDomestic to update.
     */
    where: HandlingDomesticWhereUniqueInput
  }

  /**
   * HandlingDomestic updateMany
   */
  export type HandlingDomesticUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update HandlingDomestics.
     */
    data: XOR<HandlingDomesticUpdateManyMutationInput, HandlingDomesticUncheckedUpdateManyInput>
    /**
     * Filter which HandlingDomestics to update
     */
    where?: HandlingDomesticWhereInput
  }

  /**
   * HandlingDomestic upsert
   */
  export type HandlingDomesticUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingDomestic
     */
    select?: HandlingDomesticSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingDomesticInclude<ExtArgs> | null
    /**
     * The filter to search for the HandlingDomestic to update in case it exists.
     */
    where: HandlingDomesticWhereUniqueInput
    /**
     * In case the HandlingDomestic found by the `where` argument doesn't exist, create a new HandlingDomestic with this data.
     */
    create: XOR<HandlingDomesticCreateInput, HandlingDomesticUncheckedCreateInput>
    /**
     * In case the HandlingDomestic was found with the provided `where` argument, update it with this data.
     */
    update: XOR<HandlingDomesticUpdateInput, HandlingDomesticUncheckedUpdateInput>
  }

  /**
   * HandlingDomestic delete
   */
  export type HandlingDomesticDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingDomestic
     */
    select?: HandlingDomesticSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingDomesticInclude<ExtArgs> | null
    /**
     * Filter which HandlingDomestic to delete.
     */
    where: HandlingDomesticWhereUniqueInput
  }

  /**
   * HandlingDomestic deleteMany
   */
  export type HandlingDomesticDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which HandlingDomestics to delete
     */
    where?: HandlingDomesticWhereInput
  }

  /**
   * HandlingDomestic.MitraPackages
   */
  export type HandlingDomestic$MitraPackagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MitraPackage
     */
    select?: MitraPackageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MitraPackageInclude<ExtArgs> | null
    where?: MitraPackageWhereInput
    orderBy?: MitraPackageOrderByWithRelationInput | MitraPackageOrderByWithRelationInput[]
    cursor?: MitraPackageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MitraPackageScalarFieldEnum | MitraPackageScalarFieldEnum[]
  }

  /**
   * HandlingDomestic without action
   */
  export type HandlingDomesticDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HandlingDomestic
     */
    select?: HandlingDomesticSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HandlingDomesticInclude<ExtArgs> | null
  }


  /**
   * Model Siskopatuh
   */

  export type AggregateSiskopatuh = {
    _count: SiskopatuhCountAggregateOutputType | null
    _avg: SiskopatuhAvgAggregateOutputType | null
    _sum: SiskopatuhSumAggregateOutputType | null
    _min: SiskopatuhMinAggregateOutputType | null
    _max: SiskopatuhMaxAggregateOutputType | null
  }

  export type SiskopatuhAvgAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type SiskopatuhSumAggregateOutputType = {
    price_idr: Decimal | null
    order_number: number | null
  }

  export type SiskopatuhMinAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type SiskopatuhMaxAggregateOutputType = {
    id: string | null
    name: string | null
    price_idr: Decimal | null
    order_number: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type SiskopatuhCountAggregateOutputType = {
    id: number
    name: number
    price_idr: number
    order_number: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type SiskopatuhAvgAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type SiskopatuhSumAggregateInputType = {
    price_idr?: true
    order_number?: true
  }

  export type SiskopatuhMinAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type SiskopatuhMaxAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
  }

  export type SiskopatuhCountAggregateInputType = {
    id?: true
    name?: true
    price_idr?: true
    order_number?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type SiskopatuhAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Siskopatuh to aggregate.
     */
    where?: SiskopatuhWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Siskopatuhs to fetch.
     */
    orderBy?: SiskopatuhOrderByWithRelationInput | SiskopatuhOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: SiskopatuhWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Siskopatuhs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Siskopatuhs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Siskopatuhs
    **/
    _count?: true | SiskopatuhCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: SiskopatuhAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: SiskopatuhSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: SiskopatuhMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: SiskopatuhMaxAggregateInputType
  }

  export type GetSiskopatuhAggregateType<T extends SiskopatuhAggregateArgs> = {
        [P in keyof T & keyof AggregateSiskopatuh]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateSiskopatuh[P]>
      : GetScalarType<T[P], AggregateSiskopatuh[P]>
  }




  export type SiskopatuhGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: SiskopatuhWhereInput
    orderBy?: SiskopatuhOrderByWithAggregationInput | SiskopatuhOrderByWithAggregationInput[]
    by: SiskopatuhScalarFieldEnum[] | SiskopatuhScalarFieldEnum
    having?: SiskopatuhScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: SiskopatuhCountAggregateInputType | true
    _avg?: SiskopatuhAvgAggregateInputType
    _sum?: SiskopatuhSumAggregateInputType
    _min?: SiskopatuhMinAggregateInputType
    _max?: SiskopatuhMaxAggregateInputType
  }

  export type SiskopatuhGroupByOutputType = {
    id: string
    name: string
    price_idr: Decimal
    order_number: number
    created_at: Date
    updated_at: Date
    _count: SiskopatuhCountAggregateOutputType | null
    _avg: SiskopatuhAvgAggregateOutputType | null
    _sum: SiskopatuhSumAggregateOutputType | null
    _min: SiskopatuhMinAggregateOutputType | null
    _max: SiskopatuhMaxAggregateOutputType | null
  }

  type GetSiskopatuhGroupByPayload<T extends SiskopatuhGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<SiskopatuhGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof SiskopatuhGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], SiskopatuhGroupByOutputType[P]>
            : GetScalarType<T[P], SiskopatuhGroupByOutputType[P]>
        }
      >
    >


  export type SiskopatuhSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
    MitraPackages?: boolean | Siskopatuh$MitraPackagesArgs<ExtArgs>
    _count?: boolean | SiskopatuhCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["siskopatuh"]>


  export type SiskopatuhSelectScalar = {
    id?: boolean
    name?: boolean
    price_idr?: boolean
    order_number?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type SiskopatuhInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    MitraPackages?: boolean | Siskopatuh$MitraPackagesArgs<ExtArgs>
    _count?: boolean | SiskopatuhCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $SiskopatuhPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Siskopatuh"
    objects: {
      MitraPackages: Prisma.$MitraPackagePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      price_idr: Prisma.Decimal
      order_number: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["siskopatuh"]>
    composites: {}
  }

  type SiskopatuhGetPayload<S extends boolean | null | undefined | SiskopatuhDefaultArgs> = $Result.GetResult<Prisma.$SiskopatuhPayload, S>

  type SiskopatuhCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<SiskopatuhFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: SiskopatuhCountAggregateInputType | true
    }

  export interface SiskopatuhDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Siskopatuh'], meta: { name: 'Siskopatuh' } }
    /**
     * Find zero or one Siskopatuh that matches the filter.
     * @param {SiskopatuhFindUniqueArgs} args - Arguments to find a Siskopatuh
     * @example
     * // Get one Siskopatuh
     * const siskopatuh = await prisma.siskopatuh.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends SiskopatuhFindUniqueArgs>(args: SelectSubset<T, SiskopatuhFindUniqueArgs<ExtArgs>>): Prisma__SiskopatuhClient<$Result.GetResult<Prisma.$SiskopatuhPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Siskopatuh that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {SiskopatuhFindUniqueOrThrowArgs} args - Arguments to find a Siskopatuh
     * @example
     * // Get one Siskopatuh
     * const siskopatuh = await prisma.siskopatuh.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends SiskopatuhFindUniqueOrThrowArgs>(args: SelectSubset<T, SiskopatuhFindUniqueOrThrowArgs<ExtArgs>>): Prisma__SiskopatuhClient<$Result.GetResult<Prisma.$SiskopatuhPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Siskopatuh that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SiskopatuhFindFirstArgs} args - Arguments to find a Siskopatuh
     * @example
     * // Get one Siskopatuh
     * const siskopatuh = await prisma.siskopatuh.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends SiskopatuhFindFirstArgs>(args?: SelectSubset<T, SiskopatuhFindFirstArgs<ExtArgs>>): Prisma__SiskopatuhClient<$Result.GetResult<Prisma.$SiskopatuhPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Siskopatuh that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SiskopatuhFindFirstOrThrowArgs} args - Arguments to find a Siskopatuh
     * @example
     * // Get one Siskopatuh
     * const siskopatuh = await prisma.siskopatuh.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends SiskopatuhFindFirstOrThrowArgs>(args?: SelectSubset<T, SiskopatuhFindFirstOrThrowArgs<ExtArgs>>): Prisma__SiskopatuhClient<$Result.GetResult<Prisma.$SiskopatuhPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Siskopatuhs that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SiskopatuhFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Siskopatuhs
     * const siskopatuhs = await prisma.siskopatuh.findMany()
     * 
     * // Get first 10 Siskopatuhs
     * const siskopatuhs = await prisma.siskopatuh.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const siskopatuhWithIdOnly = await prisma.siskopatuh.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends SiskopatuhFindManyArgs>(args?: SelectSubset<T, SiskopatuhFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$SiskopatuhPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Siskopatuh.
     * @param {SiskopatuhCreateArgs} args - Arguments to create a Siskopatuh.
     * @example
     * // Create one Siskopatuh
     * const Siskopatuh = await prisma.siskopatuh.create({
     *   data: {
     *     // ... data to create a Siskopatuh
     *   }
     * })
     * 
     */
    create<T extends SiskopatuhCreateArgs>(args: SelectSubset<T, SiskopatuhCreateArgs<ExtArgs>>): Prisma__SiskopatuhClient<$Result.GetResult<Prisma.$SiskopatuhPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Siskopatuhs.
     * @param {SiskopatuhCreateManyArgs} args - Arguments to create many Siskopatuhs.
     * @example
     * // Create many Siskopatuhs
     * const siskopatuh = await prisma.siskopatuh.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends SiskopatuhCreateManyArgs>(args?: SelectSubset<T, SiskopatuhCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Siskopatuh.
     * @param {SiskopatuhDeleteArgs} args - Arguments to delete one Siskopatuh.
     * @example
     * // Delete one Siskopatuh
     * const Siskopatuh = await prisma.siskopatuh.delete({
     *   where: {
     *     // ... filter to delete one Siskopatuh
     *   }
     * })
     * 
     */
    delete<T extends SiskopatuhDeleteArgs>(args: SelectSubset<T, SiskopatuhDeleteArgs<ExtArgs>>): Prisma__SiskopatuhClient<$Result.GetResult<Prisma.$SiskopatuhPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Siskopatuh.
     * @param {SiskopatuhUpdateArgs} args - Arguments to update one Siskopatuh.
     * @example
     * // Update one Siskopatuh
     * const siskopatuh = await prisma.siskopatuh.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends SiskopatuhUpdateArgs>(args: SelectSubset<T, SiskopatuhUpdateArgs<ExtArgs>>): Prisma__SiskopatuhClient<$Result.GetResult<Prisma.$SiskopatuhPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Siskopatuhs.
     * @param {SiskopatuhDeleteManyArgs} args - Arguments to filter Siskopatuhs to delete.
     * @example
     * // Delete a few Siskopatuhs
     * const { count } = await prisma.siskopatuh.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends SiskopatuhDeleteManyArgs>(args?: SelectSubset<T, SiskopatuhDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Siskopatuhs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SiskopatuhUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Siskopatuhs
     * const siskopatuh = await prisma.siskopatuh.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends SiskopatuhUpdateManyArgs>(args: SelectSubset<T, SiskopatuhUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Siskopatuh.
     * @param {SiskopatuhUpsertArgs} args - Arguments to update or create a Siskopatuh.
     * @example
     * // Update or create a Siskopatuh
     * const siskopatuh = await prisma.siskopatuh.upsert({
     *   create: {
     *     // ... data to create a Siskopatuh
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Siskopatuh we want to update
     *   }
     * })
     */
    upsert<T extends SiskopatuhUpsertArgs>(args: SelectSubset<T, SiskopatuhUpsertArgs<ExtArgs>>): Prisma__SiskopatuhClient<$Result.GetResult<Prisma.$SiskopatuhPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Siskopatuhs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SiskopatuhCountArgs} args - Arguments to filter Siskopatuhs to count.
     * @example
     * // Count the number of Siskopatuhs
     * const count = await prisma.siskopatuh.count({
     *   where: {
     *     // ... the filter for the Siskopatuhs we want to count
     *   }
     * })
    **/
    count<T extends SiskopatuhCountArgs>(
      args?: Subset<T, SiskopatuhCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], SiskopatuhCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Siskopatuh.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SiskopatuhAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends SiskopatuhAggregateArgs>(args: Subset<T, SiskopatuhAggregateArgs>): Prisma.PrismaPromise<GetSiskopatuhAggregateType<T>>

    /**
     * Group by Siskopatuh.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SiskopatuhGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends SiskopatuhGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: SiskopatuhGroupByArgs['orderBy'] }
        : { orderBy?: SiskopatuhGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, SiskopatuhGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetSiskopatuhGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Siskopatuh model
   */
  readonly fields: SiskopatuhFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Siskopatuh.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__SiskopatuhClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    MitraPackages<T extends Siskopatuh$MitraPackagesArgs<ExtArgs> = {}>(args?: Subset<T, Siskopatuh$MitraPackagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MitraPackagePayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Siskopatuh model
   */ 
  interface SiskopatuhFieldRefs {
    readonly id: FieldRef<"Siskopatuh", 'String'>
    readonly name: FieldRef<"Siskopatuh", 'String'>
    readonly price_idr: FieldRef<"Siskopatuh", 'Decimal'>
    readonly order_number: FieldRef<"Siskopatuh", 'Int'>
    readonly created_at: FieldRef<"Siskopatuh", 'DateTime'>
    readonly updated_at: FieldRef<"Siskopatuh", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Siskopatuh findUnique
   */
  export type SiskopatuhFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Siskopatuh
     */
    select?: SiskopatuhSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SiskopatuhInclude<ExtArgs> | null
    /**
     * Filter, which Siskopatuh to fetch.
     */
    where: SiskopatuhWhereUniqueInput
  }

  /**
   * Siskopatuh findUniqueOrThrow
   */
  export type SiskopatuhFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Siskopatuh
     */
    select?: SiskopatuhSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SiskopatuhInclude<ExtArgs> | null
    /**
     * Filter, which Siskopatuh to fetch.
     */
    where: SiskopatuhWhereUniqueInput
  }

  /**
   * Siskopatuh findFirst
   */
  export type SiskopatuhFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Siskopatuh
     */
    select?: SiskopatuhSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SiskopatuhInclude<ExtArgs> | null
    /**
     * Filter, which Siskopatuh to fetch.
     */
    where?: SiskopatuhWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Siskopatuhs to fetch.
     */
    orderBy?: SiskopatuhOrderByWithRelationInput | SiskopatuhOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts