import { z, ZodType } from 'zod';

export class MitraRequestValidation {
  static readonly CREATE: ZodType = z.object({
    ktp: z.string({ message: 'KTP harus diisi' }),
    upgrade_amount: z.number().int({ message: 'Jumlah upgrade harus diisi' }),
    payment_proof: z.string({ message: 'Bukti pembayaran harus diisi' }),
  });

  static readonly QUERY: ZodType = z.object({
    search: z.string().optional(),
    status: z.string().optional(),
    sort: z.string().optional(),
    order: z.string().optional(),
    page: z.number().int().min(1).default(1),
    limit: z.number().int().min(1).max(100).default(10),
  });

  static readonly UPDATE_STATUS: ZodType = z.object({
    status: z.string().refine((value) => ['PENDING', 'APPROVED', 'REJECTED'].includes(value), {
      message: 'Status harus PENDING, APPROVED, atau REJECTED',
    }),
  });
}
