import { z, ZodType } from 'zod';

const TextValueSchema = z.object({
  text: z.string({ message: 'Text harus diisi' }),
});

const ImageValueSchema = z.object({
  src: z.string({ message: 'Image URL harus diisi' }),
});

const ButtonValueSchema = z.object({
  text: z.string({ message: 'Button text harus diisi' }),
  url: z.string({ message: 'Button URL harus diisi' }),
});

const BenefitCardValueSchema = z.object({
  title: z.string({ message: 'Title harus diisi' }),
  description: z.string({ message: 'Description harus diisi' }),
});

export class ContentValidation {
  static readonly CREATE: ZodType = z.object({
    page: z.string({ message: 'Page harus diisi' }),
    section: z.string({ message: 'Section harus diisi' }),
    type: z.string({ message: 'Type harus diisi' }),
    key: z.string({ message: 'Key harus diisi' }),
    value: z.union([z.string(), ButtonValueSchema, TextValueSchema, ImageValueSchema, BenefitCardValueSchema]),
  });

  static readonly UPDATE: ZodType = z.object({
    page: z.string({ message: 'Page harus diisi' }),
    section: z.string({ message: 'Section harus diisi' }),
    type: z.string({ message: 'Type harus diisi' }),
    key: z.string({ message: 'Key harus diisi' }),
    value: z.union([z.string(), ButtonValueSchema, TextValueSchema, ImageValueSchema, BenefitCardValueSchema]),
  });

  static readonly UPDATE_VALUE: ZodType = z.object({
    value: z.union([z.string(), ButtonValueSchema, TextValueSchema, ImageValueSchema, BenefitCardValueSchema]),
  });

  static readonly CREATE_COLOR: ZodType = z.object({
    name: z.string({ message: 'Name harus diisi' }),
    hex: z.string({ message: 'Hex harus diisi' }),
  });

  static readonly UPDATE_COLORS: ZodType = z.array(
    z.object({
      id: z.string({ message: 'ID harus diisi' }),
      hex: z.string({ message: 'Hex harus diisi' }),
    }),
  );

}
