import { db } from '../application/database';
import { PackageType, PackageTypeResponse, toPackageTypeResponse } from '../model/package-type-model';

export class PackageTypeService {
  static async getAll(): Promise<PackageTypeResponse[]> {
    // Get all package types from the database
    const packageTypes = await db.query<PackageType>('SELECT * FROM package_type');

    // Map the package types to the response format
    return packageTypes.map(toPackageTypeResponse);
  }
}
