import { User, toUserResponse, UserResponse } from './user-model';

export type ProductOrder = {
  id: string;
  user_id: string;
  product_id: string;
  variation_id: string | null;
  departure: Date;
  number_of_pax: number;
  per_pax_price: number;
  total_price: number;
  created_at: Date;
  updated_at: Date;
};

export type ProductOrderResponse = {
  id: string;
  user: UserResponse;
  product_id: string;
  product_name: string;
  variation: ProductVariation | null;
  departure: Date;
  number_of_pax: number;
  per_pax_price: number;
  total_price: number;
  created_at: Date;
  updated_at: Date;
};

export type CreateProductOrderRequest = {
  product_id: string;
  variation_id?: string;
  departure: Date;
  number_of_pax: number;
  per_pax_price: number;
  total_price: number;
};

export type ProductOrderQueryParams = {
  search?: string;
  sort?: string;
  order?: 'asc' | 'desc';
  page: number;
  limit: number;
};

export type ProductVariation = {
  id: string;
  name: string;
  price: number;
};

export function toProductOrderResponse(
  productOrder: ProductOrder & {
    user: User;
    productVariation?: ProductVariation | null;
    product: { name: string };
  }
): ProductOrderResponse {
  console.log(productOrder);
  return {
    id: productOrder.id,
    user: toUserResponse(productOrder.user),
    product_id: productOrder.product_id,
    product_name: productOrder.product.name,
    variation: productOrder.productVariation ?? null,
    departure: productOrder.departure,
    number_of_pax: productOrder.number_of_pax,
    per_pax_price: Number(productOrder.per_pax_price.toString()),
    total_price: Number(productOrder.total_price.toString()),
    created_at: productOrder.created_at,
    updated_at: productOrder.updated_at,
  };
}
