import { User, toUserResponse, UserResponse } from "./user-model";

export type MitraRequest = {
  id: string;
  user_id: string;
  ktp: string;
  upgrade_amount: string;
  payment_proof: string;
  status: RequestStatus;
  created_at: Date;
  updated_at: Date;
};

export type MitraRequestResponse = {
  id: string;
  user: UserResponse;
  ktp: string;
  upgrade_amount: number;
  payment_proof: string;
  status: RequestStatus;
  created_at: Date;
  updated_at: Date;
};

export type RequestStatus = 'PENDING' | 'APPROVED' | 'REJECTED';

export type CreateMitraRequestRequest = {
  ktp: string;
  upgrade_amount: number;
  payment_proof: string;
};

export type MitraRequestQueryParams = {
  search?: string;
  status?: RequestStatus;
  sort?: string;
  order?: 'asc' | 'desc';
  page: number;
  limit: number;
};

export type UpdateMitraRequestStatusRequest = {
  status: RequestStatus;
};

export function toMitraRequestResponse(
  request: MitraRequest & {
    user: User;
  }
): MitraRequestResponse {
  return {
    id: request.id,
    user: toUserResponse(request.user),
    ktp: request.ktp,
    upgrade_amount: Number(request.upgrade_amount),
    payment_proof: request.payment_proof,
    status: request.status,
    created_at: request.created_at,
    updated_at: request.updated_at,
  };
}