export type FooterType = 'MENU' | 'LINK' | 'SOCIAL_MEDIA';

export type Footer = {
  id: string;
  name: string;
  type: FooterType;
  visible: boolean;
  order: number;
  FooterItem: FooterItem[];
};

export type FooterItem = {
  id: string;
  name: string;
  url: string;
  visible: boolean;
};

export type FooterItemResponse = {
  id: string;
  name: string;
  url: string;
  visible: boolean;
};

export type FooterResponse = {
  id: string;
  name: string;
  type: FooterType;
  visible: boolean;
  order: number;
  items: FooterItemResponse[];
};

export type CreateFooterItemRequest = {
  name: string;
  url: string;
};

export type UpdateFooterItemRequest = CreateFooterItemRequest;

export type CreateFooterRequest = {
  name: string;
  type: FooterType;
  order: number;
};

export type UpdateFooterRequest = {
  name: string;
};

export type UpdateFooterOrderRequest = {
  id: string;
  order: number;
};

export function toFooterItemResponse(footerItem: FooterItem): FooterItemResponse {
  return {
    id: footerItem.id,
    name: footerItem.name,
    url: footerItem.url,
    visible: footerItem.visible,
  };
}

export function toFooterResponse(footer: Footer & { items: FooterItem[] }): FooterResponse {
  return {
    id: footer.id,
    name: footer.name,
    type: footer.type,
    visible: footer.visible,
    order: footer.order,
    items: footer.items.map(toFooterItemResponse),
  };
}
