import { NextFunction, Request, Response } from 'express';
import { MenuItemService } from '../service/menu-item-service';
import { CreateMenuItemRequest, UpdateMenuItemRequest } from '../model/menu-item-model';

export class MenuItemController {
  static async create(req: Request, res: Response, next: NextFunction) {
    try {
      const request: CreateMenuItemRequest = req.body as CreateMenuItemRequest;
      const response = await MenuItemService.create(request);

      res.status(201).json({
        success: true,
        message: 'Menu item created successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async getAll(req: Request, res: Response, next: NextFunction) {
    try {
      const response = await MenuItemService.getAll();

      res.status(200).json({
        success: true,
        message: 'Menu items retrieved successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async get(req: Request, res: Response, next: NextFunction) {
    try {
      const id = req.params.id;
      const response = await MenuItemService.get(id);

      res.status(200).json({
        success: true,
        message: 'Menu item retrieved successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async update(req: Request, res: Response, next: NextFunction) {
    try {
      const id = req.params.id;
      const request: UpdateMenuItemRequest = req.body as UpdateMenuItemRequest;
      const response = await MenuItemService.update(id, request);

      res.status(200).json({
        success: true,
        message: 'Menu item updated successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async updateVisibility(req: Request, res: Response, next: NextFunction) {
    try {
      const id = req.params.id;
      const visible = req.body.visible;
      const response = await MenuItemService.updateVisibility(id, visible);

      res.status(200).json({
        success: true,
        message: 'Menu item visibility updated successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async delete(req: Request, res: Response, next: NextFunction) {
    try {
      const id = req.params.id;
      await MenuItemService.delete(id);

      res.status(200).json({
        success: true,
        message: 'Menu item deleted successfully',
      });
    } catch (error) {
      next(error);
    }
  }
}
