import * as assert from 'assert';
import v1 from './v1.js';
import v3 from './v3.js';
import v4 from './v4.js';
import v5 from './v5.js';
import v6 from './v6.js';
import v7 from './v7.js';
function usage() {
    console.log('Usage:');
    console.log('  uuid');
    console.log('  uuid v1');
    console.log('  uuid v3 <name> <namespace uuid>');
    console.log('  uuid v4');
    console.log('  uuid v5 <name> <namespace uuid>');
    console.log('  uuid v6');
    console.log('  uuid v7');
    console.log('  uuid --help');
    console.log('\nNote: <namespace uuid> may be "URL" or "DNS" to use the corresponding UUIDs defined by RFC9562');
}
const args = process.argv.slice(2);
if (args.indexOf('--help') >= 0) {
    usage();
    process.exit(0);
}
const version = args.shift() || 'v4';
switch (version) {
    case 'v1':
        console.log(v1());
        break;
    case 'v3': {
        const name = args.shift();
        let namespace = args.shift();
        assert.ok(name != null, 'v3 name not specified');
        assert.ok(namespace != null, 'v3 namespace not specified');
        if (namespace === 'URL') {
            namespace = v3.URL;
        }
        if (namespace === 'DNS') {
            namespace = v3.DNS;
        }
        console.log(v3(name, namespace));
        break;
    }
    case 'v4':
        console.log(v4());
        break;
    case 'v5': {
        const name = args.shift();
        let namespace = args.shift();
        assert.ok(name != null, 'v5 name not specified');
        assert.ok(namespace != null, 'v5 namespace not specified');
        if (namespace === 'URL') {
            namespace = v5.URL;
        }
        if (namespace === 'DNS') {
            namespace = v5.DNS;
        }
        console.log(v5(name, namespace));
        break;
    }
    case 'v6':
        console.log(v6());
        break;
    case 'v7':
        console.log(v7());
        break;
    default:
        usage();
        process.exit(1);
}
//# sourceMappingURL=data:application/json;base64,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