"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert = require("assert");
const node_test_1 = require("node:test");
const parse_js_1 = require("../parse.js");
const stringify_js_1 = require("../stringify.js");
const v4_js_1 = require("../v4.js");
function splitmix32(a) {
    return function () {
        a |= 0;
        a = (a + 0x9e3779b9) | 0;
        let t = a ^ (a >>> 16);
        t = Math.imul(t, 0x21f0aaad);
        t = t ^ (t >>> 15);
        t = Math.imul(t, 0x735a2d97);
        return ((t = t ^ (t >>> 15)) >>> 0) / 4294967296;
    };
}
const rand = splitmix32(0x12345678);
function rng(bytes = new Uint8Array(16)) {
    for (let i = 0; i < 16; i++) {
        bytes[i] = rand() * 256;
    }
    return bytes;
}
(0, node_test_1.describe)('parse', () => {
    (0, node_test_1.default)('String -> bytes parsing', () => {
        assert.deepStrictEqual((0, parse_js_1.default)('0f5abcd1-c194-47f3-905b-2df7263a084b'), Uint8Array.from([
            0x0f, 0x5a, 0xbc, 0xd1, 0xc1, 0x94, 0x47, 0xf3, 0x90, 0x5b, 0x2d, 0xf7, 0x26, 0x3a, 0x08,
            0x4b,
        ]));
    });
    (0, node_test_1.default)('String -> bytes -> string symmetry for assorted uuids', () => {
        for (let i = 0; i < 1000; i++) {
            const uuid = (0, v4_js_1.default)({ rng });
            assert.equal((0, stringify_js_1.default)((0, parse_js_1.default)(uuid)), uuid);
        }
    });
    (0, node_test_1.default)('Case neutrality', () => {
        assert.deepStrictEqual((0, parse_js_1.default)('0f5abcd1-c194-47f3-905b-2df7263a084b'), (0, parse_js_1.default)('0f5abcd1-c194-47f3-905b-2df7263a084b'.toUpperCase()));
    });
    (0, node_test_1.default)('Null UUID case', () => {
        assert.deepStrictEqual((0, parse_js_1.default)('00000000-0000-0000-0000-000000000000'), Uint8Array.from(new Array(16).fill(0)));
    });
    (0, node_test_1.default)('UUID validation', () => {
        assert.throws(() => (0, parse_js_1.default)());
        assert.throws(() => (0, parse_js_1.default)('invalid uuid'));
        assert.throws(() => (0, parse_js_1.default)('zyxwvuts-rqpo-nmlk-jihg-fedcba000000'));
    });
});
//# sourceMappingURL=data:application/json;base64,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