"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductValidation = void 0;
const zod_1 = require("zod");
const productVariationSchema = zod_1.z.object({
    name: zod_1.z.string({ required_error: 'Nama variasi produk harus diisi' }).min(1).max(255),
    price: zod_1.z.number({ required_error: 'Harga variasi produk harus diisi' }),
});
class ProductValidation {
}
exports.ProductValidation = ProductValidation;
ProductValidation.CREATE = zod_1.z.object({
    name: zod_1.z.string({ required_error: 'Nama produk harus diisi' }).min(1).max(255),
    description: zod_1.z.string().optional(),
    price: zod_1.z.number().optional(),
    has_variation: zod_1.z.boolean(),
    thumbnails: zod_1.z.array(zod_1.z.string()).optional(),
    category_ids: zod_1.z.array(zod_1.z.string()).optional(),
    variations: zod_1.z.array(productVariationSchema).optional(),
    includes: zod_1.z.array(zod_1.z.string()).optional(),
    excludes: zod_1.z.array(zod_1.z.string()).optional(),
});
ProductValidation.QUERY = zod_1.z.object({
    name: zod_1.z.string().optional(),
    price: zod_1.z.number().optional(),
    category_id: zod_1.z.array(zod_1.z.string()).optional(),
    has_variation: zod_1.z.boolean().optional(),
    sort: zod_1.z.string().optional(),
    order: zod_1.z.string().optional(),
    page: zod_1.z.number().int().min(1).default(1),
    limit: zod_1.z.number().int().min(1).max(100).default(10),
});
ProductValidation.UPDATE = zod_1.z.object({
    name: zod_1.z.string().min(1).max(255).optional(),
    description: zod_1.z.string().optional(),
    price: zod_1.z.number().optional(),
    has_variation: zod_1.z.boolean().optional(),
    thumbnails: zod_1.z.array(zod_1.z.string()).optional(),
    category_ids: zod_1.z.array(zod_1.z.string()).optional(),
    variations: zod_1.z.array(productVariationSchema).optional(),
    includes: zod_1.z.array(zod_1.z.string()).optional(),
    excludes: zod_1.z.array(zod_1.z.string()).optional(),
});
