"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrderValidation = void 0;
const zod_1 = require("zod");
class OrderValidation {
}
exports.OrderValidation = OrderValidation;
OrderValidation.CREATE = zod_1.z.object({
    product_id: zod_1.z.string(),
    variation_id: zod_1.z.string().optional(),
    departure: zod_1.z.string().datetime(),
    number_of_pax: zod_1.z.number().int().positive(),
    per_pax_price: zod_1.z.number(),
    total_price: zod_1.z.number(),
});
OrderValidation.QUERY = zod_1.z.object({
    search: zod_1.z.string().optional(),
    sort: zod_1.z.string().optional(),
    order: zod_1.z.string().optional(),
    page: zod_1.z.number().int().min(1).default(1),
    limit: zod_1.z.number().int().min(1).max(100).default(10),
});
