"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HotelValidation = void 0;
const zod_1 = require("zod");
class HotelValidation {
}
exports.HotelValidation = HotelValidation;
HotelValidation.CREATE = zod_1.z.object({
    vendor_id: zod_1.z.string({ message: 'ID vendor harus diisi' }),
    name: zod_1.z.string({ message: 'Nama hotel harus diisi' }),
    city: zod_1.z.string({ message: 'Kota hotel harus diisi' }),
    order_number: zod_1.z.number().int({ message: 'Nomor urut harus integer' }).min(1, 'Nomor urut minimal 1'),
    prices: zod_1.z.object({
        double: zod_1.z
            .number()
            .int({ message: 'Harga kamar double harus integer' })
            .min(0, 'Harga kamar double tidak boleh negatif'),
        triple: zod_1.z
            .number()
            .int({ message: 'Harga kamar triple harus integer' })
            .min(0, 'Harga kamar triple tidak boleh negatif'),
        quad: zod_1.z
            .number()
            .int({ message: 'Harga kamar quad harus integer' })
            .min(0, 'Harga kamar quad tidak boleh negatif'),
    }),
});
HotelValidation.UPDATE = zod_1.z.object({
    name: zod_1.z.string({ message: 'Nama hotel harus diisi' }),
    city: zod_1.z.string({ message: 'Kota hotel harus diisi' }),
    price_double: zod_1.z
        .number()
        .int({ message: 'Harga kamar double harus integer' })
        .min(0, 'Harga kamar double tidak boleh negatif'),
    price_triple: zod_1.z
        .number()
        .int({ message: 'Harga kamar triple harus integer' })
        .min(0, 'Harga kamar triple tidak boleh negatif'),
    price_quad: zod_1.z
        .number()
        .int({ message: 'Harga kamar quad harus integer' })
        .min(0, 'Harga kamar quad tidak boleh negatif'),
    order_number: zod_1.z.number().int({ message: 'Nomor urut harus integer' }).min(1, 'Nomor urut minimal 1'),
});
HotelValidation.BULK_UPDATE = zod_1.z.object({
    modified: zod_1.z.array(zod_1.z.object({
        hotel_id: zod_1.z.string({ message: 'ID hotel harus diisi' }),
        period_id: zod_1.z.string({ message: 'ID periode harus diisi' }),
        vendor_id: zod_1.z.string({ message: 'ID vendor harus diisi' }),
        city: zod_1.z.string({ message: 'Kota hotel harus diisi' }),
        name: zod_1.z.string({ message: 'Nama hotel harus diisi' }),
        price_double: zod_1.z
            .number()
            .int({ message: 'Harga kamar double harus integer' })
            .min(0, 'Harga kamar double tidak boleh negatif'),
        price_triple: zod_1.z
            .number()
            .int({ message: 'Harga kamar triple harus integer' })
            .min(0, 'Harga kamar triple tidak boleh negatif'),
        price_quad: zod_1.z
            .number()
            .int({ message: 'Harga kamar quad harus integer' })
            .min(0, 'Harga kamar quad tidak boleh negatif'),
        order_number: zod_1.z.number().int({ message: 'Nomor urut harus integer' }).min(1, 'Nomor urut minimal 1'),
    })),
    deleted: zod_1.z.array(zod_1.z.string(), { message: 'ID hotel yang dihapus harus diisi' }).optional(),
});
HotelValidation.QUERY = zod_1.z.object({
    vendor_id: zod_1.z.string().optional(),
    period_id: zod_1.z.string().optional(),
    city: zod_1.z.string().optional(),
});
