"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentValidation = void 0;
const zod_1 = require("zod");
const TextValueSchema = zod_1.z.object({
    text: zod_1.z.string({ message: 'Text harus diisi' }),
});
const ImageValueSchema = zod_1.z.object({
    src: zod_1.z.string({ message: 'Image URL harus diisi' }),
});
const ButtonValueSchema = zod_1.z.object({
    text: zod_1.z.string({ message: 'Button text harus diisi' }),
    url: zod_1.z.string({ message: 'Button URL harus diisi' }),
});
const BenefitCardValueSchema = zod_1.z.object({
    title: zod_1.z.string({ message: 'Title harus diisi' }),
    description: zod_1.z.string({ message: 'Description harus diisi' }),
});
class ContentValidation {
}
exports.ContentValidation = ContentValidation;
ContentValidation.CREATE = zod_1.z.object({
    page: zod_1.z.string({ message: 'Page harus diisi' }),
    section: zod_1.z.string({ message: 'Section harus diisi' }),
    type: zod_1.z.string({ message: 'Type harus diisi' }),
    key: zod_1.z.string({ message: 'Key harus diisi' }),
    value: zod_1.z.union([zod_1.z.string(), ButtonValueSchema, TextValueSchema, ImageValueSchema, BenefitCardValueSchema]),
});
ContentValidation.UPDATE = zod_1.z.object({
    page: zod_1.z.string({ message: 'Page harus diisi' }),
    section: zod_1.z.string({ message: 'Section harus diisi' }),
    type: zod_1.z.string({ message: 'Type harus diisi' }),
    key: zod_1.z.string({ message: 'Key harus diisi' }),
    value: zod_1.z.union([zod_1.z.string(), ButtonValueSchema, TextValueSchema, ImageValueSchema, BenefitCardValueSchema]),
});
ContentValidation.UPDATE_VALUE = zod_1.z.object({
    value: zod_1.z.union([zod_1.z.string(), ButtonValueSchema, TextValueSchema, ImageValueSchema, BenefitCardValueSchema]),
});
ContentValidation.CREATE_COLOR = zod_1.z.object({
    name: zod_1.z.string({ message: 'Name harus diisi' }),
    hex: zod_1.z.string({ message: 'Hex harus diisi' }),
});
ContentValidation.UPDATE_COLORS = zod_1.z.array(zod_1.z.object({
    id: zod_1.z.string({ message: 'ID harus diisi' }),
    hex: zod_1.z.string({ message: 'Hex harus diisi' }),
}));
