"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthValidation = void 0;
const zod_1 = require("zod");
class AuthValidation {
}
exports.AuthValidation = AuthValidation;
AuthValidation.REGISTER = zod_1.z.object({
    full_name: zod_1.z
        .string({ required_error: 'Nama lengkap tidak boleh kosong' })
        .min(3, 'Nama lengkap minimal 3 karakter')
        .max(100, 'Nama lengkap maksimal 100 karakter'),
    email: zod_1.z
        .string({ required_error: 'Email tidak boleh kosong' })
        .min(1, 'Email tidak boleh kosong')
        .email('Email tidak valid'),
    whatsapp_number: zod_1.z
        .string({ required_error: 'Nomor Whatsapp tidak boleh kosong' })
        .min(10, 'Nomor WhatsApp tidak valid')
        .max(15, 'Nomor WhatsApp tidak valid'),
    password: zod_1.z
        .string({ required_error: 'Password tidak boleh kosong' })
        .min(6, 'Password minimal 6 karakter')
        .max(100, 'Password maksimal 100 karakter'),
});
AuthValidation.LOGIN = zod_1.z.object({
    email: zod_1.z.string({ required_error: 'Email tidak boleh kosong' }).email('Email tidak valid'),
    password: zod_1.z.string({ required_error: 'Password tidak boleh kosong' }).min(1, 'Password tidak boleh kosong'),
});
