"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _a, _MenuItemService_checkMenuItemExist;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MenuItemService = void 0;
const uuid_1 = require("uuid");
const database_1 = require("../application/database");
const response_error_1 = require("../error/response-error");
const menu_item_model_1 = require("../model/menu-item-model");
const menu_item_validation_1 = require("../validation/menu-item-validation");
const validation_1 = require("../validation/validation");
class MenuItemService {
    static create(request) {
        return __awaiter(this, void 0, void 0, function* () {
            // Validate the create request
            const createRequest = validation_1.Validation.validate(menu_item_validation_1.MenuItemValidation.CREATE, request);
            // Generate a UUID for the new menu item
            const menuItemId = (0, uuid_1.v4)();
            // Insert the new menu item into the database with the UUID
            yield database_1.db.query('INSERT INTO menu_item (id, name, url) VALUES (?, ?, ?)', [
                menuItemId,
                createRequest.name,
                createRequest.url,
            ]);
            // Retrieve the newly created menu item by the UUID
            const menuItem = yield database_1.db.queryOne('SELECT * FROM menu_item WHERE id = ? LIMIT 1', [menuItemId]);
            if (!menuItem) {
                throw new response_error_1.ResponseError(500, 'Failed to create menu item');
            }
            return (0, menu_item_model_1.toMenuItemResponse)(menuItem);
        });
    }
    static getAll() {
        return __awaiter(this, void 0, void 0, function* () {
            // Retrieve all menu items from the database
            const menuItems = yield database_1.db.query('SELECT * FROM menu_item ORDER BY created_at ASC');
            // Map each menu item to the response format
            return menuItems.map(menu_item_model_1.toMenuItemResponse);
        });
    }
    static get(id) {
        return __awaiter(this, void 0, void 0, function* () {
            // Retrieve a single menu item by ID
            const menuItem = yield database_1.db.queryOne('SELECT * FROM menu_item WHERE id = ? LIMIT 1', [id]);
            if (!menuItem) {
                throw new response_error_1.ResponseError(404, 'Menu item not found');
            }
            return (0, menu_item_model_1.toMenuItemResponse)(menuItem);
        });
    }
    static update(id, request) {
        return __awaiter(this, void 0, void 0, function* () {
            // Check if the menu item exists
            yield __classPrivateFieldGet(this, _a, "m", _MenuItemService_checkMenuItemExist).call(this, id);
            // Validate the update request
            const updateRequest = validation_1.Validation.validate(menu_item_validation_1.MenuItemValidation.UPDATE, request);
            // Update the menu item in the database
            yield database_1.db.query('UPDATE menu_item SET name = ?, url = ? WHERE id = ?', [updateRequest.name, updateRequest.url, id]);
            // Retrieve the updated menu item by the ID
            const menuItem = yield database_1.db.queryOne('SELECT * FROM menu_item WHERE id = ? LIMIT 1', [id]);
            if (!menuItem) {
                throw new response_error_1.ResponseError(500, 'Failed to update menu item');
            }
            return (0, menu_item_model_1.toMenuItemResponse)(menuItem);
        });
    }
    static updateVisibility(id, visible) {
        return __awaiter(this, void 0, void 0, function* () {
            // Check if the menu item exists
            yield __classPrivateFieldGet(this, _a, "m", _MenuItemService_checkMenuItemExist).call(this, id);
            // Update the visibility of the menu item in the database
            yield database_1.db.query('UPDATE menu_item SET visible = ? WHERE id = ?', [visible, id]);
            // Retrieve the updated menu item by ID
            const menuItem = yield database_1.db.queryOne('SELECT * FROM menu_item WHERE id = ? LIMIT 1', [id]);
            if (!menuItem) {
                throw new response_error_1.ResponseError(500, 'Failed to update menu item visibility');
            }
            return (0, menu_item_model_1.toMenuItemResponse)(menuItem);
        });
    }
    static delete(id) {
        return __awaiter(this, void 0, void 0, function* () {
            // Check if the menu item exists
            yield __classPrivateFieldGet(this, _a, "m", _MenuItemService_checkMenuItemExist).call(this, id);
            // Delete the menu item from the database
            yield database_1.db.query('DELETE FROM menu_item WHERE id = ?', [id]);
        });
    }
}
exports.MenuItemService = MenuItemService;
_a = MenuItemService, _MenuItemService_checkMenuItemExist = function _MenuItemService_checkMenuItemExist(id) {
    return __awaiter(this, void 0, void 0, function* () {
        // Check if the menu item exists
        const existingMenuItem = yield database_1.db.queryOne('SELECT id FROM menu_item WHERE id = ? LIMIT 1', [id]);
        if (!existingMenuItem) {
            throw new response_error_1.ResponseError(404, 'Menu item not found');
        }
    });
};
