"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.publicRouter = void 0;
const express_1 = __importDefault(require("express"));
const auth_controller_1 = require("../controller/auth-controller");
const category_controller_1 = require("../controller/category-controller");
const contact_controller_1 = require("../controller/contact-controller");
const content_controller_1 = require("../controller/content-controller");
const exchange_rate_controller_1 = require("../controller/exchange-rate-controller");
const faq_controller_1 = require("../controller/faq-controller");
const hotel_controller_1 = require("../controller/hotel-controller");
const package_type_controller_1 = require("../controller/package-type-controller");
const product_controller_1 = require("../controller/product-controller");
const user_package_controller_1 = require("../controller/user-package-controller");
const user_package_option_controller_1 = require("../controller/user-package-option-controller");
const user_package_order_controller_1 = require("../controller/user-package-order-controller");
const menu_item_controller_1 = require("../controller/menu-item-controller");
const footer_controller_1 = require("../controller/footer-controller");
exports.publicRouter = express_1.default.Router();
// Authentication
exports.publicRouter.post('/v1/auth/register', auth_controller_1.AuthController.register);
exports.publicRouter.post('/v1/auth/login', auth_controller_1.AuthController.login);
// Package Type
exports.publicRouter.get('/v1/package-types', package_type_controller_1.PackageTypeController.getAll);
// User Package
exports.publicRouter.post('/v1/user-packages', user_package_controller_1.UserPackageController.create);
exports.publicRouter.get('/v1/user-packages/:id', user_package_controller_1.UserPackageController.get);
// User Package Option
exports.publicRouter.get('/v1/user-package-options', user_package_option_controller_1.UserPackageOptionController.getAll);
// User Package Order
exports.publicRouter.post('/v1/user-package-orders', user_package_order_controller_1.UserPackageOrderController.create);
// Category
exports.publicRouter.get('/v1/categories', category_controller_1.CategoryController.getAll);
exports.publicRouter.get('/v1/categories/:id', category_controller_1.CategoryController.get);
// Product
exports.publicRouter.get('/v1/products', product_controller_1.ProductController.getAll);
exports.publicRouter.get('/v1/products/:id', product_controller_1.ProductController.get);
// Hotel
exports.publicRouter.get('/v1/hotels/prices', hotel_controller_1.HotelController.getAllHotelPeriodPrices);
// Exchange Rate
exports.publicRouter.get('/v1/exchange-rates', exchange_rate_controller_1.ExchangeRateController.getAll);
exports.publicRouter.get('/v1/exchange-rates/:id', exchange_rate_controller_1.ExchangeRateController.get);
// Contact
exports.publicRouter.get('/v1/contacts', contact_controller_1.ContactController.getAll);
exports.publicRouter.get('/v1/contacts/:name', contact_controller_1.ContactController.getByName);
// Faq
exports.publicRouter.get('/v1/faqs', faq_controller_1.FaqController.getAll);
exports.publicRouter.get('/v1/faqs/:id', faq_controller_1.FaqController.get);
// Content
exports.publicRouter.get('/v1/contents', content_controller_1.ContentController.getAll);
exports.publicRouter.get('/v1/contents/page/:page', content_controller_1.ContentController.getAllByPage);
exports.publicRouter.get('/v1/contents/section/:section', content_controller_1.ContentController.getAllBySection);
exports.publicRouter.get('/v1/contents/colors', content_controller_1.ContentController.getAllColors);
exports.publicRouter.get('/v1/contents/colors/:id', content_controller_1.ContentController.getColor);
exports.publicRouter.get('/v1/contents/:id', content_controller_1.ContentController.get);
// Menu Item
exports.publicRouter.get('/v1/menu-items', menu_item_controller_1.MenuItemController.getAll);
exports.publicRouter.get('/v1/menu-items/:id', menu_item_controller_1.MenuItemController.get);
// Footer
exports.publicRouter.get('/v1/footers', footer_controller_1.FooterController.getAll);
exports.publicRouter.get('/v1/footers/:id', footer_controller_1.FooterController.get);
