"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toMitraPackageOrderResponse = toMitraPackageOrderResponse;
const user_model_1 = require("./user-model");
function toMitraPackageOrderResponse(order) {
    return {
        id: order.id,
        user: (0, user_model_1.toUserResponse)(order.User),
        mitra_package_id: order.mitra_package_id,
        per_pax_price_double: Number(order.MitraPackage.per_pax_price_double),
        per_pax_price_triple: Number(order.MitraPackage.per_pax_price_triple),
        per_pax_price_quad: Number(order.MitraPackage.per_pax_price_quad),
        created_at: order.created_at,
        updated_at: order.updated_at,
    };
}
