"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toMitraPackageResponse = toMitraPackageResponse;
function toMitraPackageResponse(mitraPackage) {
    return {
        id: mitraPackage.id,
        number_of_pax: mitraPackage.number_of_pax,
        period: mitraPackage.period,
        departure_date: mitraPackage.departure_date,
        travel_duration: mitraPackage.travel_duration,
        mekkah_duration: mitraPackage.mekkah_duration,
        madinah_duration: mitraPackage.madinah_duration,
        airline: mitraPackage.airline,
        vendor: mitraPackage.vendor,
        hotel_mekkah: {
            name: mitraPackage.hotelMekkah.name,
            price_double: mitraPackage.hotelMekkah.HotelPeriodPrices[0].price_double,
            price_triple: mitraPackage.hotelMekkah.HotelPeriodPrices[0].price_triple,
            price_quad: mitraPackage.hotelMekkah.HotelPeriodPrices[0].price_quad,
        },
        hotel_madinah: {
            name: mitraPackage.hotelMadinah.name,
            price_double: mitraPackage.hotelMadinah.HotelPeriodPrices[0].price_double,
            price_triple: mitraPackage.hotelMadinah.HotelPeriodPrices[0].price_triple,
            price_quad: mitraPackage.hotelMadinah.HotelPeriodPrices[0].price_quad,
        },
        visa: mitraPackage.visa,
        transportation: mitraPackage.transportation,
        muthawif: mitraPackage.muthawif,
        handling_saudi: mitraPackage.handlingSaudi,
        handling_domestic: mitraPackage.handlingDomestic,
        siskopatuh: mitraPackage.siskopatuh,
        equipment: mitraPackage.equipment,
        tour_plus: mitraPackage.tourPlus,
        manasik: mitraPackage.manasik,
        tour_leader: mitraPackage.tour_leader,
        margin: mitraPackage.margin,
        per_pax_price_double: mitraPackage.per_pax_price_double,
        per_pax_price_triple: mitraPackage.per_pax_price_triple,
        per_pax_price_quad: mitraPackage.per_pax_price_quad,
    };
}
