"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toHotelResponse = toHotelResponse;
const vendor_model_1 = require("./vendor-model");
const period_model_1 = require("./period-model");
function toHotelResponse(hotel) {
    return {
        id: hotel.id,
        vendor: (0, vendor_model_1.toVendorResponse)(hotel.Vendor),
        name: hotel.name,
        city: hotel.city,
        order_number: hotel.order_number,
        periods: hotel.HotelPeriodPrices.map((hotelPeriodPrice) => ({
            period: (0, period_model_1.toPeriodResponse)(hotelPeriodPrice.Period),
            price_double: Number(hotelPeriodPrice.price_double),
            price_triple: Number(hotelPeriodPrice.price_triple),
            price_quad: Number(hotelPeriodPrice.price_quad),
        })),
        created_at: hotel.created_at,
        updated_at: hotel.updated_at,
    };
}
