"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPackageOptionController = void 0;
const user_package_option_service_1 = require("../service/user-package-option-service");
class UserPackageOptionController {
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield user_package_option_service_1.UserPackageOptionService.getAll();
                res.status(200).json({
                    success: true,
                    message: 'Paket user berhasil didapatkan',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getByType(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const { type } = req.params;
                const response = yield user_package_option_service_1.UserPackageOptionService.getByType(type);
                res.status(200).json({
                    success: true,
                    message: 'Paket user berhasil didapatkan',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static bulkUpdate(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield user_package_option_service_1.UserPackageOptionService.bulkUpdate(request);
                res.status(200).json({
                    success: true,
                    message: 'Paket user berhasil diupdate',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.UserPackageOptionController = UserPackageOptionController;
