"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserController = void 0;
const user_service_1 = require("../service/user-service");
class UserController {
    static create(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                const response = yield user_service_1.UserService.create(request);
                res.status(201).json({
                    success: true,
                    message: 'User berhasil dibuat',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const query = {
                    full_name: req.query.full_name,
                    email: req.query.email,
                    whatsapp_number: req.query.whatsapp_number,
                    role: req.query.role ? req.query.role : undefined,
                    sort: req.query.sort,
                    order: req.query.order,
                    page: req.query.page ? Number(req.query.page) : 1,
                    limit: req.query.limit ? Number(req.query.limit) : 10,
                };
                const response = yield user_service_1.UserService.getAll(query);
                res.status(200).json({
                    success: true,
                    message: 'User berhasil didapatkan',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static get(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield user_service_1.UserService.get(id);
                res.status(200).json({
                    success: true,
                    message: 'User berhasil didapatkan',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getCurrent(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                res.status(200).json({
                    success: true,
                    message: 'User berhasil didapatkan',
                    data: req.user,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static updateCurrent(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                const response = yield user_service_1.UserService.updateCurrent(req.user, request);
                res.cookie('access_token', response.token, {
                    httpOnly: true,
                    secure: true,
                    sameSite: 'none',
                });
                res.status(200).json({
                    success: true,
                    message: 'User berhasil diupdate',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static updateCurrentPassword(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield user_service_1.UserService.updateCurrentPassword(req.user, request);
                res.status(200).json({
                    success: true,
                    message: 'Password berhasil diupdate',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static update(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const request = req.body;
                const response = yield user_service_1.UserService.update(id, request);
                res.status(200).json({
                    success: true,
                    message: 'User berhasil diupdate',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static delete(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield user_service_1.UserService.delete(id);
                res.status(200).json({
                    success: true,
                    message: 'User berhasil dihapus',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static upgradeToMitra(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield user_service_1.UserService.upgradeToMitra(id);
                res.cookie('access_token', response.token, {
                    httpOnly: true,
                    secure: true,
                    sameSite: 'none',
                });
                res.status(200).json({
                    success: true,
                    message: 'User berhasil diupgrade menjadi mitra',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.UserController = UserController;
