"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductOrderController = void 0;
const product_order_service_1 = require("../service/product-order-service");
class ProductOrderController {
    static create(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                const response = yield product_order_service_1.ProductOrderService.create(req.user, request);
                res.status(201).json({
                    success: true,
                    message: 'Order created successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static get(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield product_order_service_1.ProductOrderService.get(id);
                res.status(200).json({
                    success: true,
                    message: 'Order retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const query = {
                    search: req.query.search,
                    sort: req.query.sort,
                    order: req.query.order,
                    page: req.query.page ? Number(req.query.page) : 1,
                    limit: req.query.limit ? Number(req.query.limit) : 10,
                };
                const response = yield product_order_service_1.ProductOrderService.getAll(query);
                res.status(200).json({
                    success: true,
                    message: 'Orders retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllByUser(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield product_order_service_1.ProductOrderService.getAllByUser(req.user);
                res.status(200).json({
                    success: true,
                    message: 'Orders retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static delete(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                yield product_order_service_1.ProductOrderService.delete(id);
                res.status(200).json({
                    success: true,
                    message: 'Order deleted successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.ProductOrderController = ProductOrderController;
