"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductController = void 0;
const product_service_1 = require("../service/product-service");
class ProductController {
    static create(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            let thumbnails = [];
            try {
                if (req.files && 'thumbnails' in req.files) {
                    const files = req.files;
                    thumbnails = files['thumbnails'].map((file) => `/public/upload/thumbnail/${file.filename}`);
                }
                if (thumbnails.length === 0) {
                    thumbnails.push('/public/upload/default-thumbnail.png');
                }
                const variations = req.body.variations;
                if (variations) {
                    variations.forEach((variation) => {
                        variation.price = parseFloat(variation.price);
                    });
                }
                const request = {
                    name: req.body.name,
                    description: req.body.description,
                    price: parseFloat(req.body.price),
                    has_variation: req.body.has_variation === 'true',
                    thumbnails: thumbnails,
                    category_ids: req.body.category_ids,
                    variations: variations,
                    includes: req.body.includes,
                    excludes: req.body.excludes,
                };
                const response = yield product_service_1.ProductService.create(request);
                res.status(201).json({
                    success: true,
                    message: 'Product created successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const query = {
                    name: req.query.name,
                    category_id: req.query.category_id ? req.query.category_id.split(',') : [],
                    has_variation: req.query.has_variation ? req.query.has_variation === 'true' : undefined,
                    sort: req.query.sort,
                    order: req.query.order,
                    page: req.query.page ? Number(req.query.page) : 1,
                    limit: req.query.limit ? Number(req.query.limit) : 10,
                };
                const response = yield product_service_1.ProductService.getAll(query);
                res.status(200).json({
                    success: true,
                    message: 'Products retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static get(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield product_service_1.ProductService.get(id);
                res.status(200).json({
                    success: true,
                    message: 'Product retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static update(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                let newThumbnails = [];
                let newVariations = [];
                if (req.files && 'thumbnails' in req.files) {
                    const files = req.files;
                    newThumbnails = files['thumbnails'].map((file) => `/public/upload/thumbnail/${file.filename}`);
                }
                if (req.body.variations) {
                    newVariations = req.body.variations;
                    newVariations.forEach((variation) => {
                        variation.price = parseFloat(variation.price);
                    });
                }
                if (req.body.price) {
                    req.body.price = parseFloat(req.body.price);
                }
                const request = {
                    name: req.body.name,
                    description: req.body.description,
                    price: req.body.price,
                    has_variation: req.body.has_variation === 'true',
                    thumbnails: newThumbnails,
                    category_ids: req.body.category_ids,
                    variations: newVariations,
                    includes: req.body.includes || [],
                    excludes: req.body.excludes || [],
                };
                const response = yield product_service_1.ProductService.update(id, request);
                res.status(200).json({
                    success: true,
                    message: 'Product updated successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static delete(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                yield product_service_1.ProductService.delete(id);
                res.status(200).json({
                    success: true,
                    message: 'Product deleted successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.ProductController = ProductController;
