"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MitraRequestController = void 0;
const mitra_request_service_1 = require("../service/mitra-request-service");
class MitraRequestController {
    static create(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                // Extract form data and files
                const files = req.files;
                // Ensure that both ktp and payment_proof are uploaded
                if (!files.ktp || !files.payment) {
                    return res.status(400).json({
                        success: false,
                        message: 'KTP dan bukti pembayaran harus diunggah',
                    });
                }
                // Extract paths of the uploaded files
                const ktpFilePath = `/public/upload/ktp/${files.ktp[0].filename}`;
                const paymentFilePath = `/public/upload/payment/${files.payment[0].filename}`;
                const request = {
                    ktp: ktpFilePath,
                    upgrade_amount: Number(req.body.upgrade_amount),
                    payment_proof: paymentFilePath,
                };
                const response = yield mitra_request_service_1.MitraRequestService.create(req.user, request);
                res.status(201).json({
                    success: true,
                    message: 'Mitra request created successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getStatusByUser(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield mitra_request_service_1.MitraRequestService.getStatusByUser(req.user);
                res.status(200).json({
                    success: true,
                    message: 'Last mitra request status retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const queryParams = {
                    search: req.query.search,
                    status: req.query.status,
                    sort: req.query.sort,
                    order: req.query.order,
                    page: Number(req.query.page),
                    limit: Number(req.query.limit),
                };
                const response = yield mitra_request_service_1.MitraRequestService.getAll(queryParams);
                res.status(200).json({
                    success: true,
                    message: 'Mitra requests retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static get(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield mitra_request_service_1.MitraRequestService.get(id);
                res.status(200).json({
                    success: true,
                    message: 'Mitra request retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static updateStatus(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const statusRequest = req.body;
                yield mitra_request_service_1.MitraRequestService.updateStatus(id, statusRequest);
                res.status(200).json({
                    success: true,
                    message: 'Mitra request status updated successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static delete(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                yield mitra_request_service_1.MitraRequestService.delete(id);
                res.status(200).json({
                    success: true,
                    message: 'Mitra request deleted successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.MitraRequestController = MitraRequestController;
