"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MitraPackageOptionController = void 0;
const mitra_package_option_service_1 = require("../service/mitra-package-option-service");
class MitraPackageOptionController {
    static bulkUpdateAirline(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield mitra_package_option_service_1.MitraPackageOptionService.bulkUpdateAirlines(request);
                res.status(200).json({
                    success: true,
                    message: 'Maskapai penerbangan berhasil diupdate',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllAirlines(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const airlines = yield mitra_package_option_service_1.MitraPackageOptionService.getAllAirlines();
                res.status(200).json({
                    success: true,
                    message: 'Maskapai penerbangan berhasil diambil',
                    data: airlines,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static bulkUpdateVisas(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield mitra_package_option_service_1.MitraPackageOptionService.bulkUpdateVisas(request);
                res.status(200).json({
                    success: true,
                    message: 'Visa berhasil diupdate',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllVisas(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const visas = yield mitra_package_option_service_1.MitraPackageOptionService.getAllVisas();
                res.status(200).json({
                    success: true,
                    message: 'Visa berhasil diambil',
                    data: visas,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static bulkUpdateTranportations(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield mitra_package_option_service_1.MitraPackageOptionService.bulkUpdateTransportations(request);
                res.status(200).json({
                    success: true,
                    message: 'Transportasi berhasil diupdate',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllTransportations(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const transportation = yield mitra_package_option_service_1.MitraPackageOptionService.getAllTransportations();
                res.status(200).json({
                    success: true,
                    message: 'Transportasi berhasil diambil',
                    data: transportation,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static bulkUpdateMuthawifs(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield mitra_package_option_service_1.MitraPackageOptionService.bulkUpdateMuthawifs(request);
                res.status(200).json({
                    success: true,
                    message: 'Muthawif berhasil diupdate',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllMuthawifs(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const muthawif = yield mitra_package_option_service_1.MitraPackageOptionService.getAllMuthawifs();
                res.status(200).json({
                    success: true,
                    message: 'Muthawif berhasil diambil',
                    data: muthawif,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static bulkUpdateHandlingSaudis(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield mitra_package_option_service_1.MitraPackageOptionService.bulkUpdateHandlingSaudis(request);
                res.status(200).json({
                    success: true,
                    message: 'Handling Saudi berhasil diupdate',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllHandlingSaudis(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const handlingSaudi = yield mitra_package_option_service_1.MitraPackageOptionService.getAllHandlingSaudis();
                res.status(200).json({
                    success: true,
                    message: 'Handling Saudi berhasil diambil',
                    data: handlingSaudi,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static bulkUpdateHandlingDomestics(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield mitra_package_option_service_1.MitraPackageOptionService.bulkUpdateHandlingDomestics(request);
                res.status(200).json({
                    success: true,
                    message: 'Handling domestik berhasil diupdate',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllHandlingDomestics(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const handlingDomestic = yield mitra_package_option_service_1.MitraPackageOptionService.getAllHandlingDomestics();
                res.status(200).json({
                    success: true,
                    message: 'Handling domestik berhasil diambil',
                    data: handlingDomestic,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static bulkUpdateSiskopatuh(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield mitra_package_option_service_1.MitraPackageOptionService.bulkUpdateSiskopatuhs(request);
                res.status(200).json({
                    success: true,
                    message: 'Siskopatuh berhasil diupdate',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllSiskopatuh(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const siskopatuh = yield mitra_package_option_service_1.MitraPackageOptionService.getAllSiskopatuhs();
                res.status(200).json({
                    success: true,
                    message: 'Siskopatuh berhasil diambil',
                    data: siskopatuh,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static bulkUpdateEquipments(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield mitra_package_option_service_1.MitraPackageOptionService.bulkUpdateEquipments(request);
                res.status(200).json({
                    success: true,
                    message: 'Perlengkapan berhasil diupdate',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllEquipments(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const equipment = yield mitra_package_option_service_1.MitraPackageOptionService.getAllEquipments();
                res.status(200).json({
                    success: true,
                    message: 'Perlengkapan berhasil diambil',
                    data: equipment,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static bulkUpdateTourPluses(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield mitra_package_option_service_1.MitraPackageOptionService.bulkUpdateTourPluses(request);
                res.status(200).json({
                    success: true,
                    message: 'Tour plus berhasil diupdate',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllTourPluses(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const tourPlus = yield mitra_package_option_service_1.MitraPackageOptionService.getAllTourPluses();
                res.status(200).json({
                    success: true,
                    message: 'Tour plus berhasil diambil',
                    data: tourPlus,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static bulkUpdateManasik(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield mitra_package_option_service_1.MitraPackageOptionService.bulkUpdateManasiks(request);
                res.status(200).json({
                    success: true,
                    message: 'Manasik berhasil diupdate',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllManasik(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const manasik = yield mitra_package_option_service_1.MitraPackageOptionService.getAllManasiks();
                res.status(200).json({
                    success: true,
                    message: 'Manasik berhasil diambil',
                    data: manasik,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.MitraPackageOptionController = MitraPackageOptionController;
