"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FaqController = void 0;
const faq_service_1 = require("../service/faq-service");
class FaqController {
    static create(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                const response = yield faq_service_1.FaqService.create(request);
                res.status(201).json({
                    success: true,
                    message: 'Faq created successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield faq_service_1.FaqService.getAll();
                res.status(200).json({
                    success: true,
                    message: 'Faqs retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static get(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield faq_service_1.FaqService.get(id);
                res.status(200).json({
                    success: true,
                    message: 'Faq retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static update(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const request = req.body;
                const response = yield faq_service_1.FaqService.update(id, request);
                res.status(200).json({
                    success: true,
                    message: 'Faq updated successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static delete(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                yield faq_service_1.FaqService.delete(id);
                res.status(200).json({
                    success: true,
                    message: 'Faq deleted successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.FaqController = FaqController;
