"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentController = void 0;
const content_service_1 = require("../service/content-service");
class ContentController {
    static create(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                const response = yield content_service_1.ContentService.create(request);
                res.status(201).json({
                    success: true,
                    message: 'Content created successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static update(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let imagePath;
                if (req.file) {
                    imagePath = `/public/content/${req.file.filename}`;
                }
                const id = req.params.id;
                const request = {
                    page: req.body.page,
                    section: req.body.section,
                    type: req.body.type,
                    key: req.body.key,
                    value: imagePath || req.body.value,
                };
                const response = yield content_service_1.ContentService.update(id, request);
                res.status(200).json({
                    success: true,
                    message: 'Content updated successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static updateValue(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const request = {
                    value: req.body.value ? JSON.parse(req.body.value) : '',
                };
                const response = yield content_service_1.ContentService.updateValue(id, request, req.file);
                res.status(200).json({
                    success: true,
                    message: 'Content updated successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static updateVisibility(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const visible = req.body.visible;
                const response = yield content_service_1.ContentService.updateVisibility(id, visible);
                res.status(200).json({
                    success: true,
                    message: 'Content visibility updated successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static delete(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                yield content_service_1.ContentService.delete(id);
                res.status(200).json({
                    success: true,
                    message: 'Content deleted successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield content_service_1.ContentService.getAll();
                res.status(200).json({
                    success: true,
                    message: 'Contents retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllByPage(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const page = req.params.page;
                const response = yield content_service_1.ContentService.getAllByPage(page);
                res.status(200).json({
                    success: true,
                    message: 'Contents retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllBySection(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const section = req.params.section;
                const response = yield content_service_1.ContentService.getAllBySection(section);
                res.status(200).json({
                    success: true,
                    message: 'Contents retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static get(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield content_service_1.ContentService.get(id);
                res.status(200).json({
                    success: true,
                    message: 'Content retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllColors(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield content_service_1.ContentService.getAllColors();
                res.status(200).json({
                    success: true,
                    message: 'Colors retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getColor(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield content_service_1.ContentService.getColor(id);
                res.status(200).json({
                    success: true,
                    message: 'Color retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static createColor(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                const response = yield content_service_1.ContentService.createColor(request);
                res.status(201).json({
                    success: true,
                    message: 'Color created successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static updateColors(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield content_service_1.ContentService.updateColors(request);
                res.status(200).json({
                    success: true,
                    message: 'Color updated successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static deleteColor(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                yield content_service_1.ContentService.deleteColor(id);
                res.status(200).json({
                    success: true,
                    message: 'Color deleted successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.ContentController = ContentController;
