"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactController = void 0;
const contact_service_1 = require("../service/contact-service");
class ContactController {
    static create(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                const response = yield contact_service_1.ContactService.create(request);
                res.status(201).json({
                    success: true,
                    message: 'Contact created successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static bulkUpdate(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                const response = yield contact_service_1.ContactService.bulkUpdate(request);
                res.status(200).json({
                    success: true,
                    message: 'Contact updated successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static delete(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield contact_service_1.ContactService.delete(id);
                res.status(200).json({
                    success: true,
                    message: 'Contact deleted successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield contact_service_1.ContactService.getAll();
                res.status(200).json({
                    success: true,
                    message: 'Contacts retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getByName(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const name = req.params.name;
                const response = yield contact_service_1.ContactService.getByName(name);
                res.status(200).json({
                    success: true,
                    message: 'Contact retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.ContactController = ContactController;
